/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelutil;

import java.awt.Image;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassForwardDeclaration;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFriend;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelutil.CsmImageName;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.openide.util.ImageUtilities;

public class CsmImageLoader
implements CsmImageName {
    private static Map<String, ImageIcon> map = new HashMap<String, ImageIcon>();

    private CsmImageLoader() {
    }

    public static Image getImage(CsmObject o) {
        return CsmImageLoader.getImage(o, Collections.<CsmDeclaration.Kind, CsmDeclaration.Kind>emptyMap());
    }

    public static Image getImage(CsmObject o, Map<CsmDeclaration.Kind, CsmDeclaration.Kind> translateIcons) {
        String iconPath = CsmImageLoader.getImagePath(o, translateIcons);
        return ImageUtilities.loadImage((String)iconPath);
    }

    public static Image getFriendFunctionImage(CsmFriend o) {
        int modifiers;
        String iconPath = CsmKindUtilities.isFriendClass((CsmObject)o) ? "org/netbeans/modules/cnd/modelutil/resources/types16x16/friend_class.png" : (((modifiers = CsmUtilities.getModifiers((CsmObject)o)) & 0x40000) == 262144 ? "org/netbeans/modules/cnd/modelutil/resources/types16x16/friend_operator.png" : "org/netbeans/modules/cnd/modelutil/resources/types16x16/friend_method.png");
        return ImageUtilities.loadImage((String)iconPath);
    }

    public static ImageIcon getProjectIcon(CsmProject prj, boolean opened) {
        String iconPath = CsmImageLoader.getProjectPath(prj.isArtificial(), opened);
        return CsmImageLoader.getCachedImageIcon(iconPath);
    }

    public static Image getProjectImage(boolean library, boolean opened) {
        String iconPath = CsmImageLoader.getProjectPath(library, opened);
        return ImageUtilities.loadImage((String)iconPath);
    }

    private static String getProjectPath(boolean library, boolean opened) {
        String iconPath = library ? (opened ? "org/netbeans/modules/cnd/modelutil/resources/types16x16/libraries.png" : "org/netbeans/modules/cnd/modelutil/resources/types16x16/libraries.png") : (opened ? "org/netbeans/modules/cnd/modelutil/resources/types16x16/project_open.png" : "org/netbeans/modules/cnd/modelutil/resources/types16x16/project.png");
        return iconPath;
    }

    public static ImageIcon getIcon(CsmObject o) {
        String iconPath = CsmImageLoader.getImagePath(o);
        return CsmImageLoader.getCachedImageIcon(iconPath);
    }

    public static ImageIcon getIcon(CsmDeclaration.Kind kind, int modifiers) {
        String iconPath = CsmImageLoader.getImagePath(kind, modifiers);
        return CsmImageLoader.getCachedImageIcon(iconPath);
    }

    public static ImageIcon getPreprocessorDirectiveIcon() {
        return CsmImageLoader.getCachedImageIcon("org/netbeans/modules/cnd/modelutil/resources/types16x16/code_macro_16.png");
    }

    public static ImageIcon getTempleteParameterIcon() {
        return CsmImageLoader.getCachedImageIcon("org/netbeans/modules/cnd/modelutil/resources/types16x16/template_parameter_16.png");
    }

    public static ImageIcon getIncludeImageIcon(boolean sysIncludeKind, boolean folder) {
        String iconPath = folder ? (sysIncludeKind ? "org/netbeans/modules/cnd/modelutil/resources/types16x16/include_sys_folder_16.png" : "org/netbeans/modules/cnd/modelutil/resources/types16x16/include_usr_folder_16.png") : (sysIncludeKind ? "org/netbeans/modules/cnd/modelutil/resources/types16x16/include_sys_16.png" : "org/netbeans/modules/cnd/modelutil/resources/types16x16/include_user_16.png");
        return CsmImageLoader.getCachedImageIcon(iconPath);
    }

    public static String getImagePath(CsmObject o) {
        return CsmImageLoader.getImagePath(o, Collections.<CsmDeclaration.Kind, CsmDeclaration.Kind>emptyMap());
    }

    private static String getImagePath(CsmObject o, Map<CsmDeclaration.Kind, CsmDeclaration.Kind> translateIcons) {
        CsmDeclaration.Kind kind = CsmDeclaration.Kind.BUILT_IN;
        int modifiers = CsmUtilities.getModifiers(o);
        if (CsmKindUtilities.isEnumerator((Object)o)) {
            kind = CsmDeclaration.Kind.ENUM;
            modifiers |= 0x400;
        } else {
            if (CsmKindUtilities.isUsingDirective((CsmObject)o)) {
                return "org/netbeans/modules/cnd/modelutil/resources/types16x16/using_namespace_16.png";
            }
            if (CsmKindUtilities.isUsingDeclaration((CsmObject)o)) {
                return "org/netbeans/modules/cnd/modelutil/resources/types16x16/using_declaration_16.png";
            }
            if (CsmKindUtilities.isEnumForwardDeclaration((CsmObject)o)) {
                return "org/netbeans/modules/cnd/modelutil/resources/types16x16/enumeration_fwd_16.png";
            }
            if (CsmKindUtilities.isClassForwardDeclaration((CsmObject)o)) {
                CsmClass cls = ((CsmClassForwardDeclaration)o).getCsmClass();
                if (cls != null && cls.getKind() == CsmDeclaration.Kind.CLASS) {
                    return "org/netbeans/modules/cnd/modelutil/resources/types16x16/class_forward_decl.png";
                }
                return "org/netbeans/modules/cnd/modelutil/resources/types16x16/struct_forward_decl.png";
            }
            if (CsmKindUtilities.isProgram((CsmObject)o)) {
                return "org/netbeans/modules/cnd/modelutil/resources/types16x16/project_open.png";
            }
            if (CsmKindUtilities.isModule((CsmObject)o)) {
                return "org/netbeans/modules/cnd/modelutil/resources/types16x16/methods_container.png";
            }
            if (CsmKindUtilities.isDeclaration((CsmObject)o)) {
                kind = ((CsmDeclaration)o).getKind();
            } else if (CsmKindUtilities.isNamespace((Object)o)) {
                kind = CsmDeclaration.Kind.NAMESPACE_DEFINITION;
            } else if (CsmKindUtilities.isNamespaceAlias((CsmObject)o)) {
                kind = CsmDeclaration.Kind.NAMESPACE_ALIAS;
            } else {
                if (CsmKindUtilities.isMacro((CsmObject)o)) {
                    return "org/netbeans/modules/cnd/modelutil/resources/types16x16/code_macro_16.png";
                }
                if (CsmKindUtilities.isInclude((CsmObject)o)) {
                    if (((CsmInclude)o).isSystem()) {
                        return "org/netbeans/modules/cnd/modelutil/resources/types16x16/include_sys_16.png";
                    }
                    return "org/netbeans/modules/cnd/modelutil/resources/types16x16/include_user_16.png";
                }
                if (CsmKindUtilities.isProject((Object)o)) {
                    return CsmImageLoader.getProjectPath(((CsmProject)o).isArtificial(), false);
                }
                if (CsmKindUtilities.isFile((CsmObject)o)) {
                    switch (((CsmFile)o).getFileType()) {
                        case HEADER_FILE: {
                            return "org/netbeans/modules/cnd/modelutil/resources/types16x16/header.gif";
                        }
                        case SOURCE_CPP_FILE: 
                        case SOURCE_FILE: {
                            return "org/netbeans/modules/cnd/modelutil/resources/types16x16/cppsource.gif";
                        }
                        case SOURCE_C_FILE: {
                            return "org/netbeans/modules/cnd/modelutil/resources/types16x16/csource.gif";
                        }
                        case SOURCE_FORTRAN_FILE: {
                            return "org/netbeans/modules/cnd/modelutil/resources/types16x16/fortran.gif";
                        }
                    }
                    return "org/netbeans/modules/cnd/modelutil/resources/types16x16/header.gif";
                }
            }
        }
        if (translateIcons.get(kind) != null) {
            kind = translateIcons.get(kind);
        }
        return CsmImageLoader.getImagePath(kind, modifiers);
    }

    static String getImagePath(CsmDeclaration.Kind kind, int modifiers) {
        String iconPath = "org/openide/resources/defaultNode.gif";
        if (kind == CsmDeclaration.Kind.NAMESPACE_DEFINITION) {
            iconPath = "org/netbeans/modules/cnd/modelutil/resources/types16x16/namespace_16.png";
        } else if (kind == CsmDeclaration.Kind.NAMESPACE_ALIAS) {
            iconPath = "org/netbeans/modules/cnd/modelutil/resources/types16x16/namespace_alias.png";
        } else if (kind == CsmDeclaration.Kind.ENUM) {
            iconPath = (modifiers & 0x400) == 0 ? "org/netbeans/modules/cnd/modelutil/resources/types16x16/enumeration_16.png" : "org/netbeans/modules/cnd/modelutil/resources/types16x16/enumeration_item_16.png";
        } else if (kind == CsmDeclaration.Kind.MACRO) {
            iconPath = "org/netbeans/modules/cnd/modelutil/resources/types16x16/code_macro_16.png";
        } else if (kind == CsmDeclaration.Kind.CLASS) {
            iconPath = (modifiers & 0x100000) == 0 ? "org/netbeans/modules/cnd/modelutil/resources/types16x16/class_16.png" : "org/netbeans/modules/cnd/modelutil/resources/types16x16/class_forward_decl.png";
        } else if (kind == CsmDeclaration.Kind.STRUCT) {
            iconPath = (modifiers & 0x100000) == 0 ? "org/netbeans/modules/cnd/modelutil/resources/types16x16/struct_16.png" : "org/netbeans/modules/cnd/modelutil/resources/types16x16/struct_forward_decl.png";
        } else if (kind == CsmDeclaration.Kind.UNION) {
            iconPath = "org/netbeans/modules/cnd/modelutil/resources/types16x16/union_16.png";
        } else if (kind == CsmDeclaration.Kind.TYPEDEF) {
            iconPath = "org/netbeans/modules/cnd/modelutil/resources/types16x16/typedef_16.png";
        } else if (kind == CsmDeclaration.Kind.CLASS_FRIEND_DECLARATION) {
            iconPath = "org/netbeans/modules/cnd/modelutil/resources/types16x16/friend_class.png";
        } else if (kind == CsmDeclaration.Kind.VARIABLE || kind == CsmDeclaration.Kind.VARIABLE_DEFINITION) {
            boolean isExtern;
            boolean isLocal = (modifiers & 0x2000) != 0;
            boolean isFileLocal = (modifiers & 0x4000) != 0;
            boolean isField = (modifiers & 0x8000) != 0;
            boolean isGlobal = !(isLocal | isFileLocal | isField);
            boolean isStatic = (modifiers & 8) != 0;
            boolean isConst = (modifiers & 0x200) != 0;
            boolean bl = isExtern = (modifiers & 0x80000) != 0;
            if (isGlobal) {
                iconPath = isConst ? (isExtern ? "org/netbeans/modules/cnd/modelutil/resources/types16x16/extern_variable_16.png" : "org/netbeans/modules/cnd/modelutil/resources/types16x16/global_constant.png") : (isExtern ? "org/netbeans/modules/cnd/modelutil/resources/types16x16/extern_variable_16.png" : "org/netbeans/modules/cnd/modelutil/resources/types16x16/global_variable.png");
            }
            if (isLocal) {
                iconPath = isStatic ? (isConst ? "org/netbeans/modules/cnd/modelutil/resources/types16x16/local_constant.png" : "org/netbeans/modules/cnd/modelutil/resources/types16x16/local_variable.png") : (isConst ? "org/netbeans/modules/cnd/modelutil/resources/types16x16/local_constant.png" : "org/netbeans/modules/cnd/modelutil/resources/types16x16/local_variable.png");
            }
            if (isFileLocal) {
                iconPath = isConst ? "org/netbeans/modules/cnd/modelutil/resources/types16x16/global_constant.png" : "org/netbeans/modules/cnd/modelutil/resources/types16x16/static_variable.png";
            }
            if (isField) {
                int level = CsmUtilities.getLevel(modifiers);
                iconPath = "org/netbeans/modules/cnd/modelutil/resources/types16x16/fields.png";
                if (isStatic) {
                    switch (level) {
                        case 0: {
                            iconPath = isConst ? "org/netbeans/modules/cnd/modelutil/resources/types16x16/const_static_private.png" : "org/netbeans/modules/cnd/modelutil/resources/types16x16/fields_static_private.png";
                            break;
                        }
                        case 1: {
                            iconPath = isConst ? "org/netbeans/modules/cnd/modelutil/resources/types16x16/const_static_protected.png" : "org/netbeans/modules/cnd/modelutil/resources/types16x16/fields_static_protected.png";
                            break;
                        }
                        case 2: {
                            iconPath = isConst ? "org/netbeans/modules/cnd/modelutil/resources/types16x16/const_static_public.png" : "org/netbeans/modules/cnd/modelutil/resources/types16x16/fields_static.png";
                        }
                    }
                } else {
                    switch (level) {
                        case 0: {
                            iconPath = isConst ? "org/netbeans/modules/cnd/modelutil/resources/types16x16/const_private.png" : "org/netbeans/modules/cnd/modelutil/resources/types16x16/fields_private.png";
                            break;
                        }
                        case 1: {
                            iconPath = isConst ? "org/netbeans/modules/cnd/modelutil/resources/types16x16/const_protected.png" : "org/netbeans/modules/cnd/modelutil/resources/types16x16/fields_protected.png";
                            break;
                        }
                        case 2: {
                            iconPath = isConst ? "org/netbeans/modules/cnd/modelutil/resources/types16x16/const_public.png" : "org/netbeans/modules/cnd/modelutil/resources/types16x16/fields.png";
                        }
                    }
                }
            }
        } else if (kind == CsmDeclaration.Kind.FUNCTION || kind == CsmDeclaration.Kind.FUNCTION_DEFINITION || kind == CsmDeclaration.Kind.FUNCTION_FRIEND || kind == CsmDeclaration.Kind.FUNCTION_FRIEND_DEFINITION) {
            boolean isMethod = (modifiers & 0x8000) != 0;
            boolean isGlobal = !isMethod;
            boolean isConstructor = (modifiers & 0x800) != 0;
            boolean isDestructor = (modifiers & 0x20000) != 0;
            boolean isOperator = (modifiers & 0x40000) != 0;
            boolean isStatic = (modifiers & 8) != 0;
            boolean isFileLocal = (modifiers & 0x4000) != 0;
            int level = CsmUtilities.getLevel(modifiers);
            if (isGlobal) {
                iconPath = isOperator ? "org/netbeans/modules/cnd/modelutil/resources/types16x16/global_operator.png" : (kind == CsmDeclaration.Kind.FUNCTION || kind == CsmDeclaration.Kind.FUNCTION_FRIEND ? "org/netbeans/modules/cnd/modelutil/resources/types16x16/global_function_decl.png" : "org/netbeans/modules/cnd/modelutil/resources/types16x16/global_function.png");
                if (isFileLocal) {
                    iconPath = isOperator ? "org/netbeans/modules/cnd/modelutil/resources/types16x16/global_operator_static.png" : "org/netbeans/modules/cnd/modelutil/resources/types16x16/static_function.png";
                }
            }
            if (isMethod) {
                iconPath = isOperator ? "org/netbeans/modules/cnd/modelutil/resources/types16x16/operator_public.png" : "org/netbeans/modules/cnd/modelutil/resources/types16x16/methods.png";
                if (isStatic) {
                    switch (level) {
                        case 0: {
                            if (isOperator) {
                                iconPath = "org/netbeans/modules/cnd/modelutil/resources/types16x16/operator_static_privat.png";
                                break;
                            }
                            iconPath = "org/netbeans/modules/cnd/modelutil/resources/types16x16/methods_static_private.png";
                            break;
                        }
                        case 1: {
                            if (isOperator) {
                                iconPath = "org/netbeans/modules/cnd/modelutil/resources/types16x16/operator_static_protected.png";
                                break;
                            }
                            iconPath = "org/netbeans/modules/cnd/modelutil/resources/types16x16/methods_static_protected.png";
                            break;
                        }
                        case 2: {
                            iconPath = isOperator ? "org/netbeans/modules/cnd/modelutil/resources/types16x16/operator_static.png" : "org/netbeans/modules/cnd/modelutil/resources/types16x16/methods_static.png";
                        }
                    }
                } else {
                    switch (level) {
                        case 0: {
                            if (isOperator) {
                                iconPath = "org/netbeans/modules/cnd/modelutil/resources/types16x16/operator_privat.png";
                                break;
                            }
                            iconPath = "org/netbeans/modules/cnd/modelutil/resources/types16x16/methods_private.png";
                            break;
                        }
                        case 1: {
                            if (isOperator) {
                                iconPath = "org/netbeans/modules/cnd/modelutil/resources/types16x16/operator_protected.png";
                                break;
                            }
                            iconPath = "org/netbeans/modules/cnd/modelutil/resources/types16x16/methods_protected.png";
                            break;
                        }
                        case 2: {
                            iconPath = isOperator ? "org/netbeans/modules/cnd/modelutil/resources/types16x16/operator_public.png" : "org/netbeans/modules/cnd/modelutil/resources/types16x16/methods.png";
                        }
                    }
                }
            }
            if (isConstructor) {
                iconPath = "org/netbeans/modules/cnd/modelutil/resources/types16x16/constructors.png";
                switch (level) {
                    case 0: {
                        iconPath = "org/netbeans/modules/cnd/modelutil/resources/types16x16/constructors_private.png";
                        break;
                    }
                    case 1: {
                        iconPath = "org/netbeans/modules/cnd/modelutil/resources/types16x16/constructors_protected.png";
                        break;
                    }
                    case 2: {
                        iconPath = "org/netbeans/modules/cnd/modelutil/resources/types16x16/constructors.png";
                    }
                }
            }
            if (isDestructor) {
                iconPath = "org/netbeans/modules/cnd/modelutil/resources/types16x16/deconstructors.png";
                switch (level) {
                    case 0: {
                        iconPath = "org/netbeans/modules/cnd/modelutil/resources/types16x16/deconstructors_private.png";
                        break;
                    }
                    case 1: {
                        iconPath = "org/netbeans/modules/cnd/modelutil/resources/types16x16/deconstructors_protected.png";
                        break;
                    }
                    case 2: {
                        iconPath = "org/netbeans/modules/cnd/modelutil/resources/types16x16/deconstructors.png";
                    }
                }
            }
        }
        return iconPath;
    }

    private static ImageIcon getCachedImageIcon(String iconPath) {
        ImageIcon icon = map.get(iconPath);
        if (icon == null) {
            icon = ImageUtilities.loadImageIcon((String)iconPath, (boolean)false);
            map.put(iconPath, icon);
        }
        return icon;
    }
}

