/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelutil;

import java.awt.Color;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.text.AttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.modules.cnd.modelutil.FontColorProvider;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public final class CsmFontColorManager {
    private final Map<String, FontColorProviderImpl> providers = new HashMap<String, FontColorProviderImpl>();
    private final boolean isUnitTestsMode = CndUtils.isUnitTestMode();

    public void addListener(String mimeType, FontColorChangeListener listener) {
        this.getCreateProvider(mimeType).addListener(listener);
    }

    Color getColor(FontColorProvider.Entity color) {
        AttributeSet as = this.getCreateProvider("text/x-c++").getColor(color);
        return this.isUnitTestsMode ? Color.red : (Color)as.getAttribute(StyleConstants.ColorConstants.Foreground);
    }

    public AttributeSet getColorAttributes(String mimeType, FontColorProvider.Entity name) {
        AttributeSet as = this.getCreateProvider(mimeType).getColor(name);
        return this.isUnitTestsMode ? null : as;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FontColorProviderImpl getCreateProvider(String mimeType) {
        Map<String, FontColorProviderImpl> map = this.providers;
        synchronized (map) {
            FontColorProviderImpl fcp = this.providers.get(mimeType);
            if (fcp == null) {
                fcp = new FontColorProviderImpl(mimeType);
                this.providers.put(mimeType, fcp);
            }
            return fcp;
        }
    }

    public static CsmFontColorManager instance() {
        return Instantiator.instance;
    }

    private CsmFontColorManager() {
    }

    private static class FontColorProviderImpl
    implements FontColorProvider,
    LookupListener {
        private final String mimeType;
        private final List<WeakReference<FontColorChangeListener>> listeners = new ArrayList<WeakReference<FontColorChangeListener>>();
        private FontColorSettings fcs;
        private final Object lock = new Object();

        public FontColorProviderImpl(String mimeType) {
            this.mimeType = mimeType;
            Lookup lookup = MimeLookup.getLookup((MimePath)MimePath.get((String)mimeType));
            Lookup.Result result = lookup.lookupResult(FontColorSettings.class);
            this.fcs = (FontColorSettings)result.allInstances().iterator().next();
            result.addLookupListener((LookupListener)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addListener(FontColorChangeListener listener) {
            List<WeakReference<FontColorChangeListener>> list = this.listeners;
            synchronized (list) {
                this.listeners.add(new WeakReference<FontColorChangeListener>(listener));
            }
            listener.stateChanged(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AttributeSet getColor(FontColorProvider.Entity color) {
            Object object = this.lock;
            synchronized (object) {
                return this.fcs.getTokenFontColors(color.getResourceName());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resultChanged(LookupEvent ev) {
            Lookup lookup = MimeLookup.getLookup((MimePath)MimePath.get((String)this.mimeType));
            List<WeakReference<FontColorChangeListener>> list = this.lock;
            synchronized (list) {
                this.fcs = (FontColorSettings)lookup.lookup(FontColorSettings.class);
            }
            list = this.listeners;
            synchronized (list) {
                ListIterator<WeakReference<FontColorChangeListener>> it = this.listeners.listIterator();
                while (it.hasNext()) {
                    WeakReference<FontColorChangeListener> wrcl = it.next();
                    FontColorChangeListener cl = (FontColorChangeListener)wrcl.get();
                    if (cl != null) {
                        cl.stateChanged(this);
                        continue;
                    }
                    it.remove();
                }
            }
        }

        @Override
        public String getMimeType() {
            return this.mimeType;
        }
    }

    public static interface FontColorChangeListener
    extends EventListener {
        public void stateChanged(FontColorProvider var1);
    }

    private static class Instantiator {
        public static final CsmFontColorManager instance = new CsmFontColorManager();

        private Instantiator() {
        }
    }
}

