/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelutil;

import java.awt.Color;
import java.io.File;
import java.util.Iterator;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmEnum;
import org.netbeans.modules.cnd.api.model.CsmEnumerator;
import org.netbeans.modules.cnd.api.model.CsmField;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmNamedElement;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmParameter;
import org.netbeans.modules.cnd.api.model.CsmQualifiedNamedElement;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.deep.CsmLabel;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.swing.plaf.LFCustoms;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class CsmDisplayUtilities {
    private static final boolean SKIP_COLORING = Boolean.getBoolean("cnd.test.skip.coloring");

    private CsmDisplayUtilities() {
    }

    public static String getContextLineHtml(CsmFile csmFile, int stToken, int endToken, boolean tokenInBold) {
        CloneableEditorSupport ces = CsmUtilities.findCloneableEditorSupport(csmFile);
        StyledDocument stDoc = CsmUtilities.openDocument(ces);
        String displayText = null;
        if (stDoc instanceof BaseDocument) {
            BaseDocument doc = (BaseDocument)stDoc;
            try {
                int stOffset = stToken;
                int endOffset = endToken;
                int startLine = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)stOffset);
                int endLine = Utilities.getRowLastNonWhite((BaseDocument)doc, (int)endOffset) + 1;
                if (!tokenInBold) {
                    stOffset = -1;
                    endOffset = -1;
                }
                displayText = CsmDisplayUtilities.getLineHtml(startLine, endLine, stOffset, endOffset, doc);
            }
            catch (BadLocationException ex) {
                // empty catch block
            }
        }
        return displayText;
    }

    public static String getContextLine(CsmFile csmFile, int stToken, int endToken) {
        CloneableEditorSupport ces = CsmUtilities.findCloneableEditorSupport(csmFile);
        StyledDocument stDoc = CsmUtilities.openDocument(ces);
        String displayText = null;
        if (stDoc instanceof BaseDocument) {
            BaseDocument doc = (BaseDocument)stDoc;
            try {
                int startLine = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)stToken);
                int endLine = Utilities.getRowLastNonWhite((BaseDocument)doc, (int)endToken) + 1;
                displayText = doc.getText(startLine, endLine - startLine);
            }
            catch (BadLocationException ex) {
                // empty catch block
            }
        }
        return displayText;
    }

    public static String getLineHtml(int startLine, int endLine, int stToken, int endToken, BaseDocument doc) throws BadLocationException {
        int startBold = stToken - startLine;
        int endBold = endToken - startLine;
        String content = doc.getText(startLine, endLine - startLine);
        String mime = DocumentUtilities.getMimeType((Document)doc);
        if (startBold >= 0 && endBold >= 0 && startBold <= content.length() && endBold <= content.length() && startBold < endBold) {
            StringBuilder buf = new StringBuilder();
            buf.append(CsmDisplayUtilities.getHtml(mime, CsmDisplayUtilities.trimStart(content.substring(0, startBold))));
            buf.append("<b>");
            buf.append(CsmDisplayUtilities.getHtml(mime, content.substring(startBold, endBold)));
            buf.append("</b>");
            buf.append(CsmDisplayUtilities.getHtml(mime, CsmDisplayUtilities.trimEnd(content.substring(endBold))));
            return buf.toString();
        }
        return CsmDisplayUtilities.getHtml(mime, content);
    }

    public static String getHtml(String mime, String content) {
        StringBuilder buf = new StringBuilder();
        Language lang = CndLexerUtilities.getLanguage((String)mime);
        if (lang == null) {
            return content;
        }
        TokenHierarchy tokenH = TokenHierarchy.create((CharSequence)content, (Language)lang);
        TokenSequence tok = tokenH.tokenSequence();
        CsmDisplayUtilities.appendHtml(buf, tok);
        return buf.toString();
    }

    public static CharSequence getTooltipText(CsmObject item) {
        try {
            CharSequence tooltipText = null;
            if (CsmKindUtilities.isMethod((CsmObject)item)) {
                CharSequence functionDisplayName = CsmDisplayUtilities.getFunctionText((CsmFunction)item);
                CsmMethod meth = (CsmMethod)CsmBaseUtilities.getFunctionDeclaration((CsmFunction)((CsmFunction)item));
                CsmClass methodDeclaringClass = meth.getContainingClass();
                CharSequence displayClassName = methodDeclaringClass.getQualifiedName();
                String key = "DSC_MethodTooltip";
                if (CsmKindUtilities.isConstructor((CsmObject)item)) {
                    key = "DSC_ConstructorTooltip";
                } else if (CsmKindUtilities.isDestructor((CsmObject)item)) {
                    key = "DSC_DestructorTooltip";
                }
                tooltipText = CsmDisplayUtilities.getHtmlizedString(key, functionDisplayName, displayClassName);
            } else if (CsmKindUtilities.isFunction((CsmObject)item)) {
                CharSequence functionDisplayName = CsmDisplayUtilities.getFunctionText((CsmFunction)item);
                tooltipText = CsmDisplayUtilities.getHtmlizedString("DSC_FunctionTooltip", functionDisplayName);
            } else if (CsmKindUtilities.isClass((CsmObject)item)) {
                CsmDeclaration.Kind classKind = ((CsmDeclaration)item).getKind();
                String key = classKind == CsmDeclaration.Kind.STRUCT ? "DSC_StructTooltip" : (classKind == CsmDeclaration.Kind.UNION ? "DSC_UnionTooltip" : "DSC_ClassTooltip");
                tooltipText = CsmDisplayUtilities.getHtmlizedString(key, ((CsmClassifier)item).getQualifiedName());
            } else if (CsmKindUtilities.isTypedef((CsmObject)item)) {
                CharSequence tdName = ((CsmTypedef)item).getQualifiedName();
                tooltipText = CsmDisplayUtilities.getHtmlizedString("DSC_TypedefTooltip", tdName, ((CsmTypedef)item).getText());
            } else if (CsmKindUtilities.isEnum((CsmObject)item)) {
                tooltipText = CsmDisplayUtilities.getHtmlizedString("DSC_EnumTooltip", ((CsmEnum)item).getQualifiedName());
            } else if (CsmKindUtilities.isEnumerator((Object)item)) {
                CsmEnumerator enmtr = (CsmEnumerator)item;
                tooltipText = CsmDisplayUtilities.getHtmlizedString("DSC_EnumeratorTooltip", enmtr.getName(), enmtr.getEnumeration().getQualifiedName());
            } else if (CsmKindUtilities.isField((CsmObject)item)) {
                CharSequence fieldName = ((CsmField)item).getName();
                CsmClass containingClass = ((CsmField)item).getContainingClass();
                CharSequence displayClassName = containingClass.getQualifiedName();
                String classKind = "class";
                if (containingClass.getKind() == CsmDeclaration.Kind.STRUCT) {
                    classKind = "struct";
                } else if (containingClass.getKind() == CsmDeclaration.Kind.UNION) {
                    classKind = "union";
                }
                tooltipText = CsmDisplayUtilities.getHtmlizedString("DSC_FieldTooltip", fieldName, classKind, displayClassName, ((CsmField)item).getText());
            } else if (CsmKindUtilities.isParamVariable((CsmObject)item)) {
                CharSequence varName = ((CsmParameter)item).getName();
                tooltipText = CsmDisplayUtilities.getHtmlizedString("DSC_ParameterTooltip", varName, ((CsmParameter)item).getText());
            } else if (CsmKindUtilities.isVariable((CsmObject)item)) {
                CharSequence varName = ((CsmVariable)item).getName();
                tooltipText = CsmDisplayUtilities.getHtmlizedString("DSC_VariableTooltip", varName, ((CsmVariable)item).getText());
            } else if (CsmKindUtilities.isFile((CsmObject)item)) {
                CharSequence fileName = ((CsmFile)item).getName();
                tooltipText = CsmDisplayUtilities.getHtmlizedString("DSC_FileTooltip", fileName);
            } else if (CsmKindUtilities.isNamespace((Object)item)) {
                CharSequence nsName = ((CsmNamespace)item).getQualifiedName();
                tooltipText = CsmDisplayUtilities.getHtmlizedString("DSC_NamespaceTooltip", nsName);
            } else if (CsmKindUtilities.isMacro((CsmObject)item)) {
                CsmMacro macro = (CsmMacro)item;
                switch (macro.getKind()) {
                    case DEFINED: {
                        tooltipText = CsmDisplayUtilities.getHtmlizedString("DSC_MacroTooltip", macro.getName(), macro.getText());
                        break;
                    }
                    case COMPILER_PREDEFINED: {
                        tooltipText = CsmDisplayUtilities.getHtmlizedString("DSC_SysMacroTooltip", macro.getName(), macro.getText());
                        break;
                    }
                    case POSITION_PREDEFINED: {
                        tooltipText = CsmDisplayUtilities.getHtmlizedString("DSC_PosMacroTooltip", macro.getName(), macro.getText());
                        break;
                    }
                    case USER_SPECIFIED: {
                        tooltipText = CsmDisplayUtilities.getHtmlizedString("DSC_ProjectMacroTooltip", macro.getName(), macro.getText());
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("unexpected macro kind:" + macro.getKind() + " in macro:" + macro);
                    }
                }
            } else {
                CsmInclude incl;
                CsmFile target;
                tooltipText = CsmKindUtilities.isInclude((CsmObject)item) ? ((target = (incl = (CsmInclude)item).getIncludeFile()) == null ? (incl.getIncludeState() == CsmInclude.IncludeState.Recursive ? CsmDisplayUtilities.getHtmlizedString("DSC_IncludeRecursiveTooltip", incl.getText()) : CsmDisplayUtilities.getHtmlizedString("DSC_IncludeErrorTooltip", incl.getText())) : (target.getProject().isArtificial() ? CsmDisplayUtilities.getHtmlizedString("DSC_IncludeLibraryTooltip", target.getAbsolutePath()) : CsmDisplayUtilities.getHtmlizedString("DSC_IncludeTooltip", target.getAbsolutePath(), target.getProject().getName()))) : (CsmKindUtilities.isQualified((CsmObject)item) ? ((CsmQualifiedNamedElement)item).getQualifiedName() : (CsmKindUtilities.isLabel((CsmObject)item) ? CsmDisplayUtilities.getHtmlizedString("DSC_LabelTooltip", ((CsmLabel)item).getLabel()) : (CsmKindUtilities.isNamedElement((CsmObject)item) ? ((CsmNamedElement)item).getName() : "unhandled object " + item)));
            }
            return tooltipText;
        }
        catch (Exception e) {
            CndUtils.assertTrueInConsole((boolean)false, (String)("can not get text for " + item + " due to " + e));
            return "";
        }
    }

    private static CharSequence getFunctionText(CsmFunction fun) {
        StringBuilder txt = new StringBuilder();
        if (CsmKindUtilities.isMethod((CsmObject)fun) && ((CsmMethod)CsmBaseUtilities.getFunctionDeclaration((CsmFunction)fun)).isVirtual()) {
            txt.append("virtual ");
        }
        txt.append(fun.getReturnType().getText()).append(' ');
        txt.append(fun.getName());
        txt.append('(');
        Iterator params = fun.getParameters().iterator();
        while (params.hasNext()) {
            CsmParameter param = (CsmParameter)params.next();
            txt.append(param.getText());
            if (!params.hasNext()) continue;
            txt.append(", ");
        }
        txt.append(')');
        if (CsmKindUtilities.isMethod((CsmObject)fun)) {
            CsmMethod mtd = (CsmMethod)CsmBaseUtilities.getFunctionDeclaration((CsmFunction)fun);
            if (mtd.isConst()) {
                txt.append(" const");
            }
            if (mtd.isAbstract()) {
                txt.append(" = 0");
            }
        }
        return txt.toString();
    }

    private static String getHtmlizedString(String key, CharSequence value) {
        return CsmDisplayUtilities.getString(key, CsmDisplayUtilities.htmlize(value));
    }

    private static String getHtmlizedString(String key, CharSequence value1, CharSequence value2) {
        return CsmDisplayUtilities.getString(key, CsmDisplayUtilities.htmlize(value1), CsmDisplayUtilities.htmlize(value2));
    }

    private static String getHtmlizedString(String key, CharSequence value1, CharSequence value2, CharSequence value3, CharSequence value4) {
        return CsmDisplayUtilities.getString(key, CsmDisplayUtilities.htmlize(value1), CsmDisplayUtilities.htmlize(value2), CsmDisplayUtilities.htmlize(value3), CsmDisplayUtilities.htmlize(value4));
    }

    private static String getString(String key, CharSequence value) {
        return NbBundle.getMessage(CsmDisplayUtilities.class, (String)key, (Object)value);
    }

    private static String getString(String key, CharSequence value1, CharSequence value2) {
        return NbBundle.getMessage(CsmDisplayUtilities.class, (String)key, (Object)value1, (Object)value2);
    }

    private static String getString(String key, CharSequence value1, CharSequence value2, CharSequence value3, CharSequence value4) {
        return NbBundle.getMessage(CsmDisplayUtilities.class, (String)key, (Object[])new Object[]{value1, value2, value3, value4});
    }

    private static void appendHtml(StringBuilder buf, TokenSequence<?> ts) {
        FontColorSettings settings = null;
        LanguagePath languagePath = ts.languagePath();
        while (!SKIP_COLORING && languagePath != null && settings == null) {
            String mime = languagePath.mimePath();
            Lookup lookup = MimeLookup.getLookup((String)mime);
            settings = (FontColorSettings)lookup.lookup(FontColorSettings.class);
        }
        while (ts.moveNext()) {
            Token token = ts.token();
            TokenSequence es = ts.embedded();
            if (es != null && es.language() == CppTokenId.languagePreproc()) {
                CsmDisplayUtilities.appendHtml(buf, es);
                continue;
            }
            String category = token.id().primaryCategory();
            if (category == null) {
                category = "whitespace";
            }
            String text = "whitespace".equals(category) ? " " : ((Object)token.text()).toString();
            if (settings != null) {
                AttributeSet set = settings.getTokenFontColors(category);
                buf.append(CsmDisplayUtilities.addHTMLColor(CsmDisplayUtilities.htmlize(text), set));
                continue;
            }
            buf.append(CsmDisplayUtilities.htmlize(text));
        }
    }

    public static String htmlize(CharSequence input) {
        if (input == null) {
            System.err.println("null string");
            return "";
        }
        String temp = ((Object)input).toString().replace("&", "&amp;");
        temp = temp.replace("<", "&lt;");
        temp = temp.replace(">", "&gt;");
        return temp;
    }

    public static String addHTMLColor(String string, AttributeSet set) {
        if (set == null) {
            return string;
        }
        if (string.trim().length() == 0) {
            return string.replace(" ", "&nbsp;").replace("\n", "<br>");
        }
        StringBuilder buf = new StringBuilder(string);
        if (StyleConstants.isBold(set)) {
            buf.insert(0, "<b>");
            buf.append("</b>");
        }
        if (StyleConstants.isItalic(set)) {
            buf.insert(0, "<i>");
            buf.append("</i>");
        }
        if (StyleConstants.isStrikeThrough(set)) {
            buf.insert(0, "<s>");
            buf.append("</s>");
        }
        buf.insert(0, "<font color=" + CsmDisplayUtilities.getHTMLColor(LFCustoms.getForeground((AttributeSet)set)) + ">");
        buf.append("</font>");
        return buf.toString();
    }

    public static String getHTMLColor(Color c) {
        String colorR = "0" + Integer.toHexString(c.getRed());
        colorR = colorR.substring(colorR.length() - 2);
        String colorG = "0" + Integer.toHexString(c.getGreen());
        colorG = colorG.substring(colorG.length() - 2);
        String colorB = "0" + Integer.toHexString(c.getBlue());
        colorB = colorB.substring(colorB.length() - 2);
        String html_color = "#" + colorR + colorG + colorB;
        return html_color;
    }

    private static String trimStart(String s) {
        for (int x = 0; x < s.length(); ++x) {
            if (Character.isWhitespace(s.charAt(x))) continue;
            return s.substring(x, s.length());
        }
        return "";
    }

    private static String trimEnd(String s) {
        for (int x = s.length() - 1; x >= 0; --x) {
            if (Character.isWhitespace(s.charAt(x))) continue;
            return s.substring(0, x + 1);
        }
        return "";
    }

    public static String shrinkPath(CharSequence path, int maxDisplayedDirLen, int nrDisplayedFrontDirs, int nrDisplayedTrailingDirs) {
        return CsmDisplayUtilities.shrinkPath(path, true, File.separator, maxDisplayedDirLen, nrDisplayedFrontDirs, nrDisplayedTrailingDirs);
    }

    public static String shrinkPath(CharSequence path, boolean shrink, String separator, int maxDisplayedDirLen, int nrDisplayedFrontDirs, int nrDisplayedTrailingDirs) {
        String SLASH = "/";
        StringBuilder builder = new StringBuilder(path);
        String toReplace = null;
        if ("/".equals(separator)) {
            if (builder.indexOf("\\") >= 0) {
                toReplace = "\\";
            }
        } else if (builder.indexOf("/") >= 0) {
            toReplace = "/";
        }
        if (toReplace != null) {
            builder = new StringBuilder(builder.toString().replace(toReplace, separator));
        }
        int len = builder.length();
        if (shrink && len > maxDisplayedDirLen) {
            StringBuilder reverse = new StringBuilder(builder).reverse();
            int st = builder.indexOf(separator);
            st = st < 0 ? 0 : ++st;
            int end = 0;
            while (reverse.charAt(end) == separator.charAt(0)) {
                ++end;
            }
            int firstSlash = nrDisplayedFrontDirs > 0 ? Integer.MAX_VALUE : -1;
            for (int i = nrDisplayedFrontDirs; i > 0 && firstSlash > 0; --i) {
                firstSlash = builder.indexOf(separator, st);
                st = firstSlash + 1;
            }
            int lastSlash = nrDisplayedTrailingDirs > 0 ? Integer.MAX_VALUE : -1;
            for (int i = nrDisplayedTrailingDirs; i > 0 && lastSlash > 0; --i) {
                lastSlash = reverse.indexOf(separator, end);
                end = lastSlash + 1;
            }
            if (lastSlash > 0 && firstSlash > 0 && firstSlash < (lastSlash = len - lastSlash) - 1) {
                builder.replace(firstSlash, lastSlash - 1, "...");
            }
        }
        return builder.toString();
    }
}

