/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.stp.ui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.NavigationFilter;
import javax.swing.text.Position;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;

public class HyperlinkTextArea
extends HTMLTextArea {
    private String originalText;
    private boolean selected = false;

    public HyperlinkTextArea() {
        this.setFont(UIManager.getFont("Label.font"));
        this.setForeground(Color.DARK_GRAY);
        this.setOpaque(false);
        this.setFocusable(true);
        this.setHighlighter(null);
        this.setShowPopup(false);
        this.setNavigationFilter(new NavigationFilter(){

            @Override
            public void moveDot(NavigationFilter.FilterBypass fb, int dot, Position.Bias bias) {
                super.moveDot(fb, 0, bias);
            }

            @Override
            public void setDot(NavigationFilter.FilterBypass fb, int dot, Position.Bias bias) {
                super.setDot(fb, 0, bias);
            }

            @Override
            public int getNextVisualPositionFrom(JTextComponent text, int pos, Position.Bias bias, int direction, Position.Bias[] biasRet) throws BadLocationException {
                return 0;
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (HyperlinkTextArea.this.isSelected()) {
                    return;
                }
                HyperlinkTextArea.this.setCursor(Cursor.getPredefinedCursor(12));
                if (HyperlinkTextArea.this.isFocusOwner()) {
                    return;
                }
                HyperlinkTextArea.this.decorateHighlight();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (HyperlinkTextArea.this.isSelected()) {
                    return;
                }
                HyperlinkTextArea.this.setCursor(Cursor.getDefaultCursor());
                if (HyperlinkTextArea.this.isFocusOwner()) {
                    return;
                }
                HyperlinkTextArea.this.decorateNormal();
            }
        });
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (!HyperlinkTextArea.this.isSelected()) {
                    HyperlinkTextArea.this.decorateHighlight();
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (!HyperlinkTextArea.this.isSelected()) {
                    HyperlinkTextArea.this.decorateNormal();
                }
            }
        });
    }

    public HyperlinkTextArea(String text) {
        this();
        this.setText(text);
    }

    public void updateAppearance() {
        if (this.isSelected() || this.isFocusOwner()) {
            this.decorateHighlight();
        } else {
            this.decorateNormal();
        }
    }

    public void setForeground(Color color) {
        String originalTextBkp = this.originalText;
        super.setForeground(color);
        this.originalText = originalTextBkp;
        super.setText(this.originalText);
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        if (selected) {
            this.decorateHighlight();
        } else {
            this.decorateNormal();
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setText(String value) {
        Caret c;
        this.originalText = value;
        super.setText(value);
        Document d = this.getDocument();
        if (d != null) {
            String accesibleName = value;
            try {
                accesibleName = d.getText(1, d.getLength() - 1);
            }
            catch (BadLocationException ex) {
                // empty catch block
            }
            this.getAccessibleContext().setAccessibleName(accesibleName);
        }
        if ((c = this.getCaret()) != null) {
            c.setVisible(false);
        }
    }

    public void scrollRectToVisible(Rectangle aRect) {
    }

    protected Color getHighlightColor() {
        return Color.BLACK;
    }

    protected String getHighlightText(String originalText) {
        return "<u>" + originalText + "</u>";
    }

    protected Color getNormalColor() {
        return Color.DARK_GRAY;
    }

    protected String getNormalText(String originalText) {
        return originalText;
    }

    private void decorateHighlight() {
        this.setForeground(this.getHighlightColor());
        super.setText(this.getHighlightText(this.originalText));
    }

    private void decorateNormal() {
        this.setForeground(this.getNormalColor());
        super.setText(this.getNormalText(this.originalText));
    }
}

