/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.stp.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseWheelListener;
import java.util.EventObject;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.filters.FilterUtils;
import org.netbeans.lib.profiler.common.filters.GlobalFilters;
import org.netbeans.lib.profiler.ui.UIConstants;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.lib.profiler.ui.components.JExtendedTable;
import org.netbeans.lib.profiler.ui.components.table.BooleanTableCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.LabelTableCellRenderer;
import org.netbeans.modules.profiler.stp.ui.Bundle;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;

public final class GlobalFiltersPanel
extends JPanel
implements HelpCtx.Provider {
    private static final String HELP_CTX_KEY = "GlobalFiltersPanel.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("GlobalFiltersPanel.HelpCtx");
    private static GlobalFiltersPanel defaultInstance;
    JTextField filterTableStringCellEditorComponent;
    private ActionListener buttonsListener;
    private HTMLTextArea hintArea;
    private JButton CancelButton;
    private JButton OKButton;
    private JButton deleteButton;
    private JButton editButton;
    private JButton moveDownButton;
    private JButton moveUpButton;
    private JButton newButton;
    private JExtendedTable filterTable;
    private JLabel definedFiltersLabel;
    private SelectionListener selectionListener;
    private final Class[] columnClasses;
    private final String[] columnNames = new String[]{Bundle.GlobalFiltersPanel_ColumnNameName(), Bundle.GlobalFiltersPanel_ColumnNameValue()};
    private String cellValueBeforeEditing;
    private String[] filterNames;
    private String[] filterValues;
    private boolean filterCellEditorChangesOKButton = false;

    public GlobalFiltersPanel(String[] filterNames, String[] filterValues) {
        super(new BorderLayout());
        this.columnClasses = new Class[]{String.class, String.class};
        this.setFilterNamesFrom(filterNames);
        this.setFilterValuesFrom(filterValues);
        this.initComponents();
    }

    private GlobalFiltersPanel() {
        super(new BorderLayout());
        this.columnClasses = new Class[]{String.class, String.class};
        this.setFilterNamesFrom(new String[0]);
        this.setFilterValuesFrom(new String[0]);
        this.initComponents();
    }

    public static GlobalFiltersPanel getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new GlobalFiltersPanel();
        }
        return defaultInstance;
    }

    public JButton getCancelButton() {
        return this.CancelButton;
    }

    public String[] getFilterNamesCopy() {
        String[] names = new String[this.filterNames.length];
        System.arraycopy(this.filterNames, 0, names, 0, this.filterNames.length);
        return names;
    }

    public void setFilterNamesFrom(String[] names) {
        this.filterNames = new String[names.length];
        System.arraycopy(names, 0, this.filterNames, 0, names.length);
        if (this.filterTable != null) {
            ((AbstractTableModel)this.filterTable.getModel()).fireTableDataChanged();
        }
    }

    public String[] getFilterValuesCopy() {
        String[] values = new String[this.filterValues.length];
        System.arraycopy(this.filterValues, 0, values, 0, this.filterValues.length);
        return this.filterValues;
    }

    public void setFilterValuesFrom(String[] values) {
        this.filterValues = new String[values.length];
        System.arraycopy(values, 0, this.filterValues, 0, values.length);
        if (this.filterTable != null) {
            ((AbstractTableModel)this.filterTable.getModel()).fireTableDataChanged();
        }
        this.updateOKButton();
    }

    public HelpCtx getHelpCtx() {
        return HELP_CTX;
    }

    public JButton getOKButton() {
        return this.OKButton;
    }

    public void applyChanges() {
        this.stopFilterTableEditing();
        GlobalFilters globalFilters = Profiler.getDefault().getGlobalFilters();
        globalFilters.setFilterNames(this.getFilterNamesCopy());
        globalFilters.setFilterValues(this.getFilterValuesCopy());
        Profiler.getDefault().saveFilters();
    }

    public void editFilterValueAtRow(int row) {
        this.processUniqueFilterNameCheckAt(this.filterTable.getEditingRow(), this.filterTable.getEditingColumn());
        this.stopFilterTableEditing();
        this.filterTable.clearSelection();
        this.filterTable.addRowSelectionInterval(row, row);
        this.editSelectedRow(1);
        this.filterTableStringCellEditorComponent.selectAll();
    }

    public void init() {
        this.stopFilterTableEditing();
        this.filterTable.clearSelection();
        GlobalFilters globalFilters = Profiler.getDefault().getGlobalFilters();
        this.setFilterNamesFrom(globalFilters.getFilterNames());
        this.setFilterValuesFrom(globalFilters.getFilterValues());
    }

    private boolean isValidFilter(String complexFilter) {
        if (complexFilter == null) {
            return false;
        }
        String[] filterParts = FilterUtils.getSeparateFilters((String)complexFilter);
        for (int i = 0; i < filterParts.length; ++i) {
            if (FilterUtils.isValidProfilerFilter((String)filterParts[i])) continue;
            return false;
        }
        return true;
    }

    private void addNewFilter() {
        int nCurrentFilters = this.filterNames.length;
        String[] newFilterNames = new String[nCurrentFilters + 1];
        String[] newFilterValues = new String[nCurrentFilters + 1];
        Boolean[] newFilterEnablers = new Boolean[nCurrentFilters + 1];
        System.arraycopy(this.filterNames, 0, newFilterNames, 0, nCurrentFilters);
        System.arraycopy(this.filterValues, 0, newFilterValues, 0, nCurrentFilters);
        newFilterNames[nCurrentFilters] = this.createUniqueFilterName();
        newFilterValues[nCurrentFilters] = "";
        newFilterEnablers[nCurrentFilters] = Boolean.TRUE;
        this.filterNames = newFilterNames;
        this.filterValues = newFilterValues;
        this.filterTable.invalidate();
        this.revalidate();
        this.repaint();
        this.filterTable.clearSelection();
        this.filterTable.addRowSelectionInterval(nCurrentFilters, nCurrentFilters);
        this.makeSelectedFilterVisible();
        this.filterTable.editCellAt(nCurrentFilters, 0);
        this.filterTableStringCellEditorComponent.selectAll();
    }

    private boolean areFiltersValidExceptRow(int row) {
        for (int i = 0; i < this.filterValues.length; ++i) {
            if (i == row || this.isValidFilter(this.filterValues[i])) continue;
            return false;
        }
        return true;
    }

    private boolean containsFilterName(String filterName) {
        for (int i = 0; i < this.filterNames.length; ++i) {
            if (!this.filterNames[i].equals(filterName)) continue;
            return true;
        }
        return false;
    }

    private boolean containsFilterNameExceptRow(String filterName, int row) {
        for (int i = 0; i < this.filterNames.length; ++i) {
            if (i == row || !this.filterNames[i].equals(filterName)) continue;
            return true;
        }
        return false;
    }

    private String createUniqueFilterName() {
        return this.createUniqueFilterName(Bundle.GlobalFiltersPanel_DefaultFilterName());
    }

    private String createUniqueFilterName(String baseFilterName) {
        int index = 1;
        String filterNameExt = "";
        while (this.containsFilterName(baseFilterName + filterNameExt)) {
            filterNameExt = " (" + ++index + ")";
        }
        return baseFilterName + filterNameExt;
    }

    private void deleteSelectedFilters() {
        int nFiltersToDelete = this.filterTable.getSelectedRowCount();
        int nNewFilters = this.filterNames.length - nFiltersToDelete;
        int rowToSelect = 0;
        String[] newFilterNames = new String[nNewFilters];
        String[] newFilterValues = new String[nNewFilters];
        int index = 0;
        for (int i = 0; i < this.filterNames.length; ++i) {
            if (!this.filterTable.isRowSelected(i)) {
                newFilterNames[index] = this.filterNames[i];
                newFilterValues[index] = this.filterValues[i];
                ++index;
                continue;
            }
            rowToSelect = Math.max(0, index - 1);
            this.filterTable.removeRowSelectionInterval(i, i);
        }
        this.stopFilterTableEditing();
        this.filterNames = newFilterNames;
        this.filterValues = newFilterValues;
        this.filterTable.invalidate();
        this.revalidate();
        this.repaint();
        if (this.filterTable.getRowCount() > 0) {
            this.filterTable.addRowSelectionInterval(rowToSelect, rowToSelect);
            this.makeSelectedFilterVisible();
        }
        this.updateOKButton();
    }

    private void editSelectedCell() {
        this.filterTable.editCellAt(this.filterTable.getSelectedRow(), this.filterTable.getSelectedColumn(), new EventObject(this.filterTable));
    }

    private void editSelectedRow(int column) {
        this.filterTable.editCellAt(this.filterTable.getSelectedRow(), column, new EventObject(this.filterTable));
    }

    private void initComponents() {
        this.OKButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.OKButton, (String)Bundle.GlobalFiltersPanel_OkButtonText());
        this.CancelButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.CancelButton, (String)Bundle.GlobalFiltersPanel_CancelButtonText());
        this.buttonsListener = new ButtonsListener();
        this.selectionListener = new SelectionListener();
        this.definedFiltersLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.definedFiltersLabel, (String)Bundle.GlobalFiltersPanel_DefinedFiltersLabelText());
        this.definedFiltersLabel.setOpaque(false);
        this.definedFiltersLabel.setBorder(BorderFactory.createEmptyBorder(15, 5, 0, 5));
        this.add((Component)this.definedFiltersLabel, "North");
        LabelTableCellRenderer filterTableCellRenderer = new LabelTableCellRenderer(){

            protected void setState(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (column == 1) {
                    if (GlobalFiltersPanel.this.isValidFilter((String)value)) {
                        this.label.setForeground(UIManager.getColor("Label.foreground"));
                    } else {
                        this.label.setForeground(Color.red);
                    }
                }
            }
        };
        filterTableCellRenderer.setSupportsFocusBorder(true);
        BooleanTableCellRenderer booleanTableCellRenderer = new BooleanTableCellRenderer();
        booleanTableCellRenderer.setSupportsFocusBorder(true);
        this.filterTableStringCellEditorComponent = new JTextField();
        this.filterTableStringCellEditorComponent.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIUtils.getDarkerLine((Color)UIConstants.TABLE_SELECTION_BACKGROUND_COLOR, (float)0.65f)), BorderFactory.createEmptyBorder(1, 2, 1, 3)));
        this.filterTableStringCellEditorComponent.setSelectionColor(UIConstants.TABLE_SELECTION_BACKGROUND_COLOR);
        this.filterTableStringCellEditorComponent.setSelectedTextColor(UIConstants.TABLE_SELECTION_FOREGROUND_COLOR);
        this.filterTableStringCellEditorComponent.addKeyListener(new CellEditorKeyListener());
        this.filterTableStringCellEditorComponent.addFocusListener(new CellEditorFocusListener());
        this.filterTableStringCellEditorComponent.getDocument().addDocumentListener(new CellEditorDocumentListener());
        DefaultCellEditor filterTableStringCellEditor = new DefaultCellEditor(this.filterTableStringCellEditorComponent);
        this.filterTable = new JExtendedTable(new FilterTableModel()){

            public boolean editCellAt(int row, int column, EventObject e) {
                Component c;
                boolean canEdit = super.editCellAt(row, column, e);
                if (canEdit && (c = this.getEditorComponent()) != null) {
                    c.requestFocus();
                    c.repaint();
                }
                return canEdit;
            }
        };
        this.definedFiltersLabel.setLabelFor((Component)this.filterTable);
        this.filterTable.getAccessibleContext().setAccessibleName(Bundle.GlobalFiltersPanel_FilterTableAccessName());
        this.filterTable.setSurrendersFocusOnKeystroke(true);
        this.filterTable.setRowSelectionAllowed(true);
        this.filterTable.setSelectionMode(2);
        this.filterTable.setGridColor(UIConstants.TABLE_VERTICAL_GRID_COLOR);
        this.filterTable.setSelectionBackground(UIConstants.TABLE_SELECTION_BACKGROUND_COLOR);
        this.filterTable.setSelectionForeground(UIConstants.TABLE_SELECTION_FOREGROUND_COLOR);
        this.filterTable.setShowHorizontalLines(false);
        this.filterTable.setShowVerticalLines(true);
        this.filterTable.setRowMargin(0);
        this.filterTable.getTableHeader().setReorderingAllowed(false);
        this.filterTable.getSelectionModel().addListSelectionListener(this.selectionListener);
        this.filterTable.setDefaultRenderer(String.class, (TableCellRenderer)filterTableCellRenderer);
        this.filterTable.setDefaultRenderer(Boolean.class, (TableCellRenderer)booleanTableCellRenderer);
        this.filterTable.setRowHeight(UIUtils.getDefaultRowHeight() + 2);
        this.filterTable.setDefaultEditor(String.class, (TableCellEditor)filterTableStringCellEditor);
        this.filterTable.addKeyListener((KeyListener)new FilterTableKeyListener());
        final JScrollPane filterTableScrollPane = new JScrollPane(22, 31);
        FilterTableViewport filterTableViewport = new FilterTableViewport((JTable)this.filterTable);
        filterTableScrollPane.setViewport(filterTableViewport);
        filterTableScrollPane.addMouseWheelListener((MouseWheelListener)this.filterTable);
        filterTableScrollPane.getVerticalScrollBar().getModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (filterTableScrollPane.getVerticalScrollBar().getModel().getExtent() == filterTableScrollPane.getVerticalScrollBar().getModel().getMaximum()) {
                    filterTableScrollPane.getVerticalScrollBar().setEnabled(false);
                } else {
                    filterTableScrollPane.getVerticalScrollBar().setEnabled(true);
                }
            }
        });
        filterTableScrollPane.setPreferredSize(new Dimension(490, 370));
        JPanel filterTablePanel = new JPanel(new BorderLayout());
        filterTablePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 3));
        filterTablePanel.add((Component)filterTableScrollPane, "Center");
        this.newButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.newButton, (String)Bundle.GlobalFiltersPanel_NewButtonText());
        this.newButton.getAccessibleContext().setAccessibleDescription(Bundle.GlobalFiltersPanel_NewButtonAccessDesc());
        this.newButton.addActionListener(this.buttonsListener);
        this.editButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.editButton, (String)Bundle.GlobalFiltersPanel_EditButtonText());
        this.editButton.getAccessibleContext().setAccessibleDescription(Bundle.GlobalFiltersPanel_EditButtonAccessDesc());
        this.editButton.setEnabled(false);
        this.editButton.addActionListener(this.buttonsListener);
        this.deleteButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.deleteButton, (String)Bundle.GlobalFiltersPanel_DeleteButtonText());
        this.deleteButton.getAccessibleContext().setAccessibleDescription(Bundle.GlobalFiltersPanel_DeleteButtonAccessDesc());
        this.deleteButton.setEnabled(false);
        this.deleteButton.addActionListener(this.buttonsListener);
        this.moveUpButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.moveUpButton, (String)Bundle.GlobalFiltersPanel_MoveUpButtonText());
        this.moveUpButton.getAccessibleContext().setAccessibleDescription(Bundle.GlobalFiltersPanel_MoveUpButtonAccessDesc());
        this.moveUpButton.setEnabled(false);
        this.moveUpButton.addActionListener(this.buttonsListener);
        this.moveDownButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.moveDownButton, (String)Bundle.GlobalFiltersPanel_MoveDownButtonText());
        this.moveDownButton.getAccessibleContext().setAccessibleDescription(Bundle.GlobalFiltersPanel_MoveDownButtonAccessDesc());
        this.moveDownButton.setEnabled(false);
        this.moveDownButton.addActionListener(this.buttonsListener);
        JPanel buttonsPanel1 = new JPanel(new GridLayout(6, 1, 0, 5));
        buttonsPanel1.add(this.newButton);
        buttonsPanel1.add(this.editButton);
        buttonsPanel1.add(this.deleteButton);
        buttonsPanel1.add(new JPanel());
        buttonsPanel1.add(this.moveUpButton);
        buttonsPanel1.add(this.moveDownButton);
        JPanel buttonsPanel = new JPanel(new BorderLayout());
        buttonsPanel.setBorder(BorderFactory.createEmptyBorder(15, 5, 5, 5));
        buttonsPanel.add((Component)buttonsPanel1, "North");
        Color panelBackground = UIManager.getColor("Panel.background");
        Color hintBackground = UIUtils.getSafeColor((int)(panelBackground.getRed() - 10), (int)(panelBackground.getGreen() - 10), (int)(panelBackground.getBlue() - 10));
        this.hintArea = new HTMLTextArea(){

            public Dimension getPreferredSize() {
                return new Dimension(1, super.getPreferredSize().height);
            }
        };
        this.hintArea.setText(Bundle.GlobalFiltersPanel_HintMsg());
        this.hintArea.setEnabled(false);
        this.hintArea.setDisabledTextColor(Color.darkGray);
        this.hintArea.setBackground(hintBackground);
        this.hintArea.setBorder((Border)BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(7, 7, 10, 7, UIManager.getColor("Panel.background")), BorderFactory.createMatteBorder(10, 10, 10, 10, hintBackground)));
        this.add((Component)filterTablePanel, "Center");
        this.add((Component)buttonsPanel, "East");
        this.add((Component)this.hintArea, "South");
        this.updateOKButton();
    }

    private void makeSelectedFilterVisible() {
        this.filterTable.scrollRectToVisible(this.filterTable.getCellRect(this.filterTable.getSelectedRow(), this.filterTable.getSelectedColumn(), true));
    }

    private void moveSelectedRowDown() {
        this.stopFilterTableEditing();
        int selectedRow = this.filterTable.getSelectedRow();
        if (selectedRow < this.filterTable.getRowCount() - 1) {
            String tmpFilterName = this.filterNames[selectedRow + 1];
            String tmpFilterValue = this.filterValues[selectedRow + 1];
            this.filterNames[selectedRow + 1] = this.filterNames[selectedRow];
            this.filterValues[selectedRow + 1] = this.filterValues[selectedRow];
            this.filterNames[selectedRow] = tmpFilterName;
            this.filterValues[selectedRow] = tmpFilterValue;
            this.filterTable.repaint();
            this.filterTable.clearSelection();
            this.filterTable.addRowSelectionInterval(selectedRow + 1, selectedRow + 1);
            this.makeSelectedFilterVisible();
        }
    }

    private void moveSelectedRowUp() {
        this.stopFilterTableEditing();
        int selectedRow = this.filterTable.getSelectedRow();
        if (selectedRow > 0) {
            String tmpFilterName = this.filterNames[selectedRow - 1];
            String tmpFilterValue = this.filterValues[selectedRow - 1];
            this.filterNames[selectedRow - 1] = this.filterNames[selectedRow];
            this.filterValues[selectedRow - 1] = this.filterValues[selectedRow];
            this.filterNames[selectedRow] = tmpFilterName;
            this.filterValues[selectedRow] = tmpFilterValue;
            this.filterTable.repaint();
            this.filterTable.clearSelection();
            this.filterTable.addRowSelectionInterval(selectedRow - 1, selectedRow - 1);
            this.makeSelectedFilterVisible();
        }
    }

    private void processUniqueFilterNameCheckAt(int row, int column) {
        boolean noFilterNameDefined;
        if (column != 0) {
            return;
        }
        this.filterNames[row] = this.filterNames[row].trim();
        boolean bl = noFilterNameDefined = this.filterNames[row].length() == 0;
        if (noFilterNameDefined || this.containsFilterNameExceptRow(this.filterNames[row], row)) {
            this.stopFilterTableEditing();
            this.filterNames[row] = noFilterNameDefined ? this.createUniqueFilterName() : this.createUniqueFilterName(this.filterNames[row]);
        }
        this.filterTable.repaint();
    }

    private void stopFilterTableEditing() {
        if (this.filterTable.getCellEditor() == null) {
            return;
        }
        if (this.filterNames.length == 0 || this.filterValues.length == 0) {
            return;
        }
        this.filterTable.getCellEditor().stopCellEditing();
    }

    private void updateOKButton() {
        if (this.OKButton == null) {
            return;
        }
        for (int i = 0; i < this.filterValues.length; ++i) {
            if (this.isValidFilter(this.filterValues[i])) continue;
            this.OKButton.setEnabled(false);
            return;
        }
        this.OKButton.setEnabled(true);
    }

    private final class SelectionListener
    implements ListSelectionListener {
        private SelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int selectedRowCount = GlobalFiltersPanel.this.filterTable.getSelectedRowCount();
            if (selectedRowCount == 0) {
                GlobalFiltersPanel.this.editButton.setEnabled(false);
                GlobalFiltersPanel.this.deleteButton.setEnabled(false);
                GlobalFiltersPanel.this.moveUpButton.setEnabled(false);
                GlobalFiltersPanel.this.moveDownButton.setEnabled(false);
            } else {
                GlobalFiltersPanel.this.editButton.setEnabled(true);
                GlobalFiltersPanel.this.deleteButton.setEnabled(true);
                if (selectedRowCount == 1 && GlobalFiltersPanel.this.filterTable.getSelectedRow() > 0) {
                    GlobalFiltersPanel.this.moveUpButton.setEnabled(true);
                } else {
                    GlobalFiltersPanel.this.moveUpButton.setEnabled(false);
                }
                if (selectedRowCount == 1 && GlobalFiltersPanel.this.filterTable.getSelectedRow() < GlobalFiltersPanel.this.filterTable.getRowCount() - 1) {
                    GlobalFiltersPanel.this.moveDownButton.setEnabled(true);
                } else {
                    GlobalFiltersPanel.this.moveDownButton.setEnabled(false);
                }
            }
        }
    }

    private static final class FilterTableViewport
    extends JViewport
    implements TableColumnModelListener {
        private final JTableHeader tableHeader;

        public FilterTableViewport(JTable table) {
            this.setView(table);
            this.setBackground(table.getBackground());
            this.tableHeader = table.getTableHeader();
            this.tableHeader.getColumnModel().addColumnModelListener(this);
        }

        @Override
        public void columnAdded(TableColumnModelEvent e) {
            this.repaint();
        }

        @Override
        public void columnMarginChanged(ChangeEvent e) {
            this.repaint();
        }

        @Override
        public void columnMoved(TableColumnModelEvent e) {
            this.repaint();
        }

        @Override
        public void columnRemoved(TableColumnModelEvent e) {
            this.repaint();
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent e) {
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            this.paintVerticalLines(g);
        }

        private int getEmptySpaceY() {
            if (this.getView() == null) {
                return 0;
            }
            return this.getView().getHeight();
        }

        private void paintVerticalLines(Graphics g) {
            int emptySpaceY = this.getEmptySpaceY();
            g.setColor(UIConstants.TABLE_VERTICAL_GRID_COLOR);
            for (int i = 0; i < this.tableHeader.getColumnModel().getColumnCount(); ++i) {
                Rectangle cellRect = this.tableHeader.getHeaderRect(i);
                g.drawLine(cellRect.x + cellRect.width - 1, emptySpaceY, cellRect.x + cellRect.width - 1, this.getHeight() - 1);
            }
        }
    }

    private final class FilterTableModel
    extends AbstractTableModel {
        private FilterTableModel() {
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        public Class getColumnClass(int column) {
            return GlobalFiltersPanel.this.columnClasses[column];
        }

        @Override
        public int getColumnCount() {
            return GlobalFiltersPanel.this.columnNames.length;
        }

        @Override
        public String getColumnName(int column) {
            return GlobalFiltersPanel.this.columnNames[column];
        }

        @Override
        public int getRowCount() {
            return GlobalFiltersPanel.this.filterNames.length;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    ((GlobalFiltersPanel)GlobalFiltersPanel.this).filterNames[rowIndex] = ((String)aValue).trim();
                    break;
                }
                case 1: {
                    ((GlobalFiltersPanel)GlobalFiltersPanel.this).filterValues[rowIndex] = (String)aValue;
                }
            }
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return GlobalFiltersPanel.this.filterNames[rowIndex];
                }
                case 1: {
                    return GlobalFiltersPanel.this.filterValues[rowIndex];
                }
            }
            return null;
        }
    }

    private final class FilterTableKeyListener
    extends KeyAdapter {
        private FilterTableKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            int keyCode = e.getKeyCode();
            int keyModifiers = e.getModifiers();
            if (keyCode == GlobalFiltersPanel.this.editButton.getMnemonic() && keyModifiers == 8) {
                e.consume();
                GlobalFiltersPanel.this.editSelectedCell();
                return;
            }
            switch (keyCode) {
                case 127: {
                    e.consume();
                    GlobalFiltersPanel.this.deleteSelectedFilters();
                    break;
                }
                case 78: {
                    if (keyModifiers == 2) {
                        e.consume();
                        GlobalFiltersPanel.this.addNewFilter();
                        break;
                    }
                }
                case 38: {
                    if (keyModifiers == 2) {
                        e.consume();
                        if (GlobalFiltersPanel.this.filterTable.getSelectedRowCount() != 1 || GlobalFiltersPanel.this.filterTable.getSelectedRow() <= 0) break;
                        GlobalFiltersPanel.this.moveSelectedRowUp();
                        break;
                    }
                }
                case 40: {
                    if (keyModifiers == 2) {
                        e.consume();
                        if (GlobalFiltersPanel.this.filterTable.getSelectedRowCount() != 1 || GlobalFiltersPanel.this.filterTable.getSelectedRow() >= GlobalFiltersPanel.this.filterTable.getRowCount() - 1) break;
                        GlobalFiltersPanel.this.moveSelectedRowDown();
                        break;
                    }
                }
                case 27: {
                    GlobalFiltersPanel.this.processKeyEvent(e);
                }
            }
        }
    }

    private final class CellEditorKeyListener
    extends KeyAdapter {
        private CellEditorKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            switch (e.getKeyCode()) {
                case 10: {
                    if (GlobalFiltersPanel.this.filterTable.getEditingColumn() != 0) break;
                    e.consume();
                    GlobalFiltersPanel.this.processUniqueFilterNameCheckAt(GlobalFiltersPanel.this.filterTable.getEditingRow(), GlobalFiltersPanel.this.filterTable.getEditingColumn());
                    GlobalFiltersPanel.this.stopFilterTableEditing();
                    GlobalFiltersPanel.this.editSelectedRow(1);
                    GlobalFiltersPanel.this.filterTableStringCellEditorComponent.selectAll();
                    break;
                }
                case 27: {
                    e.consume();
                    GlobalFiltersPanel.this.filterTableStringCellEditorComponent.setText(GlobalFiltersPanel.this.cellValueBeforeEditing);
                    GlobalFiltersPanel.this.stopFilterTableEditing();
                }
            }
        }
    }

    private final class CellEditorFocusListener
    extends FocusAdapter {
        private int lastEditedColumn;
        private int lastEditedRow;

        private CellEditorFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.lastEditedRow = GlobalFiltersPanel.this.filterTable.getEditingRow();
            this.lastEditedColumn = GlobalFiltersPanel.this.filterTable.getEditingColumn();
            GlobalFiltersPanel.this.editButton.setEnabled(false);
            GlobalFiltersPanel.this.cellValueBeforeEditing = (String)GlobalFiltersPanel.this.filterTable.getValueAt(this.lastEditedRow, this.lastEditedColumn);
            GlobalFiltersPanel.this.filterCellEditorChangesOKButton = GlobalFiltersPanel.this.areFiltersValidExceptRow(this.lastEditedRow);
            if (this.lastEditedColumn == 1) {
                if (GlobalFiltersPanel.this.isValidFilter(GlobalFiltersPanel.this.filterTableStringCellEditorComponent.getText())) {
                    GlobalFiltersPanel.this.filterTableStringCellEditorComponent.setForeground(UIManager.getColor("Label.foreground"));
                    GlobalFiltersPanel.this.filterTableStringCellEditorComponent.setSelectedTextColor(UIManager.getColor("Label.foreground"));
                } else {
                    GlobalFiltersPanel.this.filterTableStringCellEditorComponent.setForeground(Color.red);
                    GlobalFiltersPanel.this.filterTableStringCellEditorComponent.setSelectedTextColor(Color.red);
                }
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            GlobalFiltersPanel.this.processUniqueFilterNameCheckAt(this.lastEditedRow, this.lastEditedColumn);
            GlobalFiltersPanel.this.editButton.setEnabled(true);
        }
    }

    private final class CellEditorDocumentListener
    implements DocumentListener {
        private CellEditorDocumentListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            if (GlobalFiltersPanel.this.filterTable.getEditingColumn() == 0) {
                this.updateFilterName();
            } else if (GlobalFiltersPanel.this.filterTable.getEditingColumn() == 1) {
                this.checkFilterValue();
            }
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            if (GlobalFiltersPanel.this.filterTable.getEditingColumn() == 0) {
                this.updateFilterName();
            } else if (GlobalFiltersPanel.this.filterTable.getEditingColumn() == 1) {
                this.checkFilterValue();
            }
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            if (GlobalFiltersPanel.this.filterTable.getEditingColumn() == 0) {
                this.updateFilterName();
            } else if (GlobalFiltersPanel.this.filterTable.getEditingColumn() == 1) {
                this.checkFilterValue();
            }
        }

        private void checkFilterValue() {
            if (!GlobalFiltersPanel.this.isValidFilter(GlobalFiltersPanel.this.filterTableStringCellEditorComponent.getText())) {
                GlobalFiltersPanel.this.filterTableStringCellEditorComponent.setForeground(Color.red);
                GlobalFiltersPanel.this.filterTableStringCellEditorComponent.setSelectedTextColor(Color.red);
                if (GlobalFiltersPanel.this.filterCellEditorChangesOKButton) {
                    GlobalFiltersPanel.this.OKButton.setEnabled(false);
                }
            } else {
                GlobalFiltersPanel.this.filterTableStringCellEditorComponent.setForeground(UIManager.getColor("Label.foreground"));
                GlobalFiltersPanel.this.filterTableStringCellEditorComponent.setSelectedTextColor(UIManager.getColor("Label.foreground"));
                if (GlobalFiltersPanel.this.filterCellEditorChangesOKButton) {
                    GlobalFiltersPanel.this.OKButton.setEnabled(true);
                }
            }
        }

        private void updateFilterName() {
            ((GlobalFiltersPanel)GlobalFiltersPanel.this).filterNames[((GlobalFiltersPanel)GlobalFiltersPanel.this).filterTable.getEditingRow()] = GlobalFiltersPanel.this.filterTableStringCellEditorComponent.getText();
        }
    }

    private final class ButtonsListener
    implements ActionListener {
        private ButtonsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == GlobalFiltersPanel.this.newButton) {
                GlobalFiltersPanel.this.addNewFilter();
            } else if (e.getSource() == GlobalFiltersPanel.this.editButton) {
                GlobalFiltersPanel.this.editSelectedCell();
            } else if (e.getSource() == GlobalFiltersPanel.this.deleteButton) {
                GlobalFiltersPanel.this.deleteSelectedFilters();
            } else if (e.getSource() == GlobalFiltersPanel.this.moveUpButton) {
                GlobalFiltersPanel.this.moveSelectedRowUp();
            } else if (e.getSource() == GlobalFiltersPanel.this.moveDownButton) {
                GlobalFiltersPanel.this.moveSelectedRowDown();
            }
        }
    }
}

