/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.stp;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.DiscreteProgress;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.stp.Bundle;
import org.netbeans.modules.profiler.stp.SelectProfilingTask;
import org.netbeans.modules.profiler.stp.ui.HyperlinkTextArea;
import org.openide.util.HelpCtx;

public class SettingsContainerPanel
extends JPanel
implements ChangeListener,
HelpCtx.Provider {
    private CardLayout basicAdvancedSettingsSwitchContainerLayout;
    private Contents contents;
    private DiscreteProgress progress;
    private HyperlinkTextArea basicAdvancedSettingsSwitchArea;
    private JLabel captionLabel;
    private JPanel basicAdvancedSettingsSwitchContainer;
    private JScrollPane contentsScroll;
    private String caption;
    private boolean showingAdvancedSettings = true;
    private boolean showingPreset;

    public SettingsContainerPanel() {
        this.initComponents();
    }

    public void setCaption(String caption) {
        this.caption = caption;
        this.captionLabel.setText(caption);
    }

    public void setContents(Contents contents) {
        this.setContents(contents, false);
    }

    public void setContents(Contents contents, boolean showAdvancedSettings) {
        if (this.contents != null) {
            contents.removeChangeListener(this);
        }
        this.contents = contents;
        if (this.contents != null) {
            contents.addChangeListener(this);
        }
        if (showAdvancedSettings) {
            this.switchToAdvancedSettings();
        } else {
            this.switchToBasicSettings();
        }
    }

    public HelpCtx getHelpCtx() {
        JPanel currentSettings;
        if (this.contents == null) {
            return HelpCtx.DEFAULT_HELP;
        }
        JPanel jPanel = currentSettings = this.showingAdvancedSettings ? this.contents.getAdvancedSettingsPanel() : this.contents.getBasicSettingsPanel();
        if (currentSettings == null || !(currentSettings instanceof HelpCtx.Provider)) {
            return HelpCtx.DEFAULT_HELP;
        }
        return ((HelpCtx.Provider)currentSettings).getHelpCtx();
    }

    public void setShowingPreset(boolean showingPreset) {
        this.showingPreset = showingPreset;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.progress.setActiveUnits(Math.round(this.contents.getProfilingOverhead() * 10.0f));
    }

    public void switchToAdvancedSettings() {
        this.showingAdvancedSettings = false;
        this.toggleBasicAdvancedSettingsView();
    }

    public void switchToBasicSettings() {
        this.showingAdvancedSettings = true;
        this.toggleBasicAdvancedSettingsView();
    }

    void setPreferredContentsSize(Dimension preferredSize) {
        this.contentsScroll.setPreferredSize(preferredSize);
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.setOpaque(true);
        this.setBackground(SelectProfilingTask.BACKGROUND_COLOR);
        final int[] commonHeight = new int[]{-1};
        this.captionLabel = new JLabel(" ");
        this.captionLabel.setFont(this.captionLabel.getFont().deriveFont(1, this.captionLabel.getFont().getSize2D() + 3.0f));
        this.captionLabel.setForeground(new Color(198, 129, 0));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 0;
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.insets = new Insets(27, 30, 12, 20);
        this.add((Component)this.captionLabel, constraints);
        JSeparator separator1 = UIUtils.createHorizontalSeparator();
        separator1.setBackground(this.getBackground());
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 0;
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 20, 0, 20);
        this.add((Component)separator1, constraints);
        this.contentsScroll = new JScrollPane(20, 31);
        this.contentsScroll.setBorder(BorderFactory.createEmptyBorder());
        this.contentsScroll.setViewportBorder(BorderFactory.createEmptyBorder());
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.weighty = 1.0;
        constraints.gridwidth = 0;
        constraints.fill = 1;
        constraints.anchor = 18;
        constraints.insets = new Insets(10, 20, 10, 20);
        this.add((Component)this.contentsScroll, constraints);
        JSeparator separator2 = UIUtils.createHorizontalSeparator();
        separator2.setBackground(this.getBackground());
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 0;
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 20, 0, 20);
        this.add((Component)separator2, constraints);
        JLabel overheadLabel = new JLabel(Bundle.SettingsContainerPanel_OverheadLabelText()){

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                if (commonHeight[0] != -1) {
                    dim.height = commonHeight[0];
                }
                return dim;
            }
        };
        overheadLabel.setFont(overheadLabel.getFont().deriveFont(overheadLabel.getFont().getSize2D() - 1.0f));
        overheadLabel.setForeground(SelectProfilingTask.DARKLINK_COLOR_INACTIVE);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(3, 22, 4, 0);
        this.add((Component)overheadLabel, constraints);
        this.progress = new DiscreteProgress();
        this.progress.setActiveUnits(4);
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 4;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(3, 5, 4, 0);
        this.add((Component)this.progress, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 2;
        constraints.gridy = 4;
        constraints.weightx = 1.0;
        constraints.gridwidth = 1;
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.insets = new Insets(3, 0, 4, 0);
        this.add((Component)UIUtils.createFillerPanel(), constraints);
        this.basicAdvancedSettingsSwitchArea = new HyperlinkTextArea(Bundle.SettingsContainerPanel_AdvancedSettingsString()){

            @Override
            protected Color getHighlightColor() {
                return SelectProfilingTask.DARKLINK_COLOR;
            }

            @Override
            protected String getHighlightText(String originalText) {
                return "<nobr><u>" + originalText + "</u></nobr>";
            }

            @Override
            protected Color getNormalColor() {
                return SelectProfilingTask.DARKLINK_COLOR_INACTIVE;
            }

            @Override
            protected String getNormalText(String originalText) {
                return "<nobr><u>" + originalText + "</u></nobr>";
            }

            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                if (commonHeight[0] != -1) {
                    dim.height = commonHeight[0];
                }
                return dim;
            }
        };
        Font font = UIManager.getFont("Label.font");
        this.basicAdvancedSettingsSwitchArea.setFont(font.deriveFont(font.getSize2D() - 1.0f));
        constraints = new GridBagConstraints();
        constraints.gridx = 3;
        constraints.gridy = 4;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(3, 0, 4, 22);
        this.add((Component)((Object)this.basicAdvancedSettingsSwitchArea), constraints);
        this.basicAdvancedSettingsSwitchArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1) {
                    SettingsContainerPanel.this.toggleBasicAdvancedSettingsView();
                }
            }
        });
        this.basicAdvancedSettingsSwitchArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32) {
                    SettingsContainerPanel.this.toggleBasicAdvancedSettingsView();
                }
            }
        });
        commonHeight[0] = Math.max(overheadLabel.getPreferredSize().height, this.basicAdvancedSettingsSwitchArea.getPreferredSize().height);
    }

    private void toggleBasicAdvancedSettingsView() {
        JPanel contentsPanel;
        this.contents.synchronizeBasicAdvancedPanels();
        boolean bl = this.showingAdvancedSettings = !this.showingAdvancedSettings;
        if (this.showingAdvancedSettings) {
            this.captionLabel.setText(Bundle.SettingsContainerPanel_AdvancedCaptionText(this.caption));
            this.basicAdvancedSettingsSwitchArea.setText(Bundle.SettingsContainerPanel_BasicSettingsString());
            contentsPanel = this.contents.getAdvancedSettingsPanel();
        } else {
            this.captionLabel.setText(this.caption);
            this.basicAdvancedSettingsSwitchArea.setText(Bundle.SettingsContainerPanel_AdvancedSettingsString());
            contentsPanel = this.contents.getBasicSettingsPanel();
        }
        this.basicAdvancedSettingsSwitchArea.updateAppearance();
        contentsPanel.setBackground(this.getBackground());
        this.contentsScroll.setViewportView(contentsPanel);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SettingsContainerPanel.this.basicAdvancedSettingsSwitchArea.setVisible(SettingsContainerPanel.this.contents.getAdvancedSettingsPanel().isVisible());
                JScrollBar contentsScrollBar = SettingsContainerPanel.this.contentsScroll.getVerticalScrollBar();
                if (contentsScrollBar == null || !contentsScrollBar.isVisible()) {
                    return;
                }
                contentsScrollBar.setValue(0);
            }
        });
        SelectProfilingTask.getDefault().updateHelpCtx();
        if (this.showingPreset && this.showingAdvancedSettings) {
            ProfilerDialogs.displayInfoDNSA((String)Bundle.SettingsContainerPanel_ReadOnlySettingsMsg(), null, null, (String)"SettingsContainerPanel.switchToAdvancedSettings.presetNotification", (boolean)false);
        }
    }

    public static interface Contents {
        public JPanel getAdvancedSettingsPanel();

        public JPanel getBasicSettingsPanel();

        public float getProfilingOverhead();

        public void addChangeListener(ChangeListener var1);

        public void removeChangeListener(ChangeListener var1);

        public void synchronizeBasicAdvancedPanels();
    }
}

