/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.stp;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.modules.profiler.stp.Bundle;
import org.netbeans.modules.profiler.stp.DefaultSettingsPanel;
import org.netbeans.modules.profiler.stp.ui.HyperlinkLabel;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;

public class MemorySettingsBasicPanel
extends DefaultSettingsPanel
implements HelpCtx.Provider {
    private static final String HELP_CTX_KEY = "MemorySettings.Basic.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("MemorySettings.Basic.HelpCtx");
    private HyperlinkLabel profilingPointsLink;
    private JCheckBox profilingPointsCheckbox;
    private JCheckBox recordStackTraceCheckbox;
    private JCheckBox fullDataCheckbox;
    private JRadioButton sampleAppRadio;
    private JRadioButton profileAppRadio;
    private Lookup.Provider project;
    private Runnable profilingPointsDisplayer;
    private boolean lastFullDataState;
    private boolean fullDataStateCache;
    private boolean lastStackTracesState;
    private boolean stackTracesStateCache;
    private boolean lastProfilingPointsState;
    private boolean profilingPointsStateCache;

    public MemorySettingsBasicPanel() {
        this.initComponents();
    }

    public void setContext(Lookup.Provider project, Runnable profilingPointsDisplayer) {
        this.project = project;
        this.profilingPointsDisplayer = profilingPointsDisplayer;
        this.updateControls();
    }

    public HelpCtx getHelpCtx() {
        return HELP_CTX;
    }

    public void setProfilingType(int profilingType) {
        this.sampleAppRadio.setSelected(profilingType == 128);
        this.profileAppRadio.setSelected(profilingType == 2 || profilingType == 4);
        this.fullDataCheckbox.setSelected(profilingType == 4);
    }

    public int getProfilingType() {
        if (this.sampleAppRadio.isSelected()) {
            return 128;
        }
        if (this.fullDataCheckbox.isSelected()) {
            return 4;
        }
        return 2;
    }

    public void setRecordStackTrace(boolean record) {
        this.recordStackTraceCheckbox.setSelected(record);
    }

    public boolean getRecordStackTrace() {
        return this.recordStackTraceCheckbox.isSelected();
    }

    public void setUseProfilingPoints(boolean use) {
        this.profilingPointsCheckbox.setSelected(use && this.profilingPointsCheckbox.isEnabled());
        this.updateControls();
    }

    public boolean getUseProfilingPoints() {
        return this.profilingPointsCheckbox.isSelected();
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception e) {
            // empty catch block
        }
        JFrame frame = new JFrame("Tester Frame");
        MemorySettingsBasicPanel contents = new MemorySettingsBasicPanel();
        contents.setPreferredSize(new Dimension(375, 255));
        frame.getContentPane().add(contents);
        frame.setDefaultCloseOperation(3);
        frame.pack();
        frame.setVisible(true);
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        ButtonGroup memoryModeRadios = new ButtonGroup();
        this.sampleAppRadio = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.sampleAppRadio, (String)Bundle.MemorySettingsBasicPanel_AllocRadioText());
        this.sampleAppRadio.setToolTipText(Bundle.StpAllocTooltip());
        this.sampleAppRadio.setOpaque(false);
        this.sampleAppRadio.setSelected(true);
        memoryModeRadios.add(this.sampleAppRadio);
        this.sampleAppRadio.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                MemorySettingsBasicPanel.this.updateControls();
            }
        });
        this.sampleAppRadio.addActionListener(this.getSettingsChangeListener());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(15, 30, 0, 0);
        this.add((Component)this.sampleAppRadio, constraints);
        this.profileAppRadio = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.profileAppRadio, (String)Bundle.MemorySettingsBasicPanel_LivenessRadioText());
        this.profileAppRadio.setToolTipText(Bundle.StpLivenessTooltip());
        this.profileAppRadio.setOpaque(false);
        this.profileAppRadio.setSelected(false);
        memoryModeRadios.add(this.profileAppRadio);
        this.profileAppRadio.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                MemorySettingsBasicPanel.this.updateControls();
            }
        });
        this.profileAppRadio.addActionListener(this.getSettingsChangeListener());
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(3, 30, 0, 0);
        this.add((Component)this.profileAppRadio, constraints);
        this.fullDataCheckbox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.fullDataCheckbox, (String)Bundle.StpFullLifecycleText());
        this.fullDataCheckbox.setToolTipText(Bundle.StpFullLifecycleTooltip());
        this.fullDataCheckbox.setOpaque(false);
        this.fullDataCheckbox.addActionListener(this.getSettingsChangeListener());
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(25, 25, 0, 0);
        this.add((Component)this.fullDataCheckbox, constraints);
        this.recordStackTraceCheckbox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.recordStackTraceCheckbox, (String)Bundle.MemorySettingsBasicPanel_RecordTracesCheckboxText());
        this.recordStackTraceCheckbox.setToolTipText(Bundle.StpStackTraceTooltip());
        this.recordStackTraceCheckbox.addActionListener(this.getSettingsChangeListener());
        this.recordStackTraceCheckbox.setOpaque(false);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(3, 25, 0, 0);
        this.add((Component)this.recordStackTraceCheckbox, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 5;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridwidth = 0;
        constraints.fill = 1;
        constraints.anchor = 18;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)UIUtils.createFillerPanel(), constraints);
        JPanel profilingPointsContainer = new JPanel(new GridBagLayout());
        this.profilingPointsCheckbox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.profilingPointsCheckbox, (String)Bundle.MemorySettingsBasicPanel_UsePpsCheckboxText());
        this.profilingPointsCheckbox.setToolTipText(Bundle.StpUsePpsTooltip());
        this.profilingPointsCheckbox.setOpaque(false);
        this.profilingPointsCheckbox.setSelected(true);
        this.profilingPointsStateCache = this.profilingPointsCheckbox.isSelected();
        this.profilingPointsCheckbox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                MemorySettingsBasicPanel.this.updateEnabling();
            }
        });
        this.profilingPointsCheckbox.addActionListener(this.getSettingsChangeListener());
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 0, 0, 10);
        profilingPointsContainer.add((Component)this.profilingPointsCheckbox, constraints);
        Color linkColor = Color.RED;
        String colorText = "rgb(" + linkColor.getRed() + "," + linkColor.getGreen() + "," + linkColor.getBlue() + ")";
        this.profilingPointsLink = new HyperlinkLabel("<nobr><a href='#'>" + Bundle.MemorySettingsBasicPanel_ShowPpsString() + "</a></nobr>", "<nobr><a href='#' color=\"" + colorText + "\">" + Bundle.MemorySettingsBasicPanel_ShowPpsString() + "</a></nobr>", new Runnable(){

            @Override
            public void run() {
                MemorySettingsBasicPanel.this.performShowProfilingPointsAction();
            }
        });
        this.profilingPointsLink.setToolTipText(Bundle.StpShowPpsTooltip());
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 0, 0, 0);
        profilingPointsContainer.add((Component)((Object)this.profilingPointsLink), constraints);
        profilingPointsContainer.setOpaque(false);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 6;
        constraints.gridwidth = 0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(20, 25, 10, 0);
        this.add((Component)profilingPointsContainer, constraints);
    }

    private void performShowProfilingPointsAction() {
        this.profilingPointsDisplayer.run();
    }

    private void updateEnabling() {
        this.profilingPointsLink.setEnabled(this.profilingPointsCheckbox.isSelected() && this.profilingPointsCheckbox.isEnabled());
    }

    private void updateControls() {
        if (this.sampleAppRadio.isSelected()) {
            if (!this.lastFullDataState) {
                this.fullDataStateCache = this.fullDataCheckbox.isSelected();
                this.fullDataCheckbox.setEnabled(false);
                this.fullDataCheckbox.setSelected(false);
                this.lastFullDataState = true;
            }
            if (!this.lastStackTracesState) {
                this.stackTracesStateCache = this.recordStackTraceCheckbox.isSelected();
                this.recordStackTraceCheckbox.setEnabled(false);
                this.recordStackTraceCheckbox.setSelected(false);
                this.lastStackTracesState = true;
            }
            this.profilingPointsCheckbox.setEnabled(false);
            if (this.project == null) {
                return;
            }
            if (!this.lastProfilingPointsState) {
                this.profilingPointsStateCache = this.profilingPointsCheckbox.isSelected();
                this.profilingPointsCheckbox.setSelected(false);
                this.lastProfilingPointsState = true;
            }
        } else {
            if (this.lastFullDataState) {
                this.fullDataCheckbox.setEnabled(true);
                this.fullDataCheckbox.setSelected(this.fullDataStateCache);
                this.lastFullDataState = false;
            }
            if (this.lastStackTracesState) {
                this.recordStackTraceCheckbox.setEnabled(true);
                this.recordStackTraceCheckbox.setSelected(this.stackTracesStateCache);
                this.lastStackTracesState = false;
            }
            this.profilingPointsCheckbox.setEnabled(this.project != null);
            if (this.project == null) {
                return;
            }
            if (this.lastProfilingPointsState) {
                this.profilingPointsCheckbox.setSelected(this.profilingPointsStateCache);
                this.lastProfilingPointsState = false;
            }
        }
    }
}

