/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.stp;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.JExtendedSpinner;
import org.netbeans.modules.profiler.stp.Bundle;
import org.netbeans.modules.profiler.stp.DefaultSettingsPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;

public class MemorySettingsAdvancedPanel
extends DefaultSettingsPanel
implements HelpCtx.Provider {
    private static final String HELP_CTX_KEY = "MemorySettings.Advanced.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("MemorySettings.Advanced.HelpCtx");
    private JCheckBox runGCCheckbox;
    private JCheckBox threadsMonitoringCheckbox;
    private JCheckBox threadsSamplingCheckbox;
    private JLabel defineDepthLabel;
    private JLabel recordStackTracesLabel;
    private JPanel settingsPanel;
    private JPanel threadsSettingsPanel;
    private JRadioButton definedDepthRadio;
    private JRadioButton fullDepthRadio;
    private JSpinner defineDepthSpinner;
    private JLabel trackEveryLabel1;
    private JLabel trackEveryLabel2;
    private JSpinner trackEverySpinner;

    public MemorySettingsAdvancedPanel() {
        this.initComponents();
    }

    public void setProfilingType(int profilingType) {
        this.settingsPanel.setVisible(profilingType != 128);
    }

    public void setAllocStackTraceLimit(int limit) {
        if (limit <= 0) {
            this.defineDepthSpinner.setValue(limit < 0 ? Integer.valueOf(-limit) : Integer.valueOf(10));
            this.fullDepthRadio.setSelected(true);
        } else {
            this.defineDepthSpinner.setValue(limit);
            this.definedDepthRadio.setSelected(true);
        }
    }

    public int getAllocStackTraceLimit() {
        if (this.fullDepthRadio.isSelected()) {
            int val = -10;
            try {
                val = -((Number)this.defineDepthSpinner.getValue()).intValue();
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            return val;
        }
        int val = 10;
        try {
            val = ((Number)this.defineDepthSpinner.getValue()).intValue();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return val;
    }

    public HelpCtx getHelpCtx() {
        return HELP_CTX;
    }

    public void setTrackEvery(int trackEvery) {
        this.trackEverySpinner.setValue(trackEvery);
    }

    public int getTrackEvery() {
        return (Integer)this.trackEverySpinner.getValue();
    }

    public void setRecordStackTrace(boolean record) {
        this.recordStackTracesLabel.setEnabled(record && this.threadsMonitoringCheckbox.isEnabled());
        this.fullDepthRadio.setEnabled(record && this.threadsMonitoringCheckbox.isEnabled());
        this.definedDepthRadio.setEnabled(record && this.threadsMonitoringCheckbox.isEnabled());
        this.defineDepthSpinner.setEnabled(record && this.threadsMonitoringCheckbox.isEnabled());
        this.updateEnabling();
    }

    public void setRunGC(boolean runGC) {
        this.runGCCheckbox.setSelected(runGC);
    }

    public void updateRunGC(boolean allocOnly) {
        this.runGCCheckbox.setEnabled(!allocOnly && this.threadsMonitoringCheckbox.isEnabled());
    }

    public boolean getRunGC() {
        return this.runGCCheckbox.isSelected();
    }

    public void setThreadsMonitoring(boolean enabled) {
        this.threadsMonitoringCheckbox.setSelected(enabled);
    }

    public boolean getThreadsMonitoring() {
        return this.threadsMonitoringCheckbox.isSelected();
    }

    public void setThreadsSampling(boolean enabled) {
        this.threadsSamplingCheckbox.setSelected(enabled);
    }

    public boolean getThreadsSampling() {
        return this.threadsSamplingCheckbox.isSelected();
    }

    public void disableAll() {
        this.recordStackTracesLabel.setEnabled(false);
        this.fullDepthRadio.setEnabled(false);
        this.definedDepthRadio.setEnabled(false);
        this.defineDepthSpinner.setEnabled(false);
        this.defineDepthLabel.setEnabled(false);
        this.runGCCheckbox.setEnabled(false);
        this.threadsSettingsPanel.setEnabled(false);
        this.threadsMonitoringCheckbox.setEnabled(false);
        this.threadsSamplingCheckbox.setEnabled(false);
        this.trackEveryLabel1.setEnabled(false);
        this.trackEveryLabel2.setEnabled(false);
        this.trackEverySpinner.setEnabled(false);
    }

    public void enableAll() {
        this.recordStackTracesLabel.setEnabled(true);
        this.fullDepthRadio.setEnabled(true);
        this.definedDepthRadio.setEnabled(true);
        this.defineDepthSpinner.setEnabled(true);
        this.defineDepthLabel.setEnabled(true);
        this.runGCCheckbox.setEnabled(true);
        this.threadsSettingsPanel.setEnabled(true);
        this.threadsMonitoringCheckbox.setEnabled(true);
        this.threadsSamplingCheckbox.setEnabled(true);
        this.trackEveryLabel1.setEnabled(true);
        this.trackEveryLabel2.setEnabled(true);
        this.trackEverySpinner.setEnabled(true);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception e) {
            // empty catch block
        }
        JFrame frame = new JFrame("Tester Frame");
        MemorySettingsAdvancedPanel contents = new MemorySettingsAdvancedPanel();
        contents.setPreferredSize(new Dimension(375, 255));
        frame.getContentPane().add(contents);
        frame.setDefaultCloseOperation(3);
        frame.pack();
        frame.setVisible(true);
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        ButtonGroup methodsTrackingRadiosGroup = new ButtonGroup();
        this.settingsPanel = new JPanel(new GridBagLayout());
        this.settingsPanel.setOpaque(false);
        this.settingsPanel.setBorder(BorderFactory.createTitledBorder(Bundle.MemorySettingsAdvancedPanel_SettingsCaption()));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 0;
        constraints.fill = 2;
        constraints.anchor = 18;
        constraints.insets = new Insets(0, 5, 10, 5);
        this.add((Component)this.settingsPanel, constraints);
        JPanel trackEveryContainer = new JPanel(new GridBagLayout());
        this.trackEveryLabel1 = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.trackEveryLabel1, (String)Bundle.MemorySettingsBasicPanel_TrackEveryLabelText());
        this.trackEveryLabel1.setToolTipText(Bundle.StpTrackEveryTooltip());
        this.trackEveryLabel1.setOpaque(false);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 0, 0, 5);
        trackEveryContainer.add((Component)this.trackEveryLabel1, constraints);
        this.trackEverySpinner = new JExtendedSpinner(new SpinnerNumberModel(10, 1, Integer.MAX_VALUE, 1)){

            public Dimension getPreferredSize() {
                return new Dimension(55, 1.getDefaultSpinnerHeight());
            }

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.trackEveryLabel1.setLabelFor(this.trackEverySpinner);
        this.trackEverySpinner.setToolTipText(Bundle.StpTrackEveryTooltip());
        this.trackEverySpinner.addChangeListener(this.getSettingsChangeListener());
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 0, 0, 0);
        trackEveryContainer.add((Component)this.trackEverySpinner, constraints);
        this.trackEveryLabel2 = new JLabel(Bundle.MemorySettingsBasicPanel_AllocLabelText());
        this.trackEveryLabel2.setToolTipText(Bundle.StpTrackEveryTooltip());
        this.trackEveryLabel2.setOpaque(false);
        constraints = new GridBagConstraints();
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 5, 0, 0);
        trackEveryContainer.add((Component)this.trackEveryLabel2, constraints);
        trackEveryContainer.setOpaque(false);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(2, 7, 5, 0);
        this.settingsPanel.add((Component)trackEveryContainer, constraints);
        this.recordStackTracesLabel = new JLabel(Bundle.MemorySettingsAdvancedPanel_RecordTracesLabelText());
        this.recordStackTracesLabel.setOpaque(false);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.weightx = 1.0;
        constraints.gridwidth = 0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(5, 7, 0, 0);
        this.settingsPanel.add((Component)this.recordStackTracesLabel, constraints);
        this.fullDepthRadio = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.fullDepthRadio, (String)Bundle.MemorySettingsAdvancedPanel_FullStackRadioText());
        this.fullDepthRadio.setToolTipText(Bundle.StpFullDepthTooltip());
        methodsTrackingRadiosGroup.add(this.fullDepthRadio);
        this.fullDepthRadio.addActionListener(this.getSettingsChangeListener());
        this.fullDepthRadio.setOpaque(false);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(5, 19, 0, 0);
        this.settingsPanel.add((Component)this.fullDepthRadio, constraints);
        JPanel sampledTimingContainer = new JPanel(new GridBagLayout());
        this.definedDepthRadio = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.definedDepthRadio, (String)Bundle.MemorySettingsAdvancedPanel_LimitStackRadioText());
        this.definedDepthRadio.setToolTipText(Bundle.StpLimitDepthTooltip());
        methodsTrackingRadiosGroup.add(this.definedDepthRadio);
        this.definedDepthRadio.setOpaque(false);
        this.definedDepthRadio.setSelected(true);
        this.definedDepthRadio.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                MemorySettingsAdvancedPanel.this.updateEnabling();
            }
        });
        this.definedDepthRadio.addActionListener(this.getSettingsChangeListener());
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 0, 0, 5);
        sampledTimingContainer.add((Component)this.definedDepthRadio, constraints);
        this.defineDepthSpinner = new JExtendedSpinner(new SpinnerNumberModel(10, 1, Integer.MAX_VALUE, 1)){

            public Dimension getPreferredSize() {
                return new Dimension(55, 3.getDefaultSpinnerHeight());
            }

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.defineDepthSpinner.addChangeListener(this.getSettingsChangeListener());
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 0, 0, 0);
        sampledTimingContainer.add((Component)this.defineDepthSpinner, constraints);
        this.defineDepthLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.defineDepthLabel, (String)Bundle.MemorySettingsAdvancedPanel_FramesLabelText());
        this.defineDepthLabel.setLabelFor(this.defineDepthSpinner);
        this.defineDepthSpinner.setToolTipText(Bundle.StpLimitDepthTooltip());
        this.defineDepthLabel.setToolTipText(Bundle.StpLimitDepthTooltip());
        this.defineDepthLabel.setOpaque(false);
        constraints = new GridBagConstraints();
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 5, 0, 0);
        sampledTimingContainer.add((Component)this.defineDepthLabel, constraints);
        sampledTimingContainer.setOpaque(false);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(1, 19, 5, 0);
        this.settingsPanel.add((Component)sampledTimingContainer, constraints);
        this.runGCCheckbox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.runGCCheckbox, (String)Bundle.MemorySettingsAdvancedPanel_RunGcCheckboxText());
        this.runGCCheckbox.setToolTipText(Bundle.StpRunGcTooltip());
        this.runGCCheckbox.setOpaque(false);
        this.runGCCheckbox.addActionListener(this.getSettingsChangeListener());
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.gridwidth = 0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(5, 7, 3, 0);
        this.settingsPanel.add((Component)this.runGCCheckbox, constraints);
        this.threadsSettingsPanel = new JPanel(new GridBagLayout());
        this.threadsSettingsPanel.setOpaque(false);
        this.threadsSettingsPanel.setBorder(BorderFactory.createTitledBorder(Bundle.MemorySettingsAdvancedPanel_ThreadsCaption()));
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 0;
        constraints.fill = 2;
        constraints.anchor = 18;
        constraints.insets = new Insets(0, 5, 10, 5);
        this.add((Component)this.threadsSettingsPanel, constraints);
        this.threadsMonitoringCheckbox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.threadsMonitoringCheckbox, (String)Bundle.MemorySettingsAdvancedPanel_EnableThreadsCheckboxText());
        this.threadsMonitoringCheckbox.setToolTipText(Bundle.StpMonitorTooltip());
        this.threadsMonitoringCheckbox.setOpaque(false);
        this.threadsMonitoringCheckbox.addActionListener(this.getSettingsChangeListener());
        this.threadsMonitoringCheckbox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                MemorySettingsAdvancedPanel.this.updateEnabling();
            }
        });
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.gridwidth = 0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(2, 7, 1, 0);
        this.threadsSettingsPanel.add((Component)this.threadsMonitoringCheckbox, constraints);
        this.threadsSamplingCheckbox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.threadsSamplingCheckbox, (String)Bundle.MemorySettingsAdvancedPanel_EnableSamplingCheckboxText());
        this.threadsSamplingCheckbox.setToolTipText(Bundle.StpSamplingTooltip());
        this.threadsSamplingCheckbox.setOpaque(false);
        this.threadsSamplingCheckbox.addActionListener(this.getSettingsChangeListener());
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.weightx = 1.0;
        constraints.gridwidth = 0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 7, 3, 0);
        this.threadsSettingsPanel.add((Component)this.threadsSamplingCheckbox, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridwidth = 0;
        constraints.fill = 1;
        constraints.anchor = 18;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)UIUtils.createFillerPanel(), constraints);
    }

    private void updateEnabling() {
        this.defineDepthSpinner.setEnabled(this.definedDepthRadio.isSelected() && this.recordStackTracesLabel.isEnabled());
        this.defineDepthLabel.setEnabled(this.definedDepthRadio.isSelected() && this.recordStackTracesLabel.isEnabled());
        this.threadsSamplingCheckbox.setEnabled(this.threadsMonitoringCheckbox.isSelected() && this.threadsMonitoringCheckbox.isEnabled());
    }
}

