/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.stp;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.filters.DefinedFilterSets;
import org.netbeans.lib.profiler.common.filters.FilterUtils;
import org.netbeans.lib.profiler.common.filters.SimpleFilter;
import org.netbeans.lib.profiler.ui.SwingWorker;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.JExtendedComboBox;
import org.netbeans.modules.profiler.api.ProfilingRoots;
import org.netbeans.modules.profiler.api.ProgressDisplayer;
import org.netbeans.modules.profiler.api.ProjectUtilities;
import org.netbeans.modules.profiler.api.project.ProjectContentsSupport;
import org.netbeans.modules.profiler.stp.Bundle;
import org.netbeans.modules.profiler.stp.DefaultSettingsPanel;
import org.netbeans.modules.profiler.stp.SelectProfilingTask;
import org.netbeans.modules.profiler.stp.ui.FilterSetsPanel;
import org.netbeans.modules.profiler.stp.ui.GlobalFiltersPanel;
import org.netbeans.modules.profiler.stp.ui.HyperlinkLabel;
import org.netbeans.modules.profiler.stp.ui.PreferredInstrFilterPanel;
import org.netbeans.modules.profiler.stp.ui.QuickFilterPanel;
import org.netbeans.modules.profiler.ui.ProfilerProgressDisplayer;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public class CPUSettingsBasicPanel
extends DefaultSettingsPanel
implements ActionListener,
PopupMenuListener,
HelpCtx.Provider {
    private static final String HELP_CTX_KEY = "CPUSettings.Basic.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("CPUSettings.Basic.HelpCtx");
    private HyperlinkLabel editFilterLink;
    private HyperlinkLabel editFilterSetsLink;
    private HyperlinkLabel partOfAppHintLink;
    private HyperlinkLabel profilingPointsLink;
    private HyperlinkLabel showFilterLink;
    private HyperlinkLabel stopwatchHintLink;
    private JButton globalFiltersButton;
    private JCheckBox profilingPointsCheckbox;
    private JComboBox filterCombo;
    private JLabel filterLabel;
    private JRadioButton sampleAppRadio;
    private JRadioButton profileAppRadio;
    private JRadioButton stopwatchRadio;
    private List<SimpleFilter> preferredInstrFilters;
    private Object selectedInstrumentationFilter = SimpleFilter.NO_FILTER;
    private Lookup.Provider project;
    private Runnable profilingPointsDisplayer;
    private SimpleFilter quickFilter;
    private ClientUtils.SourceCodeSelection[] rootMethods = new ClientUtils.SourceCodeSelection[0];
    private boolean filterComboBoxPopupCancelled = false;
    private boolean lastProfilingPointsState;
    private boolean profilingPointsStateCache;
    private final AtomicBoolean rootMethodsActionExecuting = new AtomicBoolean(false);

    public CPUSettingsBasicPanel() {
        this.initComponents();
    }

    public void setContext(Lookup.Provider project, List<SimpleFilter> preferredInstrFilters, Runnable profilingPointsDisplayer) {
        this.project = project;
        this.profilingPointsDisplayer = profilingPointsDisplayer;
        this.preferredInstrFilters = preferredInstrFilters;
    }

    public HelpCtx getHelpCtx() {
        return HELP_CTX;
    }

    public void setInstrumentationFilter(Object instrumentationFilter) {
        this.selectedInstrumentationFilter = instrumentationFilter;
        this.updateFilterComboBoxItems();
        this.selectActiveComboItem();
        this.updateControls();
    }

    public Object getInstrumentationFilter() {
        return this.selectedInstrumentationFilter;
    }

    public void setProfilingType(int profilingType) {
        this.sampleAppRadio.setSelected(profilingType == 64);
        this.profileAppRadio.setSelected(profilingType == 8 || profilingType == 16);
        this.stopwatchRadio.setSelected(profilingType == 32);
        this.profilingPointsCheckbox.setEnabled(this.project != null && this.profileAppRadio.isSelected());
    }

    public int getProfilingType() {
        if (this.sampleAppRadio.isSelected()) {
            return 64;
        }
        if (this.profileAppRadio.isSelected()) {
            return this.rootMethods.length == 0 ? 8 : 16;
        }
        return 32;
    }

    public void setQuickFilter(SimpleFilter quickFilter) {
        this.quickFilter = quickFilter;
    }

    public SimpleFilter getQuickFilter() {
        return this.quickFilter;
    }

    public void setRootMethods(ClientUtils.SourceCodeSelection[] rootMethods) {
        this.rootMethods = rootMethods;
    }

    public ClientUtils.SourceCodeSelection[] getRootMethods() {
        return this.rootMethods;
    }

    public void setUseProfilingPoints(boolean use) {
        this.profilingPointsCheckbox.setSelected(use && this.profilingPointsCheckbox.isEnabled());
        this.updateEnabling();
    }

    public boolean getUseProfilingPoints() {
        return this.profilingPointsCheckbox.isSelected();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.globalFiltersButton) {
            CPUSettingsBasicPanel.performEditGlobalFiltersAction();
        } else if (e.getSource() == this.filterCombo) {
            this.updateComboLinks();
            this.updateControls();
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception e) {
            // empty catch block
        }
        JFrame frame = new JFrame("Tester Frame");
        CPUSettingsBasicPanel contents = new CPUSettingsBasicPanel();
        contents.setPreferredSize(new Dimension(375, 245));
        frame.getContentPane().add(contents);
        frame.setDefaultCloseOperation(3);
        frame.pack();
        frame.setVisible(true);
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
        this.filterComboBoxPopupCancelled = true;
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        if (!this.filterComboBoxPopupCancelled && this.quickFilter != null && this.quickFilter.equals(this.filterCombo.getSelectedItem())) {
            this.filterCombo.removePopupMenuListener(this);
            this.filterCombo.hidePopup();
            this.filterCombo.addPopupMenuListener(this);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CPUSettingsBasicPanel.this.performQuickFilterAction();
                }
            });
        }
        this.filterComboBoxPopupCancelled = false;
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        ButtonGroup cpuModeRadios = new ButtonGroup();
        this.sampleAppRadio = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.sampleAppRadio, (String)Bundle.CPUSettingsBasicPanel_SampleAppRadioText());
        this.sampleAppRadio.setToolTipText(Bundle.StpSampleAppTooltip());
        this.sampleAppRadio.setOpaque(false);
        this.sampleAppRadio.setSelected(true);
        cpuModeRadios.add(this.sampleAppRadio);
        this.sampleAppRadio.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                CPUSettingsBasicPanel.this.updateControls();
            }
        });
        this.sampleAppRadio.addActionListener(this.getSettingsChangeListener());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(15, 30, 0, 0);
        this.add((Component)this.sampleAppRadio, constraints);
        JPanel partOfAppContainer = new JPanel(new GridBagLayout()){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, Math.max(((CPUSettingsBasicPanel)CPUSettingsBasicPanel.this).profileAppRadio.getPreferredSize().height, ((CPUSettingsBasicPanel)CPUSettingsBasicPanel.this).partOfAppHintLink.getPreferredSize().height));
            }
        };
        this.profileAppRadio = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.profileAppRadio, (String)Bundle.CPUSettingsBasicPanel_ProfileAppRadioText());
        this.profileAppRadio.setToolTipText(Bundle.StpProfileAppTooltip());
        this.profileAppRadio.setOpaque(false);
        this.profileAppRadio.setSelected(true);
        cpuModeRadios.add(this.profileAppRadio);
        this.profileAppRadio.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                CPUSettingsBasicPanel.this.updateControls();
            }
        });
        this.profileAppRadio.addActionListener(this.getSettingsChangeListener());
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 0, 0, 0);
        partOfAppContainer.add((Component)this.profileAppRadio, constraints);
        Color linkColor = Color.RED;
        String colorText = "rgb(" + linkColor.getRed() + "," + linkColor.getGreen() + "," + linkColor.getBlue() + ")";
        String textColorText = "rgb(" + Color.GRAY.getRed() + "," + Color.GRAY.getGreen() + "," + Color.GRAY.getBlue() + ")";
        String labelText = "<nobr>" + Bundle.CPUSettingsBasicPanel_DefaultRootsString(textColorText, "") + "</nobr>";
        String labelFocusedText = "<nobr>" + Bundle.CPUSettingsBasicPanel_DefaultRootsString(textColorText, "color=\"" + colorText + "\"") + "</nobr>";
        this.partOfAppHintLink = new HyperlinkLabel(labelText, labelFocusedText, new Runnable(){

            @Override
            public void run() {
                CPUSettingsBasicPanel.this.performRootMethodsAction();
            }
        });
        this.partOfAppHintLink.setToolTipText(Bundle.CPUSettingsBasicPanel_DefaultRootsToolTip());
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 0, 0, 0);
        partOfAppContainer.add((Component)((Object)this.partOfAppHintLink), constraints);
        partOfAppContainer.setOpaque(false);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(3, 30, 0, 0);
        this.add((Component)partOfAppContainer, constraints);
        JPanel stopwatchContainer = new JPanel(new GridBagLayout());
        this.stopwatchRadio = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.stopwatchRadio, (String)Bundle.CPUSettingsBasicPanel_StopwatchRadioText());
        this.stopwatchRadio.setOpaque(false);
        this.stopwatchRadio.setSelected(true);
        cpuModeRadios.add(this.stopwatchRadio);
        this.stopwatchRadio.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                CPUSettingsBasicPanel.this.updateControls();
            }
        });
        this.stopwatchRadio.addActionListener(this.getSettingsChangeListener());
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 0, 0, 0);
        stopwatchContainer.add((Component)this.stopwatchRadio, constraints);
        labelText = "<nobr><font color='" + textColorText + "'>2 stopwatches defined, </font><a href='#'>view</a></nobr>";
        labelFocusedText = "<nobr><font color='" + textColorText + "'>2 stopwatches defined, </font><a href='#' color=\"" + colorText + "\">view</a></nobr>";
        this.stopwatchHintLink = new HyperlinkLabel(labelText, labelFocusedText, new Runnable(){

            @Override
            public void run() {
                CPUSettingsBasicPanel.this.performRootMethodsAction();
            }
        });
        this.stopwatchHintLink.setVisible(false);
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 10, 0, 0);
        stopwatchContainer.add((Component)((Object)this.stopwatchHintLink), constraints);
        stopwatchContainer.setOpaque(false);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(3, 30, 0, 0);
        this.add((Component)stopwatchContainer, constraints);
        stopwatchContainer.setVisible(false);
        this.filterLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.filterLabel, (String)Bundle.CPUSettingsBasicPanel_FilterLabelText());
        this.filterLabel.setToolTipText(Bundle.StpFilterTooltip());
        this.filterLabel.setOpaque(false);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(25, 25, 0, 0);
        this.add((Component)this.filterLabel, constraints);
        this.filterCombo = new JExtendedComboBox(){

            public int getPreferredWidth() {
                int preferredWidth = super.getPreferredSize().width;
                preferredWidth = Math.max(preferredWidth, 220);
                preferredWidth = Math.min(preferredWidth, 300);
                return preferredWidth;
            }

            public Dimension getPreferredSize() {
                return new Dimension(this.getPreferredWidth(), super.getPreferredSize().height);
            }

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.filterLabel.setLabelFor(this.filterCombo);
        this.filterCombo.setToolTipText(Bundle.StpFilterTooltip());
        this.filterCombo.addActionListener(this);
        this.filterCombo.addActionListener(this.getSettingsChangeListener());
        this.filterCombo.addPopupMenuListener(this);
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(25, 5, 0, 0);
        this.add((Component)this.filterCombo, constraints);
        JPanel filterLinksContainer = new JPanel(new GridBagLayout());
        labelText = "<nobr><a href='#'>" + Bundle.CPUSettingsBasicPanel_ShowFilterString() + "</a></nobr>";
        labelFocusedText = "<nobr><a href='#' color=\"" + colorText + "\">" + Bundle.CPUSettingsBasicPanel_ShowFilterString() + "</a></nobr>";
        this.showFilterLink = new HyperlinkLabel(labelText, labelFocusedText, new Runnable(){

            @Override
            public void run() {
                CPUSettingsBasicPanel.this.performShowFilterAction();
            }
        });
        this.showFilterLink.setToolTipText(Bundle.StpShowFilterTooltip());
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 0, 0, 10);
        filterLinksContainer.add((Component)((Object)this.showFilterLink), constraints);
        labelText = "<nobr><a href='#'>" + Bundle.CPUSettingsBasicPanel_EditFilterString() + "</a></nobr>";
        labelFocusedText = "<nobr><a href='#' color=\"" + colorText + "\">" + Bundle.CPUSettingsBasicPanel_EditFilterString() + "</a></nobr>";
        this.editFilterLink = new HyperlinkLabel(labelText, labelFocusedText, new Runnable(){

            @Override
            public void run() {
                CPUSettingsBasicPanel.this.performQuickFilterAction();
            }
        });
        this.editFilterLink.setVisible(false);
        this.editFilterLink.setToolTipText(Bundle.StpEditFilterTooltip());
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 0, 0, 10);
        filterLinksContainer.add((Component)((Object)this.editFilterLink), constraints);
        labelText = "<nobr><a href='#'>" + Bundle.CPUSettingsBasicPanel_EditFilterSetString() + "</a></nobr>";
        labelFocusedText = "<nobr><a href='#' color=\"" + colorText + "\">" + Bundle.CPUSettingsBasicPanel_EditFilterSetString() + "</a></nobr>";
        this.editFilterSetsLink = new HyperlinkLabel(labelText, labelFocusedText, new Runnable(){

            @Override
            public void run() {
                CPUSettingsBasicPanel.this.performCustomizeFilterSetsAction();
            }
        });
        this.editFilterSetsLink.setToolTipText(Bundle.StpManageFilterSetsTooltip());
        constraints = new GridBagConstraints();
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 0, 0, 0);
        filterLinksContainer.add((Component)((Object)this.editFilterSetsLink), constraints);
        filterLinksContainer.setOpaque(false);
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 4;
        constraints.gridwidth = 0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)filterLinksContainer, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 5;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridwidth = 0;
        constraints.fill = 1;
        constraints.anchor = 18;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)UIUtils.createFillerPanel(), constraints);
        JPanel profilingPointsContainer = new JPanel(new GridBagLayout());
        this.profilingPointsCheckbox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.profilingPointsCheckbox, (String)Bundle.CPUSettingsBasicPanel_UsePpsCheckboxText());
        this.profilingPointsCheckbox.setToolTipText(Bundle.StpUsePpsTooltip());
        this.profilingPointsCheckbox.setOpaque(false);
        this.profilingPointsCheckbox.setSelected(true);
        this.profilingPointsStateCache = this.profilingPointsCheckbox.isSelected();
        this.profilingPointsCheckbox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                CPUSettingsBasicPanel.this.updateEnabling();
            }
        });
        this.profilingPointsCheckbox.addActionListener(this.getSettingsChangeListener());
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 0, 0, 10);
        profilingPointsContainer.add((Component)this.profilingPointsCheckbox, constraints);
        labelText = "<nobr><a href='#'>" + Bundle.CPUSettingsBasicPanel_ShowPpsString() + "</a></nobr>";
        labelFocusedText = "<nobr><a href='#' color=\"" + colorText + "\">" + Bundle.CPUSettingsBasicPanel_ShowPpsString() + "</a></nobr>";
        this.profilingPointsLink = new HyperlinkLabel(labelText, labelFocusedText, new Runnable(){

            @Override
            public void run() {
                CPUSettingsBasicPanel.this.performShowProfilingPointsAction();
            }
        });
        this.profilingPointsLink.setToolTipText(Bundle.StpShowPpsTooltip());
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 0, 0, 0);
        profilingPointsContainer.add((Component)((Object)this.profilingPointsLink), constraints);
        profilingPointsContainer.setOpaque(false);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 6;
        constraints.gridwidth = 0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(20, 25, 10, 0);
        this.add((Component)profilingPointsContainer, constraints);
        this.globalFiltersButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.globalFiltersButton, (String)Bundle.CPUSettingsBasicPanel_EditGlobalFilterString());
        Dimension d1 = this.showFilterLink.getPreferredSize();
        Dimension d2 = this.editFilterLink.getPreferredSize();
        Dimension d3 = new Dimension(Math.max(d1.width, d2.width), Math.max(d1.height, d2.height));
        this.showFilterLink.setPreferredSize(d3);
        this.editFilterLink.setPreferredSize(d3);
    }

    private void performCustomizeFilterSetsAction() {
        FilterSetsPanel filterSetsPanel = FilterSetsPanel.getDefault();
        DialogDescriptor dd = new DialogDescriptor((Object)filterSetsPanel, Bundle.CPUSettingsBasicPanel_FilterSetsDialogCaption(), true, new Object[]{DialogDescriptor.OK_OPTION, DialogDescriptor.CANCEL_OPTION}, DialogDescriptor.OK_OPTION, 0, null, null);
        Dialog d = DialogDisplayer.getDefault().createDialog(dd);
        dd.setAdditionalOptions(new Object[]{this.globalFiltersButton});
        dd.setButtonListener((ActionListener)this);
        int itemsToSkip = 4;
        if (this.preferredInstrFilters != null) {
            itemsToSkip += this.preferredInstrFilters.size();
        }
        filterSetsPanel.init(Math.max(this.filterCombo.getSelectedIndex() - itemsToSkip, 0));
        d.pack();
        d.setVisible(true);
        dd.setButtonListener(null);
        if (dd.getValue() == DialogDescriptor.OK_OPTION) {
            filterSetsPanel.applyChanges();
            if (filterSetsPanel.getSelectedFilterSet() != null) {
                this.selectedInstrumentationFilter = filterSetsPanel.getSelectedFilterSet();
            }
            this.updateFilterComboBoxItems();
        }
    }

    private static void performEditGlobalFiltersAction() {
        GlobalFiltersPanel globalFiltersPanel = GlobalFiltersPanel.getDefault();
        DialogDescriptor dd = new DialogDescriptor((Object)globalFiltersPanel, Bundle.CPUSettingsBasicPanel_GlobalFiltersDialogCaption(), true, new Object[]{globalFiltersPanel.getOKButton(), globalFiltersPanel.getCancelButton()}, (Object)globalFiltersPanel.getOKButton(), 0, null, null);
        Dialog d = DialogDisplayer.getDefault().createDialog(dd);
        globalFiltersPanel.init();
        d.pack();
        d.setVisible(true);
        if (dd.getValue() == globalFiltersPanel.getOKButton()) {
            globalFiltersPanel.applyChanges();
            FilterSetsPanel.getDefault().processGlobalFiltersChanged();
        }
    }

    private void performQuickFilterAction() {
        QuickFilterPanel quickFilterPanel = QuickFilterPanel.getDefault();
        DialogDescriptor dd = new DialogDescriptor((Object)quickFilterPanel, Bundle.CPUSettingsBasicPanel_QuickFilterDialogCaption(), true, new Object[]{quickFilterPanel.getOKButton(), quickFilterPanel.getCancelButton()}, (Object)quickFilterPanel.getOKButton(), 0, null, null);
        Dialog d = DialogDisplayer.getDefault().createDialog(dd);
        quickFilterPanel.init(this.quickFilter);
        d.pack();
        d.setVisible(true);
        if (dd.getValue() == quickFilterPanel.getOKButton()) {
            quickFilterPanel.applyChanges();
            this.filterCombo.setSelectedItem(this.quickFilter);
        }
        this.updateControls();
        this.filterCombo.requestFocus();
    }

    private void performRootMethodsAction() {
        if (this.rootMethodsActionExecuting.compareAndSet(false, true)) {
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    new SwingWorker(false){
                        private ProgressDisplayer pd;
                        private final AtomicBoolean cancelled;
                        private ClientUtils.SourceCodeSelection[] rms;
                        {
                            this.pd = ProfilerProgressDisplayer.getDefault();
                            this.cancelled = new AtomicBoolean(false);
                        }

                        protected void doInBackground() {
                            this.rms = CPUSettingsBasicPanel.this.rootMethods.length == 0 ? ProjectContentsSupport.get((Lookup.Provider)CPUSettingsBasicPanel.this.project).getProfilingRoots(null, ProjectUtilities.hasSubprojects((Lookup.Provider)CPUSettingsBasicPanel.this.project)) : CPUSettingsBasicPanel.this.rootMethods;
                        }

                        protected void nonResponding() {
                            this.pd.showProgress(Bundle.MSG_DefaultRoots(), new ProgressDisplayer.ProgressController(){

                                public boolean cancel() {
                                    cancelled.set(true);
                                    return true;
                                }
                            });
                        }

                        protected void done() {
                            ClientUtils.SourceCodeSelection[] roots;
                            this.pd.close();
                            if (!this.cancelled.get() && (roots = ProfilingRoots.selectRoots((ClientUtils.SourceCodeSelection[])this.rms, (Lookup.Provider)CPUSettingsBasicPanel.this.project)) != null) {
                                CPUSettingsBasicPanel.access$902(CPUSettingsBasicPanel.this, roots);
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        CPUSettingsBasicPanel.this.updateControls();
                                    }
                                });
                            }
                            CPUSettingsBasicPanel.this.rootMethodsActionExecuting.set(false);
                        }
                    }.execute();
                }
            });
        }
    }

    private void performShowFilterAction() {
        this.selectedInstrumentationFilter = this.filterCombo.getSelectedItem();
        if (!this.preferredInstrFilters.contains(this.selectedInstrumentationFilter)) {
            return;
        }
        PreferredInstrFilterPanel preferredInstrFilterPanel = PreferredInstrFilterPanel.getDefault();
        PreferredInstrFilterPanel.FilterResolver filterComputer = new PreferredInstrFilterPanel.FilterResolver(){

            @Override
            protected String[] computeFilterValues() {
                SimpleFilter sf = SelectProfilingTask.getDefault().getResolvedPredefinedFilter((SimpleFilter)CPUSettingsBasicPanel.this.selectedInstrumentationFilter);
                String[] fvs = FilterUtils.getSeparateFilters((String)sf.getFilterValue());
                return fvs;
            }
        };
        DialogDescriptor dd = new DialogDescriptor((Object)preferredInstrFilterPanel, Bundle.CPUSettingsBasicPanel_ShowFilterCaption(((SimpleFilter)this.selectedInstrumentationFilter).getFilterName()), true, new Object[]{preferredInstrFilterPanel.OPEN_IN_QUICKFILTER_BUTTON, preferredInstrFilterPanel.CLOSE_BUTTON}, (Object)preferredInstrFilterPanel.CLOSE_BUTTON, 0, null, null);
        Dialog d = DialogDisplayer.getDefault().createDialog(dd);
        preferredInstrFilterPanel.init(filterComputer);
        d.pack();
        d.setVisible(true);
        if (dd.getValue() == preferredInstrFilterPanel.OPEN_IN_QUICKFILTER_BUTTON) {
            String[] filterValues = filterComputer.getFilterValues();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < filterValues.length; ++i) {
                sb.append(filterValues[i]).append(i == filterValues.length - 1 ? "" : " ");
            }
            this.quickFilter.setFilterType(2);
            this.quickFilter.setFilterValue(sb.toString());
            this.performQuickFilterAction();
            return;
        }
        this.filterCombo.requestFocus();
    }

    private void performShowProfilingPointsAction() {
        this.profilingPointsDisplayer.run();
    }

    private void selectActiveComboItem() {
        int itemToSelect = this.preferredInstrFilters != null && !this.preferredInstrFilters.isEmpty() ? 1 : 0;
        for (int i = 0; i < this.filterCombo.getItemCount(); ++i) {
            Object comboItem = this.filterCombo.getItemAt(i);
            if (!comboItem.equals(this.selectedInstrumentationFilter)) continue;
            itemToSelect = i;
            break;
        }
        this.filterCombo.setSelectedIndex(itemToSelect);
        this.updateComboLinks();
    }

    private void updateComboLinks() {
        this.selectedInstrumentationFilter = this.filterCombo.getSelectedItem();
        if (this.selectedInstrumentationFilter == null) {
            this.selectedInstrumentationFilter = SimpleFilter.NO_FILTER;
        }
        if (this.quickFilter.equals(this.selectedInstrumentationFilter)) {
            this.showFilterLink.setVisible(false);
            this.editFilterLink.setVisible(true);
        } else if (this.preferredInstrFilters != null && this.preferredInstrFilters.contains(this.selectedInstrumentationFilter)) {
            this.showFilterLink.setEnabled(true);
            this.showFilterLink.setVisible(true);
            this.editFilterLink.setVisible(false);
        } else {
            this.showFilterLink.setEnabled(false);
            this.showFilterLink.setVisible(true);
            this.editFilterLink.setVisible(false);
        }
    }

    private void updateControls() {
        this.partOfAppHintLink.setVisible(this.profileAppRadio.isSelected());
        this.stopwatchHintLink.setVisible(this.stopwatchRadio.isSelected());
        boolean rootMethodsSubmitOK = true;
        boolean quickFilterSubmitOK = true;
        if (this.profileAppRadio.isSelected()) {
            String labelToolTip;
            String labelFocusedText;
            String labelText;
            Color linkColor = Color.RED;
            String colorText = "rgb(" + linkColor.getRed() + "," + linkColor.getGreen() + "," + linkColor.getBlue() + ")";
            String textColorText = "rgb(" + Color.GRAY.getRed() + "," + Color.GRAY.getGreen() + "," + Color.GRAY.getBlue() + ")";
            if (this.rootMethods.length == 0) {
                labelText = "<nobr>" + Bundle.CPUSettingsBasicPanel_DefaultRootsString(textColorText, "") + "</nobr>";
                labelFocusedText = "<nobr>" + Bundle.CPUSettingsBasicPanel_DefaultRootsString(textColorText, "color=\"" + colorText + "\"") + "</nobr>";
                labelToolTip = Bundle.CPUSettingsBasicPanel_DefaultRootsToolTip();
                rootMethodsSubmitOK = true;
            } else {
                labelText = "<nobr>" + Bundle.CPUSettingsBasicPanel_CustomRootsString(textColorText, "") + "</nobr>";
                labelFocusedText = "<nobr>" + Bundle.CPUSettingsBasicPanel_CustomRootsString(textColorText, "color=\"" + colorText + "\"") + "</nobr>";
                labelToolTip = Bundle.CPUSettingsBasicPanel_CustomRootsToolTip();
                rootMethodsSubmitOK = true;
            }
            this.partOfAppHintLink.setText(labelText, labelFocusedText);
            this.partOfAppHintLink.setToolTipText(labelToolTip);
        }
        if (this.quickFilter != null && this.quickFilter.equals(this.filterCombo.getSelectedItem()) && this.quickFilter.getFilterValue().trim().length() == 0) {
            quickFilterSubmitOK = false;
        }
        if (rootMethodsSubmitOK && quickFilterSubmitOK) {
            SelectProfilingTask.getDefault().enableSubmitButton();
        } else {
            SelectProfilingTask.getDefault().disableSubmitButton();
        }
        if (this.project != null) {
            if (this.sampleAppRadio.isSelected() || this.stopwatchRadio.isSelected()) {
                if (this.lastProfilingPointsState) {
                    return;
                }
                this.profilingPointsStateCache = this.profilingPointsCheckbox.isSelected();
                this.profilingPointsCheckbox.setEnabled(false);
                this.profilingPointsCheckbox.setSelected(false);
                if (this.stopwatchRadio.isSelected()) {
                    this.filterLabel.setEnabled(false);
                    this.filterCombo.setEnabled(false);
                    this.showFilterLink.setEnabled(false);
                    this.editFilterSetsLink.setEnabled(false);
                }
                this.lastProfilingPointsState = true;
            } else {
                if (!this.lastProfilingPointsState) {
                    return;
                }
                this.profilingPointsCheckbox.setEnabled(true);
                this.profilingPointsCheckbox.setSelected(this.profilingPointsStateCache);
                this.filterLabel.setEnabled(true);
                this.filterCombo.setEnabled(true);
                this.showFilterLink.setEnabled(true);
                this.editFilterSetsLink.setEnabled(true);
                this.lastProfilingPointsState = false;
            }
        }
    }

    private void updateEnabling() {
        this.profilingPointsLink.setEnabled(this.profilingPointsCheckbox.isSelected() && this.profilingPointsCheckbox.isEnabled());
    }

    private void updateFilterComboBoxItems() {
        this.filterCombo.removeActionListener(this);
        this.filterCombo.removeAllItems();
        this.filterCombo.addItem(FilterUtils.NONE_FILTER);
        if (this.preferredInstrFilters != null && this.preferredInstrFilters.size() > 0) {
            for (int i = 0; i < this.preferredInstrFilters.size(); ++i) {
                this.filterCombo.addItem(this.preferredInstrFilters.get(i));
            }
        }
        this.filterCombo.addItem(new JSeparator());
        this.filterCombo.addItem(this.quickFilter);
        this.filterCombo.addItem(new JSeparator());
        DefinedFilterSets definedFilterSets = Profiler.getDefault().getDefinedFilterSets();
        for (int i = 0; i < definedFilterSets.getFilterSetsCount(); ++i) {
            this.filterCombo.addItem(definedFilterSets.getFilterSetAt(i));
        }
        this.selectActiveComboItem();
        this.filterCombo.addActionListener(this);
    }

    static /* synthetic */ ClientUtils.SourceCodeSelection[] access$902(CPUSettingsBasicPanel x0, ClientUtils.SourceCodeSelection[] x1) {
        x0.rootMethods = x1;
        return x1;
    }
}

