/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.stp;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.JExtendedSpinner;
import org.netbeans.modules.profiler.stp.Bundle;
import org.netbeans.modules.profiler.stp.DefaultSettingsPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;

public class CPUSettingsAdvancedPanel
extends DefaultSettingsPanel
implements HelpCtx.Provider {
    private static final String HELP_CTX_KEY = "CPUSettings.Advanced.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("CPUSettings.Advanced.HelpCtx");
    private JCheckBox excludeTimeCheckbox;
    private JCheckBox instrumentEmptyMethodsCheckbox;
    private JCheckBox instrumentGettersSettersCheckbox;
    private JCheckBox instrumentMethodInvokeCheckbox;
    private JCheckBox limitThreadsCheckbox;
    private JCheckBox profileFrameworkCheckbox;
    private JCheckBox profileSpawnedThreadsCheckbox;
    private JCheckBox threadsMonitoringCheckbox;
    private JCheckBox threadsSamplingCheckbox;
    private JCheckBox useCPUTimerCheckbox;
    private JComboBox instrumentationSchemeCombo;
    private JLabel instrumentLabel;
    private JLabel instrumentationSchemeLabel;
    private JLabel methodsTrackingLabel;
    private JLabel sampledTimingLabel;
    private JLabel samplingFrequencyLabel;
    private JLabel samplingFrequencyUnitsLabel;
    private JPanel settingsPanel;
    private JPanel samplSettingsPanel;
    private JPanel instrSettingsPanel;
    private JPanel threadsSettingsPanel;
    private JRadioButton exactTimingRadio;
    private JRadioButton sampledTimingRadio;
    private JSpinner limitThreadsSpinner;
    private JSpinner sampledTimingSpinner;
    private JSpinner samplingFrequencySpinner;
    private int profilingType;

    public CPUSettingsAdvancedPanel() {
        this.initComponents();
    }

    public void setProfilingType(int profilingType) {
        this.profilingType = profilingType;
        if (profilingType == 64) {
            this.settingsPanel.removeAll();
            this.settingsPanel.add(this.samplSettingsPanel);
        } else {
            this.settingsPanel.removeAll();
            this.settingsPanel.add(this.instrSettingsPanel);
        }
    }

    public void setCPUProfilingType(int type) {
        if (this.profilingType == 64) {
            return;
        }
        this.exactTimingRadio.setSelected(type == 0);
        this.sampledTimingRadio.setSelected(type == 1);
        this.sampledTimingSpinner.setEnabled(this.sampledTimingRadio.isSelected());
    }

    public int getCPUProfilingType() {
        if (this.profilingType == 64) {
            return 2;
        }
        if (this.exactTimingRadio.isSelected()) {
            return 0;
        }
        return 1;
    }

    public void setSamplingFrequency(int samplingFrequency) {
        this.samplingFrequencySpinner.setValue(samplingFrequency);
    }

    public int getSamplingFrequency() {
        return (Integer)this.samplingFrequencySpinner.getValue();
    }

    public void setEntireAppDefaults(boolean isPreset) {
        if (isPreset) {
            this.profileSpawnedThreadsCheckbox.setSelected(false);
        }
        if (isPreset) {
            this.instrumentationSchemeCombo.setSelectedItem(Bundle.CPUSettingsAdvancedPanel_SchemeComboBoxItemTotal());
        }
        if (isPreset) {
            this.profileFrameworkCheckbox.setSelected(false);
        }
        if (!isPreset) {
            this.profileFrameworkCheckbox.setEnabled(true);
        }
        if (isPreset) {
            this.useCPUTimerCheckbox.setSelected(false);
        }
        if (isPreset) {
            this.exactTimingRadio.setSelected(true);
        }
    }

    public void setExcludeThreadTime(boolean exclude) {
        this.excludeTimeCheckbox.setSelected(exclude);
    }

    public boolean getExcludeThreadTime() {
        return this.excludeTimeCheckbox.isSelected();
    }

    public HelpCtx getHelpCtx() {
        return HELP_CTX;
    }

    public void setInstrumentEmptyMethods(boolean instrument) {
        this.instrumentEmptyMethodsCheckbox.setSelected(instrument);
    }

    public boolean getInstrumentEmptyMethods() {
        return this.instrumentEmptyMethodsCheckbox.isSelected();
    }

    public void setInstrumentGettersSetters(boolean instrument) {
        this.instrumentGettersSettersCheckbox.setSelected(instrument);
    }

    public boolean getInstrumentGettersSetters() {
        return this.instrumentGettersSettersCheckbox.isSelected();
    }

    public void setInstrumentMethodInvoke(boolean instrument) {
        this.instrumentMethodInvokeCheckbox.setSelected(instrument);
    }

    public boolean getInstrumentMethodInvoke() {
        return this.instrumentMethodInvokeCheckbox.isSelected();
    }

    public void setInstrumentationScheme(int scheme) {
        if (scheme == 1) {
            this.instrumentationSchemeCombo.setSelectedItem(Bundle.CPUSettingsAdvancedPanel_SchemeComboBoxItemLazy());
        } else if (scheme == 2) {
            this.instrumentationSchemeCombo.setSelectedItem(Bundle.CPUSettingsAdvancedPanel_SchemeComboBoxItemEager());
        } else {
            this.instrumentationSchemeCombo.setSelectedItem(Bundle.CPUSettingsAdvancedPanel_SchemeComboBoxItemTotal());
        }
    }

    public int getInstrumentationScheme() {
        Object selectedScheme = this.instrumentationSchemeCombo.getSelectedItem();
        if (selectedScheme.equals(Bundle.CPUSettingsAdvancedPanel_SchemeComboBoxItemLazy())) {
            return 1;
        }
        if (selectedScheme.equals(Bundle.CPUSettingsAdvancedPanel_SchemeComboBoxItemEager())) {
            return 2;
        }
        return 3;
    }

    public void setPartOfAppDefaults(boolean isPreset) {
        if (isPreset) {
            this.profileSpawnedThreadsCheckbox.setSelected(false);
        }
        if (isPreset) {
            this.instrumentationSchemeCombo.setSelectedItem(Bundle.CPUSettingsAdvancedPanel_SchemeComboBoxItemLazy());
        }
        if (isPreset) {
            this.useCPUTimerCheckbox.setSelected(false);
        }
        this.profileFrameworkCheckbox.setSelected(false);
        this.profileFrameworkCheckbox.setEnabled(false);
    }

    public void setProfileFramework(boolean profile) {
        this.profileFrameworkCheckbox.setSelected(profile);
    }

    public boolean getProfileFramework() {
        return this.profileFrameworkCheckbox.isSelected();
    }

    public void setProfileSpawnedThreads(boolean profile) {
        this.profileSpawnedThreadsCheckbox.setSelected(profile);
    }

    public boolean getProfileSpawnedThreads() {
        return this.profileSpawnedThreadsCheckbox.isSelected();
    }

    public void setProfiledThreadsLimit(int limit) {
        this.limitThreadsCheckbox.setSelected(limit > 0);
        this.limitThreadsSpinner.setValue(Math.abs(limit));
        this.limitThreadsSpinner.setEnabled(this.limitThreadsCheckbox.isSelected());
    }

    public int getProfiledThreadsLimit() {
        if (this.limitThreadsCheckbox.isSelected()) {
            return (Integer)this.limitThreadsSpinner.getValue();
        }
        return -((Integer)this.limitThreadsSpinner.getValue()).intValue();
    }

    public void setSamplingInterval(int samplingInterval) {
        this.sampledTimingSpinner.setValue(samplingInterval);
    }

    public int getSamplingInterval() {
        return (Integer)this.sampledTimingSpinner.getValue();
    }

    public void setThreadsMonitoring(boolean enabled) {
        this.threadsMonitoringCheckbox.setSelected(enabled);
    }

    public boolean getThreadsMonitoring() {
        return this.threadsMonitoringCheckbox.isSelected();
    }

    public void setThreadsSampling(boolean enabled) {
        this.threadsSamplingCheckbox.setSelected(enabled);
    }

    public boolean getThreadsSampling() {
        return this.threadsSamplingCheckbox.isSelected();
    }

    public void setUseCPUTimer(boolean use, boolean available) {
        this.useCPUTimerCheckbox.setSelected(use);
        this.useCPUTimerCheckbox.setEnabled(available);
    }

    public boolean getUseCPUTimer() {
        return this.profilingType == 64 || this.useCPUTimerCheckbox.isSelected();
    }

    public void disableAll() {
        this.methodsTrackingLabel.setEnabled(false);
        this.exactTimingRadio.setEnabled(false);
        this.sampledTimingRadio.setEnabled(false);
        this.sampledTimingSpinner.setEnabled(false);
        this.sampledTimingLabel.setEnabled(false);
        this.excludeTimeCheckbox.setEnabled(false);
        this.profileFrameworkCheckbox.setEnabled(false);
        this.profileSpawnedThreadsCheckbox.setEnabled(false);
        this.limitThreadsCheckbox.setEnabled(false);
        this.limitThreadsSpinner.setEnabled(false);
        this.useCPUTimerCheckbox.setEnabled(false);
        this.instrumentationSchemeLabel.setEnabled(false);
        this.instrumentationSchemeCombo.setEnabled(false);
        this.instrumentLabel.setEnabled(false);
        this.instrumentMethodInvokeCheckbox.setEnabled(false);
        this.instrumentGettersSettersCheckbox.setEnabled(false);
        this.instrumentEmptyMethodsCheckbox.setEnabled(false);
        this.samplingFrequencyLabel.setEnabled(false);
        this.samplingFrequencyUnitsLabel.setEnabled(false);
        this.samplingFrequencySpinner.setEnabled(false);
        this.threadsSettingsPanel.setEnabled(false);
        this.threadsMonitoringCheckbox.setEnabled(false);
        this.threadsSamplingCheckbox.setEnabled(false);
    }

    public void enableAll() {
        this.methodsTrackingLabel.setEnabled(true);
        this.exactTimingRadio.setEnabled(true);
        this.sampledTimingRadio.setEnabled(true);
        this.sampledTimingSpinner.setEnabled(true);
        this.sampledTimingLabel.setEnabled(true);
        this.excludeTimeCheckbox.setEnabled(true);
        this.profileFrameworkCheckbox.setEnabled(true);
        this.profileSpawnedThreadsCheckbox.setEnabled(true);
        this.limitThreadsCheckbox.setEnabled(true);
        this.limitThreadsSpinner.setEnabled(true);
        this.useCPUTimerCheckbox.setEnabled(true);
        this.instrumentationSchemeLabel.setEnabled(true);
        this.instrumentationSchemeCombo.setEnabled(true);
        this.instrumentLabel.setEnabled(true);
        this.instrumentMethodInvokeCheckbox.setEnabled(true);
        this.instrumentGettersSettersCheckbox.setEnabled(true);
        this.instrumentEmptyMethodsCheckbox.setEnabled(true);
        this.samplingFrequencyLabel.setEnabled(true);
        this.samplingFrequencyUnitsLabel.setEnabled(true);
        this.samplingFrequencySpinner.setEnabled(true);
        this.threadsSettingsPanel.setEnabled(true);
        this.threadsMonitoringCheckbox.setEnabled(true);
        this.threadsSamplingCheckbox.setEnabled(true);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception e) {
            // empty catch block
        }
        JFrame frame = new JFrame("Tester Frame");
        CPUSettingsAdvancedPanel contents = new CPUSettingsAdvancedPanel();
        contents.setPreferredSize(new Dimension(375, 255));
        frame.getContentPane().add(contents);
        frame.setDefaultCloseOperation(3);
        frame.pack();
        frame.setVisible(true);
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        ButtonGroup methodsTrackingRadiosGroup = new ButtonGroup();
        this.settingsPanel = new JPanel(new BorderLayout());
        this.settingsPanel.setOpaque(false);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 0;
        constraints.fill = 2;
        constraints.anchor = 18;
        constraints.insets = new Insets(0, 5, 10, 5);
        this.add((Component)this.settingsPanel, constraints);
        this.samplSettingsPanel = new JPanel(new GridBagLayout());
        this.samplSettingsPanel.setOpaque(false);
        this.samplSettingsPanel.setBorder(BorderFactory.createTitledBorder(Bundle.CPUSettingsAdvancedPanel_SettingsCaption()));
        JPanel samplingFrequencyContainer = new JPanel(new GridBagLayout());
        this.samplingFrequencyLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.samplingFrequencyLabel, (String)Bundle.StpSamplingFrequencyLabel());
        this.samplingFrequencyLabel.setToolTipText(Bundle.StpSamplingFrequencyTooltip());
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 0, 0, 5);
        samplingFrequencyContainer.add((Component)this.samplingFrequencyLabel, constraints);
        this.samplingFrequencySpinner = new JExtendedSpinner(new SpinnerNumberModel(10, 1, Integer.MAX_VALUE, 1)){

            public Dimension getPreferredSize() {
                return new Dimension(55, 1.getDefaultSpinnerHeight());
            }

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.samplingFrequencySpinner.setToolTipText(Bundle.StpSamplingFrequencyTooltip());
        this.samplingFrequencySpinner.addChangeListener(this.getSettingsChangeListener());
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 0, 0, 0);
        samplingFrequencyContainer.add((Component)this.samplingFrequencySpinner, constraints);
        this.samplingFrequencyUnitsLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.samplingFrequencyUnitsLabel, (String)"&ms");
        this.samplingFrequencyUnitsLabel.setLabelFor(this.samplingFrequencySpinner);
        this.samplingFrequencyUnitsLabel.setToolTipText(Bundle.StpSamplingFrequencyTooltip());
        this.samplingFrequencyUnitsLabel.setOpaque(false);
        constraints = new GridBagConstraints();
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 5, 0, 0);
        samplingFrequencyContainer.add((Component)this.samplingFrequencyUnitsLabel, constraints);
        samplingFrequencyContainer.setOpaque(false);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(2, 7, 8, 0);
        this.samplSettingsPanel.add((Component)samplingFrequencyContainer, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridwidth = 0;
        constraints.fill = 1;
        constraints.anchor = 18;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.samplSettingsPanel.add((Component)UIUtils.createFillerPanel(), constraints);
        this.instrSettingsPanel = new JPanel(new GridBagLayout());
        this.instrSettingsPanel.setOpaque(false);
        this.instrSettingsPanel.setBorder(BorderFactory.createTitledBorder(Bundle.CPUSettingsAdvancedPanel_SettingsCaption()));
        this.methodsTrackingLabel = new JLabel(Bundle.CPUSettingsAdvancedPanel_MethodsTrackingLabelText());
        this.methodsTrackingLabel.setOpaque(false);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.gridwidth = 0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(2, 7, 0, 0);
        this.instrSettingsPanel.add((Component)this.methodsTrackingLabel, constraints);
        this.exactTimingRadio = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.exactTimingRadio, (String)Bundle.CPUSettingsAdvancedPanel_InstrRadioText());
        this.exactTimingRadio.setToolTipText(Bundle.StpExactTimingTooltip());
        methodsTrackingRadiosGroup.add(this.exactTimingRadio);
        this.exactTimingRadio.addActionListener(this.getSettingsChangeListener());
        this.exactTimingRadio.setOpaque(false);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(5, 19, 0, 0);
        this.instrSettingsPanel.add((Component)this.exactTimingRadio, constraints);
        JPanel sampledTimingContainer = new JPanel(new GridBagLayout());
        this.sampledTimingRadio = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.sampledTimingRadio, (String)Bundle.CPUSettingsAdvancedPanel_SamplingRadioText());
        this.sampledTimingRadio.setToolTipText(Bundle.StpSampledTimingTooltip());
        methodsTrackingRadiosGroup.add(this.sampledTimingRadio);
        this.sampledTimingRadio.setOpaque(false);
        this.sampledTimingRadio.setSelected(true);
        this.sampledTimingRadio.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                CPUSettingsAdvancedPanel.this.sampledTimingSpinner.setEnabled(CPUSettingsAdvancedPanel.this.sampledTimingRadio.isSelected());
                CPUSettingsAdvancedPanel.this.sampledTimingLabel.setEnabled(CPUSettingsAdvancedPanel.this.sampledTimingRadio.isSelected());
            }
        });
        this.sampledTimingRadio.addActionListener(this.getSettingsChangeListener());
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 0, 0, 5);
        sampledTimingContainer.add((Component)this.sampledTimingRadio, constraints);
        this.sampledTimingSpinner = new JExtendedSpinner(new SpinnerNumberModel(10, 1, Integer.MAX_VALUE, 1)){

            public Dimension getPreferredSize() {
                return new Dimension(55, 3.getDefaultSpinnerHeight());
            }

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.sampledTimingSpinner.setToolTipText(Bundle.StpSampledTimingTooltip());
        this.sampledTimingSpinner.addChangeListener(this.getSettingsChangeListener());
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 0, 0, 0);
        sampledTimingContainer.add((Component)this.sampledTimingSpinner, constraints);
        this.sampledTimingLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.sampledTimingLabel, (String)"&ms");
        this.sampledTimingLabel.setLabelFor(this.sampledTimingSpinner);
        this.sampledTimingLabel.setToolTipText(Bundle.StpSampledTimingTooltip());
        this.sampledTimingLabel.setOpaque(false);
        constraints = new GridBagConstraints();
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 5, 0, 0);
        sampledTimingContainer.add((Component)this.sampledTimingLabel, constraints);
        sampledTimingContainer.setOpaque(false);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(1, 19, 5, 0);
        this.instrSettingsPanel.add((Component)sampledTimingContainer, constraints);
        this.excludeTimeCheckbox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.excludeTimeCheckbox, (String)Bundle.CPUSettingsAdvancedPanel_ExcludeTimeCheckboxText());
        this.excludeTimeCheckbox.setToolTipText(Bundle.StpSleepWaitTooltip());
        this.excludeTimeCheckbox.addActionListener(this.getSettingsChangeListener());
        this.excludeTimeCheckbox.setOpaque(false);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(5, 7, 0, 0);
        this.instrSettingsPanel.add((Component)this.excludeTimeCheckbox, constraints);
        this.profileFrameworkCheckbox = new JCheckBox(){

            @Override
            public void setSelected(boolean b) {
                super.setSelected(b);
                CPUSettingsAdvancedPanel.this.updateEnabling();
            }
        };
        Mnemonics.setLocalizedText((AbstractButton)this.profileFrameworkCheckbox, (String)Bundle.CPUSettingsAdvancedPanel_ProfileFrameworkCheckboxText());
        this.profileFrameworkCheckbox.setToolTipText(Bundle.StpFrameworkTooltip());
        this.profileFrameworkCheckbox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                CPUSettingsAdvancedPanel.this.updateEnabling();
            }
        });
        this.profileFrameworkCheckbox.addActionListener(this.getSettingsChangeListener());
        this.profileFrameworkCheckbox.setOpaque(false);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.gridwidth = 0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(5, 7, 0, 0);
        this.instrSettingsPanel.add((Component)this.profileFrameworkCheckbox, constraints);
        this.profileSpawnedThreadsCheckbox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.profileSpawnedThreadsCheckbox, (String)Bundle.CPUSettingsAdvancedPanel_ProfileThreadsCheckboxText());
        this.profileSpawnedThreadsCheckbox.setToolTipText(Bundle.StpSpawnedTooltip());
        this.profileSpawnedThreadsCheckbox.addActionListener(this.getSettingsChangeListener());
        this.profileSpawnedThreadsCheckbox.setOpaque(false);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 5;
        constraints.gridwidth = 0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(5, 7, 0, 0);
        this.instrSettingsPanel.add((Component)this.profileSpawnedThreadsCheckbox, constraints);
        JPanel limitThreadsContainer = new JPanel(new GridBagLayout());
        this.limitThreadsCheckbox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.limitThreadsCheckbox, (String)Bundle.CPUSettingsAdvancedPanel_LimitThreadsCheckboxText());
        this.limitThreadsCheckbox.setToolTipText(Bundle.StpLimitThreadsTooltip());
        this.limitThreadsCheckbox.addActionListener(this.getSettingsChangeListener());
        this.limitThreadsCheckbox.setOpaque(false);
        this.limitThreadsCheckbox.setSelected(true);
        this.limitThreadsCheckbox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                CPUSettingsAdvancedPanel.this.limitThreadsSpinner.setEnabled(CPUSettingsAdvancedPanel.this.limitThreadsCheckbox.isSelected());
            }
        });
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 0, 0, 5);
        limitThreadsContainer.add((Component)this.limitThreadsCheckbox, constraints);
        this.limitThreadsSpinner = new JExtendedSpinner(new SpinnerNumberModel(50, 1, Integer.MAX_VALUE, 1)){

            public Dimension getPreferredSize() {
                return new Dimension(55, 7.getDefaultSpinnerHeight());
            }

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.limitThreadsSpinner.setToolTipText(Bundle.StpLimitThreadsTooltip());
        this.limitThreadsSpinner.addChangeListener(this.getSettingsChangeListener());
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 0, 0, 0);
        limitThreadsContainer.add((Component)this.limitThreadsSpinner, constraints);
        limitThreadsContainer.setOpaque(false);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 6;
        constraints.gridwidth = 0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(5, 7, 0, 0);
        this.instrSettingsPanel.add((Component)limitThreadsContainer, constraints);
        this.useCPUTimerCheckbox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.useCPUTimerCheckbox, (String)Bundle.CPUSettingsAdvancedPanel_ThreadTimerCheckboxText());
        this.useCPUTimerCheckbox.setToolTipText(Bundle.StpCpuTimerTooltip());
        this.useCPUTimerCheckbox.addActionListener(this.getSettingsChangeListener());
        this.useCPUTimerCheckbox.setOpaque(false);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 7;
        constraints.gridwidth = 0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(5, 7, 0, 0);
        this.instrSettingsPanel.add((Component)this.useCPUTimerCheckbox, constraints);
        JPanel instrumentationSchemeContainer = new JPanel(new GridBagLayout());
        this.instrumentationSchemeLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.instrumentationSchemeLabel, (String)Bundle.CPUSettingsAdvancedPanel_InstrSchemeLabelText());
        this.instrumentationSchemeLabel.setToolTipText(Bundle.StpInstrSchemeTooltip());
        this.instrumentationSchemeLabel.setOpaque(false);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 0, 0, 5);
        instrumentationSchemeContainer.add((Component)this.instrumentationSchemeLabel, constraints);
        this.instrumentationSchemeCombo = new JComboBox(new String[]{Bundle.CPUSettingsAdvancedPanel_SchemeComboBoxItemLazy(), Bundle.CPUSettingsAdvancedPanel_SchemeComboBoxItemEager(), Bundle.CPUSettingsAdvancedPanel_SchemeComboBoxItemTotal()}){

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.instrumentationSchemeLabel.setLabelFor(this.instrumentationSchemeCombo);
        this.instrumentationSchemeCombo.setToolTipText(Bundle.StpInstrSchemeTooltip());
        this.instrumentationSchemeCombo.addActionListener(this.getSettingsChangeListener());
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 0, 0, 0);
        instrumentationSchemeContainer.add((Component)this.instrumentationSchemeCombo, constraints);
        instrumentationSchemeContainer.setOpaque(false);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 8;
        constraints.gridwidth = 0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(5, 7, 2, 0);
        this.instrSettingsPanel.add((Component)instrumentationSchemeContainer, constraints);
        this.instrumentLabel = new JLabel(Bundle.CPUSettingsAdvancedPanel_InstrumentLabelText());
        this.instrumentLabel.setOpaque(false);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 9;
        constraints.gridwidth = 0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(5, 7, 0, 0);
        this.instrSettingsPanel.add((Component)this.instrumentLabel, constraints);
        this.instrumentMethodInvokeCheckbox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.instrumentMethodInvokeCheckbox, (String)Bundle.CPUSettingsAdvancedPanel_MethodInvokeCheckboxText());
        this.instrumentMethodInvokeCheckbox.setToolTipText(Bundle.StpMethodInvokeTooltip());
        this.instrumentMethodInvokeCheckbox.addActionListener(this.getSettingsChangeListener());
        this.instrumentMethodInvokeCheckbox.setOpaque(false);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 10;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(2, 19, 0, 0);
        this.instrSettingsPanel.add((Component)this.instrumentMethodInvokeCheckbox, constraints);
        this.instrumentGettersSettersCheckbox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.instrumentGettersSettersCheckbox, (String)Bundle.CPUSettingsAdvancedPanel_GetterSetterCheckboxText());
        this.instrumentGettersSettersCheckbox.setToolTipText(Bundle.StpGetterSetterTooltip());
        this.instrumentGettersSettersCheckbox.addActionListener(this.getSettingsChangeListener());
        this.instrumentGettersSettersCheckbox.setOpaque(false);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 11;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(1, 19, 0, 0);
        this.instrSettingsPanel.add((Component)this.instrumentGettersSettersCheckbox, constraints);
        this.instrumentEmptyMethodsCheckbox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.instrumentEmptyMethodsCheckbox, (String)Bundle.CPUSettingsAdvancedPanel_EmptyMethodsCheckboxText());
        this.instrumentEmptyMethodsCheckbox.setToolTipText(Bundle.StpEmptyMethodsTooltip());
        this.instrumentEmptyMethodsCheckbox.addActionListener(this.getSettingsChangeListener());
        this.instrumentEmptyMethodsCheckbox.setOpaque(false);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 12;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(1, 19, 3, 0);
        this.instrSettingsPanel.add((Component)this.instrumentEmptyMethodsCheckbox, constraints);
        this.threadsSettingsPanel = new JPanel(new GridBagLayout());
        this.threadsSettingsPanel.setOpaque(false);
        this.threadsSettingsPanel.setBorder(BorderFactory.createTitledBorder(Bundle.CPUSettingsAdvancedPanel_ThreadsCaption()));
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 0;
        constraints.fill = 2;
        constraints.anchor = 18;
        constraints.insets = new Insets(0, 5, 10, 5);
        this.add((Component)this.threadsSettingsPanel, constraints);
        this.threadsMonitoringCheckbox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.threadsMonitoringCheckbox, (String)Bundle.CPUSettingsAdvancedPanel_EnableThreadsCheckboxText());
        this.threadsMonitoringCheckbox.setToolTipText(Bundle.StpMonitorTooltip());
        this.threadsMonitoringCheckbox.addActionListener(this.getSettingsChangeListener());
        this.threadsMonitoringCheckbox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                CPUSettingsAdvancedPanel.this.updateEnabling();
            }
        });
        this.threadsMonitoringCheckbox.setOpaque(false);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.gridwidth = 0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(2, 7, 1, 0);
        this.threadsSettingsPanel.add((Component)this.threadsMonitoringCheckbox, constraints);
        this.threadsSamplingCheckbox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.threadsSamplingCheckbox, (String)Bundle.CPUSettingsAdvancedPanel_EnableSamplingCheckboxText());
        this.threadsSamplingCheckbox.setToolTipText(Bundle.StpSamplingTooltip());
        this.threadsSamplingCheckbox.addActionListener(this.getSettingsChangeListener());
        this.threadsSamplingCheckbox.setOpaque(false);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.weightx = 1.0;
        constraints.gridwidth = 0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 7, 3, 0);
        this.threadsSettingsPanel.add((Component)this.threadsSamplingCheckbox, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridwidth = 0;
        constraints.fill = 1;
        constraints.anchor = 18;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)UIUtils.createFillerPanel(), constraints);
    }

    private void updateEnabling() {
        if (this.profileFrameworkCheckbox.isSelected()) {
            this.profileSpawnedThreadsCheckbox.setSelected(true);
            this.profileSpawnedThreadsCheckbox.setEnabled(false);
            this.instrumentationSchemeCombo.setSelectedItem(Bundle.CPUSettingsAdvancedPanel_SchemeComboBoxItemTotal());
            this.instrumentationSchemeCombo.setEnabled(false);
        } else {
            this.profileSpawnedThreadsCheckbox.setEnabled(this.methodsTrackingLabel.isEnabled());
            this.instrumentationSchemeCombo.setEnabled(this.methodsTrackingLabel.isEnabled());
        }
        this.threadsSamplingCheckbox.setEnabled(this.threadsMonitoringCheckbox.isSelected() && this.methodsTrackingLabel.isEnabled());
    }
}

