/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.stp;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.lib.profiler.common.AttachSettings;
import org.netbeans.modules.profiler.api.project.ProjectStorage;
import org.netbeans.modules.profiler.stp.Bundle;
import org.netbeans.modules.profiler.stp.Utils;
import org.netbeans.modules.profiler.stp.ui.HyperlinkLabel;
import org.openide.awt.Mnemonics;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public class AttachSettingsPanel
extends JPanel {
    private static final int PREFERRED_HINT_HEIGHT = new HyperlinkLabel((String)"ABC<a href='#'>ABC</a>", (String)"ABC<a href='#'>ABC</a>", null).getPreferredSize().height;
    private AttachSettings settings;
    private HyperlinkLabel attachModeHintLabel;
    private JLabel attachModeLabel;
    private Lookup.Provider project;
    private boolean settingsValid;

    public AttachSettingsPanel() {
        this.initComponents();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.attachModeLabel.setEnabled(enabled);
        this.attachModeHintLabel.setEnabled(enabled);
    }

    public void setSettings(Lookup.Provider project, boolean settingsValid) {
        this.project = project;
        this.settingsValid = settingsValid;
        this.settings = Utils.getAttachSettings(project);
        this.updateSettingsHint();
    }

    public AttachSettings getSettings() {
        return this.settingsValid ? this.settings : null;
    }

    public void resetSettings() {
        this.setSettings(null, false);
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.attachModeLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.attachModeLabel, (String)Bundle.AttachSettingsPanel_AttachModeLabelText());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(6, 15, 6, 4);
        this.add((Component)this.attachModeLabel, constraints);
        this.attachModeHintLabel = new HyperlinkLabel("ABC<a href='#'>ABC</a>", "ABC<a href='#'>ABC</a>", new Runnable(){

            @Override
            public void run() {
                final AttachSettings attachSettings = Utils.selectAttachSettings(AttachSettingsPanel.this.project);
                if (attachSettings != null) {
                    AttachSettingsPanel.this.settings = attachSettings;
                    AttachSettingsPanel.this.updateSettingsHint();
                    RequestProcessor.getDefault().post(new Runnable(){

                        @Override
                        public void run() {
                            ProjectStorage.saveAttachSettings((Lookup.Provider)AttachSettingsPanel.this.project, (AttachSettings)attachSettings);
                        }
                    });
                }
            }
        }){

            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, PREFERRED_HINT_HEIGHT);
            }
        };
        this.attachModeLabel.setLabelFor((Component)((Object)this.attachModeHintLabel));
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridwidth = 0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(6, 0, 6, 5);
        this.add((Component)((Object)this.attachModeHintLabel), constraints);
    }

    private void updateSettingsHint() {
        Color linkColor = Color.RED;
        String colorText = "rgb(" + linkColor.getRed() + "," + linkColor.getGreen() + "," + linkColor.getBlue() + ")";
        String labelText = "";
        String labelFocusedText = "";
        if (!this.settingsValid) {
            this.attachModeHintLabel.setFocusable(false);
            labelFocusedText = labelText = "<nobr>" + Bundle.AttachSettingsPanel_ProjectPendingString() + "</nobr>";
        } else if (this.settings == null) {
            this.attachModeHintLabel.setFocusable(true);
            labelText = "<nobr>" + Bundle.AttachSettingsPanel_DefineSettingsString("") + "</nobr>";
            labelFocusedText = "<nobr>" + Bundle.AttachSettingsPanel_DefineSettingsString("color=\"" + colorText + "\"") + "</nobr>";
        } else {
            this.attachModeHintLabel.setFocusable(true);
            String attachMethodString = this.settings.isDirect() ? Bundle.AttachSettingsPanel_DirectAttachString() : Bundle.AttachSettingsPanel_DynamicAttachString();
            String targetType = this.settings.getTargetType();
            String serverType = this.settings.getServerType();
            String targetString = "".equals(serverType) ? targetType : serverType;
            String remoteString = this.settings.getHost();
            if (this.settings.isRemote()) {
                labelText = "<nobr>" + Bundle.AttachSettingsPanel_RemoteAttachHintText(attachMethodString, targetString, remoteString, "") + "</nobr>";
                labelFocusedText = "<nobr>" + Bundle.AttachSettingsPanel_RemoteAttachHintText(attachMethodString, targetString, remoteString, "color=\"" + colorText + "\"") + "</nobr>";
                this.attachModeHintLabel.setText("<nobr>" + Bundle.AttachSettingsPanel_RemoteAttachHintText(attachMethodString, targetString, remoteString, "") + "</nobr>");
            } else {
                labelText = "<nobr>" + Bundle.AttachSettingsPanel_LocalAttachHintText(attachMethodString, targetString, "") + "</nobr>";
                labelFocusedText = "<nobr>" + Bundle.AttachSettingsPanel_LocalAttachHintText(attachMethodString, targetString, "color=\"" + colorText + "\"") + "</nobr>";
            }
        }
        this.attachModeHintLabel.setText(labelText, labelFocusedText);
    }
}

