/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdump.section;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.cnd.dwarfdump.reader.ElfReader;
import org.netbeans.modules.cnd.dwarfdump.section.ElfSection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringTableSection
extends ElfSection {
    private byte[] stringtable = null;

    public StringTableSection(ElfReader reader, int sectionIdx) throws IOException {
        super(reader, sectionIdx);
        this.read();
    }

    public StringTableSection(ElfReader reader, byte[] stringtable) {
        super(null, 0, null, "String Table");
        this.stringtable = stringtable;
    }

    @Override
    public final StringTableSection read() throws IOException {
        long filePos = this.reader.getFilePointer();
        this.reader.seek(this.header.getSectionOffset());
        this.stringtable = new byte[(int)this.header.getSectionSize()];
        this.reader.read(this.stringtable);
        this.reader.seek(filePos);
        return this;
    }

    public byte[] getStringTable() {
        return this.stringtable;
    }

    public List<String> getStrings() {
        String string;
        ArrayList<String> res = new ArrayList<String>();
        if (this.stringtable == null) {
            return res;
        }
        for (int offset = 0; offset < this.stringtable.length; offset += string.length() + 1) {
            string = this.getString(offset);
            res.add(string);
        }
        return res;
    }

    public String getString(long offset) {
        StringBuilder str = new StringBuilder();
        for (int i = (int)offset; i < this.stringtable.length && this.stringtable[i] != 0; ++i) {
            str.append((char)this.stringtable[i]);
        }
        return str.toString();
    }

    @Override
    public void dump(PrintStream out) {
        String string;
        super.dump(out);
        if (this.stringtable == null) {
            out.println("<Empty table>");
            return;
        }
        int idx = 0;
        out.printf("No.\tOffset\tString\n", new Object[0]);
        for (int offset = 0; offset < this.stringtable.length; offset += string.length() + 1) {
            string = this.getString(offset);
            out.printf("%d.\t%d\t%s\n", ++idx, offset, string);
        }
    }

    @Override
    public String toString() {
        ByteArrayOutputStream st = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(st);
        this.dump(out);
        return st.toString();
    }
}

