/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdump.section;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.cnd.dwarfdump.CompilationUnitInterface;
import org.netbeans.modules.cnd.dwarfdump.CompilationUnitStab;
import org.netbeans.modules.cnd.dwarfdump.Dwarf;
import org.netbeans.modules.cnd.dwarfdump.reader.DwarfReader;
import org.netbeans.modules.cnd.dwarfdump.section.DwarfDebugInfoSection;
import org.netbeans.modules.cnd.dwarfdump.section.ElfSection;
import org.netbeans.modules.cnd.dwarfdump.section.StabIndexStrSection;

public class StabIndexSection
extends ElfSection {
    private final StabIndexStrSection strings;
    private final List<CompilationUnitInterface> list = new ArrayList<CompilationUnitInterface>();
    private static final int N_UNDF = 0;
    private static final int N_ILDPAD = 76;
    private static final int N_FUN = 36;
    private static final int N_SO = 100;
    private static final int N_OBJ = 56;
    private static final int N_CMDLINE = 52;
    private static final int N_MAIN = 42;

    public StabIndexSection(DwarfReader reader, int sectionIdx) throws IOException {
        super(reader, sectionIdx);
        this.strings = (StabIndexStrSection)reader.getSection(".stab.indexstr");
        this.read();
    }

    public Dwarf.CompilationUnitIterator compilationUnits() throws IOException {
        return new DwarfDebugInfoSection.ListIterator(this.list.iterator());
    }

    public final StabIndexSection read() throws IOException {
        long sectionStart = this.header.getSectionOffset();
        long sectionEnd = this.header.getSectionSize() + sectionStart;
        this.reader.seek(sectionStart);
        long StabStrtab = 0L;
        long StrTabSize = 0L;
        String source = "";
        String line = "";
        String object = "";
        boolean isMain = false;
        int state = 1;
        int lang = 0;
        while (this.reader.getFilePointer() < sectionEnd) {
            String s;
            long str;
            int offset = this.reader.readInt();
            int type = this.reader.readByte() & 0xFF;
            int other = this.reader.readByte() & 0xFF;
            short desc = this.reader.readShort();
            int value = this.reader.readInt();
            if (type == 0 || type == 76) {
                StabStrtab += StrTabSize;
                StrTabSize = value;
            }
            if (offset == 0) continue;
            if (type == 36 && other == 1) {
                if (offset == 1) {
                    ++StrTabSize;
                }
                str = StabStrtab + StrTabSize;
                s = this.strings.getString(str);
                StrTabSize += (long)(s.length() + 1);
            } else {
                str = StabStrtab + (long)offset;
                s = this.strings.getString(str);
            }
            if (type == 100) {
                if (state != 1) {
                    this.list.add(new CompilationUnitStab(source, line, object, isMain, lang));
                    source = "";
                    line = "";
                    object = "";
                    isMain = false;
                    lang = 0;
                }
                source = source + s;
                state = 1;
                if (lang != 0 || desc == 0) continue;
                lang = desc;
                continue;
            }
            if (type == 56) {
                object = object + s;
                state = 2;
                continue;
            }
            if (type == 52) {
                line = s;
                state = 3;
                continue;
            }
            if (type != 42) continue;
            isMain = true;
        }
        if (state >= 1) {
            this.list.add(new CompilationUnitStab(source, line, object, isMain, lang));
        }
        return null;
    }
}

