/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdump.section;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.netbeans.modules.cnd.dwarfdump.CompilationUnit;
import org.netbeans.modules.cnd.dwarfdump.CompilationUnitInterface;
import org.netbeans.modules.cnd.dwarfdump.CompilationUnitStab;
import org.netbeans.modules.cnd.dwarfdump.Dwarf;
import org.netbeans.modules.cnd.dwarfdump.elf.SectionHeader;
import org.netbeans.modules.cnd.dwarfdump.reader.DwarfReader;
import org.netbeans.modules.cnd.dwarfdump.reader.ElfReader;
import org.netbeans.modules.cnd.dwarfdump.section.ElfSection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DwarfDebugInfoSection
extends ElfSection {
    private List<CompilationUnitInterface> compilationUnits;

    public DwarfDebugInfoSection(DwarfReader reader, int sectionIdx) throws IOException {
        super(reader, sectionIdx);
        reader.getSection(".rela.debug_info");
    }

    public DwarfDebugInfoSection(ElfReader reader, int sectionIdx, SectionHeader header, String sectionName) {
        super(reader, sectionIdx, header, sectionName);
    }

    public CompilationUnit getCompilationUnit(long unit_offset) throws IOException {
        for (CompilationUnitInterface unit : this.getCompilationUnits()) {
            if (!(unit instanceof CompilationUnit)) continue;
            CompilationUnit cu = (CompilationUnit)unit;
            if (cu.unit_offset != unit_offset) continue;
            return cu;
        }
        return null;
    }

    public Dwarf.CompilationUnitIterator iteratorCompilationUnits() throws IOException {
        if (this.compilationUnits != null) {
            return new ListIterator(this.compilationUnits.iterator());
        }
        return new UnitIterator();
    }

    public List<CompilationUnitInterface> getCompilationUnits() throws IOException {
        if (this.compilationUnits != null) {
            return this.compilationUnits;
        }
        this.compilationUnits = new ArrayList<CompilationUnitInterface>();
        int cuOffset = 0;
        while ((long)cuOffset != this.header.sh_size) {
            ((DwarfReader)this.reader).seek(this.header.getSectionOffset() + (long)cuOffset);
            if (this.reader.readDWlen() == 0L) break;
            CompilationUnit unit = new CompilationUnit((DwarfReader)this.reader, this.header.getSectionOffset(), cuOffset);
            this.compilationUnits.add(unit);
            cuOffset = (int)((long)cuOffset + unit.getUnitTotalLength());
        }
        return this.compilationUnits;
    }

    @Override
    public void dump(PrintStream out) {
        try {
            for (CompilationUnitInterface unit : this.getCompilationUnits()) {
                if (unit instanceof CompilationUnit) {
                    ((CompilationUnit)unit).dump(out);
                    continue;
                }
                if (!(unit instanceof CompilationUnitStab)) continue;
                ((CompilationUnitStab)unit).dump(out);
            }
        }
        catch (IOException ex) {
            Dwarf.LOG.log(Level.OFF, "Cannot dump compilation unit " + this.reader.getFileName(), ex);
        }
    }

    @Override
    public String toString() {
        ByteArrayOutputStream st = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(st);
        this.dump(out);
        return st.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ListIterator
    implements Dwarf.CompilationUnitIterator {
        private final Iterator<CompilationUnitInterface> it;

        public ListIterator(Iterator<CompilationUnitInterface> it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() throws IOException {
            return this.it.hasNext();
        }

        @Override
        public CompilationUnitInterface next() throws IOException {
            return this.it.next();
        }
    }

    private class UnitIterator
    implements Dwarf.CompilationUnitIterator {
        private int cuOffset = 0;
        private CompilationUnit unit;

        public UnitIterator() throws IOException {
            this.advance();
        }

        public boolean hasNext() throws IOException {
            return this.unit != null;
        }

        public CompilationUnit next() throws IOException {
            CompilationUnit res = this.unit;
            this.advance();
            return res;
        }

        private void advance() throws IOException {
            this.unit = null;
            if ((long)this.cuOffset != DwarfDebugInfoSection.this.header.sh_size) {
                ((DwarfReader)DwarfDebugInfoSection.this.reader).seek(DwarfDebugInfoSection.this.header.getSectionOffset() + (long)this.cuOffset);
                if (DwarfDebugInfoSection.this.reader.readDWlen() == 0L) {
                    return;
                }
                this.unit = new CompilationUnit((DwarfReader)DwarfDebugInfoSection.this.reader, DwarfDebugInfoSection.this.header.getSectionOffset(), this.cuOffset);
                this.cuOffset = (int)((long)this.cuOffset + this.unit.getUnitTotalLength());
            }
        }
    }
}

