/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdump.dwarf;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.netbeans.modules.cnd.dwarfdump.Dwarf;
import org.netbeans.modules.cnd.dwarfdump.dwarf.DwarfMacinfoEntry;
import org.netbeans.modules.cnd.dwarfdump.dwarfconsts.MACINFO;
import org.netbeans.modules.cnd.dwarfdump.section.DwarfMacroInfoSection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DwarfMacinfoTable {
    private long baseSourceTableOffset = -1L;
    private long fileSourceTableOffset = -1L;
    private final DwarfMacroInfoSection section;
    private final List<DwarfMacinfoEntry> baseSourceTable = new ArrayList<DwarfMacinfoEntry>();
    private final List<DwarfMacinfoEntry> fileSourceTable = new ArrayList<DwarfMacinfoEntry>();
    private List<Integer> commandIncludedFilesTable;
    private boolean baseSourceTableRead;
    private boolean fileSourceTableRead;
    private boolean commandIncludedFilesRead;

    public DwarfMacinfoTable(DwarfMacroInfoSection section, long offset) {
        this.section = section;
        this.baseSourceTableRead = false;
        this.fileSourceTableRead = false;
        this.baseSourceTableOffset = this.fileSourceTableOffset = offset;
    }

    public void addEntry(DwarfMacinfoEntry entry) {
        if (entry.fileIdx == -1) {
            this.baseSourceTable.add(entry);
        } else {
            this.fileSourceTable.add(entry);
        }
    }

    private List<DwarfMacinfoEntry> getBaseSourceTable() throws IOException {
        if (this.baseSourceTableRead) {
            return this.baseSourceTable;
        }
        this.readBaseSourceTable();
        return this.baseSourceTable;
    }

    private List<DwarfMacinfoEntry> getFileSourceTable() throws IOException {
        if (this.fileSourceTableRead) {
            return this.fileSourceTable;
        }
        this.readFileSourceTable();
        return this.fileSourceTable;
    }

    private void readBaseSourceTable() throws IOException {
        long length = this.section.readMacinfoTable(this, this.baseSourceTableOffset, true);
        this.fileSourceTableOffset = this.baseSourceTableOffset + length;
        this.baseSourceTableRead = true;
    }

    private void readFileSourceTable() throws IOException {
        this.section.readMacinfoTable(this, this.fileSourceTableOffset, false);
        this.fileSourceTableRead = true;
    }

    public List<Integer> getCommandLineIncludedFiles() throws IOException {
        if (!this.commandIncludedFilesRead) {
            this.commandIncludedFilesTable = this.section.getCommandIncudedFiles(this, this.fileSourceTableOffset);
            this.commandIncludedFilesRead = true;
        }
        return this.commandIncludedFilesTable;
    }

    public List<DwarfMacinfoEntry> getCommandLineMarcos() throws IOException {
        List<DwarfMacinfoEntry> entries = this.getBaseSourceTable();
        int size = entries.size();
        if (size == 0) {
            return entries;
        }
        int idx = 0;
        if (size > 2) {
            DwarfMacinfoEntry firstEntry = entries.get(0);
            DwarfMacinfoEntry secondEntry = entries.get(1);
            if (firstEntry.fileIdx == -1 && secondEntry.fileIdx == -1 && firstEntry.lineNum == secondEntry.lineNum) {
                ArrayList<DwarfMacinfoEntry> retain = new ArrayList<DwarfMacinfoEntry>();
                for (int i = idx; i < entries.size(); ++i) {
                    DwarfMacinfoEntry entry = entries.get(i);
                    if (entry.fileIdx != -1) break;
                    retain.add(entry);
                }
                return retain;
            }
        }
        ArrayList<DwarfMacinfoEntry> result = new ArrayList<DwarfMacinfoEntry>();
        int currLine = entries.get((int)idx).lineNum;
        int prevLine = -1;
        int count = 0;
        while (currLine > prevLine && idx < size) {
            prevLine = currLine;
            if (idx == size - 1) {
                return result;
            }
            currLine = entries.get((int)(++idx)).lineNum;
            ++count;
        }
        if (count < 10 && currLine == 1) {
            idx = 0;
            DwarfMacinfoEntry entry = entries.get(idx);
            do {
                result.add(entry);
                currLine = entry.lineNum;
                if (++idx >= size) break;
                entry = entries.get(idx);
            } while (entry.lineNum == 1);
            return result;
        }
        DwarfMacinfoEntry entry = entries.get(idx);
        do {
            result.add(entry);
            currLine = entry.lineNum;
            if (++idx >= size) break;
            entry = entries.get(idx);
        } while (entry.lineNum - currLine == 1);
        return result;
    }

    public ArrayList<DwarfMacinfoEntry> getMacros(int fileIdx) throws IOException {
        ArrayList<DwarfMacinfoEntry> result = new ArrayList<DwarfMacinfoEntry>();
        for (DwarfMacinfoEntry entry : this.getFileSourceTable()) {
            if (entry.fileIdx != fileIdx || !entry.type.equals((Object)MACINFO.DW_MACINFO_define) && !entry.type.equals((Object)MACINFO.DW_MACINFO_undef)) continue;
            result.add(entry);
        }
        return result;
    }

    public void dump(PrintStream out) {
        out.printf("\nMACRO Table (offset = %d [0x%08x]):\n\n", this.baseSourceTableOffset, this.baseSourceTableOffset);
        try {
            for (DwarfMacinfoEntry entry : this.getBaseSourceTable()) {
                entry.dump(out);
            }
            for (DwarfMacinfoEntry entry : this.getFileSourceTable()) {
                entry.dump(out);
            }
        }
        catch (IOException ex) {
            Dwarf.LOG.log(Level.INFO, "Cannot read eteries", ex);
        }
    }

    public String toString() {
        ByteArrayOutputStream st = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(st);
        this.dump(out);
        return st.toString();
    }
}

