/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdump.dwarf;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.netbeans.modules.cnd.dwarfdump.Dwarf;
import org.netbeans.modules.cnd.dwarfdump.dwarf.DwarfEntry;
import org.netbeans.modules.cnd.dwarfdump.dwarfconsts.ATTR;
import org.netbeans.modules.cnd.dwarfdump.dwarfconsts.TAG;
import org.netbeans.modules.cnd.dwarfdump.section.DwarfAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DwarfAbbriviationTableEntry {
    private final long index;
    private final long tag;
    private final boolean hasChildren;
    private final List<DwarfAttribute> attributes = new ArrayList<DwarfAttribute>();

    public DwarfAbbriviationTableEntry(long index, long tag, boolean hasChildren) {
        this.index = index;
        this.tag = tag;
        this.hasChildren = hasChildren;
    }

    public void addAttribute(int attrName, int valueForm) {
        if (attrName != 0 && valueForm != 0) {
            this.attributes.add(new DwarfAttribute(attrName, valueForm));
        }
    }

    public long getTableIndex() {
        return this.index;
    }

    public int getAttribute(ATTR attrName) {
        for (int i = 0; i < this.attributes.size(); ++i) {
            DwarfAttribute attr = this.attributes.get(i);
            if (!attr.attrName.equals((Object)attrName)) continue;
            return i;
        }
        return -1;
    }

    public DwarfAttribute getAttribute(int idx) {
        return this.attributes.get(idx);
    }

    public int getAttributesCount() {
        return this.attributes.size();
    }

    public boolean hasChildren() {
        return this.hasChildren;
    }

    public void dump() {
        this.dump(System.out, null);
    }

    public void dump(PrintStream out) {
        this.dump(out, null);
    }

    public void dump(PrintStream out, DwarfEntry dwarfEntry) {
        out.println("Abbrev Number: " + this.index + " (" + (Object)((Object)this.getKind()) + ") " + " : " + (this.hasChildren ? "[has children]" : "[no children]"));
        if (dwarfEntry != null) {
            try {
                String qname = dwarfEntry.getQualifiedName();
                if (qname != null) {
                    out.println("\tQualified Name: " + qname);
                }
            }
            catch (IOException ex) {
                Dwarf.LOG.log(Level.SEVERE, null, ex);
            }
            this.dumpAttributes(out, dwarfEntry.getValues());
        }
    }

    public TAG getKind() {
        return TAG.get((int)this.tag);
    }

    private void dumpAttributes(PrintStream out, List<Object> values) {
        for (int i = 0; i < this.getAttributesCount(); ++i) {
            if (values == null) {
                this.getAttribute(i).dump(out);
                continue;
            }
            this.getAttribute(i).dump(out, values.get(i));
        }
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(DwarfEntry dwarfEntry) {
        ByteArrayOutputStream st = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(st);
        this.dump(out, dwarfEntry);
        return st.toString();
    }
}

