/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdump;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import org.netbeans.modules.cnd.dwarfdump.CompilationUnitInterface;
import org.netbeans.modules.cnd.dwarfdump.dwarf.DwarfEntry;
import org.netbeans.modules.cnd.dwarfdump.dwarfconsts.LANG;

public class CompilationUnitStab
implements CompilationUnitInterface {
    private final String sourceName;
    private final String compileLine;
    private final String compileDir;
    private final String objectFile;
    private final boolean hasMain;
    private final int desc;

    public CompilationUnitStab(String sourceName, String line, String objectFile, boolean hasMain, int desc) {
        this.sourceName = sourceName;
        int i = line.indexOf(59);
        if (i > 0) {
            this.compileDir = line.substring(0, i).trim();
            this.compileLine = line.substring(i + 1).trim();
        } else {
            this.compileDir = line;
            this.compileLine = line;
        }
        this.objectFile = objectFile;
        this.hasMain = hasMain;
        this.desc = desc;
    }

    public String getCompilationDir() throws IOException {
        return this.compileDir;
    }

    public String getSourceFileName() throws IOException {
        return this.sourceName;
    }

    public String getCommandLine() throws IOException {
        return this.compileLine;
    }

    public String getObjectFile() throws IOException {
        return this.objectFile;
    }

    public boolean hasMain() throws IOException {
        return this.hasMain;
    }

    public String getSourceFileAbsolutePath() throws IOException {
        String dir = this.getCompilationDir();
        String name = this.getSourceFileName();
        String result = dir != null ? (this.isAbsolute(name) ? name : (dir.endsWith("/") || dir.endsWith("\\") ? dir + name : dir + File.separator + name)) : name;
        return result;
    }

    private boolean isAbsolute(String path) {
        return path.startsWith("/") || path.length() > 2 && path.charAt(1) == ':';
    }

    public String getSourceLanguage() throws IOException {
        switch (this.desc) {
            case 1: {
                return null;
            }
            case 2: {
                return LANG.DW_LANG_C.toString();
            }
            case 3: {
                return LANG.DW_LANG_C89.toString();
            }
            case 4: {
                return LANG.DW_LANG_C_plus_plus.toString();
            }
            case 5: {
                return LANG.DW_LANG_Fortran77.toString();
            }
            case 6: {
                return LANG.DW_LANG_Pascal83.toString();
            }
            case 7: {
                return LANG.DW_LANG_Fortran90.toString();
            }
            case 8: {
                return LANG.DW_LANG_Java.toString();
            }
            case 9: {
                return LANG.DW_LANG_C99.toString();
            }
        }
        return null;
    }

    public DwarfEntry getRoot() {
        return null;
    }

    public void dump(PrintStream out) throws IOException {
        out.println("*** " + this.getSourceFileAbsolutePath() + " ***");
        out.println("    Source Name:  " + this.sourceName);
        out.println("    Compile Dir:  " + this.compileDir);
        out.println("    Compile Line: " + this.compileLine);
        out.println("    Object File:  " + this.objectFile);
        out.println("    Has Main:     " + this.hasMain);
        out.println();
    }

    public String toString() {
        try {
            ByteArrayOutputStream st = new ByteArrayOutputStream();
            PrintStream out = new PrintStream(st);
            this.dump(out);
            return st.toString();
        }
        catch (IOException ex) {
            return "";
        }
    }
}

