/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.welcome.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.welcome.content.BundleSupport;
import org.netbeans.modules.welcome.content.Constants;
import org.netbeans.modules.welcome.content.LinkButton;
import org.netbeans.modules.welcome.content.Utils;
import org.netbeans.modules.welcome.ui.InstallConfig;
import org.openide.awt.Actions;
import org.openide.util.Exceptions;

class PluginsPanel
extends JPanel
implements Constants {
    public PluginsPanel(boolean showInstallPlugins) {
        super(new GridBagLayout());
        this.setOpaque(false);
        if (showInstallPlugins) {
            InstallConfig ic = InstallConfig.getDefault();
            if (ic.isErgonomicsEnabled()) {
                this.addInstallPlugins(BundleSupport.getLabel("InstallPluginsFullIDE"), BundleSupport.getLabel("InstallPluginsDescrFullIDE"));
            } else {
                this.addInstallPlugins(BundleSupport.getLabel("InstallPlugins"), BundleSupport.getLabel("InstallPluginsDescr"));
            }
        } else {
            this.addActivateFeatures(BundleSupport.getLabel("ActivateFeaturesFullIDE"), BundleSupport.getLabel("ActivateFeaturesDescrFullIDE"));
        }
    }

    private void addActivateFeatures(String label, String description) {
        LinkButton b = new LinkButton(label, Utils.getColor("LinkColor"), true, "ActivateFeatures"){

            @Override
            public void actionPerformed(ActionEvent e) {
                this.logUsage();
                new ShowPluginManagerAction("installed").actionPerformed(e);
            }
        };
        b.setFont(GET_STARTED_FONT);
        this.add((Component)b, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.add((Component)new JLabel(description), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(20, 9, 5, 5), 0, 0));
        this.add((Component)new JLabel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void addInstallPlugins(String label, String description) {
        LinkButton b = new LinkButton(label, Utils.getColor("LinkColor"), true, "InstallPlugins"){

            @Override
            public void actionPerformed(ActionEvent e) {
                this.logUsage();
                new ShowPluginManagerAction("available").actionPerformed(e);
            }
        };
        b.setFont(GET_STARTED_FONT);
        this.add((Component)b, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.add((Component)new JLabel(description), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(20, 9, 5, 5), 0, 0));
        this.add((Component)new JLabel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    private static class ShowPluginManagerAction
    extends AbstractAction {
        private final String initialTab;

        public ShowPluginManagerAction(String initialTab) {
            super(BundleSupport.getLabel("AddPlugins"));
            this.initialTab = initialTab;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                Actions.forID((String)"System", (String)"org.netbeans.modules.autoupdate.ui.actions.PluginManagerAction").actionPerformed(new ActionEvent(e.getSource(), 100, this.initialTab));
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

