/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import com.sun.tools.javac.api.ClientCodeWrapper;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.java.source.parsing.FileManagerTransaction;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.parsing.InferableJavaFileObject;
import org.netbeans.modules.java.source.parsing.MemoryFileManager;
import org.netbeans.modules.java.source.parsing.ProcessorGenerated;
import org.netbeans.modules.java.source.parsing.SiblingSource;
import org.netbeans.modules.java.source.util.Iterators;

@ClientCodeWrapper.Trusted
public final class ProxyFileManager
implements JavaFileManager {
    private static final Logger LOG = Logger.getLogger(ProxyFileManager.class.getName());
    private static final JavaFileManager.Location ALL = new JavaFileManager.Location(){

        @Override
        public String getName() {
            return "ALL";
        }

        @Override
        public boolean isOutputLocation() {
            return false;
        }
    };
    private static final JavaFileManager.Location SOURCE_PATH_WRITE = new JavaFileManager.Location(){

        @Override
        public String getName() {
            return "SOURCE_PATH_WRITE";
        }

        @Override
        public boolean isOutputLocation() {
            return false;
        }
    };
    private final Map<JavaFileManager.Location, JavaFileManager[]> fileManagers;
    private final ProcessorGenerated processorGeneratedFiles;
    private final SiblingSource siblings;
    private JavaFileObject lastInfered;
    private String lastInferedResult;

    public ProxyFileManager(@NonNull JavaFileManager bootPath, @NonNull JavaFileManager classPath, @NullAllowed JavaFileManager sourcePath, @NullAllowed JavaFileManager aptSources, @NullAllowed JavaFileManager outputhPath, @NullAllowed MemoryFileManager memoryFileManager, @NonNull ProcessorGenerated processorGeneratedFiles, @NonNull SiblingSource siblings) {
        JavaFileManager[] javaFileManagerArray;
        JavaFileManager[] javaFileManagerArray2;
        JavaFileManager[] javaFileManagerArray3;
        JavaFileManager[] javaFileManagerArray4;
        JavaFileManager[] javaFileManagerArray5;
        assert (bootPath != null);
        assert (classPath != null);
        assert (memoryFileManager == null || sourcePath != null);
        assert (processorGeneratedFiles != null);
        assert (siblings != null);
        this.fileManagers = new HashMap<JavaFileManager.Location, JavaFileManager[]>();
        if (outputhPath == null) {
            JavaFileManager[] javaFileManagerArray6 = new JavaFileManager[1];
            javaFileManagerArray5 = javaFileManagerArray6;
            javaFileManagerArray6[0] = classPath;
        } else {
            JavaFileManager[] javaFileManagerArray7 = new JavaFileManager[2];
            javaFileManagerArray7[0] = outputhPath;
            javaFileManagerArray5 = javaFileManagerArray7;
            javaFileManagerArray7[1] = classPath;
        }
        this.fileManagers.put(StandardLocation.CLASS_PATH, javaFileManagerArray5);
        this.fileManagers.put(StandardLocation.PLATFORM_CLASS_PATH, new JavaFileManager[]{bootPath});
        if (sourcePath == null) {
            javaFileManagerArray4 = new JavaFileManager[]{};
        } else if (memoryFileManager == null) {
            JavaFileManager[] javaFileManagerArray8 = new JavaFileManager[1];
            javaFileManagerArray4 = javaFileManagerArray8;
            javaFileManagerArray8[0] = sourcePath;
        } else {
            JavaFileManager[] javaFileManagerArray9 = new JavaFileManager[2];
            javaFileManagerArray9[0] = sourcePath;
            javaFileManagerArray4 = javaFileManagerArray9;
            javaFileManagerArray9[1] = memoryFileManager;
        }
        this.fileManagers.put(StandardLocation.SOURCE_PATH, javaFileManagerArray4);
        if (outputhPath == null) {
            javaFileManagerArray3 = new JavaFileManager[]{};
        } else {
            JavaFileManager[] javaFileManagerArray10 = new JavaFileManager[1];
            javaFileManagerArray3 = javaFileManagerArray10;
            javaFileManagerArray10[0] = outputhPath;
        }
        this.fileManagers.put(StandardLocation.CLASS_OUTPUT, javaFileManagerArray3);
        if (aptSources == null) {
            javaFileManagerArray2 = new JavaFileManager[]{};
        } else {
            JavaFileManager[] javaFileManagerArray11 = new JavaFileManager[1];
            javaFileManagerArray2 = javaFileManagerArray11;
            javaFileManagerArray11[0] = aptSources;
        }
        this.fileManagers.put(StandardLocation.SOURCE_OUTPUT, javaFileManagerArray2);
        if (sourcePath == null) {
            javaFileManagerArray = new JavaFileManager[]{};
        } else {
            JavaFileManager[] javaFileManagerArray12 = new JavaFileManager[1];
            javaFileManagerArray = javaFileManagerArray12;
            javaFileManagerArray12[0] = sourcePath;
        }
        this.fileManagers.put(SOURCE_PATH_WRITE, javaFileManagerArray);
        IdentityHashMap all = new IdentityHashMap();
        for (JavaFileManager[] jfmsForLoc : this.fileManagers.values()) {
            for (JavaFileManager jfm : jfmsForLoc) {
                all.put(jfm, null);
            }
        }
        this.fileManagers.put(ALL, all.keySet().toArray(new JavaFileManager[all.size()]));
        this.processorGeneratedFiles = processorGeneratedFiles;
        this.siblings = siblings;
    }

    @Override
    @NonNull
    public Iterable<JavaFileObject> list(@NonNull JavaFileManager.Location l, @NonNull String packageName, @NonNull Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        JavaFileManager[] fms;
        LinkedList<Iterable<JavaFileObject>> iterables = new LinkedList<Iterable<JavaFileObject>>();
        for (JavaFileManager fm : fms = this.getFileManagers(l)) {
            iterables.add(fm.list(l, packageName, kinds, recurse));
        }
        Iterable<JavaFileObject> result = Iterators.chained(iterables);
        if (LOG.isLoggable(Level.FINER)) {
            StringBuilder urls = new StringBuilder();
            for (JavaFileObject jfo : result) {
                urls.append(jfo.toUri().toString());
                urls.append(", ");
            }
            LOG.log(Level.FINER, "List {0} Package: {1} Kinds: {2} -> {3}", new Object[]{l, packageName, kinds, urls});
        }
        return result;
    }

    @Override
    @CheckForNull
    public FileObject getFileForInput(@NonNull JavaFileManager.Location l, @NonNull String packageName, @NonNull String relativeName) throws IOException {
        JavaFileManager[] fms;
        for (JavaFileManager fm : fms = this.getFileManagers(l)) {
            FileObject result = fm.getFileForInput(l, packageName, relativeName);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    @CheckForNull
    public FileObject getFileForOutput(@NonNull JavaFileManager.Location l, @NonNull String packageName, @NonNull String relativeName, @NullAllowed FileObject sibling) throws IOException, UnsupportedOperationException, IllegalArgumentException {
        JavaFileManager[] fms = this.getFileManagers(l == StandardLocation.SOURCE_PATH ? SOURCE_PATH_WRITE : l);
        assert (fms.length <= 1);
        if (fms.length == 0) {
            return null;
        }
        return this.mark(fms[0].getFileForOutput(l, packageName, relativeName, sibling), l);
    }

    @Override
    @CheckForNull
    public ClassLoader getClassLoader(@NonNull JavaFileManager.Location l) {
        return null;
    }

    @Override
    public void flush() throws IOException {
        for (JavaFileManager fm : this.getFileManagers(ALL)) {
            fm.flush();
        }
    }

    @Override
    public void close() throws IOException {
        for (JavaFileManager fm : this.getFileManagers(ALL)) {
            fm.close();
        }
    }

    @Override
    public int isSupportedOption(@NonNull String string) {
        return -1;
    }

    @Override
    public boolean handleOption(@NonNull String current, @NonNull Iterator<String> remains) {
        if ("apt-origin".equals(current)) {
            if (!remains.hasNext()) {
                throw new IllegalArgumentException("The apt-source-root requires folder.");
            }
            String sib = remains.next();
            if (sib.length() != 0) {
                URL sibling = ProxyFileManager.asURL(sib);
                boolean inSourceRoot = this.processorGeneratedFiles.findSibling(Collections.singleton(sibling)) != null;
                this.siblings.push(sibling, inSourceRoot);
            } else {
                this.siblings.pop();
            }
            return true;
        }
        boolean isSourceElement = "apt-source-element".equals(current);
        if (isSourceElement || "apt-resource-element".equals(current)) {
            if (remains.hasNext()) {
                Collection<? extends URL> urls = ProxyFileManager.asURLs(remains);
                URL sibling = this.processorGeneratedFiles.findSibling(urls);
                boolean inSourceRoot = true;
                if (sibling == null) {
                    sibling = this.siblings.getProvider().getSibling();
                    inSourceRoot = this.siblings.getProvider().isInSourceRoot();
                }
                this.siblings.push(sibling, inSourceRoot);
                if (LOG.isLoggable(Level.INFO) && isSourceElement && urls.size() > 1) {
                    StringBuilder sb = new StringBuilder();
                    for (URL uRL : urls) {
                        if (sb.length() > 0) {
                            sb.append(", ");
                        }
                        sb.append(uRL);
                    }
                    LOG.log(Level.FINE, "Multiple source files passed as ORIGIN_SOURCE_ELEMENT_URL: {0}; using: {1}", new Object[]{sb, this.siblings.getProvider().getSibling()});
                }
            } else {
                this.siblings.pop();
            }
            return true;
        }
        Collection<String> defensiveCopy = ProxyFileManager.copy(remains);
        for (JavaFileManager m : this.getFileManagers(ALL)) {
            if (!m.handleOption(current, defensiveCopy.iterator())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasLocation(@NonNull JavaFileManager.Location location) {
        return this.fileManagers.containsKey(location);
    }

    @Override
    @CheckForNull
    public JavaFileObject getJavaFileForInput(@NonNull JavaFileManager.Location l, @NonNull String className, @NonNull JavaFileObject.Kind kind) throws IOException {
        JavaFileManager[] fms;
        for (JavaFileManager fm : fms = this.getFileManagers(l)) {
            JavaFileObject result = fm.getJavaFileForInput(l, className, kind);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    @CheckForNull
    public JavaFileObject getJavaFileForOutput(@NonNull JavaFileManager.Location l, @NonNull String className, @NonNull JavaFileObject.Kind kind, @NonNull FileObject sibling) throws IOException, UnsupportedOperationException, IllegalArgumentException {
        JavaFileManager[] fms = this.getFileManagers(l);
        assert (fms.length <= 1);
        if (fms.length == 0) {
            return null;
        }
        JavaFileObject result = fms[0].getJavaFileForOutput(l, className, kind, sibling);
        return this.mark(result, l);
    }

    @Override
    @CheckForNull
    public String inferBinaryName(@NonNull JavaFileManager.Location location, @NonNull JavaFileObject javaFileObject) {
        JavaFileManager[] fms;
        InferableJavaFileObject ifo;
        String result;
        assert (javaFileObject != null);
        if (javaFileObject == this.lastInfered) {
            return this.lastInferedResult;
        }
        if (javaFileObject instanceof InferableJavaFileObject && (result = (ifo = (InferableJavaFileObject)javaFileObject).inferBinaryName()) != null) {
            this.lastInfered = javaFileObject;
            this.lastInferedResult = result;
            return result;
        }
        for (JavaFileManager fm : fms = this.getFileManagers(location)) {
            result = fm.inferBinaryName(location, javaFileObject);
            if (result == null || result.length() <= 0) continue;
            this.lastInfered = javaFileObject;
            this.lastInferedResult = result;
            return result;
        }
        return null;
    }

    @Override
    public boolean isSameFile(FileObject fileObject, FileObject fileObject0) {
        JavaFileManager[] fms;
        for (JavaFileManager fm : fms = this.getFileManagers(ALL)) {
            if (!fm.isSameFile(fileObject, fileObject0)) continue;
            return true;
        }
        return fileObject.toUri().equals(fileObject0.toUri());
    }

    @CheckForNull
    private <T extends FileObject> T mark(@NullAllowed T result, @NonNull JavaFileManager.Location l) throws MalformedURLException {
        ProcessorGenerated.Type type = null;
        if (l == StandardLocation.CLASS_OUTPUT) {
            type = ProcessorGenerated.Type.RESOURCE;
        } else if (l == StandardLocation.SOURCE_OUTPUT) {
            type = ProcessorGenerated.Type.SOURCE;
        }
        if (result != null && this.siblings.getProvider().hasSibling() && this.siblings.getProvider().isInSourceRoot()) {
            if (type == ProcessorGenerated.Type.SOURCE) {
                this.processorGeneratedFiles.register(this.siblings.getProvider().getSibling(), result, type);
            } else if (type == ProcessorGenerated.Type.RESOURCE) {
                try {
                    result.openInputStream().close();
                }
                catch (IOException ioe) {
                    this.processorGeneratedFiles.register(this.siblings.getProvider().getSibling(), result, type);
                }
            }
        }
        return (T)(result == null ? null : (this.processorGeneratedFiles.canWrite() || !this.siblings.getProvider().hasSibling() ? (InferableJavaFileObject)result : FileManagerTransaction.nullFileObject((InferableJavaFileObject)result)));
    }

    private JavaFileManager[] getFileManagers(JavaFileManager.Location location) {
        JavaFileManager[] result = this.fileManagers.get(location);
        return result != null ? result : new JavaFileManager[]{};
    }

    private static URL asURL(String url) throws IllegalArgumentException {
        try {
            return new URL(url);
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("Invalid path argument: " + url, ex);
        }
    }

    private static Collection<? extends URL> asURLs(Iterator<? extends String> surls) {
        ArrayDeque<URL> result = new ArrayDeque<URL>();
        while (surls.hasNext()) {
            String surl = surls.next();
            if (!"java".equals(FileObjects.getExtension(surl))) continue;
            result.add(ProxyFileManager.asURL(surl));
        }
        return result;
    }

    private static Collection<String> copy(Iterator<String> from) {
        if (!from.hasNext()) {
            return Collections.emptyList();
        }
        LinkedList<String> result = new LinkedList<String>();
        while (from.hasNext()) {
            result.add(from.next());
        }
        return result;
    }
}

