/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.indexing;

import com.sun.tools.javac.util.Context;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.processing.Processor;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.AnnotationProcessingQuery;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.modules.java.source.indexing.JavaIndex;
import org.netbeans.modules.java.source.parsing.CachingArchiveClassLoader;
import org.netbeans.modules.parsing.api.indexing.IndexingManager;
import org.netbeans.modules.parsing.impl.indexing.PathRegistry;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;

public class APTUtils
implements ChangeListener,
PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(APTUtils.class.getName());
    private static final String PROCESSOR_PATH = "processorPath";
    private static final String APT_ENABLED = "aptEnabled";
    private static final String ANNOTATION_PROCESSORS = "annotationProcessors";
    private static final String SOURCE_LEVEL_ROOT = "sourceLevel";
    private static final Map<URL, APTUtils> knownSourceRootsMap = new HashMap<URL, APTUtils>();
    private static final Map<FileObject, Reference<APTUtils>> auxiliarySourceRootsMap = new WeakHashMap<FileObject, Reference<APTUtils>>();
    private static final Lookup HARDCODED_PROCESSORS = Lookups.forPath((String)"Editors/text/x-java/AnnotationProcessors");
    private static final boolean DISABLE_CLASSLOADER_CACHE = Boolean.getBoolean("java.source.aptutils.disable.classloader.cache");
    private static final int SLIDING_WINDOW = 1000;
    private static final RequestProcessor RP = new RequestProcessor(APTUtils.class);
    private final FileObject root;
    private final ClassPath processorPath;
    private final AnnotationProcessingQuery.Result aptOptions;
    private final SourceLevelQuery.Result sourceLevel;
    private final RequestProcessor.Task slidingRefresh;
    private volatile ClassLoaderRef classLoaderCache;
    private static final Iterable<? extends String> javacPackages = Arrays.asList("com.sun.javadoc.", "com.sun.source.", "javax.annotation.processing.", "javax.lang.model.", "javax.tools.", "com.sun.tools.javac.", "com.sun.tools.javadoc.");

    private APTUtils(final @NonNull FileObject root, @NonNull ClassPath preprocessorPath, @NonNull AnnotationProcessingQuery.Result aptOptions, @NonNull SourceLevelQuery.Result sourceLevel) {
        this.root = root;
        this.processorPath = preprocessorPath;
        this.aptOptions = aptOptions;
        this.sourceLevel = sourceLevel;
        this.slidingRefresh = RP.create(new Runnable(){

            @Override
            public void run() {
                IndexingManager.getDefault().refreshIndex(root.toURL(), Collections.emptyList(), false);
            }
        });
    }

    public static APTUtils get(FileObject root) {
        APTUtils utils;
        URL rootUrl;
        if (root == null) {
            return null;
        }
        try {
            rootUrl = root.getURL();
        }
        catch (FileStateInvalidException ex) {
            LOG.log(Level.FINE, null, ex);
            return null;
        }
        if (knownSourceRootsMap.containsKey(rootUrl)) {
            APTUtils utils2 = knownSourceRootsMap.get(rootUrl);
            if (utils2 == null) {
                utils2 = APTUtils.create(root);
                knownSourceRootsMap.put(rootUrl, utils2);
            }
            return utils2;
        }
        Reference<APTUtils> utilsRef = auxiliarySourceRootsMap.get(root);
        APTUtils aPTUtils = utils = utilsRef != null ? utilsRef.get() : null;
        if (utils == null) {
            utils = APTUtils.create(root);
            auxiliarySourceRootsMap.put(root, new WeakReference<APTUtils>(utils));
        }
        return utils;
    }

    public static void sourceRootRegistered(FileObject root, URL rootURL) {
        if (root == null || knownSourceRootsMap.containsKey(rootURL) || PathRegistry.getDefault().getUnknownRoots().contains(rootURL)) {
            return;
        }
        Reference<APTUtils> utilsRef = auxiliarySourceRootsMap.remove(root);
        APTUtils utils = utilsRef != null ? utilsRef.get() : null;
        knownSourceRootsMap.put(rootURL, utils);
    }

    public static void sourceRootUnregistered(Iterable<? extends URL> roots) {
        for (URL uRL : roots) {
            knownSourceRootsMap.remove(uRL);
        }
        for (URL uRL : PathRegistry.getDefault().getUnknownRoots()) {
            knownSourceRootsMap.remove(uRL);
        }
    }

    private static APTUtils create(FileObject root) {
        ClassPath pp = ClassPath.getClassPath((FileObject)root, (String)"classpath/processor");
        if (pp == null) {
            return null;
        }
        AnnotationProcessingQuery.Result options = AnnotationProcessingQuery.getAnnotationProcessingOptions((FileObject)root);
        SourceLevelQuery.Result sourceLevel = SourceLevelQuery.getSourceLevel2((FileObject)root);
        APTUtils utils = new APTUtils(root, pp, options, sourceLevel);
        pp.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)utils, (Object)pp));
        pp.getRoots();
        options.addChangeListener(WeakListeners.change((ChangeListener)utils, (Object)options));
        if (sourceLevel.supportsChanges()) {
            sourceLevel.addChangeListener(WeakListeners.change((ChangeListener)utils, (Object)sourceLevel));
        }
        return utils;
    }

    public boolean aptEnabledOnScan() {
        return this.aptOptions.annotationProcessingEnabled().contains(AnnotationProcessingQuery.Trigger.ON_SCAN);
    }

    public boolean aptEnabledInEditor() {
        return this.aptOptions.annotationProcessingEnabled().contains(AnnotationProcessingQuery.Trigger.IN_EDITOR);
    }

    public Collection<? extends Processor> resolveProcessors(boolean onScan) {
        ClassLoader cl;
        ClassLoaderRef cache = this.classLoaderCache;
        if (cache == null || (cl = cache.get(this.root)) == null) {
            cl = CachingArchiveClassLoader.forClassPath(this.processorPath, new BypassOpenIDEUtilClassLoader(Context.class.getClassLoader()));
            this.classLoaderCache = !DISABLE_CLASSLOADER_CACHE ? new ClassLoaderRef(cl, this.root) : null;
        }
        Collection<Processor> result = this.lookupProcessors(cl, onScan);
        return result;
    }

    public Map<? extends String, ? extends String> processorOptions() {
        return this.aptOptions.processorOptions();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.verifyAttributes(this.root, true)) {
            this.slidingRefresh.schedule(1000);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("roots".equals(evt.getPropertyName())) {
            this.classLoaderCache = null;
        }
        if (this.verifyAttributes(this.root, true)) {
            this.slidingRefresh.schedule(1000);
        }
    }

    private Collection<Processor> lookupProcessors(ClassLoader cl, boolean onScan) {
        Iterable<? extends String> processorNames = this.aptOptions.annotationProcessorsToRun();
        if (processorNames == null) {
            processorNames = this.getProcessorNames(cl);
        }
        LinkedList<Processor> result = new LinkedList<Processor>();
        for (String string : processorNames) {
            try {
                Class<?> clazz = Class.forName(string, true, cl);
                Object instance = clazz.newInstance();
                if (!(instance instanceof Processor)) continue;
                result.add((Processor)instance);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                LOG.log(Level.FINE, null, t);
            }
        }
        if (!onScan) {
            result.addAll(HARDCODED_PROCESSORS.lookupAll(Processor.class));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterable<? extends String> getProcessorNames(ClassLoader cl) {
        LinkedList<String> result = new LinkedList<String>();
        try {
            Enumeration<URL> resources = cl.getResources("META-INF/services/" + Processor.class.getName());
            while (resources.hasMoreElements()) {
                BufferedReader ins = null;
                try {
                    String line;
                    ins = new BufferedReader(new InputStreamReader(resources.nextElement().openStream(), "UTF-8"));
                    while ((line = ins.readLine()) != null) {
                        int hash = line.indexOf(35);
                        String string = line = hash != -1 ? line.substring(0, hash) : line;
                        if ((line = line.trim()).length() <= 0) continue;
                        result.add(line);
                    }
                }
                catch (IOException ex) {
                    LOG.log(Level.FINE, null, ex);
                }
                finally {
                    if (ins == null) continue;
                    ins.close();
                }
            }
        }
        catch (IOException ex) {
            LOG.log(Level.FINE, null, ex);
        }
        return result;
    }

    boolean verifyAttributes(FileObject fo, boolean checkOnly) {
        if (fo == null) {
            return false;
        }
        boolean vote = false;
        try {
            boolean apEnabledOnScan;
            URL url = fo.getURL();
            if (JavaIndex.ensureAttributeValue(url, SOURCE_LEVEL_ROOT, this.sourceLevel.getSourceLevel(), checkOnly)) {
                JavaIndex.LOG.fine("forcing reindex due to source level change");
                vote = true;
                if (checkOnly) {
                    return vote;
                }
            }
            if (JavaIndex.ensureAttributeValue(url, APT_ENABLED, (apEnabledOnScan = this.aptOptions.annotationProcessingEnabled().contains(AnnotationProcessingQuery.Trigger.ON_SCAN)) ? Boolean.TRUE.toString() : null, checkOnly)) {
                JavaIndex.LOG.fine("forcing reindex due to change in annotation processing options");
                vote = true;
                if (checkOnly) {
                    return vote;
                }
            }
            if (!apEnabledOnScan) {
                return vote;
            }
            if (JavaIndex.ensureAttributeValue(url, PROCESSOR_PATH, APTUtils.pathToString(this.processorPath), checkOnly)) {
                JavaIndex.LOG.fine("forcing reindex due to processor path change");
                vote = true;
                if (checkOnly) {
                    return vote;
                }
            }
            if (JavaIndex.ensureAttributeValue(url, ANNOTATION_PROCESSORS, this.encodeToStirng(this.aptOptions.annotationProcessorsToRun()), checkOnly)) {
                JavaIndex.LOG.fine("forcing reindex due to change in annotation processors");
                vote = true;
                if (checkOnly) {
                    return vote;
                }
            }
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
        return vote;
    }

    @NonNull
    private static String pathToString(@NonNull ClassPath cp) {
        StringBuilder b = new StringBuilder();
        for (FileObject fo : cp.getRoots()) {
            URL u = fo.toURL();
            File f = FileUtil.archiveOrDirForURL((URL)u);
            if (f != null) {
                if (b.length() > 0) {
                    b.append(File.pathSeparatorChar);
                }
                b.append(f.getAbsolutePath());
                continue;
            }
            if (b.length() > 0) {
                b.append(File.pathSeparatorChar);
            }
            b.append(u);
        }
        return b.toString();
    }

    private String encodeToStirng(Iterable<? extends String> strings) {
        if (strings == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Iterator<? extends String> it = strings.iterator();
        while (it.hasNext()) {
            sb.append((Object)it.next());
            if (!it.hasNext()) continue;
            sb.append(',');
        }
        return sb.length() > 0 ? sb.toString() : null;
    }

    private static final class ClassLoaderRef
    extends SoftReference<ClassLoader>
    implements Runnable {
        private final long timeStamp;
        private final String rootPath;

        public ClassLoaderRef(ClassLoader cl, FileObject root) {
            super(cl, Utilities.activeReferenceQueue());
            this.timeStamp = ClassLoaderRef.getTimeStamp(root);
            this.rootPath = FileUtil.getFileDisplayName((FileObject)root);
            LOG.log(Level.FINER, "ClassLoader for root {0} created.", new Object[]{this.rootPath});
        }

        public ClassLoader get(FileObject root) {
            long curTimeStamp = ClassLoaderRef.getTimeStamp(root);
            return curTimeStamp == this.timeStamp ? (ClassLoader)this.get() : null;
        }

        @Override
        public void run() {
            LOG.log(Level.FINER, "ClassLoader for root {0} freed.", new Object[]{this.rootPath});
        }

        private static long getTimeStamp(FileObject root) {
            FileObject archiveFile = FileUtil.getArchiveFile((FileObject)root);
            return archiveFile != null ? root.lastModified().getTime() : -1L;
        }
    }

    private static final class BypassOpenIDEUtilClassLoader
    extends ClassLoader {
        private final ClassLoader contextCL;

        public BypassOpenIDEUtilClassLoader(ClassLoader contextCL) {
            super(BypassOpenIDEUtilClassLoader.getSystemClassLoader().getParent());
            this.contextCL = contextCL;
        }

        @Override
        protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            char f;
            char c = f = name.length() > 4 ? name.charAt(4) : (char)'\u0000';
            if (f == 'x' || f == 's') {
                for (String pack : javacPackages) {
                    if (!name.startsWith(pack)) continue;
                    return this.contextCL.loadClass(name);
                }
            }
            return super.loadClass(name, resolve);
        }
    }
}

