/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.plugins.mpowerplayer;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.netbeans.spi.mobility.cldcplatform.CLDCPlatformDescriptor;
import org.netbeans.spi.mobility.cldcplatform.CustomCLDCPlatformConfigurator;
import org.openide.util.NbBundle;

public final class MPowerPlayerPlatformConfigurator
implements CustomCLDCPlatformConfigurator {
    private static final String DISPLY_NAME = "Emulator_displayname";
    private static final String DESCRIPTION = "Emulator_description";
    private static final String CONFIGURATIONS = "configurations";
    private static final String OPTIONAL = "optional";
    private static final String PROFILES = "profiles";
    private static final String PREVERIFY_COMMAND = "preverify.command";
    private static final String RUN_COMMAND = "run.command";
    private static final String DEBUG_COMMAND = "debug.command";
    private static final String TYPE = "CUSTOM";
    private static final String CHECK_FOLDER = "check.folder";
    private static final String DEVICES = "devices";
    private static final String JAVADOCS_FOLDER = "javadoc.folder";
    private static final String MAJOR_CHECK_FOLDER = "majorCheck.folder";
    private static final String OS_SUPPORTED = "os.supported";
    private Properties apiSettings;
    private List<CLDCPlatformDescriptor.Device> devices;

    private List<CLDCPlatformDescriptor.Profile> createAPISettings() {
        String allProperties = this.apiSettings.getProperty(CONFIGURATIONS) + "," + this.apiSettings.getProperty(PROFILES) + "," + this.apiSettings.getProperty(OPTIONAL);
        StringTokenizer propertiesTokenizer = new StringTokenizer(allProperties, ",");
        ArrayList<CLDCPlatformDescriptor.Profile> descriptors = new ArrayList<CLDCPlatformDescriptor.Profile>(propertiesTokenizer.countTokens());
        while (propertiesTokenizer.hasMoreTokens()) {
            CLDCPlatformDescriptor.ProfileType profileType;
            String token = propertiesTokenizer.nextToken().trim();
            if (this.apiSettings.getProperty(CONFIGURATIONS).contains(token)) {
                profileType = CLDCPlatformDescriptor.ProfileType.Configuration;
            } else if (this.apiSettings.getProperty(PROFILES).contains(token)) {
                profileType = CLDCPlatformDescriptor.ProfileType.Profile;
            } else if (this.apiSettings.getProperty(OPTIONAL).contains(token)) {
                profileType = CLDCPlatformDescriptor.ProfileType.Optional;
            } else {
                throw new IllegalStateException("Type of profile is necessary to create Platform Descriptor");
            }
            descriptors.add(new CLDCPlatformDescriptor.Profile(this.apiSettings.getProperty(token + ".displayname"), this.apiSettings.getProperty(token + ".version"), this.apiSettings.getProperty(token + ".description"), profileType, this.apiSettings.getProperty(token + ".dependencies"), this.apiSettings.getProperty(token + ".bcp"), this.apiSettings.getProperty("default").contains(token)));
        }
        return Collections.unmodifiableList(descriptors);
    }

    public static void main(String[] args) {
        MPowerPlayerPlatformConfigurator mppc = new MPowerPlayerPlatformConfigurator();
        if (args.length == 1) {
            if (mppc.isPossiblePlatform(new File(args[0]))) {
                System.out.println("Found valid MPowerPlayer SDK at " + args[0]);
            } else {
                System.out.println("Did not find valid MPowerPlayer SDK at " + args[0]);
            }
        } else {
            System.out.println("Usage: MPowerPlayerConfigurator <mpp-sdk root>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPossiblePlatform(File file) {
        String osName;
        if (this.apiSettings == null) {
            this.apiSettings = new Properties();
            try {
                InputStream resource = MPowerPlayerPlatformConfigurator.class.getResourceAsStream("Configuration.properties");
                try {
                    this.apiSettings.load(resource);
                }
                finally {
                    resource.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        String folderCheck = this.apiSettings.getProperty(CHECK_FOLDER);
        String osSupported = this.apiSettings.getProperty(OS_SUPPORTED);
        if (!osSupported.equalsIgnoreCase(osName = (String)System.getProperties().get("os.name"))) {
            return false;
        }
        if (folderCheck == null) {
            throw new IllegalArgumentException("Null folder platform check");
        }
        if (file != null && file.isDirectory()) {
            File preverifier;
            File[] files = file.listFiles(new JarFilenameFilter());
            File[] platformFiles = file.listFiles(new PlatformFileFilter());
            if (files != null && platformFiles != null && files.length == 4 && platformFiles.length == 1 && (preverifier = new File(file.getPath() + folderCheck)).exists()) {
                return true;
            }
        }
        return false;
    }

    public CLDCPlatformDescriptor getPlatform(File file) {
        if (!this.isPossiblePlatform(file)) {
            return null;
        }
        String home = file.getAbsolutePath();
        String javadocFolder = this.apiSettings.getProperty(JAVADOCS_FOLDER);
        String srcPath = "";
        String runCommand = this.apiSettings.getProperty(RUN_COMMAND);
        String debugCommand = this.apiSettings.getProperty(DEBUG_COMMAND);
        String preverifyCommand = this.apiSettings.getProperty(PREVERIFY_COMMAND);
        String displayName = NbBundle.getMessage(MPowerPlayerPlatformConfigurator.class, (String)DISPLY_NAME);
        if (javadocFolder == null) {
            throw new IllegalArgumentException("null javadocs folder");
        }
        String docPath = home + javadocFolder;
        String allProperties = this.apiSettings.getProperty(DEVICES);
        StringTokenizer propertiesTokenizer = new StringTokenizer(allProperties, ",");
        this.devices = new ArrayList<CLDCPlatformDescriptor.Device>();
        while (propertiesTokenizer.hasMoreTokens()) {
            String token = propertiesTokenizer.nextToken().trim();
            this.devices.add(new CLDCPlatformDescriptor.Device(this.apiSettings.getProperty(token + ".name"), NbBundle.getMessage(MPowerPlayerPlatformConfigurator.class, (String)DESCRIPTION), Collections.EMPTY_LIST, this.createAPISettings(), new CLDCPlatformDescriptor.Screen(Integer.valueOf(this.apiSettings.getProperty(token + ".screen.width").trim()).intValue(), Integer.valueOf(this.apiSettings.getProperty(token + ".screen.height").trim()).intValue(), Integer.valueOf(this.apiSettings.getProperty(token + ".screen.bitDepth").trim()).intValue(), (Integer.valueOf(this.apiSettings.getProperty(token + ".screen.color").trim()) == 1 ? Boolean.TRUE : Boolean.FALSE).booleanValue(), (Integer.valueOf(this.apiSettings.getProperty(token + ".screen.touch").trim()) == 1 ? Boolean.TRUE : Boolean.FALSE).booleanValue())));
        }
        return new CLDCPlatformDescriptor(displayName, home, TYPE, srcPath, docPath, preverifyCommand, runCommand, debugCommand, this.devices);
    }

    public String getRegistryProviderName() {
        return null;
    }

    private class PlatformFileFilter
    implements FileFilter {
        private PlatformFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            String majorCheckFolder = MPowerPlayerPlatformConfigurator.this.apiSettings.getProperty(MPowerPlayerPlatformConfigurator.MAJOR_CHECK_FOLDER);
            return file.getName().equalsIgnoreCase(majorCheckFolder) && file.isDirectory();
        }
    }

    private class JarFilenameFilter
    implements FilenameFilter {
        private JarFilenameFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.toLowerCase().endsWith(".jar");
        }
    }
}

