/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.composer.options;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.composer.commands.Composer;
import org.netbeans.modules.php.composer.options.Bundle;

public final class ComposerOptionsValidator {
    private static final Pattern VENDOR_REGEX = Pattern.compile("^[a-z0-9-]+$");
    private static final Pattern EMAIL_REGEX = Pattern.compile("^\\w+[\\.\\w\\-]*@\\w+[\\.\\w\\-]*\\.[a-z]{2,}$", 2);
    private final List<Message> errors = new LinkedList<Message>();
    private final List<Message> warnings = new LinkedList<Message>();

    public void validate(String composerPath, String vendor, String authorName, String authorEmail) {
        this.validateComposerPath(composerPath);
        this.validateVendor(vendor);
        this.validateAuthorName(authorName);
        this.validateAuthorEmail(authorEmail);
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public List<Message> getErrors() {
        return new ArrayList<Message>(this.errors);
    }

    public boolean hasWarnings() {
        return !this.warnings.isEmpty();
    }

    public List<Message> getWarnings() {
        return new ArrayList<Message>(this.warnings);
    }

    private void validateComposerPath(String composerPath) {
        String warning = Composer.validate(composerPath);
        if (warning != null) {
            this.warnings.add(new Message("composerPath", warning));
        }
    }

    void validateVendor(String vendor) {
        if (!VENDOR_REGEX.matcher(vendor).matches()) {
            this.errors.add(new Message("vendor", Bundle.ComposerOptionsValidator_error_invalidVendor()));
        }
    }

    private void validateAuthorName(String authorName) {
        if (!StringUtils.hasText((String)authorName)) {
            this.errors.add(new Message("authorName", Bundle.ComposerOptionsValidator_error_noAuthorName()));
        }
    }

    void validateAuthorEmail(String authorEmail) {
        if (!StringUtils.hasText((String)authorEmail) || !EMAIL_REGEX.matcher(authorEmail).matches()) {
            this.errors.add(new Message("authorEmail", Bundle.ComposerOptionsValidator_error_invalidAuthorEmail()));
        }
    }

    public static final class Message {
        private final String source;
        private final String message;

        public Message(String source, String message) {
            this.source = source;
            this.message = message;
        }

        public String getSource() {
            return this.source;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

