/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.composer.options;

import java.util.List;
import java.util.prefs.Preferences;
import org.netbeans.modules.php.api.util.FileUtils;
import org.openide.util.NbPreferences;

public class ComposerOptions {
    private static final String PREFERENCES_PATH = "composer";
    private static final ComposerOptions INSTANCE = new ComposerOptions();
    private static final String COMPOSER_PATH = "composer.path";
    private static final String VENDOR = "vendor";
    private static final String AUTHOR_NAME = "author.name";
    private static final String AUTHOR_EMAIL = "author.email";
    private volatile boolean composerSearched = false;

    public static ComposerOptions getInstance() {
        return INSTANCE;
    }

    public String getComposerPath() {
        String composerPath = this.getPreferences().get(COMPOSER_PATH, null);
        if (composerPath == null && !this.composerSearched) {
            this.composerSearched = true;
            List paths = FileUtils.findFileOnUsersPath((String[])new String[]{PREFERENCES_PATH, "composer.phar"});
            if (!paths.isEmpty()) {
                composerPath = (String)paths.get(0);
                this.setComposerPath(composerPath);
            }
        }
        return composerPath;
    }

    public void setComposerPath(String composerPath) {
        this.getPreferences().put(COMPOSER_PATH, composerPath);
    }

    public String getVendor() {
        return this.getPreferences().get(VENDOR, VENDOR);
    }

    public void setVendor(String vendor) {
        this.getPreferences().put(VENDOR, vendor);
    }

    public String getAuthorName() {
        return this.getPreferences().get(AUTHOR_NAME, System.getProperty("user.name"));
    }

    public void setAuthorName(String authorName) {
        this.getPreferences().put(AUTHOR_NAME, authorName);
    }

    public String getAuthorEmail() {
        return this.getPreferences().get(AUTHOR_EMAIL, "your@email.here");
    }

    public void setAuthorEmail(String authorEmail) {
        this.getPreferences().put(AUTHOR_EMAIL, authorEmail);
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(ComposerOptions.class).node(PREFERENCES_PATH);
    }
}

