/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.composer.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.modules.php.api.executable.InvalidPhpExecutableException;
import org.netbeans.modules.php.api.executable.PhpExecutable;
import org.netbeans.modules.php.api.executable.PhpExecutableValidator;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.composer.commands.Bundle;
import org.netbeans.modules.php.composer.options.ComposerOptions;
import org.netbeans.modules.php.composer.ui.options.ComposerOptionsPanelController;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class Composer {
    public static final String NAME = "composer";
    public static final String LONG_NAME = "composer.phar";
    private static final String LOCK_FILENAME = "composer.json";
    private static final String INIT_COMMAND = "init";
    private static final String INSTALL_COMMAND = "install";
    private static final String UPDATE_COMMAND = "update";
    private static final String VALIDATE_COMMAND = "validate";
    private static final String SELF_UPDATE_COMMAND = "self-update";
    private static final List<String> DEFAULT_PARAMS = Arrays.asList("--ansi", "--no-interaction");
    private static final String NAME_PARAM = "--name=%s";
    private static final String AUTHOR_PARAM = "--author=%s <%s>";
    private static final String DESCRIPTION_PARAM = "--description=%s";
    private static final String DEV_PARAM = "--dev";
    private final String composerPath;

    public Composer(String composerPath) {
        this.composerPath = composerPath;
    }

    public static Composer getDefault() throws InvalidPhpExecutableException {
        String composerPath = ComposerOptions.getInstance().getComposerPath();
        String error = Composer.validate(composerPath);
        if (error != null) {
            throw new InvalidPhpExecutableException(error);
        }
        return new Composer(composerPath);
    }

    public static String validate(String composerPath) {
        return PhpExecutableValidator.validateCommand((String)composerPath, (String)Bundle.Composer_script_label());
    }

    public Future<Integer> init(PhpModule phpModule) {
        FileObject lockFile = this.getLockFile(phpModule);
        if (lockFile != null && lockFile.isValid() && !this.userConfirmation(phpModule.getDisplayName(), Bundle.Composer_lockFile_exists())) {
            return null;
        }
        ComposerOptions options = ComposerOptions.getInstance();
        List<String> params = Arrays.asList(String.format(NAME_PARAM, this.getInitName(options.getVendor(), phpModule.getName())), String.format(AUTHOR_PARAM, options.getAuthorName(), options.getAuthorEmail()), String.format(DESCRIPTION_PARAM, Bundle.Composer_init_description(phpModule.getDisplayName())));
        return this.runCommand(phpModule, INIT_COMMAND, Bundle.Composer_run_init(), params);
    }

    private String getInitName(String vendor, String projectName) {
        StringBuilder name = new StringBuilder(50);
        name.append(vendor);
        name.append('/');
        name.append(StringUtils.webalize((String)projectName));
        return name.toString();
    }

    public Future<Integer> install(PhpModule phpModule) {
        return this.runCommand(phpModule, INSTALL_COMMAND, Bundle.Composer_run_install());
    }

    public Future<Integer> installDev(PhpModule phpModule) {
        return this.runCommand(phpModule, INSTALL_COMMAND, Bundle.Composer_run_installDev(), Collections.singletonList(DEV_PARAM));
    }

    public Future<Integer> update(PhpModule phpModule) {
        return this.runCommand(phpModule, UPDATE_COMMAND, Bundle.Composer_run_update());
    }

    public Future<Integer> updateDev(PhpModule phpModule) {
        return this.runCommand(phpModule, UPDATE_COMMAND, Bundle.Composer_run_updateDev(), Collections.singletonList(DEV_PARAM));
    }

    public Future<Integer> validate(PhpModule phpModule) {
        return this.runCommand(phpModule, VALIDATE_COMMAND, Bundle.Composer_run_validate());
    }

    public Future<Integer> selfUpdate() {
        return this.runCommand(null, SELF_UPDATE_COMMAND, Bundle.Composer_run_selfUpdate());
    }

    private Future<Integer> runCommand(PhpModule phpModule, String command, String title) {
        return this.runCommand(phpModule, command, title, Collections.<String>emptyList());
    }

    private Future<Integer> runCommand(PhpModule phpModule, String command, String title, List<String> commandParams) {
        FileObject sourceDirectory = null;
        if (phpModule != null && (sourceDirectory = phpModule.getSourceDirectory()) == null) {
            Composer.warnNoSources(phpModule.getDisplayName());
            return null;
        }
        PhpExecutable composer = new PhpExecutable(this.composerPath).optionsSubcategory("Composer").displayName(title).additionalParameters(this.getAllParameters(command, commandParams));
        if (sourceDirectory != null) {
            composer.workDir(FileUtil.toFile((FileObject)sourceDirectory));
        }
        return composer.run(this.getDescriptor());
    }

    private List<String> getAllParameters(String command, List<String> commandParams) {
        ArrayList<String> allParams = new ArrayList<String>(DEFAULT_PARAMS.size() + commandParams.size() + 1);
        allParams.addAll(DEFAULT_PARAMS);
        allParams.add(command);
        allParams.addAll(commandParams);
        return allParams;
    }

    private ExecutionDescriptor getDescriptor() {
        return PhpExecutable.DEFAULT_EXECUTION_DESCRIPTOR.optionsPath(ComposerOptionsPanelController.getOptionsPath()).inputVisible(false);
    }

    private static void warnNoSources(String projectName) {
        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.Composer_project_noSources(projectName), 2));
    }

    private FileObject getLockFile(PhpModule phpModule) {
        FileObject sourceDirectory = phpModule.getSourceDirectory();
        if (sourceDirectory == null) {
            return null;
        }
        return sourceDirectory.getFileObject(LOCK_FILENAME);
    }

    private boolean userConfirmation(String title, String question) {
        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)question, title, 0);
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation) == DialogDescriptor.YES_OPTION;
    }
}

