/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.packets;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.php.dbgp.packets.BreakResponse;
import org.netbeans.modules.php.dbgp.packets.BrkpntRemoveResponse;
import org.netbeans.modules.php.dbgp.packets.BrkpntSetResponse;
import org.netbeans.modules.php.dbgp.packets.BrkpntUpdateResponse;
import org.netbeans.modules.php.dbgp.packets.ContextGetResponse;
import org.netbeans.modules.php.dbgp.packets.ContextNamesResponse;
import org.netbeans.modules.php.dbgp.packets.DbgpMessage;
import org.netbeans.modules.php.dbgp.packets.DbgpStream;
import org.netbeans.modules.php.dbgp.packets.EvalResponse;
import org.netbeans.modules.php.dbgp.packets.ExecResponse;
import org.netbeans.modules.php.dbgp.packets.ExprResponse;
import org.netbeans.modules.php.dbgp.packets.FeatureGetResponse;
import org.netbeans.modules.php.dbgp.packets.FeatureSetResponse;
import org.netbeans.modules.php.dbgp.packets.PropertyGetResponse;
import org.netbeans.modules.php.dbgp.packets.PropertySetResponse;
import org.netbeans.modules.php.dbgp.packets.PropertyValueResponse;
import org.netbeans.modules.php.dbgp.packets.RequestedUrlEvalCommand;
import org.netbeans.modules.php.dbgp.packets.RequestedUrlEvalResponse;
import org.netbeans.modules.php.dbgp.packets.SourceResponse;
import org.netbeans.modules.php.dbgp.packets.StackDepthResponse;
import org.netbeans.modules.php.dbgp.packets.StackGetResponse;
import org.netbeans.modules.php.dbgp.packets.StatusResponse;
import org.netbeans.modules.php.dbgp.packets.StreamResponse;
import org.netbeans.modules.php.dbgp.packets.TypeMapGetResponse;
import org.w3c.dom.Node;

class MessageBuilder {
    private static final Logger LOGGER = Logger.getLogger(MessageBuilder.class.getName());
    private static final String TYPE = "type";

    private MessageBuilder() {
    }

    static DbgpMessage createStream(Node node) {
        Node attr = node.getAttributes().getNamedItem(TYPE);
        assert (attr != null);
        String type = attr.getNodeValue();
        if (DbgpStream.StreamType.STDOUT.toString().equals(type)) {
            return new DbgpStream(node, DbgpStream.StreamType.STDOUT);
        }
        if (DbgpStream.StreamType.STDERR.toString().equals(type)) {
            return new DbgpStream(node, DbgpStream.StreamType.STDERR);
        }
        assert (false);
        return null;
    }

    static DbgpMessage createResponse(Node node) {
        String command = DbgpMessage.getAttribute(node, "command");
        if ("run".equals(command) || "status".equals(command) || "step_out".equals(command) || "step_over".equals(command) || "step_into".equals(command) || "stop".equals(command)) {
            return new StatusResponse(node);
        }
        if ("breakpoint_set".equals(command)) {
            return new BrkpntSetResponse(node);
        }
        if ("breakpoint_update".equals(command)) {
            return new BrkpntUpdateResponse(node);
        }
        if ("breakpoint_remove".equals(command)) {
            return new BrkpntRemoveResponse(node);
        }
        if ("context_names".equals(command)) {
            return new ContextNamesResponse(node);
        }
        if ("context_get".equals(command)) {
            return new ContextGetResponse(node);
        }
        if ("stack_depth".equals(command)) {
            return new StackDepthResponse(node);
        }
        if ("stack_get".equals(command)) {
            return new StackGetResponse(node);
        }
        if ("typemap_get".equals(command)) {
            return new TypeMapGetResponse(node);
        }
        if ("property_set".equals(command)) {
            return new PropertySetResponse(node);
        }
        if ("property_get".equals(command)) {
            return new PropertyGetResponse(node);
        }
        if ("property_value".equals(command)) {
            return new PropertyValueResponse(node);
        }
        if ("source".equals(command)) {
            return new SourceResponse(node);
        }
        if (DbgpStream.StreamType.STDERR.toString().equals(command) || DbgpStream.StreamType.STDOUT.toString().equals(command)) {
            return new StreamResponse(node);
        }
        if ("feature_get".equals(command)) {
            return new FeatureGetResponse(node);
        }
        if ("feature_set".equals(command)) {
            return new FeatureSetResponse(node);
        }
        if ("break".equals(command)) {
            return new BreakResponse(node);
        }
        if ("eval".equals(command)) {
            String transactionId = DbgpMessage.getAttribute(node, "transaction_id");
            if (transactionId.equals(RequestedUrlEvalCommand.getLastUsedTransactionId())) {
                return new RequestedUrlEvalResponse(node);
            }
            return new EvalResponse(node);
        }
        if ("expr".equals(command)) {
            return new ExprResponse(node);
        }
        if ("exec".equals(command)) {
            return new ExecResponse(node);
        }
        LOGGER.log(Level.INFO, "Command not matched: {0} NODE: {1}", new Object[]{command, node});
        return new DbgpMessage.NoneDbgpMessage(node);
    }
}

