/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.packets;

import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.php.dbgp.DebugSession;
import org.netbeans.modules.php.dbgp.DebuggerOptions;
import org.netbeans.modules.php.dbgp.SessionId;
import org.netbeans.modules.php.dbgp.breakpoints.AbstractBreakpoint;
import org.netbeans.modules.php.dbgp.breakpoints.Utils;
import org.netbeans.modules.php.dbgp.packets.BrkpntSetCommand;
import org.netbeans.modules.php.dbgp.packets.DbgpCommand;
import org.netbeans.modules.php.dbgp.packets.DbgpMessage;
import org.netbeans.modules.php.dbgp.packets.DbgpResponse;
import org.netbeans.modules.php.dbgp.packets.DbgpStream;
import org.netbeans.modules.php.dbgp.packets.FeatureGetCommand;
import org.netbeans.modules.php.dbgp.packets.FeatureGetResponse;
import org.netbeans.modules.php.dbgp.packets.FeatureSetCommand;
import org.netbeans.modules.php.dbgp.packets.FeatureSetResponse;
import org.netbeans.modules.php.dbgp.packets.RequestedUrlEvalCommand;
import org.netbeans.modules.php.dbgp.packets.RunCommand;
import org.netbeans.modules.php.dbgp.packets.StepIntoCommand;
import org.netbeans.modules.php.dbgp.packets.StreamCommand;
import org.w3c.dom.Node;

public class InitMessage
extends DbgpMessage {
    private static final String IDEKEY = "idekey";
    private static final String FILE = "fileuri";

    InitMessage(Node node) {
        super(node);
    }

    public String getSessionId() {
        return InitMessage.getAttribute(this.getNode(), IDEKEY);
    }

    public String getFileUri() {
        return InitMessage.getAttribute(this.getNode(), FILE);
    }

    @Override
    public void process(DebugSession session, DbgpCommand command) {
        this.setId(session);
        this.setShowHidden(session);
        this.setMaxDepth(session);
        this.setMaxChildren(session);
        this.setMaxDataSize(session);
        this.setBreakpoints(session);
        this.negotiateOutputStream(session);
        this.negotiateRequestedUrls(session);
        String transactionId = session.getTransactionId();
        DbgpCommand startCommand = DebuggerOptions.getGlobalInstance().isDebuggerStoppedAtTheFirstLine() ? new StepIntoCommand(transactionId) : new RunCommand(transactionId);
        session.sendCommandLater(startCommand);
    }

    private void setMaxDataSize(DebugSession session) {
        FeatureGetCommand command = new FeatureGetCommand(session.getTransactionId());
        command.setFeature(FeatureGetCommand.Feature.MAX_DATA);
        DbgpResponse response = session.sendSynchronCommand(command);
        assert (response instanceof FeatureGetResponse);
        FeatureGetResponse featureGetResponse = (FeatureGetResponse)response;
        Integer maxSize = 0;
        try {
            maxSize = Integer.parseInt(featureGetResponse.getDetails());
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        int current = DbgpMessage.getMaxDataSize();
        if (current > maxSize) {
            FeatureSetCommand setCommand = new FeatureSetCommand(session.getTransactionId());
            setCommand.setFeature(FeatureGetCommand.Feature.MAX_DATA);
            setCommand.setValue(current + "");
            response = session.sendSynchronCommand(setCommand);
            assert (response instanceof FeatureSetResponse);
            FeatureSetResponse setResponse = (FeatureSetResponse)response;
            if (!setResponse.isSuccess()) {
                DbgpMessage.setMaxDataSize(maxSize);
            }
        } else {
            DbgpMessage.setMaxDataSize(maxSize);
        }
    }

    private void setShowHidden(DebugSession session) {
        this.setFeature(session, FeatureGetCommand.Feature.SHOW_HIDDEN, "1");
    }

    private void setMaxDepth(DebugSession session) {
        this.setFeature(session, FeatureGetCommand.Feature.MAX_DEPTH, String.valueOf(DebuggerOptions.getGlobalInstance().getMaxStructuresDepth()));
    }

    private void setMaxChildren(DebugSession session) {
        this.setFeature(session, FeatureGetCommand.Feature.MAX_CHILDREN, String.valueOf(DebuggerOptions.getGlobalInstance().getMaxChildren()));
    }

    private void setFeature(DebugSession session, FeatureGetCommand.Feature feature, String value) {
        FeatureSetCommand setCommand = new FeatureSetCommand(session.getTransactionId());
        setCommand.setFeature(feature);
        setCommand.setValue(value);
        DbgpResponse response = session.sendSynchronCommand(setCommand);
        assert (response instanceof FeatureSetResponse) : response;
    }

    private void negotiateOutputStream(DebugSession session) {
        if (DebuggerOptions.getGlobalInstance().showDebuggerConsole()) {
            StreamCommand streamCommand = new StreamCommand(DbgpStream.StreamType.STDOUT, session.getTransactionId());
            streamCommand.setOperation(StreamCommand.Operation.COPY);
            session.sendCommandLater(streamCommand);
        }
    }

    private void negotiateRequestedUrls(DebugSession session) {
        if (DebuggerOptions.getGlobalInstance().showRequestedUrls()) {
            session.sendCommandLater(new RequestedUrlEvalCommand(session.getTransactionId()));
        }
    }

    private void setBreakpoints(DebugSession session) {
        Breakpoint[] breakpoints;
        SessionId id = session.getSessionId();
        for (Breakpoint breakpoint : breakpoints = DebuggerManager.getDebuggerManager().getBreakpoints()) {
            AbstractBreakpoint brkpnt;
            BrkpntSetCommand command;
            if (!(breakpoint instanceof AbstractBreakpoint) || (command = Utils.getCommand(session, id, brkpnt = (AbstractBreakpoint)breakpoint)) == null) continue;
            session.sendCommandLater(command);
        }
    }

    private void setId(DebugSession session) {
        session.initConnection(this);
    }
}

