/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.models;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.ReferenceQueue;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JToolTip;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.Watch;
import org.netbeans.modules.php.dbgp.ModelNode;
import org.netbeans.modules.php.dbgp.UnsufficientValueException;
import org.netbeans.modules.php.dbgp.models.ClearingThread;
import org.netbeans.modules.php.dbgp.models.ViewModelSupport;
import org.netbeans.modules.php.dbgp.models.WeakProxyListener;
import org.netbeans.modules.php.dbgp.packets.Property;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;

public class WatchesModel
extends ViewModelSupport
implements TreeModel,
NodeModel,
TableModel {
    private Listener myListener;
    private ContextProvider myLookupProvider;
    private Map<Watch, ScriptWatchEvaluating> myWatches = new WeakHashMap<Watch, ScriptWatchEvaluating>();
    private AtomicReference<ScriptWatchEvaluating[]> myWatcheNodes;
    private static final ClearingThread<Listener> CLERAING_THREAD = new ClearingThread();

    public WatchesModel(ContextProvider lookupProvider) {
        this.myLookupProvider = lookupProvider;
        this.myWatcheNodes = new AtomicReference();
    }

    @Override
    public void clearModel() {
        this.fireTreeChanged();
    }

    public void updateExpressionValue(String expr, Property value) {
        ScriptWatchEvaluating[] nodes = this.myWatcheNodes.get();
        if (nodes == null) {
            return;
        }
        for (ScriptWatchEvaluating node : nodes) {
            String expression = node.getExpression();
            if (!expr.equals(expression)) continue;
            node.setEvaluated(value);
            this.fireTableValueChangedComputed(node, null);
        }
    }

    public Object getRoot() {
        return "Root";
    }

    public Object[] getChildren(Object parent, int from, int to) throws UnknownTypeException {
        if (parent == "Root") {
            Watch[] allWatches = DebuggerManager.getDebuggerManager().getWatches();
            to = Math.min(allWatches.length, to);
            from = Math.min(allWatches.length, from);
            Watch[] watches = new Watch[to - from];
            System.arraycopy(allWatches, from, watches, 0, to - from);
            Object[] evaluatedWatches = this.getEvaluatingWatches(watches);
            if (this.myListener == null) {
                this.myListener = new Listener();
            }
            this.myWatcheNodes.set((ScriptWatchEvaluating[])evaluatedWatches);
            return evaluatedWatches;
        }
        if (parent instanceof ModelNode) {
            return ((ModelNode)parent).getChildren(from, to);
        }
        throw new UnknownTypeException((Object)(parent + " " + parent.getClass().getName()));
    }

    public int getChildrenCount(Object node) throws UnknownTypeException {
        if (node == "Root") {
            if (this.myListener == null) {
                this.myListener = new Listener();
            }
            return Integer.MAX_VALUE;
        }
        if (node instanceof ModelNode) {
            return ((ModelNode)node).getChildrenSize();
        }
        throw new UnknownTypeException((Object)(node + " " + node.getClass().getName()));
    }

    public boolean isLeaf(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return false;
        }
        if (node instanceof ModelNode) {
            return ((ModelNode)node).getChildrenSize() == 0;
        }
        throw new UnknownTypeException((Object)(node + " " + node.getClass().getName()));
    }

    public Object getValueAt(Object node, String columnID) throws UnknownTypeException {
        if (node instanceof JToolTip) {
            return this.getTooltip((JToolTip)node, columnID);
        }
        if ("WatchType".equals(columnID)) {
            if (node instanceof ModelNode) {
                return ((ModelNode)node).getType();
            }
        } else if ("WatchValue".equals(columnID) && node instanceof ModelNode) {
            String value;
            try {
                value = ((ModelNode)node).getValue();
            }
            catch (UnsufficientValueException e) {
                return "null";
            }
            return value == null ? "null" : value;
        }
        throw new UnknownTypeException(node);
    }

    public boolean isReadOnly(Object node, String string) throws UnknownTypeException {
        return true;
    }

    public void setValueAt(Object node, String string, Object value) throws UnknownTypeException {
        throw new UnknownTypeException(node);
    }

    public String getDisplayName(Object node) throws UnknownTypeException {
        if (node == null) {
            return "null";
        }
        if (node == "Root") {
            return "Root";
        }
        if (node instanceof ModelNode) {
            return ((ModelNode)node).getName();
        }
        throw new UnknownTypeException(node);
    }

    public String getIconBase(Object node) throws UnknownTypeException {
        if (node == null || node == "Root") {
            return "org/netbeans/modules/debugger/resources/localsView/LocalVariable";
        }
        if (node instanceof ModelNode) {
            return ((ModelNode)node).getIconBase();
        }
        throw new UnknownTypeException(node);
    }

    public String getShortDescription(Object node) throws UnknownTypeException {
        if (node == null || node == "Root") {
            return null;
        }
        if (node instanceof ModelNode) {
            return ((ModelNode)node).getShortDescription();
        }
        throw new UnknownTypeException(node);
    }

    private String getTooltip(JToolTip tooltip, String columnId) throws UnknownTypeException {
        Object row = tooltip.getClientProperty("getShortDescription");
        if ("WatchType".equals(columnId) && row instanceof ModelNode) {
            return ((ModelNode)row).getType();
        }
        throw new UnknownTypeException((Object)tooltip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTreeChanged() {
        Map<Watch, ScriptWatchEvaluating> map = this.getWatchesMap();
        synchronized (map) {
            for (ScriptWatchEvaluating watch : this.getWatchesMap().values()) {
                watch.requestValue();
            }
        }
        this.fireChangeEvent((ModelEvent)new ModelEvent.TreeChanged((Object)this));
    }

    private void fireWatchesChanged() {
        this.fireChangeEvent((ModelEvent)new ModelEvent.NodeChanged((Object)this, (Object)"Root", 8));
    }

    void fireTableValueChanged(Object node, String propertyName) {
        ((ScriptWatchEvaluating)node).requestValue();
        this.fireTableValueChangedComputed(node, propertyName);
    }

    private void fireTableValueChangedComputed(Object node, String propertyName) {
        this.fireChangeEvent((ModelEvent)new ModelEvent.TableValueChanged((Object)this, node, propertyName));
    }

    private ScriptWatchEvaluating[] getEvaluatingWatches(Watch[] watches) {
        ScriptWatchEvaluating[] evaluatingWatches = new ScriptWatchEvaluating[watches.length];
        int i = 0;
        for (Watch watch : watches) {
            ScriptWatchEvaluating evaluatingWatch = this.getWatchesMap().get(watch);
            if (evaluatingWatch == null) {
                evaluatingWatch = new ScriptWatchEvaluating(this.myLookupProvider, watch);
                this.getWatchesMap().put(watches[i], evaluatingWatch);
            }
            evaluatingWatches[i++] = evaluatingWatch;
        }
        return evaluatingWatches;
    }

    private Map<Watch, ScriptWatchEvaluating> getWatchesMap() {
        return this.myWatches;
    }

    static /* synthetic */ ClearingThread access$100() {
        return CLERAING_THREAD;
    }

    static {
        CLERAING_THREAD.start();
    }

    class Listener
    extends DebuggerManagerAdapter
    implements PropertyChangeListener {
        private WeakProxyListener<Listener> myListener = new WeakProxyListener<Listener>(this, (ReferenceQueue<Listener>)WatchesModel.access$100().getQueue());

        private Listener() {
            Watch[] watches;
            DebuggerManager.getDebuggerManager().addDebuggerListener("watches", this.myListener);
            for (Watch watch : watches = DebuggerManager.getDebuggerManager().getWatches()) {
                watch.addPropertyChangeListener(this.myListener);
            }
        }

        public void watchAdded(Watch watch) {
            watch.addPropertyChangeListener((PropertyChangeListener)this);
            WatchesModel.this.fireWatchesChanged();
        }

        public void watchRemoved(Watch watch) {
            watch.removePropertyChangeListener((PropertyChangeListener)this);
            WatchesModel.this.fireWatchesChanged();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            if ("watches".equals(propName)) {
                return;
            }
            if (evt.getSource() instanceof Watch) {
                Object node;
                Map map = WatchesModel.this.getWatchesMap();
                synchronized (map) {
                    node = WatchesModel.this.getWatchesMap().get((Watch)evt.getSource());
                }
                if (node != null) {
                    WatchesModel.this.fireTableValueChanged(node, null);
                    return;
                }
            }
            this.myListener.setupTask();
        }

        void fireTreeChanged() {
            WatchesModel.this.fireTreeChanged();
        }
    }

    private static class ScriptWatchEvaluating
    extends org.netbeans.modules.php.dbgp.models.nodes.ScriptWatchEvaluating {
        protected ScriptWatchEvaluating(ContextProvider provider, Watch watch) {
            super(provider, watch);
        }

        @Override
        protected synchronized void setEvaluated(Property value) {
            super.setEvaluated(value);
        }

        @Override
        protected void requestValue() {
            super.requestValue();
        }
    }
}

