/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.breakpoints;

import java.util.EventListener;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.php.dbgp.DebugSession;
import org.netbeans.modules.php.dbgp.SessionId;
import org.netbeans.modules.php.dbgp.breakpoints.AbstractBreakpoint;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.text.Line;
import org.openide.util.WeakListeners;

public class LineBreakpoint
extends AbstractBreakpoint {
    private Line myLine;
    private FileRemoveListener myListener;
    private FileChangeListener myWeakListener;
    private String myFileUrl;

    public LineBreakpoint(Line line) {
        this.myLine = line;
        this.myListener = new FileRemoveListener();
        FileObject fileObject = (FileObject)line.getLookup().lookup(FileObject.class);
        if (fileObject != null) {
            this.myWeakListener = (FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)((Object)this.myListener), (Object)fileObject);
            fileObject.addFileChangeListener(this.myWeakListener);
            this.myFileUrl = fileObject.toURL().toString();
        } else {
            this.myFileUrl = "";
        }
    }

    public final void setValid(String message) {
        this.setValidity(Breakpoint.VALIDITY.VALID, message);
    }

    public final void setInvalid(String message) {
        this.setValidity(Breakpoint.VALIDITY.INVALID, message);
    }

    public Line getLine() {
        return this.myLine;
    }

    public String getFileUrl() {
        return this.myFileUrl;
    }

    @Override
    public int isTemp() {
        return 0;
    }

    @Override
    public boolean isSessionRelated(DebugSession session) {
        SessionId id;
        SessionId sessionId = id = session != null ? session.getSessionId() : null;
        if (id == null) {
            return false;
        }
        Project project = id.getProject();
        return project != null;
    }

    @Override
    public void removed() {
        FileObject fileObject = (FileObject)this.getLine().getLookup().lookup(FileObject.class);
        if (fileObject != null) {
            fileObject.removeFileChangeListener(this.myWeakListener);
        }
    }

    private Project getProject() {
        Line line = this.getLine();
        if (line == null) {
            return null;
        }
        FileObject fileObject = (FileObject)line.getLookup().lookup(FileObject.class);
        if (fileObject == null) {
            return null;
        }
        return FileOwnerQuery.getOwner((FileObject)fileObject);
    }

    private class FileRemoveListener
    extends FileChangeAdapter {
        private FileRemoveListener() {
        }

        public void fileDeleted(FileEvent arg0) {
            DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)LineBreakpoint.this);
        }
    }
}

