/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.php.api.util.Pair;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

abstract class URIMapper {
    private static final Logger LOGGER = Logger.getLogger(URIMapper.class.getName());

    URIMapper() {
    }

    abstract File toSourceFile(URI var1);

    abstract URI toWebServerURI(File var1, boolean var2);

    URI toWebServerURI(File localFile) {
        return this.toWebServerURI(localFile, true);
    }

    static MultiMapper createMultiMapper(URI webServerURI, FileObject sourceFileObj, FileObject sourceRoot, List<Pair<String, String>> pathMapping) {
        MultiMapper mergedMapper = new MultiMapper();
        for (Pair<String, String> pair : pathMapping) {
            pair = URIMapper.encodedPathMappingPair(pair);
            String uriPath = (String)pair.first;
            String filePath = (String)pair.second;
            if (uriPath.length() <= 0 || filePath.length() <= 0) continue;
            if (!uriPath.startsWith("file:")) {
                uriPath = !uriPath.startsWith("/") ? "file:/" + uriPath : "file:" + uriPath;
            }
            if (!uriPath.endsWith("/")) {
                uriPath = uriPath + "/";
            }
            URI remoteURI = URI.create(uriPath);
            File localFile = new File(filePath);
            FileObject localFo = FileUtil.toFileObject((File)localFile);
            if (localFo == null || !localFo.isFolder()) continue;
            URIMapper customMapper = URIMapper.createBasedInstance(remoteURI, localFile);
            mergedMapper.addAsLastMapper(customMapper);
        }
        URIMapper defaultMapper = URIMapper.createDefaultMapper(webServerURI, sourceFileObj, sourceRoot);
        if (defaultMapper != null) {
            mergedMapper.addAsLastMapper(defaultMapper);
        }
        mergedMapper.addAsLastMapper(URIMapper.createOneToOne());
        return mergedMapper;
    }

    static URIMapper createDefaultMapper(URI webServerURI, FileObject sourceFileObj, FileObject sourceRoot) {
        if (sourceRoot == null) {
            return null;
        }
        if (!"file".equals(webServerURI.getScheme())) {
            return null;
        }
        File webServerFile = Utilities.toFile((URI)webServerURI);
        File sourceFile = FileUtil.toFile((FileObject)sourceFileObj);
        String sourcePath = FileUtil.getRelativePath((FileObject)sourceRoot, (FileObject)sourceFileObj);
        if (sourcePath != null) {
            if (sourceFile.isDirectory() && !(sourceFile = new File(sourceFile, webServerFile.getName())).exists()) {
                LOGGER.log(Level.FINE, "No default path mapping: webServerURI: {0} sourceFile: {1}", new Object[]{webServerURI.toString(), sourceFile.getAbsolutePath()});
                return null;
            }
            if (!sourceFile.equals(webServerFile)) {
                File sourceRootFile = FileUtil.toFile((FileObject)sourceRoot);
                assert (sourceRootFile != null);
                URI[] bases = URIMapper.findBases(webServerURI, sourceFile, sourceRootFile);
                if (bases.length > 0) {
                    URI webServerBase = bases[0];
                    File sourceBase = Utilities.toFile((URI)bases[1]);
                    assert (webServerBase != null);
                    assert (sourceBase != null);
                    return new BaseMapper(webServerBase, sourceBase);
                }
            }
        }
        LOGGER.log(Level.FINE, "No default path mapping: webServerURI: {0} sourceFile: {1}", new Object[]{webServerURI.toString(), sourceFile.getAbsolutePath()});
        return null;
    }

    static URIMapper createOneToOne() {
        return new URIMapper(){
            private Map<File, File> can2AbsFile = new HashMap<File, File>();

            @Override
            File toSourceFile(URI remoteURI) {
                File retval = Utilities.toFile((URI)remoteURI);
                File absFile = this.can2AbsFile.get(retval);
                File file = retval = absFile != null ? absFile : retval;
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.log(Level.INFO, String.format("%s: %s -> %s", this.getClass().toString(), remoteURI, retval));
                }
                return retval;
            }

            @Override
            URI toWebServerURI(File localFile, boolean includeHostPart) {
                File canonicalFile = null;
                try {
                    canonicalFile = localFile.getCanonicalFile();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                if (!localFile.equals(canonicalFile)) {
                    this.can2AbsFile.put(canonicalFile, localFile);
                    localFile = canonicalFile;
                }
                URI retval = URIMapper.toURI(localFile, includeHostPart);
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.log(Level.INFO, String.format("%s: %s -> %s", this.getClass().toString(), localFile, retval));
                }
                return retval;
            }
        };
    }

    static URIMapper createBasedInstance(URI baseRemoteURI, File baseLocalFolder) {
        return new BaseMapper(baseRemoteURI, baseLocalFolder);
    }

    private static URI[] findBases(URI webServerURI, File sourceFile, File sourceRoot) {
        File baseFile = sourceFile;
        boolean nullRetVal = true;
        ArrayList pathFragments = new ArrayList();
        Collections.addAll(pathFragments, webServerURI.getPath().split("/"));
        Collections.reverse(pathFragments);
        for (String path : pathFragments) {
            if (baseFile == null || !path.equals(baseFile.getName()) || baseFile.equals(sourceRoot)) break;
            nullRetVal = false;
            if (baseFile.equals(sourceRoot)) break;
            baseFile = baseFile.getParentFile();
        }
        if (nullRetVal) {
            return new URI[0];
        }
        assert (baseFile.isDirectory());
        int basePathLen = webServerURI.getPath().length() - (sourceFile.getAbsolutePath().length() - baseFile.getAbsolutePath().length());
        String basePath = webServerURI.getPath().substring(0, basePathLen);
        URI baseURI = URIMapper.createURI(webServerURI.getScheme(), webServerURI.getHost(), basePath, webServerURI.getFragment(), true, true);
        return new URI[]{baseURI, Utilities.toURI((File)baseFile)};
    }

    private static URI createURI(String scheme, String host, String path, String fragment, boolean includeHostPart, boolean pathEndsWithSlash) {
        if (pathEndsWithSlash && !path.endsWith("/")) {
            path = path + "/";
        }
        if (host == null && includeHostPart) {
            host = "";
        }
        try {
            return new URI(scheme, host, path, fragment);
        }
        catch (URISyntaxException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    private static URI toURI(File webServerBase, boolean includeHostPart) {
        URI webServerBaseURI = Utilities.toURI((File)webServerBase);
        return URIMapper.createURI(webServerBaseURI.getScheme(), webServerBaseURI.getHost(), webServerBaseURI.getPath(), webServerBaseURI.getFragment(), includeHostPart, webServerBase.exists() && webServerBase.isDirectory());
    }

    private static Pair<String, String> encodedPathMappingPair(Pair<String, String> pathMapping) {
        String resName = (String)pathMapping.first;
        resName = resName.replace('\\', '/');
        String[] elements = resName.split("/");
        StringBuilder sb = new StringBuilder(200);
        for (int i = 0; i < elements.length; ++i) {
            String element = elements[i];
            boolean skip = false;
            if (i == 0 && element.length() == 2 && element.charAt(1) == ':') {
                skip = true;
            }
            if (!skip) {
                try {
                    element = URLEncoder.encode(element, "UTF-8");
                    element = element.replace("+", "%20");
                }
                catch (UnsupportedEncodingException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            sb.append(element);
            if (i >= elements.length - 1) continue;
            sb.append('/');
        }
        return Pair.of((Object)sb.toString(), (Object)pathMapping.second);
    }

    static class MultiMapper
    extends URIMapper {
        private LinkedList<URIMapper> mappers = new LinkedList();

        MultiMapper() {
        }

        MultiMapper addAsFirstMapper(URIMapper mapper) {
            this.mappers.addFirst(mapper);
            return this;
        }

        MultiMapper addAsLastMapper(URIMapper mapper) {
            this.mappers.addLast(mapper);
            return this;
        }

        @Override
        File toSourceFile(URI remoteURI) {
            if ("file".equals(remoteURI.getScheme())) {
                for (URIMapper mapperInstance : this.mappers) {
                    File sourceFile = mapperInstance.toSourceFile(remoteURI);
                    if (sourceFile == null) continue;
                    return sourceFile;
                }
            }
            return null;
        }

        @Override
        URI toWebServerURI(File localFile, boolean includeHostPart) {
            for (URIMapper mapperInstance : this.mappers) {
                URI toWebServerURI = mapperInstance.toWebServerURI(localFile, includeHostPart);
                if (toWebServerURI == null) continue;
                return toWebServerURI;
            }
            return null;
        }
    }

    private static class BaseMapper
    extends URIMapper {
        private static final String FILE_SCHEME = "file";
        private URI baseWebServerURI;
        private URI baseSourceURI;
        private File baseSourceFolder;

        BaseMapper(URI baseWebServerURI, File baseSourceFolder) {
            if (!baseSourceFolder.exists()) {
                throw new IllegalArgumentException();
            }
            if (!baseSourceFolder.isDirectory()) {
                throw new IllegalArgumentException();
            }
            this.baseSourceFolder = baseSourceFolder;
            this.baseWebServerURI = baseWebServerURI;
            boolean isLoggable = LOGGER.isLoggable(Level.FINE);
            if (isLoggable) {
                if (!FILE_SCHEME.equals(baseWebServerURI.getScheme())) {
                    LOGGER.log(Level.FINE, "Unexpected scheme: {0}", baseWebServerURI.toString());
                }
                if (baseWebServerURI.getPath() == null) {
                    LOGGER.log(Level.FINE, "URI.getPath() == null: {0}", baseWebServerURI.toString());
                }
                if (baseWebServerURI.getPath() == null) {
                    LOGGER.log(Level.FINE, "URI.getPath() == null: {0}", baseWebServerURI.toString());
                } else if (!baseWebServerURI.getPath().endsWith("/")) {
                    LOGGER.log(Level.FINE, "Not \"/\" at the end of URI.getPath(): {0}", baseWebServerURI.toString());
                }
                if (!baseWebServerURI.isAbsolute()) {
                    LOGGER.log(Level.FINE, "URI not absolute: {0}", baseWebServerURI.toString());
                }
            }
            assert (FILE_SCHEME.equals(baseWebServerURI.getScheme()));
            assert (baseWebServerURI.getPath() != null);
            assert (baseWebServerURI.getPath().endsWith("/")) : baseWebServerURI.getPath();
            assert (baseWebServerURI.isAbsolute());
            this.baseSourceURI = Utilities.toURI((File)baseSourceFolder);
            assert (this.baseSourceURI.isAbsolute());
        }

        @Override
        File toSourceFile(URI webServerURI) {
            URI relativizedURI = this.baseWebServerURI.relativize(webServerURI);
            File retval = null;
            if (!relativizedURI.isAbsolute()) {
                assert (FILE_SCHEME.equals(webServerURI.getScheme()));
                retval = Utilities.toFile((URI)this.baseSourceURI.resolve(relativizedURI));
            }
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, String.format("%s: %s -> %s", this.getClass().toString(), webServerURI, retval));
            }
            return retval;
        }

        @Override
        URI toWebServerURI(File sourceFile, boolean includeHostPart) {
            URI retval = null;
            if (sourceFile.equals(this.baseSourceFolder)) {
                retval = this.baseWebServerURI;
            } else {
                URI relativizedURI = this.baseSourceURI.relativize(Utilities.toURI((File)sourceFile));
                if (!relativizedURI.isAbsolute()) {
                    URI uri = this.baseWebServerURI.resolve(relativizedURI);
                    retval = URIMapper.createURI(uri.getScheme(), uri.getHost(), uri.getPath(), uri.getFragment(), true, false);
                }
            }
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, String.format("%s: %s -> %s", this.getClass().toString(), sourceFile, retval));
            }
            return retval;
        }
    }
}

