/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.impl;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.parsing.api.indexing.IndexingManager;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.tasklist.filter.TaskFilter;
import org.netbeans.modules.tasklist.impl.Accessor;
import org.netbeans.modules.tasklist.impl.CurrentEditorScanningScope;
import org.netbeans.modules.tasklist.impl.Loader;
import org.netbeans.modules.tasklist.impl.ScannerList;
import org.netbeans.modules.tasklist.impl.TaskList;
import org.netbeans.modules.tasklist.trampoline.TaskManager;
import org.netbeans.spi.tasklist.FileTaskScanner;
import org.netbeans.spi.tasklist.PushTaskScanner;
import org.netbeans.spi.tasklist.Task;
import org.netbeans.spi.tasklist.TaskScanningScope;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;

public class TaskManagerImpl
extends TaskManager {
    public static final String PROP_SCOPE = "taskScanningScope";
    public static final String PROP_FILTER = "filter";
    public static final String PROP_WORKING_STATUS = "workingStatus";
    private PropertyChangeSupport propertySupport = new PropertyChangeSupport((Object)this);
    private TaskList taskList = new TaskList();
    private TaskScanningScope scope = Accessor.getEmptyScope();
    private TaskFilter filter = TaskFilter.EMPTY;
    private static TaskManagerImpl theInstance;
    private final Set<PushTaskScanner> workingScanners = new HashSet<PushTaskScanner>(10);
    private boolean isLoadingFromCache = false;
    private boolean workingStatus = false;
    private Loader loader;
    public static final RequestProcessor RP;

    public static TaskManagerImpl getInstance() {
        if (null == theInstance) {
            theInstance = new TaskManagerImpl();
        }
        return theInstance;
    }

    public void observe(final TaskScanningScope newScope, final TaskFilter newFilter) {
        RP.post(new Runnable(){

            @Override
            public void run() {
                TaskManagerImpl.this.doObserve(newScope, newFilter);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doObserve(TaskScanningScope newScope, TaskFilter newFilter) {
        TaskScanningScope oldScope = this.scope;
        TaskFilter oldFilter = this.filter;
        TaskManagerImpl taskManagerImpl = this;
        synchronized (taskManagerImpl) {
            if (null == newScope || Accessor.getEmptyScope().equals(newScope)) {
                this.scope.attach(null);
                this.stopLoading();
                this.workingScanners.clear();
                this.isLoadingFromCache = false;
                for (PushTaskScanner pushTaskScanner : ScannerList.getPushScannerList().getScanners()) {
                    pushTaskScanner.setScope(null, null);
                }
                for (FileTaskScanner fileTaskScanner : ScannerList.getFileScannerList().getScanners()) {
                    fileTaskScanner.attach(null);
                }
                this.scope = Accessor.getEmptyScope();
                this.filter = TaskFilter.EMPTY;
                this.taskList.clear();
                this.setWorkingStatus(false);
            } else {
                boolean dirtyCache = NbPreferences.forModule(TaskManagerImpl.class).getBoolean("dirtyCache", false);
                NbPreferences.forModule(TaskManagerImpl.class).putBoolean("dirtyCache", false);
                if (null == newFilter) {
                    newFilter = TaskFilter.EMPTY;
                }
                if (!this.scope.equals(newScope) || !this.filter.equals(newFilter)) {
                    this.taskList.clear();
                    if (!newScope.equals(this.scope)) {
                        this.scope.attach(null);
                        newScope.attach(Accessor.createCallback((TaskManager)this, newScope));
                    }
                    this.workingScanners.clear();
                    this.isLoadingFromCache = false;
                    this.setWorkingStatus(false);
                    boolean bl = this.compareScanners(this.filter, newFilter);
                    this.scope = newScope;
                    this.filter = newFilter;
                    this.attachFileScanners(newFilter);
                    this.attachPushScanners(newScope, newFilter);
                    if (bl || dirtyCache) {
                        this.clearCache();
                    } else {
                        this.startLoading();
                    }
                }
            }
        }
        this.propertySupport.firePropertyChange(PROP_SCOPE, oldScope, newScope);
        this.propertySupport.firePropertyChange(PROP_FILTER, oldFilter, newFilter);
    }

    private boolean compareScanners(TaskFilter oldFilter, TaskFilter newFilter) {
        if (null == oldFilter || oldFilter == TaskFilter.EMPTY) {
            return false;
        }
        List<FileTaskScanner> oldScanners = ScannerList.getFileScanners(oldFilter);
        List<FileTaskScanner> newScanners = ScannerList.getFileScanners(newFilter);
        if (oldScanners.size() > 0 && oldScanners.size() != newScanners.size()) {
            return true;
        }
        for (FileTaskScanner scanner : oldScanners) {
            if (newScanners.contains(scanner)) continue;
            return true;
        }
        return false;
    }

    private void attachFileScanners(TaskFilter newFilter) {
        for (FileTaskScanner fileTaskScanner : this.getFileScanners()) {
            if (!newFilter.isEnabled(fileTaskScanner)) {
                fileTaskScanner.attach(null);
                continue;
            }
            if (!newFilter.isEnabled(fileTaskScanner)) continue;
            fileTaskScanner.attach(Accessor.createCallback((TaskManager)this, fileTaskScanner));
        }
    }

    private void attachPushScanners(TaskScanningScope newScope, TaskFilter newFilter) {
        for (PushTaskScanner pushTaskScanner : this.getPushScanners()) {
            if (!newFilter.isEnabled(pushTaskScanner)) {
                pushTaskScanner.setScope(null, null);
                continue;
            }
            if (!newFilter.isEnabled(pushTaskScanner)) continue;
            pushTaskScanner.setScope(newScope, Accessor.createCallback((TaskManager)this, pushTaskScanner));
        }
    }

    Iterable<? extends FileTaskScanner> getFileScanners() {
        return ScannerList.getFileScannerList().getScanners();
    }

    Iterable<? extends PushTaskScanner> getPushScanners() {
        return ScannerList.getPushScannerList().getScanners();
    }

    public void abort() {
        RP.post(new Runnable(){

            @Override
            public void run() {
                TaskManagerImpl.this.doAbort();
            }
        });
    }

    private void doAbort() {
        this.stopLoading();
        for (PushTaskScanner scanner : ScannerList.getPushScannerList().getScanners()) {
            scanner.setScope(null, null);
        }
        this.workingScanners.clear();
        this.setWorkingStatus(false);
    }

    boolean isObserved() {
        return !Accessor.getEmptyScope().equals(this.getScope());
    }

    boolean isCurrentEditorScope() {
        return this.scope instanceof CurrentEditorScanningScope;
    }

    public TaskScanningScope getScope() {
        return this.scope;
    }

    public TaskList getTasks() {
        return this.taskList;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propName, PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(propName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propName, PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(propName, listener);
    }

    private void startLoading() {
        if (null != this.loader) {
            this.loader.cancel();
        }
        this.loader = new Loader(this.scope, this.filter, this.taskList);
        RP.post((Runnable)this.loader);
    }

    private void stopLoading() {
        if (null != this.loader) {
            this.loader.cancel();
        }
        this.loader = null;
        this.isLoadingFromCache = false;
        this.setWorkingStatus(this.isWorking());
    }

    public TaskFilter getFilter() {
        return this.filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(FileTaskScanner scanner, FileObject ... resources) {
        try {
            TaskManagerImpl taskManagerImpl = this;
            synchronized (taskManagerImpl) {
                this.taskList.clear(scanner, resources);
            }
            ArrayList<URL> toRefresh = new ArrayList<URL>(1);
            for (FileObject fo : resources) {
                toRefresh.clear();
                toRefresh.add(fo.getURL());
                Collection roots = QuerySupport.findRoots((FileObject)fo, null, null, null);
                for (FileObject root : roots) {
                    IndexingManager.getDefault().refreshIndex(root.getURL(), toRefresh);
                }
            }
        }
        catch (IOException ioE) {
            this.getLogger().log(Level.INFO, "Error while refreshing files.", ioE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(FileTaskScanner scanner) {
        TaskManagerImpl taskManagerImpl = this;
        synchronized (taskManagerImpl) {
            this.taskList.clear(scanner);
            this.clearCache();
        }
    }

    public void clearCache() {
        IndexingManager.getDefault().refreshAllIndices("TaskListIndexer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void makeCacheDirty() {
        TaskManagerImpl taskManagerImpl = this;
        synchronized (taskManagerImpl) {
            NbPreferences.forModule(TaskManagerImpl.class).putBoolean("dirtyCache", true);
        }
    }

    public void refresh(final TaskScanningScope scopeToRefresh) {
        if (this.scope.equals(scopeToRefresh)) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    TaskManagerImpl.this.doRefresh(scopeToRefresh);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRefresh(TaskScanningScope scopeToRefresh) {
        TaskManagerImpl taskManagerImpl = this;
        synchronized (taskManagerImpl) {
            if (this.scope.equals(scopeToRefresh)) {
                this.taskList.clear();
                if (this.isObserved()) {
                    for (PushTaskScanner scanner : ScannerList.getPushScannerList().getScanners()) {
                        scanner.setScope(null, null);
                        if (!this.getFilter().isEnabled(scanner)) continue;
                        scanner.setScope(scopeToRefresh, Accessor.createCallback((TaskManager)this, scanner));
                    }
                    boolean dirtyCache = NbPreferences.forModule(TaskManagerImpl.class).getBoolean("dirtyCache", false);
                    if (dirtyCache && this.isCurrentEditorScope()) {
                        this.cacheCurrentEditorFile();
                    } else {
                        this.startLoading();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void started(PushTaskScanner scanner) {
        Set<PushTaskScanner> set = this.workingScanners;
        synchronized (set) {
            this.workingScanners.add(scanner);
            this.setWorkingStatus(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finished(PushTaskScanner scanner) {
        Set<PushTaskScanner> set = this.workingScanners;
        synchronized (set) {
            this.workingScanners.remove(scanner);
            this.setWorkingStatus(this.isWorking());
        }
    }

    public void setTasks(PushTaskScanner scanner, FileObject resource, List<? extends Task> tasks) {
        if (this.isObserved() && this.scope.isInScope(resource)) {
            try {
                this.taskList.setTasks(scanner, resource, tasks, this.filter);
            }
            catch (IOException ioE) {
                this.getLogger().log(Level.INFO, "Error while updating tasks from " + Accessor.getDisplayName(scanner), ioE);
            }
        }
    }

    public void setTasks(PushTaskScanner scanner, List<? extends Task> tasks) {
        if (this.isObserved()) {
            try {
                this.taskList.setTasks(scanner, null, tasks, this.filter);
            }
            catch (IOException ioE) {
                this.getLogger().log(Level.INFO, "Error while updating tasks from " + Accessor.getDisplayName(scanner), ioE);
            }
        }
    }

    public void clearAllTasks(PushTaskScanner scanner) {
        this.taskList.clear(scanner);
    }

    private Logger getLogger() {
        return Logger.getLogger(TaskManagerImpl.class.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isWorking() {
        Set<PushTaskScanner> set = this.workingScanners;
        synchronized (set) {
            return !this.workingScanners.isEmpty() || this.isLoadingFromCache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setLoadingStatus(Loader loader, boolean isLoading) {
        TaskManagerImpl taskManagerImpl = this;
        synchronized (taskManagerImpl) {
            if (this.loader != loader) {
                return;
            }
            this.isLoadingFromCache = isLoading;
        }
        this.setWorkingStatus(this.isWorking());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setWorkingStatus(boolean newStatus) {
        Set<PushTaskScanner> set = this.workingScanners;
        synchronized (set) {
            if (newStatus != this.workingStatus) {
                boolean oldStatus = this.workingStatus;
                this.workingStatus = newStatus;
                Logger.getLogger("org.netbeans.log.startup").log(Level.FINE, newStatus ? "start" : "end", TaskManagerImpl.class.getName());
                this.propertySupport.firePropertyChange(PROP_WORKING_STATUS, oldStatus, newStatus);
                if (!this.workingStatus) {
                    this.workingScanners.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitFinished() {
        Set<PushTaskScanner> set = this.workingScanners;
        synchronized (set) {
            if (!this.isWorking()) {
                return;
            }
            this._waitFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _waitFinished() {
        Set<PushTaskScanner> set = this.workingScanners;
        synchronized (set) {
            try {
                this.workingScanners.wait();
            }
            catch (InterruptedException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
    }

    private void cacheCurrentEditorFile() {
        try {
            Iterator it = this.scope.iterator();
            if (!it.hasNext()) {
                return;
            }
            FileObject fo = (FileObject)it.next();
            ArrayList<URL> toRefresh = new ArrayList<URL>(1);
            toRefresh.add(fo.getURL());
            Collection roots = QuerySupport.findRoots((FileObject)fo, null, null, null);
            for (FileObject root : roots) {
                IndexingManager.getDefault().refreshIndex(root.getURL(), toRefresh);
            }
        }
        catch (FileStateInvalidException ex) {
            this.getLogger().log(Level.INFO, "Error while refreshing files.", ex);
        }
    }

    static {
        RP = new RequestProcessor("TaskList");
    }
}

