/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject.ui;

import java.awt.Color;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.CharConversionException;
import java.net.URL;
import javax.swing.Action;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ui.ProjectProblems;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.api.common.project.ui.LogicalViewProvider2;
import org.netbeans.modules.java.j2seproject.J2SEProject;
import org.netbeans.modules.java.j2seproject.J2SEProjectUtil;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.ui.ProjectProblemsProvider;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.netbeans.spi.project.ui.support.NodeFactorySupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.xml.XMLUtil;

public class J2SELogicalViewProvider
implements LogicalViewProvider2 {
    private static final RequestProcessor RP = new RequestProcessor(J2SELogicalViewProvider.class);
    private static final String[] BREAKABLE_PROPERTIES = new String[]{"javac.classpath", "run.classpath", "debug.classpath", "run.test.classpath", "debug.test.classpath", "endorsed.classpath", "javac.test.classpath"};
    private static final String COMPILE_ON_SAVE_DISABLED_BADGE_PATH = "org/netbeans/modules/java/j2seproject/ui/resources/compileOnSaveDisabledBadge.gif";
    private static final Image compileOnSaveDisabledBadge;
    private final J2SEProject project;
    private final UpdateHelper helper;
    private final PropertyEvaluator evaluator;
    private final ReferenceHelper resolver;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final PropertyChangeListener pcl;
    private final RequestProcessor.Task task = RP.create(new Runnable(){

        @Override
        public void run() {
            J2SELogicalViewProvider.this.setBroken(ProjectProblems.isBroken((Project)J2SELogicalViewProvider.this.project));
            J2SELogicalViewProvider.this.setCompileOnSaveDisabled(J2SELogicalViewProvider.this.isCompileOnSaveDisabled());
        }
    });
    private volatile boolean listenersInited;
    private volatile boolean broken;
    private volatile boolean compileOnSaveDisabled;

    public J2SELogicalViewProvider(J2SEProject project, UpdateHelper helper, PropertyEvaluator evaluator, ReferenceHelper resolver) {
        this.project = project;
        assert (project != null);
        this.helper = helper;
        assert (helper != null);
        this.evaluator = evaluator;
        assert (evaluator != null);
        this.resolver = resolver;
        assert (resolver != null);
        this.pcl = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propName = evt.getPropertyName();
                if (propName == null || "problems".equals(evt.getPropertyName()) || "compile.on.save".equals(evt.getPropertyName()) || propName.startsWith("compile.on.save.unsupported")) {
                    J2SELogicalViewProvider.this.testBroken();
                }
            }
        };
    }

    private void initListeners() {
        if (this.listenersInited) {
            return;
        }
        ProjectManager.mutex().readAccess(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Class<J2SELogicalViewProvider> clazz = J2SELogicalViewProvider.class;
                synchronized (J2SELogicalViewProvider.class) {
                    if (!J2SELogicalViewProvider.this.listenersInited) {
                        J2SELogicalViewProvider.this.evaluator.addPropertyChangeListener(J2SELogicalViewProvider.this.pcl);
                        ProjectProblemsProvider ppp = (ProjectProblemsProvider)J2SELogicalViewProvider.this.project.getLookup().lookup(ProjectProblemsProvider.class);
                        if (ppp != null) {
                            ppp.addPropertyChangeListener(J2SELogicalViewProvider.this.pcl);
                        }
                        J2SELogicalViewProvider.this.listenersInited = true;
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        });
    }

    public Node createLogicalView() {
        this.initListeners();
        InstanceContent ic = new InstanceContent();
        ic.add((Object)this.project);
        ic.add((Object)this.project, (InstanceContent.Convertor)new InstanceContent.Convertor<J2SEProject, FileObject>(){

            public FileObject convert(J2SEProject obj) {
                return obj.getProjectDirectory();
            }

            public Class<? extends FileObject> type(J2SEProject obj) {
                return FileObject.class;
            }

            public String id(J2SEProject obj) {
                FileObject fo = obj.getProjectDirectory();
                return fo == null ? "" : fo.getPath();
            }

            public String displayName(J2SEProject obj) {
                return obj.toString();
            }
        });
        ic.add((Object)this.project, (InstanceContent.Convertor)new InstanceContent.Convertor<J2SEProject, DataObject>(){

            public DataObject convert(J2SEProject obj) {
                try {
                    FileObject fo = obj.getProjectDirectory();
                    return fo == null ? null : DataObject.find((FileObject)fo);
                }
                catch (DataObjectNotFoundException ex) {
                    return null;
                }
            }

            public Class<? extends DataObject> type(J2SEProject obj) {
                return DataObject.class;
            }

            public String id(J2SEProject obj) {
                FileObject fo = obj.getProjectDirectory();
                return fo == null ? "" : fo.getPath();
            }

            public String displayName(J2SEProject obj) {
                return obj.toString();
            }
        });
        return new J2SELogicalViewRootNode((Lookup)new AbstractLookup((AbstractLookup.Content)ic));
    }

    public PropertyEvaluator getEvaluator() {
        return this.evaluator;
    }

    public ReferenceHelper getRefHelper() {
        return this.resolver;
    }

    public UpdateHelper getUpdateHelper() {
        return this.helper;
    }

    public Node findPath(Node root, Object target) {
        Project prj = (Project)root.getLookup().lookup(Project.class);
        if (prj == null) {
            return null;
        }
        if (target instanceof FileObject) {
            FileObject fo = (FileObject)target;
            if (J2SELogicalViewProvider.isOtherProjectSource(fo, prj)) {
                return null;
            }
            for (Node n : root.getChildren().getNodes(true)) {
                Node result = PackageView.findPath((Node)n, (Object)target);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    private static boolean isOtherProjectSource(@NonNull FileObject fo, @NonNull Project me) {
        Project owner = FileOwnerQuery.getOwner((FileObject)fo);
        if (owner == null) {
            return false;
        }
        if (me.equals(owner)) {
            return false;
        }
        for (SourceGroup sg : ProjectUtils.getSources((Project)owner).getSourceGroups("java")) {
            if (!FileUtil.isParentOf((FileObject)sg.getRootFolder(), (FileObject)fo)) continue;
            return true;
        }
        return false;
    }

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    public void testBroken() {
        this.task.schedule(500);
    }

    public String[] getBreakableProperties() {
        SourceRoots roots = this.project.getSourceRoots();
        String[] srcRootProps = roots.getRootProperties();
        roots = this.project.getTestSourceRoots();
        String[] testRootProps = roots.getRootProperties();
        String[] result = new String[BREAKABLE_PROPERTIES.length + srcRootProps.length + testRootProps.length];
        System.arraycopy(BREAKABLE_PROPERTIES, 0, result, 0, BREAKABLE_PROPERTIES.length);
        System.arraycopy(srcRootProps, 0, result, BREAKABLE_PROPERTIES.length, srcRootProps.length);
        System.arraycopy(testRootProps, 0, result, BREAKABLE_PROPERTIES.length + srcRootProps.length, testRootProps.length);
        return result;
    }

    public String[] getPlatformProperties() {
        return new String[]{"platform.active"};
    }

    private boolean isCompileOnSaveDisabled() {
        return !J2SEProjectUtil.isCompileOnSaveEnabled(this.project) && J2SEProjectUtil.isCompileOnSaveSupported(this.project);
    }

    private void setBroken(boolean broken) {
        if (this.broken != broken) {
            this.broken = broken;
            this.changeSupport.fireChange();
        }
    }

    private void setCompileOnSaveDisabled(boolean value) {
        if (this.compileOnSaveDisabled != value) {
            this.compileOnSaveDisabled = value;
            this.changeSupport.fireChange();
        }
    }

    @NonNull
    private static Color getErrorForeground() {
        Color result = UIManager.getDefaults().getColor("nb.errorForeground");
        if (result == null) {
            result = Color.RED;
        }
        return result;
    }

    static {
        URL errorBadgeIconURL = J2SELogicalViewProvider.class.getClassLoader().getResource(COMPILE_ON_SAVE_DISABLED_BADGE_PATH);
        String compileOnSaveDisabledTP = "<img src=\"" + errorBadgeIconURL + "\">&nbsp;" + NbBundle.getMessage(J2SELogicalViewProvider.class, (String)"TP_CompileOnSaveDisabled");
        compileOnSaveDisabledBadge = ImageUtilities.assignToolTipToImage((Image)ImageUtilities.loadImage((String)COMPILE_ON_SAVE_DISABLED_BADGE_PATH), (String)compileOnSaveDisabledTP);
    }

    private final class J2SELogicalViewRootNode
    extends AbstractNode
    implements ChangeListener,
    PropertyChangeListener {
        private final ProjectInformation info;

        J2SELogicalViewRootNode(Lookup lkp) {
            super(NodeFactorySupport.createCompositeChildren((Project)J2SELogicalViewProvider.this.project, (String)"Projects/org-netbeans-modules-java-j2seproject/Nodes"), lkp);
            this.info = ProjectUtils.getInformation((Project)J2SELogicalViewProvider.this.project);
            this.setIconBaseWithExtension("org/netbeans/modules/java/j2seproject/ui/resources/j2seProject.png");
            J2SELogicalViewProvider.this.broken = ProjectProblems.isBroken((Project)J2SELogicalViewProvider.this.project);
            J2SELogicalViewProvider.this.compileOnSaveDisabled = J2SELogicalViewProvider.this.isCompileOnSaveDisabled();
            J2SELogicalViewProvider.this.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)J2SELogicalViewProvider.this));
            this.info.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.info));
        }

        public String getShortDescription() {
            String prjDirDispName = FileUtil.getFileDisplayName((FileObject)J2SELogicalViewProvider.this.project.getProjectDirectory());
            return NbBundle.getMessage(J2SELogicalViewProvider.class, (String)"HINT_project_root_node", (Object)prjDirDispName);
        }

        public String getHtmlDisplayName() {
            String dispName = super.getDisplayName();
            try {
                dispName = XMLUtil.toElementContent((String)dispName);
            }
            catch (CharConversionException ex) {
                return dispName;
            }
            return J2SELogicalViewProvider.this.broken ? "<font color=\"#" + Integer.toHexString(J2SELogicalViewProvider.getErrorForeground().getRGB() & 0xFFFFFF) + "\">" + dispName + "</font>" : null;
        }

        public Image getIcon(int type) {
            Image original = super.getIcon(type);
            return !J2SELogicalViewProvider.this.broken && J2SELogicalViewProvider.this.compileOnSaveDisabled ? ImageUtilities.mergeImages((Image)original, (Image)compileOnSaveDisabledBadge, (int)8, (int)0) : original;
        }

        public Image getOpenedIcon(int type) {
            Image original = super.getOpenedIcon(type);
            return !J2SELogicalViewProvider.this.broken && J2SELogicalViewProvider.this.compileOnSaveDisabled ? ImageUtilities.mergeImages((Image)original, (Image)compileOnSaveDisabledBadge, (int)8, (int)0) : original;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.fireIconChange();
            this.fireOpenedIconChange();
            this.fireDisplayNameChange(null, null);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    J2SELogicalViewRootNode.this.fireNameChange(null, null);
                    J2SELogicalViewRootNode.this.fireDisplayNameChange(null, null);
                }
            });
        }

        public Action[] getActions(boolean context) {
            return CommonProjectActions.forType((String)"org-netbeans-modules-java-j2seproject");
        }

        public boolean canRename() {
            return true;
        }

        public String getName() {
            return this.info.getDisplayName();
        }

        public void setName(String s) {
            DefaultProjectOperations.performDefaultRenameOperation((Project)J2SELogicalViewProvider.this.project, (String)s);
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(J2SELogicalViewRootNode.class);
        }
    }
}

