/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.java.j2seproject.AntTargetsProvider;
import org.netbeans.modules.java.j2seproject.J2SEProject;
import org.netbeans.modules.java.j2seproject.J2SEProjectUtil;
import org.netbeans.modules.java.j2seproject.UpdateProjectImpl;
import org.netbeans.spi.project.CopyOperationImplementation;
import org.netbeans.spi.project.DeleteOperationImplementation;
import org.netbeans.spi.project.MoveOrRenameOperationImplementation;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.Utilities;

public class J2SEProjectOperations
implements DeleteOperationImplementation,
CopyOperationImplementation,
MoveOrRenameOperationImplementation {
    private static final Logger LOG = Logger.getLogger(J2SEProjectOperations.class.getName());
    private final J2SEProject project;
    private final UpdateProjectImpl updateProject;
    private final Map<String, String> privatePropsToRestore = new HashMap<String, String>();
    private String libraryPath;
    private File libraryFile;
    private boolean libraryWithinProject;
    private String absolutesRelPath;
    private FileSystem configs;

    public J2SEProjectOperations(@NonNull J2SEProject project, @NonNull UpdateProjectImpl updateProject) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        Parameters.notNull((CharSequence)"updateProject", (Object)updateProject);
        this.project = project;
        this.updateProject = updateProject;
    }

    private static void addFile(FileObject projectDirectory, String fileName, List<FileObject> result) {
        FileObject file = projectDirectory.getFileObject(fileName);
        if (file != null) {
            result.add(file);
        }
    }

    public List<FileObject> getMetadataFiles() {
        FileObject projectDirectory = this.project.getProjectDirectory();
        ArrayList<FileObject> files = new ArrayList<FileObject>();
        J2SEProjectOperations.addFile(projectDirectory, "nbproject", files);
        J2SEProjectOperations.addFile(projectDirectory, J2SEProjectUtil.getBuildXmlName(this.project), files);
        J2SEProjectOperations.addFile(projectDirectory, "xml-resources", files);
        J2SEProjectOperations.addFile(projectDirectory, "catalog.xml", files);
        return files;
    }

    public List<FileObject> getDataFiles() {
        File f;
        ArrayList<FileObject> files = new ArrayList<FileObject>();
        files.addAll(Arrays.asList(this.project.getSourceRoots().getRoots()));
        files.addAll(Arrays.asList(this.project.getTestSourceRoots().getRoots()));
        J2SEProjectOperations.addFile(this.project.getProjectDirectory(), "manifest.mf", files);
        J2SEProjectOperations.addFile(this.project.getProjectDirectory(), "master-application.jnlp", files);
        J2SEProjectOperations.addFile(this.project.getProjectDirectory(), "master-applet.jnlp", files);
        J2SEProjectOperations.addFile(this.project.getProjectDirectory(), "master-component.jnlp", files);
        J2SEProjectOperations.addFile(this.project.getProjectDirectory(), "preview-application.html", files);
        J2SEProjectOperations.addFile(this.project.getProjectDirectory(), "preview-applet.html", files);
        AntProjectHelper helper = this.project.getAntProjectHelper();
        if (helper.getLibrariesLocation() != null && (f = helper.resolveFile(helper.getLibrariesLocation())) != null && f.exists()) {
            FileObject libFolder = FileUtil.toFileObject((File)f).getParent();
            if (FileUtil.isParentOf((FileObject)this.project.getProjectDirectory(), (FileObject)libFolder)) {
                files.add(libFolder);
            }
        }
        return files;
    }

    public void notifyDeleting() throws IOException {
        this.clean();
    }

    private void clean() throws IOException {
        Properties p = new Properties();
        AntTargetsProvider ap = (AntTargetsProvider)this.project.getLookup().lookup(AntTargetsProvider.class);
        assert (ap != null);
        String[] targetNames = ap.getTargetNames("clean", Lookup.EMPTY, p, false);
        assert (targetNames != null);
        assert (targetNames.length > 0);
        FileObject buildXML = J2SEProjectUtil.getBuildXml(this.project);
        if (buildXML != null) {
            ActionUtils.runTarget((FileObject)buildXML, (String[])targetNames, (Properties)p).waitFinished();
        } else {
            LOG.log(Level.INFO, "Not cleaning the project: {0}, the build file: {1} does not exist.", new Object[]{ProjectUtils.getInformation((Project)this.project).getDisplayName(), J2SEProjectUtil.getBuildXmlName(this.project)});
        }
    }

    public void notifyDeleted() throws IOException {
        this.project.getAntProjectHelper().notifyDeleted();
    }

    public void notifyCopying() {
        this.rememberLibraryLocation();
        this.readPrivateProperties();
        this.rememberConfigurations();
    }

    public void notifyCopied(Project original, File originalPath, String nueName) {
        if (original == null) {
            return;
        }
        J2SEProjectOperations origOperations = (J2SEProjectOperations)original.getLookup().lookup(J2SEProjectOperations.class);
        this.fixLibraryLocation(origOperations);
        this.fixPrivateProperties(origOperations);
        this.fixDistJarProperty(nueName);
        this.fixApplicationTitle(nueName);
        this.project.getReferenceHelper().fixReferences(originalPath);
        this.updateProject.setTransparentUpdate(true);
        this.project.setName(nueName);
        this.restoreConfigurations(origOperations);
    }

    public void notifyMoving() throws IOException {
        if (!this.project.getUpdateHelper().requestUpdate()) {
            throw new IOException(NbBundle.getMessage(J2SEProjectOperations.class, (String)"MSG_OldProjectMetadata"));
        }
        this.rememberLibraryLocation();
        this.readPrivateProperties();
        this.rememberConfigurations();
        this.clean();
    }

    public void notifyMoved(Project original, File originalPath, String nueName) {
        if (original == null) {
            this.project.getAntProjectHelper().notifyDeleted();
            return;
        }
        J2SEProjectOperations origOperations = (J2SEProjectOperations)original.getLookup().lookup(J2SEProjectOperations.class);
        this.fixLibraryLocation(origOperations);
        this.fixPrivateProperties(origOperations);
        this.fixDistJarProperty(nueName);
        this.fixApplicationTitle(nueName);
        this.project.setName(nueName);
        this.project.getReferenceHelper().fixReferences(originalPath);
        this.restoreConfigurations(origOperations);
    }

    public void notifyRenaming() throws IOException {
        if (!this.project.getUpdateHelper().requestUpdate()) {
            throw new IOException(NbBundle.getMessage(J2SEProjectOperations.class, (String)"MSG_OldProjectMetadata"));
        }
        this.clean();
    }

    public void notifyRenamed(String nueName) throws IOException {
        this.fixDistJarProperty(nueName);
        this.fixApplicationTitle(nueName);
        this.project.setName(nueName);
    }

    private void fixLibraryLocation(J2SEProjectOperations original) throws IllegalArgumentException {
        String libPath = original.libraryPath;
        if (libPath != null) {
            if (!new File(libPath).isAbsolute()) {
                if (!original.libraryWithinProject) {
                    File file = original.libraryFile;
                    if (file == null) {
                        return;
                    }
                    String relativized = PropertyUtils.relativizeFile((File)FileUtil.toFile((FileObject)this.project.getProjectDirectory()), (File)file);
                    if (relativized != null) {
                        this.project.getAntProjectHelper().setLibrariesLocation(relativized);
                    } else {
                        this.project.getAntProjectHelper().setLibrariesLocation(file.getAbsolutePath());
                    }
                }
            } else if (original.libraryWithinProject && original.absolutesRelPath != null) {
                this.project.getAntProjectHelper().setLibrariesLocation(PropertyUtils.resolveFile((File)FileUtil.toFile((FileObject)this.project.getProjectDirectory()), (String)original.absolutesRelPath).getAbsolutePath());
            }
        }
    }

    private void readPrivateProperties() {
        ProjectManager.mutex().readAccess(new Runnable(){

            @Override
            public void run() {
                J2SEProjectOperations.this.privatePropsToRestore.clear();
                J2SEProjectOperations.this.backUpPrivateProp("application.args");
                J2SEProjectOperations.this.backUpPrivateProp("work.dir");
                J2SEProjectOperations.this.backUpPrivateProp("compile.on.save");
            }
        });
    }

    private void backUpPrivateProp(String propName) {
        assert (ProjectManager.mutex().isReadAccess() || ProjectManager.mutex().isWriteAccess());
        String tmp = this.project.getUpdateHelper().getProperties("nbproject/private/private.properties").getProperty(propName);
        if (tmp != null) {
            this.privatePropsToRestore.put(propName, tmp);
        }
    }

    private void fixPrivateProperties(final J2SEProjectOperations original) {
        if (original != null && !original.privatePropsToRestore.isEmpty()) {
            ProjectManager.mutex().writeAccess(new Runnable(){

                @Override
                public void run() {
                    EditableProperties ep = J2SEProjectOperations.this.project.getUpdateHelper().getProperties("nbproject/private/private.properties");
                    for (Map.Entry entry : original.privatePropsToRestore.entrySet()) {
                        ep.put((String)entry.getKey(), (String)entry.getValue());
                    }
                    J2SEProjectOperations.this.project.getUpdateHelper().putProperties("nbproject/private/private.properties", ep);
                }
            });
        }
    }

    private void fixDistJarProperty(final String newName) {
        ProjectManager.mutex().writeAccess(new Runnable(){

            @Override
            public void run() {
                ProjectInformation pi = (ProjectInformation)J2SEProjectOperations.this.project.getLookup().lookup(ProjectInformation.class);
                String oldDistJar = pi == null ? null : "${dist.dir}/" + PropertyUtils.getUsablePropertyName((String)pi.getDisplayName()) + ".jar";
                EditableProperties ep = J2SEProjectOperations.this.project.getUpdateHelper().getProperties("nbproject/project.properties");
                String propValue = ep.getProperty("dist.jar");
                if (oldDistJar != null && oldDistJar.equals(propValue)) {
                    ep.put("dist.jar", "${dist.dir}/" + PropertyUtils.getUsablePropertyName((String)newName) + ".jar");
                    J2SEProjectOperations.this.project.getUpdateHelper().putProperties("nbproject/project.properties", ep);
                }
            }
        });
    }

    private void fixApplicationTitle(final String newName) {
        ProjectManager.mutex().writeAccess(new Runnable(){

            @Override
            public void run() {
                String oldName = ProjectUtils.getInformation((Project)J2SEProjectOperations.this.project).getDisplayName();
                EditableProperties ep = J2SEProjectOperations.this.project.getUpdateHelper().getProperties("nbproject/project.properties");
                String propValue = ep.getProperty("application.title");
                if (oldName != null && oldName.equals(propValue)) {
                    ep.put("application.title", newName);
                    J2SEProjectOperations.this.project.getUpdateHelper().putProperties("nbproject/project.properties", ep);
                }
            }
        });
    }

    private void rememberLibraryLocation() {
        this.libraryWithinProject = false;
        this.absolutesRelPath = null;
        this.libraryPath = this.project.getAntProjectHelper().getLibrariesLocation();
        if (this.libraryPath != null) {
            File prjRoot = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
            this.libraryFile = PropertyUtils.resolveFile((File)prjRoot, (String)this.libraryPath);
            if (FileOwnerQuery.getOwner((URI)Utilities.toURI((File)this.libraryFile)) == this.project && this.libraryFile.getAbsolutePath().startsWith(prjRoot.getAbsolutePath())) {
                this.libraryWithinProject = true;
                FileObject fo = FileUtil.toFileObject((File)this.libraryFile);
                if (new File(this.libraryPath).isAbsolute() && fo != null) {
                    this.absolutesRelPath = FileUtil.getRelativePath((FileObject)this.project.getProjectDirectory(), (FileObject)fo);
                }
            }
        }
    }

    private void rememberConfigurations() {
        FileObject fo = this.project.getProjectDirectory().getFileObject("nbproject/private/config.properties");
        if (fo != null) {
            try {
                FileSystem fs = FileUtil.createMemoryFileSystem();
                FileUtil.copyFile((FileObject)fo, (FileObject)fs.getRoot(), (String)fo.getName());
                fo = this.project.getProjectDirectory().getFileObject("nbproject/private/configs");
                if (fo != null && fo.isFolder()) {
                    FileObject cfgs = fs.getRoot().createFolder("configs");
                    for (FileObject child : fo.getChildren()) {
                        FileUtil.copyFile((FileObject)child, (FileObject)cfgs, (String)child.getName());
                    }
                }
                this.configs = fs;
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
        }
    }

    private void restoreConfigurations(J2SEProjectOperations original) {
        FileSystem fs = original.configs;
        original.configs = null;
        if (fs != null) {
            try {
                FileObject configsFolder;
                FileObject privateFolder;
                FileObject fo = fs.getRoot().getFileObject("config.properties");
                if (fo != null && (privateFolder = FileUtil.createFolder((FileObject)this.project.getProjectDirectory(), (String)"nbproject/private")) != null) {
                    FileObject oldFile = privateFolder.getFileObject(fo.getName(), fo.getExt());
                    if (oldFile != null) {
                        privateFolder.refresh();
                        oldFile = privateFolder.getFileObject(fo.getName(), fo.getExt());
                        if (oldFile != null) {
                            oldFile.delete();
                        }
                    }
                    FileUtil.copyFile((FileObject)fo, (FileObject)privateFolder, (String)fo.getName());
                }
                if ((fo = fs.getRoot().getFileObject("configs")) != null && (configsFolder = FileUtil.createFolder((FileObject)this.project.getProjectDirectory(), (String)"nbproject/private/configs")) != null) {
                    for (FileObject child : fo.getChildren()) {
                        FileUtil.copyFile((FileObject)child, (FileObject)configsFolder, (String)child.getName());
                    }
                }
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
        }
    }
}

