/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.php.editor.api.elements.ParameterElement;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.model.nodes.FunctionDeclarationInfo;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.editor.verification.AbstractHint;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.openide.filesystems.FileObject;

public class WrongOrderOfArgsHint
extends AbstractHint {
    private static final String HINT_ID = "Wrong.Order.Of.Args.Hint";

    @Override
    void compute(PHPRuleContext context, List<Hint> hints) {
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() == null) {
            return;
        }
        FileObject fileObject = phpParseResult.getSnapshot().getSource().getFileObject();
        if (fileObject == null) {
            return;
        }
        TokenHierarchy tokenHierarchy = phpParseResult.getSnapshot().getTokenHierarchy();
        CheckVisitor checkVisitor = new CheckVisitor(fileObject, context.doc, tokenHierarchy);
        phpParseResult.getProgram().accept(checkVisitor);
        hints.addAll(checkVisitor.getHints());
    }

    public String getId() {
        return HINT_ID;
    }

    public String getDescription() {
        return Bundle.WrongOrderOfArgsHintDesc();
    }

    public String getDisplayName() {
        return Bundle.WrongOrderOfArgsHintDispName();
    }

    @Override
    public HintSeverity getDefaultSeverity() {
        return HintSeverity.WARNING;
    }

    private static class RearrangedFunctionDeclaration
    extends FunctionDeclaration {
        public RearrangedFunctionDeclaration(FunctionDeclaration node) {
            super(node.getStartOffset(), node.getEndOffset(), node.getFunctionName(), node.getFormalParameters(), node.getBody(), node.isReference());
        }

        @Override
        public List<FormalParameter> getFormalParameters() {
            LinkedList<FormalParameter> rearrangedList = new LinkedList<FormalParameter>();
            LinkedList<FormalParameter> parametersWithDefault = new LinkedList<FormalParameter>();
            for (FormalParameter param : super.getFormalParameters()) {
                if (param.getDefaultValue() == null) {
                    rearrangedList.add(param);
                    continue;
                }
                parametersWithDefault.add(param);
            }
            rearrangedList.addAll(parametersWithDefault);
            return rearrangedList;
        }
    }

    private static class RearrangeParametersFix
    implements HintFix {
        private final FunctionDeclaration node;
        private final BaseDocument doc;
        private final FunctionDeclarationInfo functionDeclarationInfo;
        private final TokenHierarchy<?> tokenHierarchy;

        public RearrangeParametersFix(BaseDocument doc, FunctionDeclaration node, TokenHierarchy<?> tokenHierarchy) {
            this.doc = doc;
            this.node = node;
            this.tokenHierarchy = tokenHierarchy;
            this.functionDeclarationInfo = FunctionDeclarationInfo.create(new RearrangedFunctionDeclaration(node));
        }

        public String getDescription() {
            return Bundle.RearrangeParamsDisp(this.functionDeclarationInfo.getName());
        }

        public void implement() throws Exception {
            EditList edits = new EditList(this.doc);
            OffsetRange offsetRange = this.getOffsetRange();
            StringBuilder sb = new StringBuilder();
            for (ParameterElement param : this.functionDeclarationInfo.getParameters()) {
                sb.append(param.asString(ParameterElement.OutputType.COMPLETE_DECLARATION)).append(", ");
            }
            edits.replace(offsetRange.getStart(), offsetRange.getLength(), sb.toString().substring(0, sb.length() - 2), true, 0);
            edits.apply();
        }

        public OffsetRange getOffsetRange() {
            int start = 0;
            int end = 0;
            TokenSequence<PHPTokenId> ts = LexUtilities.getPHPTokenSequence(this.tokenHierarchy, this.node.getStartOffset());
            if (ts != null) {
                ts.move(this.node.getStartOffset());
                int braceMatch = 0;
                while (ts.moveNext()) {
                    Token t = ts.token();
                    if (t.id() != PHPTokenId.PHP_TOKEN) continue;
                    if (((Object)t.text()).toString().equals("(")) {
                        if (braceMatch == 0) {
                            start = ts.offset() + 1;
                        }
                        ++braceMatch;
                    } else if (((Object)t.text()).toString().equals(")")) {
                        --braceMatch;
                    }
                    if (braceMatch != 0) continue;
                    end = ts.offset();
                    ts.moveNext();
                    break;
                }
            }
            return new OffsetRange(start, end);
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }
    }

    private class CheckVisitor
    extends DefaultVisitor {
        private final FileObject fileObject;
        private final List<FunctionDeclaration> wrongFunctions = new LinkedList<FunctionDeclaration>();
        private final List<Hint> hints = new LinkedList<Hint>();
        private final BaseDocument doc;
        private final TokenHierarchy<?> tokenHierarchy;

        public CheckVisitor(FileObject fileObject, BaseDocument doc, TokenHierarchy<?> tokenHierarchy) {
            this.fileObject = fileObject;
            this.doc = doc;
            this.tokenHierarchy = tokenHierarchy;
        }

        public List<Hint> getHints() {
            for (FunctionDeclaration wrongFunction : this.wrongFunctions) {
                this.processWrongFunction(wrongFunction);
            }
            return this.hints;
        }

        private void processWrongFunction(FunctionDeclaration node) {
            RearrangeParametersFix hintFix = new RearrangeParametersFix(this.doc, node, this.tokenHierarchy);
            this.hints.add(new Hint((Rule)WrongOrderOfArgsHint.this, Bundle.WrongOrderOfArgsDesc(), this.fileObject, hintFix.getOffsetRange(), Collections.singletonList(hintFix), 500));
        }

        @Override
        public void visit(FunctionDeclaration node) {
            boolean defaultValue = false;
            for (FormalParameter formalParameter : node.getFormalParameters()) {
                if (formalParameter.getDefaultValue() != null) {
                    defaultValue = true;
                    continue;
                }
                if (!defaultValue) continue;
                this.wrongFunctions.add(node);
                break;
            }
        }
    }
}

