/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.Assignment;
import org.netbeans.modules.php.editor.parser.astnodes.CastExpression;
import org.netbeans.modules.php.editor.parser.astnodes.CatchClause;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassInstanceCreation;
import org.netbeans.modules.php.editor.parser.astnodes.CloneExpression;
import org.netbeans.modules.php.editor.parser.astnodes.ConditionalExpression;
import org.netbeans.modules.php.editor.parser.astnodes.ConstantDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ContinueStatement;
import org.netbeans.modules.php.editor.parser.astnodes.DeclareStatement;
import org.netbeans.modules.php.editor.parser.astnodes.DoStatement;
import org.netbeans.modules.php.editor.parser.astnodes.EchoStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.ExpressionStatement;
import org.netbeans.modules.php.editor.parser.astnodes.FieldsDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ForEachStatement;
import org.netbeans.modules.php.editor.parser.astnodes.ForStatement;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.GotoLabel;
import org.netbeans.modules.php.editor.parser.astnodes.GotoStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.IfStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Include;
import org.netbeans.modules.php.editor.parser.astnodes.InstanceOfExpression;
import org.netbeans.modules.php.editor.parser.astnodes.InterfaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.LambdaFunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocBlock;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocMethodTag;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocStaticAccessType;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTypeTag;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocVarTypeTag;
import org.netbeans.modules.php.editor.parser.astnodes.PHPVarComment;
import org.netbeans.modules.php.editor.parser.astnodes.PostfixExpression;
import org.netbeans.modules.php.editor.parser.astnodes.PrefixExpression;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.ReflectionVariable;
import org.netbeans.modules.php.editor.parser.astnodes.ReturnStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Scalar;
import org.netbeans.modules.php.editor.parser.astnodes.SingleFieldDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.StaticFieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.StaticMethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.SwitchStatement;
import org.netbeans.modules.php.editor.parser.astnodes.ThrowStatement;
import org.netbeans.modules.php.editor.parser.astnodes.UnaryOperation;
import org.netbeans.modules.php.editor.parser.astnodes.UseStatement;
import org.netbeans.modules.php.editor.parser.astnodes.UseStatementPart;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.WhileStatement;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.editor.verification.AbstractHint;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.netbeans.modules.php.editor.verification.PHPRuleWithPreferences;
import org.netbeans.modules.php.editor.verification.UnusedVariableCustomizer;
import org.openide.filesystems.FileObject;

public class UnusedVariableHint
extends AbstractHint
implements PHPRuleWithPreferences {
    private static final String HINT_ID = "Unused.Variable.Hint";
    private static final String CHECK_UNUSED_FORMAL_PARAMETERS = "php.verification.check.unused.formal.parameters";
    private static final List<String> UNCHECKED_VARIABLES = new LinkedList<String>();
    private Preferences preferences;

    @Override
    void compute(PHPRuleContext context, List<Hint> hints) {
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() == null) {
            return;
        }
        FileObject fileObject = phpParseResult.getSnapshot().getSource().getFileObject();
        if (fileObject != null) {
            CheckVisitor checkVisitor = new CheckVisitor(fileObject);
            phpParseResult.getProgram().accept(checkVisitor);
            hints.addAll(checkVisitor.getHints());
        }
    }

    public String getId() {
        return HINT_ID;
    }

    public String getDescription() {
        return Bundle.UnusedVariableHintDesc();
    }

    public String getDisplayName() {
        return Bundle.UnusedVariableHintDispName();
    }

    @Override
    public HintSeverity getDefaultSeverity() {
        return HintSeverity.WARNING;
    }

    @Override
    public void setPreferences(Preferences preferences) {
        this.preferences = preferences;
    }

    @Override
    public JComponent getCustomizer(Preferences preferences) {
        return new UnusedVariableCustomizer(preferences, this);
    }

    public void setCheckUnusedFormalParameters(Preferences preferences, boolean isEnabled) {
        preferences.putBoolean(CHECK_UNUSED_FORMAL_PARAMETERS, isEnabled);
    }

    public boolean checkUnusedFormalParameters(Preferences preferences) {
        return preferences.getBoolean(CHECK_UNUSED_FORMAL_PARAMETERS, true);
    }

    static {
        UNCHECKED_VARIABLES.add("this");
        UNCHECKED_VARIABLES.add("GLOBALS");
        UNCHECKED_VARIABLES.add("_SERVER");
        UNCHECKED_VARIABLES.add("_GET");
        UNCHECKED_VARIABLES.add("_POST");
        UNCHECKED_VARIABLES.add("_FILES");
        UNCHECKED_VARIABLES.add("_COOKIE");
        UNCHECKED_VARIABLES.add("_SESSION");
        UNCHECKED_VARIABLES.add("_REQUEST");
        UNCHECKED_VARIABLES.add("_ENV");
    }

    private static final class HintVariable {
        private final ASTNode node;
        private final String name;

        static HintVariable create(ASTNode node, String name) {
            return new HintVariable(node, name);
        }

        private HintVariable(ASTNode node, String name) {
            this.node = node;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public int getStartOffset() {
            return this.node.getStartOffset() + 1;
        }

        public int getEndOffset() {
            return this.node.getEndOffset();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            HintVariable other = (HintVariable)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public int hashCode() {
            int hash = 7;
            hash = 19 * hash + (this.name != null ? this.name.hashCode() : 0);
            return hash;
        }
    }

    private class CheckVisitor
    extends DefaultVisitor {
        private final Stack<ASTNode> parentNodes = new Stack();
        private final Map<ASTNode, List<HintVariable>> unusedVariables = new HashMap<ASTNode, List<HintVariable>>();
        private final Map<ASTNode, List<HintVariable>> usedVariables = new HashMap<ASTNode, List<HintVariable>>();
        private final FileObject fileObject;
        private boolean forceVariableAsUsed;
        private boolean forceVariableAsUnused;

        public CheckVisitor(FileObject fileObject) {
            this.fileObject = fileObject;
        }

        public List<Hint> getHints() {
            LinkedList<Hint> hints = new LinkedList<Hint>();
            for (ASTNode scopeNode : this.unusedVariables.keySet()) {
                List<HintVariable> scopeVariables = this.unusedVariables.get(scopeNode);
                for (HintVariable variable : scopeVariables) {
                    int start = variable.getStartOffset();
                    int end = variable.getEndOffset();
                    OffsetRange offsetRange = new OffsetRange(start, end);
                    hints.add(new Hint((Rule)UnusedVariableHint.this, Bundle.UnusedVariableHintCustom(variable.getName()), this.fileObject, offsetRange, null, 500));
                }
            }
            return hints;
        }

        @CheckForNull
        private Identifier getIdentifier(Variable variable) {
            Identifier retval = null;
            if (variable != null && variable.isDollared() && variable.getName() instanceof Identifier) {
                retval = (Identifier)variable.getName();
            }
            return retval;
        }

        private List<HintVariable> getUsedScopeVariables(ASTNode parentNode) {
            List<HintVariable> usedScopeVariables = this.usedVariables.get(parentNode);
            if (usedScopeVariables == null) {
                usedScopeVariables = new LinkedList<HintVariable>();
                this.usedVariables.put(parentNode, usedScopeVariables);
            }
            return usedScopeVariables;
        }

        private List<HintVariable> getUnusedScopeVariables(ASTNode parentNode) {
            List<HintVariable> unusedScopeVariables = this.unusedVariables.get(parentNode);
            if (unusedScopeVariables == null) {
                unusedScopeVariables = new LinkedList<HintVariable>();
                this.unusedVariables.put(parentNode, unusedScopeVariables);
            }
            return unusedScopeVariables;
        }

        @CheckForNull
        private HintVariable getUnusedVariable(String currentVarName, List<HintVariable> unusedScopeVariables) {
            HintVariable retval = null;
            for (HintVariable variable : unusedScopeVariables) {
                String varName = variable.getName();
                if (!currentVarName.equals(varName)) continue;
                retval = variable;
                break;
            }
            return retval;
        }

        private boolean isVariableUsed(String currentVarName, List<HintVariable> usedScopeVariables) {
            boolean retval = false;
            for (HintVariable variable : usedScopeVariables) {
                String varName = variable.getName();
                if (!currentVarName.equals(varName)) continue;
                retval = true;
                break;
            }
            return retval;
        }

        private void forceVariableAsUnused(HintVariable node, List<HintVariable> unusedScopeVariables) {
            HintVariable unusedVariable = this.getUnusedVariable(node.getName(), unusedScopeVariables);
            if (unusedVariable != null) {
                unusedScopeVariables.remove(unusedVariable);
            }
            unusedScopeVariables.add(node);
        }

        private void forceVariableAsUsed(HintVariable hintVariable, List<HintVariable> usedScopeVariables, List<HintVariable> unusedScopeVariables) {
            String currentVarName = hintVariable.getName();
            if (this.isVariableUsed(currentVarName, usedScopeVariables)) {
                return;
            }
            usedScopeVariables.add(hintVariable);
            HintVariable unusedVariable = this.getUnusedVariable(currentVarName, unusedScopeVariables);
            if (unusedVariable != null) {
                unusedScopeVariables.remove(unusedVariable);
            }
        }

        @Override
        public void visit(Variable node) {
            Identifier identifier = this.getIdentifier(node);
            if (identifier != null) {
                this.process(HintVariable.create(node, identifier.getName()));
            }
        }

        private void process(HintVariable hintVariable) {
            if (hintVariable != null && !UNCHECKED_VARIABLES.contains(hintVariable.getName())) {
                ASTNode parentNode = this.parentNodes.peek();
                String currentVarName = hintVariable.getName();
                List<HintVariable> usedScopeVariables = this.getUsedScopeVariables(parentNode);
                List<HintVariable> unusedScopeVariables = this.getUnusedScopeVariables(parentNode);
                if (this.forceVariableAsUnused) {
                    this.forceVariableAsUnused(hintVariable, unusedScopeVariables);
                    return;
                }
                if (this.forceVariableAsUsed) {
                    this.forceVariableAsUsed(hintVariable, usedScopeVariables, unusedScopeVariables);
                    return;
                }
                if (this.isVariableUsed(currentVarName, usedScopeVariables)) {
                    return;
                }
                HintVariable unusedVariable = this.getUnusedVariable(currentVarName, unusedScopeVariables);
                if (unusedVariable != null) {
                    unusedScopeVariables.remove(unusedVariable);
                    usedScopeVariables.add(hintVariable);
                    return;
                }
                unusedScopeVariables.add(hintVariable);
            }
        }

        @Override
        public void visit(Program node) {
            this.parentNodes.push(node);
            super.visit(node);
            this.parentNodes.pop();
        }

        @Override
        public void visit(NamespaceDeclaration node) {
            this.parentNodes.push(node);
            super.visit(node);
            this.parentNodes.pop();
        }

        @Override
        public void visit(FunctionDeclaration node) {
            if (node.getBody() != null) {
                this.parentNodes.push(node);
                super.visit(node);
                this.parentNodes.pop();
            }
        }

        @Override
        public void visit(EchoStatement node) {
            this.forceVariableAsUsed = true;
            this.scan(node.getExpressions());
            this.forceVariableAsUsed = false;
        }

        @Override
        public void visit(ExpressionStatement node) {
            if (node.getExpression() instanceof Variable) {
                this.forceVariableAsUnused = true;
                this.scan(node.getExpression());
                this.forceVariableAsUnused = false;
            } else {
                this.scan(node.getExpression());
            }
        }

        @Override
        public void visit(Include node) {
            this.forceVariableAsUsed = true;
            this.scan(node.getExpression());
            this.forceVariableAsUsed = false;
        }

        @Override
        public void visit(FunctionInvocation node) {
            this.forceVariableAsUsed = true;
            String functionName = CodeUtils.extractFunctionName(node);
            if ("compact".equals(functionName)) {
                this.handleCompactFunction(node);
            }
            super.visit(node);
            this.forceVariableAsUsed = false;
        }

        private void handleCompactFunction(FunctionInvocation node) {
            List<Expression> parameters = node.getParameters();
            for (Expression parameter : parameters) {
                this.handleFunctionParameter(parameter);
            }
        }

        private void handleFunctionParameter(Expression parameter) {
            if (parameter instanceof Scalar) {
                this.handleScalar((Scalar)parameter);
            }
        }

        private void handleScalar(Scalar scalar) {
            if (scalar.getScalarType().equals((Object)Scalar.Type.STRING)) {
                this.process(HintVariable.create(scalar, this.extractVariableName(scalar.getStringValue())));
            }
        }

        private String extractVariableName(String quotedValue) {
            String result = quotedValue;
            if (quotedValue.startsWith("'") && quotedValue.endsWith("'") || quotedValue.startsWith("\"") && quotedValue.endsWith("\"")) {
                result = quotedValue.substring(1, quotedValue.length() - 1);
            }
            return result;
        }

        @Override
        public void visit(MethodInvocation node) {
            this.forceVariableAsUsed = true;
            this.scan(node.getDispatcher());
            this.forceVariableAsUsed = false;
            this.scan(node.getMethod());
        }

        @Override
        public void visit(IfStatement node) {
            this.forceVariableAsUsed = true;
            this.scan(node.getCondition());
            this.forceVariableAsUsed = false;
            this.scan(node.getTrueStatement());
            this.scan(node.getFalseStatement());
        }

        @Override
        public void visit(InstanceOfExpression node) {
            this.forceVariableAsUsed = true;
            this.scan(node.getExpression());
            this.scan(node.getClassName());
            this.forceVariableAsUsed = false;
        }

        @Override
        public void visit(PostfixExpression node) {
            this.forceVariableAsUsed = true;
            this.scan(node.getVariable());
            this.forceVariableAsUsed = false;
        }

        @Override
        public void visit(PrefixExpression node) {
            this.forceVariableAsUsed = true;
            this.scan(node.getVariable());
            this.forceVariableAsUsed = false;
        }

        @Override
        public void visit(ReflectionVariable node) {
            this.forceVariableAsUsed = true;
            this.scan(node.getName());
            this.forceVariableAsUsed = false;
        }

        @Override
        public void visit(CloneExpression node) {
            this.forceVariableAsUsed = true;
            this.scan(node.getExpression());
            this.forceVariableAsUsed = false;
        }

        @Override
        public void visit(CastExpression node) {
            this.forceVariableAsUsed = true;
            this.scan(node.getExpression());
            this.forceVariableAsUsed = false;
        }

        @Override
        public void visit(Assignment node) {
            this.scan(node.getLeftHandSide());
            this.forceVariableAsUsed = true;
            this.scan(node.getRightHandSide());
            this.forceVariableAsUsed = false;
        }

        @Override
        public void visit(ConditionalExpression node) {
            this.forceVariableAsUsed = true;
            this.scan(node.getCondition());
            this.scan(node.getIfTrue());
            this.scan(node.getIfFalse());
            this.forceVariableAsUsed = false;
        }

        @Override
        public void visit(ReturnStatement node) {
            this.forceVariableAsUsed = true;
            this.scan(node.getExpression());
            this.forceVariableAsUsed = false;
        }

        @Override
        public void visit(SwitchStatement node) {
            this.forceVariableAsUsed = true;
            this.scan(node.getExpression());
            this.forceVariableAsUsed = false;
            this.scan(node.getBody());
        }

        @Override
        public void visit(ThrowStatement node) {
            this.forceVariableAsUsed = true;
            this.scan(node.getExpression());
            this.forceVariableAsUsed = false;
        }

        @Override
        public void visit(UnaryOperation node) {
            this.forceVariableAsUsed = true;
            this.scan(node.getExpression());
            this.forceVariableAsUsed = false;
        }

        @Override
        public void visit(ClassDeclaration node) {
            this.scan(node.getBody());
        }

        @Override
        public void visit(ClassInstanceCreation node) {
            this.forceVariableAsUsed = true;
            this.scan(node.getClassName());
            this.scan(node.ctorParams());
            this.forceVariableAsUsed = false;
        }

        @Override
        public void visit(DoStatement node) {
            this.forceVariableAsUsed = true;
            this.scan(node.getCondition());
            this.forceVariableAsUsed = false;
            this.scan(node.getBody());
        }

        @Override
        public void visit(DeclareStatement node) {
            this.scan(node.getBody());
        }

        @Override
        public void visit(CatchClause node) {
            this.scan(node.getVariable());
            this.scan(node.getBody());
        }

        @Override
        public void visit(FormalParameter node) {
            if (UnusedVariableHint.this.checkUnusedFormalParameters(UnusedVariableHint.this.preferences)) {
                this.scan(node.getParameterName());
            } else {
                this.forceVariableAsUsed = true;
                this.scan(node.getParameterName());
                this.forceVariableAsUsed = false;
            }
        }

        @Override
        public void visit(ForEachStatement node) {
            this.forceVariableAsUsed = true;
            this.scan(node.getExpression());
            this.forceVariableAsUsed = false;
            this.scan(node.getKey());
            this.scan(node.getValue());
            this.scan(node.getStatement());
        }

        @Override
        public void visit(ForStatement node) {
            this.forceVariableAsUsed = true;
            this.scan(node.getInitializers());
            this.scan(node.getConditions());
            this.scan(node.getUpdaters());
            this.forceVariableAsUsed = false;
            this.scan(node.getBody());
        }

        @Override
        public void visit(StaticMethodInvocation node) {
            this.forceVariableAsUsed = true;
            this.scan(node.getClassName());
            this.forceVariableAsUsed = false;
            this.scan(node.getMethod());
        }

        @Override
        public void visit(WhileStatement node) {
            this.forceVariableAsUsed = true;
            this.scan(node.getCondition());
            this.forceVariableAsUsed = false;
            this.scan(node.getBody());
        }

        @Override
        public void visit(LambdaFunctionDeclaration node) {
            this.forceVariableAsUsed = true;
            this.scan(node.getLexicalVariables());
            this.forceVariableAsUsed = false;
            this.parentNodes.push(node);
            this.scan(node.getLexicalVariables());
            this.scan(node.getFormalParameters());
            this.scan(node.getBody());
            this.parentNodes.pop();
        }

        @Override
        public void visit(StaticFieldAccess node) {
            this.forceVariableAsUsed = true;
            super.visit(node);
            this.forceVariableAsUsed = false;
        }

        @Override
        public void visit(InterfaceDeclaration node) {
        }

        @Override
        public void visit(FieldsDeclaration node) {
        }

        @Override
        public void visit(PHPDocBlock node) {
        }

        @Override
        public void visit(PHPDocTypeTag node) {
        }

        @Override
        public void visit(PHPDocMethodTag node) {
        }

        @Override
        public void visit(PHPDocVarTypeTag node) {
        }

        @Override
        public void visit(PHPDocStaticAccessType node) {
        }

        @Override
        public void visit(PHPVarComment node) {
        }

        @Override
        public void visit(ConstantDeclaration node) {
        }

        @Override
        public void visit(ContinueStatement node) {
        }

        @Override
        public void visit(SingleFieldDeclaration node) {
        }

        @Override
        public void visit(UseStatement node) {
        }

        @Override
        public void visit(UseStatementPart node) {
        }

        @Override
        public void visit(GotoLabel node) {
        }

        @Override
        public void visit(GotoStatement node) {
        }
    }
}

