/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.AnonymousObjectVariable;
import org.netbeans.modules.php.editor.parser.astnodes.DereferencedArrayAccess;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.LambdaFunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.ReflectionVariable;
import org.netbeans.modules.php.editor.parser.astnodes.Scalar;
import org.netbeans.modules.php.editor.parser.astnodes.StaticMethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.TraitDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.UseTraitStatement;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.editor.verification.AbstractUnhandledError;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.netbeans.modules.php.editor.verification.PHPVerificationError;
import org.openide.filesystems.FileObject;

public class PHP54UnhandledError
extends AbstractUnhandledError {
    @Override
    void compute(PHPRuleContext context, List<Error> errors) {
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() == null) {
            return;
        }
        FileObject fileObject = phpParseResult.getSnapshot().getSource().getFileObject();
        if (fileObject != null && PHP54UnhandledError.appliesTo(fileObject)) {
            CheckVisitor checkVisitor = new CheckVisitor(fileObject);
            phpParseResult.getProgram().accept(checkVisitor);
            errors.addAll(checkVisitor.getErrors());
        }
    }

    public static boolean appliesTo(FileObject fobj) {
        return !CodeUtils.isPhp54(fobj);
    }

    public String getDisplayName() {
        return Bundle.PHP54VersionErrorHintDispName();
    }

    private static final class PHP54VersionError
    extends PHPVerificationError {
        private static final String KEY = "Php.Version.54";

        private PHP54VersionError(FileObject fileObject, int startOffset, int endOffset) {
            super(fileObject, startOffset, endOffset);
        }

        public String getDisplayName() {
            return Bundle.CheckPHP54VerDisp();
        }

        public String getDescription() {
            return Bundle.CheckPHP54VerDesc();
        }

        public String getKey() {
            return KEY;
        }
    }

    private static class CheckVisitor
    extends DefaultVisitor {
        private List<PHPVerificationError> errors = new ArrayList<PHPVerificationError>();
        private static final String BINARY_PREFIX = "0b";
        private boolean checkAnonymousObjectVariable;
        private final FileObject fileObject;

        public CheckVisitor(FileObject fileObject) {
            this.fileObject = fileObject;
        }

        public Collection<PHPVerificationError> getErrors() {
            return Collections.unmodifiableCollection(this.errors);
        }

        @Override
        public void visit(TraitDeclaration node) {
            Identifier name = node.getName();
            if (name != null) {
                this.createError(name);
            } else {
                this.createError(node);
            }
        }

        @Override
        public void visit(UseTraitStatement node) {
            this.createError(node);
        }

        @Override
        public void visit(MethodInvocation node) {
            this.checkAnonymousObjectVariable = true;
            super.visit(node);
            this.checkAnonymousObjectVariable = false;
        }

        @Override
        public void visit(FieldAccess node) {
            this.checkAnonymousObjectVariable = true;
            super.visit(node);
            this.checkAnonymousObjectVariable = false;
        }

        @Override
        public void visit(AnonymousObjectVariable node) {
            if (this.checkAnonymousObjectVariable) {
                this.createError(node);
            }
        }

        @Override
        public void visit(DereferencedArrayAccess node) {
            this.createError(node);
        }

        @Override
        public void visit(Scalar node) {
            if (node.getScalarType().equals((Object)Scalar.Type.REAL) && node.getStringValue().startsWith(BINARY_PREFIX)) {
                this.createError(node);
            }
        }

        @Override
        public void visit(StaticMethodInvocation node) {
            Expression name = node.getMethod().getFunctionName().getName();
            if (name instanceof ReflectionVariable) {
                this.createError(name);
            }
        }

        @Override
        public void visit(LambdaFunctionDeclaration node) {
            if (node.isStatic()) {
                this.createError(node);
            }
        }

        private void createError(int startOffset, int endOffset) {
            PHP54VersionError error = new PHP54VersionError(this.fileObject, startOffset, endOffset);
            this.errors.add(error);
        }

        private void createError(ASTNode node) {
            this.createError(node.getStartOffset(), node.getEndOffset());
            super.visit(node);
        }
    }
}

