/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.UiUtils;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.PHPCompletionItem;
import org.netbeans.modules.php.editor.api.ElementQuery;
import org.netbeans.modules.php.editor.api.NameKind;
import org.netbeans.modules.php.editor.api.PhpElementKind;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.elements.BaseFunctionElement;
import org.netbeans.modules.php.editor.api.elements.ClassElement;
import org.netbeans.modules.php.editor.api.elements.ElementFilter;
import org.netbeans.modules.php.editor.api.elements.FieldElement;
import org.netbeans.modules.php.editor.api.elements.MethodElement;
import org.netbeans.modules.php.editor.api.elements.TypeConstantElement;
import org.netbeans.modules.php.editor.elements.MethodElementImpl;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.model.ClassMemberElement;
import org.netbeans.modules.php.editor.model.ClassScope;
import org.netbeans.modules.php.editor.model.MethodScope;
import org.netbeans.modules.php.editor.model.Model;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassInstanceCreation;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.MethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.StaticConstantAccess;
import org.netbeans.modules.php.editor.parser.astnodes.StaticFieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.StaticMethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.VariableBase;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultTreePathVisitor;
import org.netbeans.modules.php.editor.verification.AbstractSuggestion;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;

public class IntroduceSuggestion
extends AbstractSuggestion {
    private static final String UNKNOWN_FILE_NAME = "?";

    public String getId() {
        return "Introduce.Hint";
    }

    public String getDescription() {
        return Bundle.IntroduceHintDesc();
    }

    public String getDisplayName() {
        return Bundle.IntroduceHintDispName();
    }

    @Override
    void compute(PHPRuleContext context, List<Hint> hints, int caretOffset) throws BadLocationException {
        int lineEnd;
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() == null) {
            return;
        }
        FileObject fileObject = phpParseResult.getSnapshot().getSource().getFileObject();
        if (fileObject == null) {
            return;
        }
        BaseDocument doc = context.doc;
        int lineBegin = caretOffset > 0 ? Utilities.getRowStart((BaseDocument)doc, (int)caretOffset) : -1;
        int n = lineEnd = lineBegin != -1 ? Utilities.getRowEnd((BaseDocument)doc, (int)caretOffset) : -1;
        if (lineBegin != -1 && lineEnd != -1 && caretOffset > lineBegin) {
            Model model = phpParseResult.getModel();
            IntroduceFixVisitor introduceFixVisitor = new IntroduceFixVisitor(model, lineBegin, lineEnd);
            phpParseResult.getProgram().accept(introduceFixVisitor);
            IntroduceFix variableFix = introduceFixVisitor.getIntroduceFix();
            if (variableFix != null) {
                hints.add(new Hint((Rule)this, this.getDisplayName(), fileObject, variableFix.getOffsetRange(), Collections.singletonList(variableFix), 500));
            }
        }
    }

    private static boolean isInside(int carret, int left, int right) {
        return carret >= left && carret <= right;
    }

    private static boolean isBefore(int carret, int margin) {
        return carret <= margin;
    }

    private static String getParameters(List<Expression> parameters) {
        StringBuilder paramNames = new StringBuilder();
        for (int i = 0; i < parameters.size(); ++i) {
            Expression expression = parameters.get(i);
            String varName = null;
            if (expression instanceof Variable) {
                varName = CodeUtils.extractVariableName((Variable)expression);
            }
            if (varName == null) {
                varName = String.format("$param%d", i);
            }
            if (i > 0) {
                paramNames.append(", ");
            }
            paramNames.append(varName);
        }
        return paramNames.toString();
    }

    private static int getOffset(BaseDocument doc, TypeScope typeScope, PhpElementKind kind) throws BadLocationException {
        int offset = -1;
        HashSet<ClassMemberElement> elements = new HashSet<ClassMemberElement>();
        elements.addAll(typeScope.getDeclaredConstants());
        switch (kind) {
            case METHOD: {
                if (!(typeScope instanceof ClassScope)) break;
                ClassScope clz = (ClassScope)typeScope;
                elements.addAll(clz.getDeclaredFields());
                elements.addAll(clz.getDeclaredMethods());
                break;
            }
            case FIELD: {
                if (!(typeScope instanceof ClassScope)) break;
                ClassScope clz = (ClassScope)typeScope;
                elements.addAll(clz.getDeclaredFields());
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        for (ModelElement modelElement : elements) {
            int newOffset = modelElement.getOffset();
            newOffset = modelElement instanceof MethodScope ? IntroduceSuggestion.getOffsetAfterBlockCloseCurly(doc, newOffset) : IntroduceSuggestion.getOffsetAfterNextSemicolon(doc, newOffset);
            if (newOffset <= offset) continue;
            offset = newOffset;
        }
        if (offset == -1) {
            offset = IntroduceSuggestion.getOffsetAfterClassOpenCurly(doc, typeScope.getOffset());
        }
        return offset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getOffsetAfterBlockCloseCurly(BaseDocument doc, int offset) throws BadLocationException {
        int retval;
        block7: {
            retval = offset;
            doc.readLock();
            try {
                TokenSequence<PHPTokenId> ts = LexUtilities.getPHPTokenSequence((Document)doc, retval);
                if (ts == null) break block7;
                ts.move(retval);
                int curlyMatch = 0;
                while (ts.moveNext()) {
                    Token t = ts.token();
                    if (t.id() != PHPTokenId.PHP_CURLY_OPEN && t.id() != PHPTokenId.PHP_CURLY_CLOSE) continue;
                    if (t.id() == PHPTokenId.PHP_CURLY_OPEN) {
                        ++curlyMatch;
                    } else if (t.id() == PHPTokenId.PHP_CURLY_CLOSE) {
                        --curlyMatch;
                    }
                    if (curlyMatch != 0) continue;
                    ts.moveNext();
                    retval = ts.offset();
                    break;
                }
            }
            finally {
                doc.readUnlock();
            }
        }
        return retval;
    }

    private static int getOffsetAfterNextSemicolon(BaseDocument doc, int offset) throws BadLocationException {
        return IntroduceSuggestion.getOffsetAfterNextTokenId(doc, offset, PHPTokenId.PHP_SEMICOLON);
    }

    private static int getOffsetAfterClassOpenCurly(BaseDocument doc, int offset) throws BadLocationException {
        return IntroduceSuggestion.getOffsetAfterNextTokenId(doc, offset, PHPTokenId.PHP_CURLY_OPEN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getOffsetAfterNextTokenId(BaseDocument doc, int offset, PHPTokenId tokenId) throws BadLocationException {
        int retval;
        block4: {
            retval = offset;
            doc.readLock();
            try {
                TokenSequence<PHPTokenId> ts = LexUtilities.getPHPTokenSequence((Document)doc, retval);
                if (ts == null) break block4;
                ts.move(retval);
                while (ts.moveNext()) {
                    Token t = ts.token();
                    if (t.id() != tokenId) continue;
                    ts.moveNext();
                    retval = ts.offset();
                    break;
                }
            }
            finally {
                doc.readUnlock();
            }
        }
        return retval;
    }

    private static PHPCompletionItem.MethodDeclarationItem createMethodDeclarationItem(TypeScope typeScope, MethodInvocation node) {
        String methodName = CodeUtils.extractFunctionName(node.getMethod());
        MethodElement method = MethodElementImpl.createMagicMethod(typeScope, methodName, 0, IntroduceSuggestion.getParameters(node.getMethod().getParameters()));
        return PHPCompletionItem.MethodDeclarationItem.forIntroduceHint(method, null);
    }

    private static PHPCompletionItem.MethodDeclarationItem createMethodDeclarationItem(TypeScope typeScope, StaticMethodInvocation node) {
        String methodName = CodeUtils.extractFunctionName(node.getMethod());
        MethodElement method = MethodElementImpl.createMagicMethod(typeScope, methodName, 8, IntroduceSuggestion.getParameters(node.getMethod().getParameters()));
        return PHPCompletionItem.MethodDeclarationItem.forIntroduceHint(method, null);
    }

    static abstract class IntroduceFix
    implements HintFix {
        BaseDocument doc;
        ASTNode node;

        public IntroduceFix(BaseDocument doc, ASTNode node) {
            this.doc = doc;
            this.node = node;
        }

        OffsetRange getOffsetRange() {
            return new OffsetRange(this.node.getStartOffset(), this.node.getEndOffset());
        }

        public boolean isInteractive() {
            return false;
        }

        public boolean isSafe() {
            return true;
        }
    }

    private static class IntroduceClassConstantFix
    extends IntroduceFix {
        private TypeScope type;
        private String templ;
        private String constantName;

        public IntroduceClassConstantFix(BaseDocument doc, StaticConstantAccess node, TypeScope type) {
            super(doc, node);
            this.type = type;
            this.constantName = node.getConstant().getName();
            this.templ = String.format("const %s = \"\";", this.constantName);
        }

        public void implement() throws Exception {
            int templateOffset = this.getOffset();
            EditList edits = new EditList(this.doc);
            edits.replace(templateOffset, 0, "\n" + this.templ, true, 0);
            edits.apply();
            templateOffset = Utilities.getRowEnd((BaseDocument)this.doc, (int)(templateOffset + 1)) - 2;
            UiUtils.open((FileObject)this.type.getFileObject(), (int)templateOffset);
        }

        public String getDescription() {
            String clsName = this.type.getName();
            FileObject fileObject = this.type.getFileObject();
            String fileName = fileObject == null ? IntroduceSuggestion.UNKNOWN_FILE_NAME : fileObject.getNameExt();
            return Bundle.IntroduceHintClassConstDesc(this.constantName, clsName, fileName);
        }

        int getOffset() throws BadLocationException {
            return IntroduceSuggestion.getOffset(this.doc, this.type, PhpElementKind.TYPE_CONSTANT);
        }
    }

    private static class IntroduceStaticFieldFix
    extends IntroduceFix {
        private ClassScope clz;
        private String templ;
        private String fieldName;

        public IntroduceStaticFieldFix(BaseDocument doc, StaticFieldAccess node, ClassScope clz) {
            super(doc, node);
            this.clz = clz;
            this.templ = this.createTemplate();
        }

        public void implement() throws Exception {
            int templateOffset = this.getOffset();
            EditList edits = new EditList(this.doc);
            edits.replace(templateOffset, 0, "\n" + this.templ, true, 0);
            edits.apply();
            templateOffset = Utilities.getRowEnd((BaseDocument)this.doc, (int)(templateOffset + 1)) - 2;
            UiUtils.open((FileObject)this.clz.getFileObject(), (int)templateOffset);
        }

        public String getDescription() {
            String clsName = this.clz.getName();
            FileObject fileObject = this.clz.getFileObject();
            String fileName = fileObject == null ? IntroduceSuggestion.UNKNOWN_FILE_NAME : fileObject.getNameExt();
            return Bundle.IntroduceHintStaticFieldDesc(this.fieldName, clsName, fileName);
        }

        int getOffset() throws BadLocationException {
            return IntroduceSuggestion.getOffset(this.doc, this.clz, PhpElementKind.FIELD);
        }

        private String createTemplate() {
            Variable fieldVar = ((StaticFieldAccess)this.node).getField();
            this.fieldName = CodeUtils.extractVariableName(fieldVar);
            if (!fieldVar.isDollared()) {
                this.fieldName = "$" + this.fieldName;
            }
            return String.format("static %s = \"\";", this.fieldName);
        }
    }

    private static class IntroduceFieldFix
    extends IntroduceFix {
        private ClassScope clz;
        private String templ;
        private String fieldName;
        private final VariableBase dispatcher;

        public IntroduceFieldFix(BaseDocument doc, FieldAccess node, ClassScope clz) {
            super(doc, node);
            this.clz = clz;
            this.dispatcher = node.getDispatcher();
            this.templ = this.createTemplate();
        }

        public void implement() throws Exception {
            int templateOffset = this.getOffset();
            EditList edits = new EditList(this.doc);
            edits.replace(templateOffset, 0, "\n" + this.templ, true, 0);
            edits.apply();
            templateOffset = Utilities.getRowEnd((BaseDocument)this.doc, (int)(templateOffset + 1)) - 2;
            UiUtils.open((FileObject)this.clz.getFileObject(), (int)templateOffset);
        }

        public String getDescription() {
            String clsName = this.clz.getName();
            FileObject fileObject = this.clz.getFileObject();
            String fileName = fileObject == null ? IntroduceSuggestion.UNKNOWN_FILE_NAME : fileObject.getNameExt();
            return Bundle.IntroduceHintFieldDesc(this.templ, clsName, fileName);
        }

        int getOffset() throws BadLocationException {
            return IntroduceSuggestion.getOffset(this.doc, this.clz, PhpElementKind.FIELD);
        }

        private String createTemplate() {
            Variable fieldVar = ((FieldAccess)this.node).getField();
            this.fieldName = CodeUtils.extractVariableName(fieldVar);
            if (!fieldVar.isDollared()) {
                this.fieldName = "$" + this.fieldName;
            }
            return String.format("%s %s;", this.isInternal() ? "private" : "public", this.fieldName);
        }

        private boolean isInternal() {
            boolean result = false;
            if (this.dispatcher instanceof Variable) {
                Variable variable = (Variable)this.dispatcher;
                String dispatcherName = CodeUtils.extractVariableName(variable);
                result = "$this".equals(dispatcherName);
            }
            return result;
        }
    }

    private static class IntroduceStaticMethodFix
    extends IntroduceFix {
        private TypeScope type;
        private PHPCompletionItem.MethodDeclarationItem item;

        public IntroduceStaticMethodFix(BaseDocument doc, StaticMethodInvocation node, TypeScope type) {
            super(doc, node);
            this.type = type;
            this.item = IntroduceSuggestion.createMethodDeclarationItem(type, node);
        }

        public void implement() throws Exception {
            int templateOffset = this.getOffset();
            EditList edits = new EditList(this.doc);
            edits.replace(templateOffset, 0, "\n" + this.item.getCustomInsertTemplate(), true, 0);
            edits.apply();
            templateOffset = Utilities.getRowEnd((BaseDocument)this.doc, (int)(templateOffset + 1));
            UiUtils.open((FileObject)this.type.getFileObject(), (int)(Utilities.getRowEnd((BaseDocument)this.doc, (int)(templateOffset + 1)) - 1));
        }

        public String getDescription() {
            String clsName = this.type.getName();
            FileObject fileObject = this.type.getFileObject();
            String fileName = fileObject == null ? IntroduceSuggestion.UNKNOWN_FILE_NAME : fileObject.getNameExt();
            return Bundle.IntroduceHintStaticMethodDesc(this.item.getMethod().asString(BaseFunctionElement.PrintAs.NameAndParamsDeclaration), clsName, fileName);
        }

        int getOffset() throws BadLocationException {
            return IntroduceSuggestion.getOffset(this.doc, this.type, PhpElementKind.METHOD);
        }
    }

    private static class IntroduceMethodFix
    extends IntroduceFix {
        private TypeScope type;
        private PHPCompletionItem.MethodDeclarationItem item;

        public IntroduceMethodFix(BaseDocument doc, MethodInvocation node, TypeScope type) {
            super(doc, node);
            this.type = type;
            this.item = IntroduceSuggestion.createMethodDeclarationItem(type, node);
        }

        public void implement() throws Exception {
            int templateOffset = this.getOffset();
            EditList edits = new EditList(this.doc);
            edits.replace(templateOffset, 0, "\n" + this.item.getCustomInsertTemplate(), true, 0);
            edits.apply();
            templateOffset = Utilities.getRowEnd((BaseDocument)this.doc, (int)(templateOffset + 1));
            UiUtils.open((FileObject)this.type.getFileObject(), (int)(Utilities.getRowEnd((BaseDocument)this.doc, (int)(templateOffset + 1)) - 1));
        }

        public String getDescription() {
            String clsName = this.type.getName();
            FileObject fileObject = this.type.getFileObject();
            String fileName = fileObject == null ? IntroduceSuggestion.UNKNOWN_FILE_NAME : fileObject.getNameExt();
            return Bundle.IntroduceHintMethodDesc(this.item.getMethod().asString(BaseFunctionElement.PrintAs.NameAndParamsDeclaration), clsName, fileName);
        }

        int getOffset() throws BadLocationException {
            return IntroduceSuggestion.getOffset(this.doc, this.type, PhpElementKind.METHOD);
        }
    }

    private static class IntroduceClassFix
    extends IntroduceFix {
        private String clsName;
        private FileObject folder;
        private FileObject template;

        static IntroduceClassFix getInstance(String className, Model model, ClassInstanceCreation instanceCreation) {
            FileObject currentFile = model.getFileScope().getFileObject();
            FileObject folder = currentFile == null ? null : currentFile.getParent();
            String templatePath = "Templates/Scripting/PHPClass.php";
            FileObject template = FileUtil.getConfigFile((String)templatePath);
            return template != null && folder != null && folder.canWrite() ? new IntroduceClassFix(className, template, folder, instanceCreation) : null;
        }

        IntroduceClassFix(String className, FileObject template, FileObject folder, ClassInstanceCreation instanceCreation) {
            super(null, instanceCreation);
            this.clsName = className;
            this.template = template;
            this.folder = folder;
        }

        public void implement() throws Exception {
            final DataFolder dataFolder = DataFolder.findFolder((FileObject)this.folder);
            final DataObject configDataObject = DataObject.find((FileObject)this.template);
            final FileObject[] clsFo = new FileObject[1];
            FileUtil.runAtomicAction((Runnable)new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        DataObject clsDataObject = configDataObject.createFromTemplate(dataFolder, IntroduceClassFix.this.clsName);
                        clsFo[0] = clsDataObject.getPrimaryFile();
                        FileObject fo = clsFo[0];
                        FileLock lock = fo.lock();
                        try {
                            fo.rename(lock, fo.getName(), "php");
                        }
                        finally {
                            lock.releaseLock();
                        }
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            });
            if (clsFo[0] != null) {
                UiUtils.open((FileObject)clsFo[0], (int)0);
            }
        }

        public String getDescription() {
            String fileName = FileUtil.getFileDisplayName((FileObject)this.folder);
            int length = fileName.length();
            if (length > 30) {
                int indexOf = (fileName = fileName.substring(length - 30)).indexOf("/");
                if (indexOf != -1) {
                    fileName = fileName.substring(indexOf);
                }
                fileName = String.format("...%s/%s.php", fileName, this.clsName);
            }
            return Bundle.IntroduceHintClassDesc(this.clsName, fileName);
        }
    }

    private static class IntroduceFixVisitor
    extends DefaultTreePathVisitor {
        private int lineBegin;
        private int lineEnd;
        private IntroduceFix fix;
        private Model model;

        IntroduceFixVisitor(Model model, int lineBegin, int lineEnd) {
            this.lineBegin = lineBegin;
            this.lineEnd = lineEnd;
            this.model = model;
        }

        @Override
        public void scan(ASTNode node) {
            if (node != null && IntroduceSuggestion.isBefore(node.getStartOffset(), this.lineEnd)) {
                super.scan(node);
            }
        }

        @Override
        public void visit(ClassInstanceCreation instanceCreation) {
            if (IntroduceSuggestion.isInside(instanceCreation.getStartOffset(), this.lineBegin, this.lineEnd)) {
                ClassElement clz;
                String clzName = CodeUtils.extractClassName(instanceCreation.getClassName());
                clzName = clzName != null && clzName.trim().length() > 0 ? clzName : null;
                ElementQuery.Index index = this.model.getIndexScope().getIndex();
                Set<Object> classes = Collections.emptySet();
                if (StringUtils.hasText((String)clzName)) {
                    classes = index.getClasses(NameKind.exact(clzName));
                }
                if (clzName != null && classes.isEmpty() && (clz = this.getIndexedClass(clzName)) == null) {
                    this.fix = IntroduceClassFix.getInstance(clzName, this.model, instanceCreation);
                }
            }
            super.visit(instanceCreation);
        }

        @Override
        public void visit(MethodInvocation methodInvocation) {
            Collection<? extends TypeScope> allTypes;
            String methName;
            if (IntroduceSuggestion.isInside(methodInvocation.getStartOffset(), this.lineBegin, this.lineEnd) && StringUtils.hasText((String)(methName = CodeUtils.extractFunctionName(methodInvocation.getMethod()))) && (allTypes = ModelUtils.resolveType(this.model, methodInvocation)).size() == 1) {
                TypeScope type = ModelUtils.getFirst(allTypes);
                ElementQuery.Index index = this.model.getIndexScope().getIndex();
                Set<MethodElement> allMethods = ElementFilter.forName(NameKind.exact(methName)).filter(index.getAllMethods(type));
                if (allMethods.isEmpty()) {
                    BaseDocument document;
                    FileObject fileObject = type.getFileObject();
                    BaseDocument baseDocument = document = fileObject != null ? GsfUtilities.getDocument((FileObject)fileObject, (boolean)true) : null;
                    if (document != null && fileObject.canWrite()) {
                        this.fix = new IntroduceMethodFix(document, methodInvocation, type);
                    }
                }
            }
            super.visit(methodInvocation);
        }

        @Override
        public void visit(StaticMethodInvocation methodInvocation) {
            if (IntroduceSuggestion.isInside(methodInvocation.getStartOffset(), this.lineBegin, this.lineEnd)) {
                Collection<? extends TypeScope> allTypes;
                String methName = CodeUtils.extractFunctionName(methodInvocation.getMethod());
                String clzName = CodeUtils.extractUnqualifiedClassName(methodInvocation);
                if (clzName != null && StringUtils.hasText((String)methName) && (allTypes = ModelUtils.resolveType(this.model, methodInvocation)).size() == 1) {
                    ElementFilter staticFilter;
                    TypeScope type = ModelUtils.getFirst(allTypes);
                    ElementQuery.Index index = this.model.getIndexScope().getIndex();
                    ElementFilter nameFilter = ElementFilter.forName(NameKind.exact(methName));
                    Set<MethodElement> allMethods = ElementFilter.allOf(nameFilter, staticFilter = ElementFilter.forStaticModifiers(true)).filter(index.getAllMethods(type));
                    if (allMethods.isEmpty()) {
                        BaseDocument document;
                        FileObject fileObject = type.getFileObject();
                        BaseDocument baseDocument = document = fileObject != null ? GsfUtilities.getDocument((FileObject)fileObject, (boolean)true) : null;
                        if (document != null && fileObject.canWrite()) {
                            this.fix = new IntroduceStaticMethodFix(document, methodInvocation, type);
                        }
                    }
                }
            }
            super.visit(methodInvocation);
        }

        @Override
        public void visit(FieldAccess fieldAccess) {
            Collection<? extends TypeScope> allTypes;
            String fieldName;
            if (IntroduceSuggestion.isInside(fieldAccess.getStartOffset(), this.lineBegin, this.lineEnd) && StringUtils.hasText((String)(fieldName = CodeUtils.extractVariableName(fieldAccess.getField()))) && (allTypes = ModelUtils.resolveType(this.model, fieldAccess)).size() == 1) {
                TypeScope type = ModelUtils.getFirst(allTypes);
                ElementQuery.Index index = this.model.getIndexScope().getIndex();
                Set<FieldElement> allFields = ElementFilter.forName(NameKind.exact(fieldName)).filter(index.getAlllFields(type));
                if (allFields.isEmpty()) {
                    BaseDocument document;
                    FileObject fileObject = type.getFileObject();
                    BaseDocument baseDocument = document = fileObject != null ? GsfUtilities.getDocument((FileObject)fileObject, (boolean)false) : null;
                    if (document != null && fileObject.canWrite() && type instanceof ClassScope) {
                        this.fix = new IntroduceFieldFix(document, fieldAccess, (ClassScope)type);
                    }
                }
            }
            super.visit(fieldAccess);
        }

        @Override
        public void visit(StaticFieldAccess fieldAccess) {
            if (IntroduceSuggestion.isInside(fieldAccess.getStartOffset(), this.lineBegin, this.lineEnd)) {
                Variable field = fieldAccess.getField();
                String clzName = CodeUtils.extractUnqualifiedClassName(fieldAccess);
                if (clzName != null) {
                    Collection<? extends TypeScope> allTypes;
                    String fieldName = CodeUtils.extractVariableName(field);
                    if (!StringUtils.hasText((String)fieldName)) {
                        return;
                    }
                    if (fieldName.startsWith("$")) {
                        fieldName = fieldName.substring(1);
                    }
                    if ((allTypes = ModelUtils.resolveType(this.model, fieldAccess)).size() == 1) {
                        TypeScope type = ModelUtils.getFirst(allTypes);
                        ElementQuery.Index index = this.model.getIndexScope().getIndex();
                        ElementFilter staticFieldsFilter = ElementFilter.allOf(ElementFilter.forName(NameKind.exact(fieldName)), ElementFilter.forStaticModifiers(true));
                        Set<FieldElement> allFields = staticFieldsFilter.filter(index.getAlllFields(type));
                        if (allFields.isEmpty()) {
                            BaseDocument document;
                            FileObject fileObject = type.getFileObject();
                            BaseDocument baseDocument = document = fileObject != null ? GsfUtilities.getDocument((FileObject)fileObject, (boolean)false) : null;
                            if (document != null && fileObject.canWrite() && type instanceof ClassScope) {
                                this.fix = new IntroduceStaticFieldFix(document, fieldAccess, (ClassScope)type);
                            }
                        }
                    }
                }
            }
            super.visit(fieldAccess);
        }

        @Override
        public void visit(StaticConstantAccess staticConstantAccess) {
            if (IntroduceSuggestion.isInside(staticConstantAccess.getStartOffset(), this.lineBegin, this.lineEnd)) {
                Collection<? extends TypeScope> allTypes;
                String constName = staticConstantAccess.getConstant().getName();
                String clzName = CodeUtils.extractUnqualifiedClassName(staticConstantAccess);
                if (clzName != null && StringUtils.hasText((String)constName) && (allTypes = ModelUtils.resolveType(this.model, staticConstantAccess)).size() == 1) {
                    TypeScope type = ModelUtils.getFirst(allTypes);
                    ElementQuery.Index index = this.model.getIndexScope().getIndex();
                    Set<TypeConstantElement> allConstants = ElementFilter.forName(NameKind.exact(constName)).filter(index.getAllTypeConstants(type));
                    if (allConstants.isEmpty()) {
                        BaseDocument document;
                        FileObject fileObject = type.getFileObject();
                        BaseDocument baseDocument = document = fileObject != null ? GsfUtilities.getDocument((FileObject)fileObject, (boolean)false) : null;
                        if (document != null && fileObject.canWrite()) {
                            this.fix = new IntroduceClassConstantFix(document, staticConstantAccess, type);
                        }
                    }
                }
            }
            super.visit(staticConstantAccess);
        }

        public IntroduceFix getIntroduceFix() {
            return this.fix;
        }

        private ClassElement getIndexedClass(String name) {
            ClassElement retval = null;
            ElementQuery.Index index = this.model.getIndexScope().getIndex();
            Collection<Object> classes = Collections.emptyList();
            if ("self".equals(name) || "parent".equals(name)) {
                ClassDeclaration classDeclaration = null;
                for (ASTNode aSTNode : this.getPath()) {
                    if (!(aSTNode instanceof ClassDeclaration)) continue;
                    classDeclaration = (ClassDeclaration)aSTNode;
                    break;
                }
                if (classDeclaration != null) {
                    String clzName = CodeUtils.extractClassName(classDeclaration);
                    classes = index.getClasses(NameKind.exact(clzName));
                }
            } else {
                classes = index.getClasses(NameKind.exact(name));
            }
            if (classes.size() == 1) {
                String superClassName;
                QualifiedName superClassQualifiedName;
                retval = (ClassElement)classes.iterator().next();
                if ("parent".equals(name) && (superClassQualifiedName = retval.getSuperClassName()) != null && (superClassName = superClassQualifiedName.getName()) != null) {
                    classes = index.getClasses(NameKind.exact(superClassName));
                    retval = classes.size() == 1 ? (ClassElement)classes.iterator().next() : null;
                }
            }
            return retval;
        }
    }
}

