/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ClassInstanceCreation;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.ExpressionStatement;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.IgnoreError;
import org.netbeans.modules.php.editor.parser.astnodes.MethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.StaticMethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.editor.verification.AbstractSuggestion;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.openide.filesystems.FileObject;

public class AssignVariableSuggestion
extends AbstractSuggestion {
    private static final List<String> LANGUAGE_CUNSTRUCTS = new ArrayList<String>(Arrays.asList("die", "exit"));

    public String getId() {
        return "assign.variable.hint";
    }

    public String getDescription() {
        return Bundle.AssignVariableHintDesc();
    }

    public String getDisplayName() {
        return Bundle.AssignVariableHintDisplayName();
    }

    @Override
    void compute(PHPRuleContext context, List<Hint> hints, int caretOffset) throws BadLocationException {
        int lineEnd;
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() == null) {
            return;
        }
        FileObject fileObject = phpParseResult.getSnapshot().getSource().getFileObject();
        if (fileObject == null) {
            return;
        }
        int lineBegin = caretOffset > 0 ? Utilities.getRowStart((BaseDocument)context.doc, (int)caretOffset) : -1;
        int n = lineEnd = lineBegin != -1 ? Utilities.getRowEnd((BaseDocument)context.doc, (int)caretOffset) : -1;
        if (lineBegin != -1 && lineEnd != -1 && caretOffset > lineBegin) {
            IntroduceFixVisitor introduceFixVisitor = new IntroduceFixVisitor(context.doc, lineBegin, lineEnd);
            phpParseResult.getProgram().accept(introduceFixVisitor);
            IntroduceFix variableFix = introduceFixVisitor.getIntroduceFix();
            if (variableFix != null) {
                hints.add(new Hint((Rule)this, this.getDisplayName(), fileObject, variableFix.getOffsetRange(), Collections.singletonList(variableFix), 500));
            }
        }
    }

    private static boolean isInside(int carret, int left, int right) {
        return carret >= left && carret <= right;
    }

    private static boolean isBefore(int carret, int margin) {
        return carret <= margin;
    }

    private static String firstToLower(String name) {
        if (name.length() == 0) {
            return null;
        }
        String cand = Character.toLowerCase(name.charAt(0)) + name.substring(1);
        return cand;
    }

    private class IntroduceFixImpl
    extends IntroduceFix {
        private final String guessName;

        IntroduceFixImpl(BaseDocument doc, ASTNode node, String variable) {
            super(doc, node);
            this.guessName = variable;
        }

        @Override
        protected String getVariableName() {
            return super.getVariableName(this.guessName);
        }
    }

    private abstract class IntroduceFix
    implements HintFix {
        BaseDocument doc;
        ASTNode node;
        List<Variable> variables;

        public IntroduceFix(BaseDocument doc, ASTNode node) {
            this.doc = doc;
            this.node = node;
        }

        OffsetRange getOffsetRange() {
            return new OffsetRange(this.node.getStartOffset(), this.node.getEndOffset());
        }

        public boolean isInteractive() {
            return false;
        }

        public boolean isSafe() {
            return true;
        }

        public void setVariables(List<Variable> variables) {
            this.variables = variables;
        }

        public String getDescription() {
            return AssignVariableSuggestion.this.getDescription();
        }

        public void implement() throws Exception {
            int textOffset = this.getTextOffset();
            String variableName = this.getVariableName();
            EditList edits = new EditList(this.doc);
            edits.replace(textOffset, 0, String.format("$%s = ", variableName), true, 0);
            edits.apply();
            JTextComponent target = GsfUtilities.getOpenPane();
            if (target != null) {
                int selectStart = textOffset + 1;
                int selectEnd = selectStart + variableName.length();
                target.select(selectStart, selectEnd);
            }
        }

        protected int getTextOffset() {
            return this.node.getStartOffset();
        }

        abstract String getVariableName();

        String adjustName(String name) {
            if (name == null) {
                return null;
            }
            String shortName = null;
            if (name.startsWith("get") && name.length() > 3) {
                shortName = name.substring(3);
            }
            if (name.startsWith("is") && name.length() > 2) {
                shortName = name.substring(2);
            }
            if (shortName != null) {
                return AssignVariableSuggestion.firstToLower(shortName);
            }
            return name;
        }

        String getVariableName(String guessName) {
            String proposedName = guessName = (guessName = this.adjustName(AssignVariableSuggestion.firstToLower(guessName))) != null ? guessName : "variable";
            int incr = -1;
            boolean cont = true;
            block0: while (cont) {
                if (incr != -1) {
                    proposedName = String.format("%s%d", guessName, incr);
                }
                cont = false;
                for (Variable variable : this.variables) {
                    String varName = CodeUtils.extractVariableName(variable);
                    if (varName == null || !variable.isDollared() || !proposedName.equals(varName = varName.substring(1))) continue;
                    ++incr;
                    cont = true;
                    continue block0;
                }
            }
            return proposedName;
        }
    }

    private class IntroduceFixVisitor
    extends DefaultVisitor {
        private int lineBegin;
        private int lineEnd;
        private BaseDocument doc;
        private IntroduceFix fix;
        private List<Variable> variables;

        IntroduceFixVisitor(BaseDocument doc, int lineBegin, int lineEnd) {
            this.doc = doc;
            this.lineBegin = lineBegin;
            this.lineEnd = lineEnd;
            this.variables = new ArrayList<Variable>();
        }

        @Override
        public void scan(ASTNode node) {
            if (node != null && (AssignVariableSuggestion.isBefore(node.getStartOffset(), this.lineEnd) || this.fix != null)) {
                super.scan(node);
            }
        }

        @Override
        public void visit(ExpressionStatement node) {
            if (AssignVariableSuggestion.isInside(node.getStartOffset(), this.lineBegin, this.lineEnd)) {
                Expression expression = node.getExpression();
                if (expression instanceof IgnoreError) {
                    expression = ((IgnoreError)expression).getExpression();
                }
                String guessName = null;
                if (expression instanceof ClassInstanceCreation) {
                    ClassInstanceCreation instanceCreation = (ClassInstanceCreation)expression;
                    guessName = CodeUtils.extractClassName(instanceCreation.getClassName());
                } else if (expression instanceof MethodInvocation) {
                    MethodInvocation methodInvocation = (MethodInvocation)expression;
                    guessName = CodeUtils.extractFunctionName(methodInvocation.getMethod());
                } else if (expression instanceof FunctionInvocation) {
                    FunctionInvocation functionInvocation = (FunctionInvocation)expression;
                    String functionName = CodeUtils.extractFunctionName(functionInvocation);
                    if (this.hasReturnValue(functionName)) {
                        guessName = functionName;
                    }
                } else if (expression instanceof StaticMethodInvocation) {
                    StaticMethodInvocation methodInvocation = (StaticMethodInvocation)expression;
                    guessName = CodeUtils.extractFunctionName(methodInvocation.getMethod());
                }
                if (guessName != null) {
                    this.fix = new IntroduceFixImpl(this.doc, node, guessName);
                }
            }
            super.visit(node);
        }

        private boolean hasReturnValue(String functionName) {
            return !LANGUAGE_CUNSTRUCTS.contains(functionName);
        }

        @Override
        public void visit(Variable node) {
            this.variables.add(node);
            super.visit(node);
        }

        public IntroduceFix getIntroduceFix() {
            if (this.fix != null) {
                this.fix.setVariables(this.variables);
            }
            return this.fix;
        }
    }
}

