/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.parser;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.csl.api.ColoringAttributes;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.SemanticAnalyzer;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.UnusedOffsetRanges;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayAccess;
import org.netbeans.modules.php.editor.parser.astnodes.Block;
import org.netbeans.modules.php.editor.parser.astnodes.BodyDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ConstantDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.FieldsDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionName;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.InterfaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceName;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTypeNode;
import org.netbeans.modules.php.editor.parser.astnodes.PHPVarComment;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.StaticConstantAccess;
import org.netbeans.modules.php.editor.parser.astnodes.StaticFieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.StaticMethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.TraitDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.TraitMethodAliasDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.TypeDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.UseStatement;
import org.netbeans.modules.php.editor.parser.astnodes.UseStatementPart;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultTreePathVisitor;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;

public class SemanticAnalysis
extends SemanticAnalyzer {
    public static final EnumSet<ColoringAttributes> UNUSED_FIELD_SET = EnumSet.of(ColoringAttributes.UNUSED, ColoringAttributes.FIELD);
    public static final EnumSet<ColoringAttributes> UNUSED_STATIC_FIELD_SET = EnumSet.of(ColoringAttributes.UNUSED, ColoringAttributes.FIELD, ColoringAttributes.STATIC);
    public static final EnumSet<ColoringAttributes> UNUSED_METHOD_SET = EnumSet.of(ColoringAttributes.UNUSED, ColoringAttributes.METHOD);
    public static final EnumSet<ColoringAttributes> STATIC_METHOD_SET = EnumSet.of(ColoringAttributes.STATIC, ColoringAttributes.METHOD);
    public static final EnumSet<ColoringAttributes> UNUSED_STATIC_METHOD_SET = EnumSet.of(ColoringAttributes.STATIC, ColoringAttributes.METHOD, ColoringAttributes.UNUSED);
    public static final EnumSet<ColoringAttributes> UNUSED_USES_SET = EnumSet.of(ColoringAttributes.UNUSED);
    private static final String NAMESPACE_SEPARATOR = "\\";
    private boolean cancelled;
    private Map<OffsetRange, Set<ColoringAttributes>> semanticHighlights = null;
    private Set<UnusedOffsetRanges> unusedUsesOffsetRanges;

    public static Set<UnusedOffsetRanges> computeUnusedUsesOffsetRanges(PHPParseResult r) {
        SemanticAnalysis semanticAnalysis = new SemanticAnalysis();
        semanticAnalysis.process((Parser.Result)r);
        return semanticAnalysis.getUnusedUsesOffsetRanges();
    }

    public Map<OffsetRange, Set<ColoringAttributes>> getHighlights() {
        return this.semanticHighlights;
    }

    private Set<UnusedOffsetRanges> getUnusedUsesOffsetRanges() {
        return this.unusedUsesOffsetRanges;
    }

    public synchronized void cancel() {
        this.cancelled = true;
    }

    public void run(Parser.Result r, SchedulerEvent event) {
        this.resume();
        if (this.isCancelled()) {
            return;
        }
        this.process(r);
    }

    void process(Parser.Result r) {
        PHPParseResult result = (PHPParseResult)r;
        HashMap<OffsetRange, Set<ColoringAttributes>> highlights = new HashMap<OffsetRange, Set<ColoringAttributes>>(100);
        if (result.getProgram() != null) {
            SemanticHighlightVisitor semanticHighlightVisitor = new SemanticHighlightVisitor(highlights, result.getSnapshot());
            result.getProgram().accept(semanticHighlightVisitor);
            this.semanticHighlights = highlights.size() > 0 ? highlights : null;
            this.unusedUsesOffsetRanges = semanticHighlightVisitor.getUnusedUsesOffsetRanges();
        }
    }

    protected final synchronized boolean isCancelled() {
        return this.cancelled;
    }

    protected final synchronized void resume() {
        this.cancelled = false;
    }

    public int getPriority() {
        return 0;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.EDITOR_SENSITIVE_TASK_SCHEDULER;
    }

    private class SemanticHighlightVisitor
    extends DefaultTreePathVisitor {
        Map<OffsetRange, Set<ColoringAttributes>> highlights;
        private final Map<UnusedIdentifier, ASTNodeColoring> privateFieldsUnused;
        private final Map<UnusedIdentifier, ASTNodeColoring> privateUnusedMethods;
        private List<Block> needToScan = new ArrayList<Block>();
        private final Map<String, ASTNodeColoring> unusedUses;
        private final Snapshot snapshot;
        private final Map<String, UnusedOffsetRanges> unusedUsesOffsetRanges;
        private TypeDeclaration typeDeclaration;

        public SemanticHighlightVisitor(Map<OffsetRange, Set<ColoringAttributes>> highlights, Snapshot snapshot) {
            this.highlights = highlights;
            this.privateFieldsUnused = new HashMap<UnusedIdentifier, ASTNodeColoring>();
            this.unusedUses = new HashMap<String, ASTNodeColoring>();
            this.privateUnusedMethods = new HashMap<UnusedIdentifier, ASTNodeColoring>();
            this.unusedUsesOffsetRanges = new HashMap<String, UnusedOffsetRanges>();
            this.snapshot = snapshot;
        }

        public Set<UnusedOffsetRanges> getUnusedUsesOffsetRanges() {
            HashSet<UnusedOffsetRanges> result = new HashSet<UnusedOffsetRanges>();
            for (UnusedOffsetRanges unusedOffsetRanges : this.unusedUsesOffsetRanges.values()) {
                result.add(unusedOffsetRanges);
            }
            return result;
        }

        private void addOffsetRange(ASTNode node, Set<ColoringAttributes> coloring) {
            int start = this.snapshot.getOriginalOffset(node.getStartOffset());
            if (start > -1) {
                int end = start + node.getEndOffset() - node.getStartOffset();
                assert (coloring != null) : ((Object)this.snapshot.getText()).toString();
                this.highlights.put(new OffsetRange(start, end), coloring);
            }
        }

        @Override
        public void visit(Program program) {
            this.scan(program.getStatements());
            this.scan(program.getComments());
            for (ASTNodeColoring item : this.unusedUses.values()) {
                this.addOffsetRange(item.identifier, item.coloring);
            }
        }

        @Override
        public void visit(ClassDeclaration cldec) {
            if (SemanticAnalysis.this.isCancelled()) {
                return;
            }
            this.addToPath(cldec);
            this.typeDeclaration = cldec;
            this.scan(cldec.getSuperClass());
            this.scan(cldec.getInterfaes());
            Identifier name = cldec.getName();
            this.addOffsetRange(name, ColoringAttributes.CLASS_SET);
            this.needToScan = new ArrayList<Block>();
            if (cldec.getBody() != null) {
                cldec.getBody().accept(this);
                for (Block block : this.needToScan) {
                    block.accept(this);
                }
                for (ASTNodeColoring item : this.privateFieldsUnused.values()) {
                    if (item.coloring.contains(ColoringAttributes.STATIC)) {
                        this.addOffsetRange(item.identifier, UNUSED_STATIC_FIELD_SET);
                        continue;
                    }
                    this.addOffsetRange(item.identifier, UNUSED_FIELD_SET);
                }
                for (ASTNodeColoring item : this.privateUnusedMethods.values()) {
                    if (item.coloring.contains(ColoringAttributes.STATIC)) {
                        this.addOffsetRange(item.identifier, UNUSED_STATIC_METHOD_SET);
                        continue;
                    }
                    this.addOffsetRange(item.identifier, UNUSED_METHOD_SET);
                }
            }
        }

        @Override
        public void visit(MethodDeclaration md) {
            Block body;
            this.scan(md.getFunction().getFormalParameters());
            boolean isPrivate = BodyDeclaration.Modifier.isPrivate(md.getModifier());
            EnumSet<ColoringAttributes> coloring = ColoringAttributes.METHOD_SET;
            if (BodyDeclaration.Modifier.isStatic(md.getModifier())) {
                coloring = STATIC_METHOD_SET;
            }
            Identifier identifier = md.getFunction().getFunctionName();
            String name = identifier.getName();
            if (isPrivate && name != null && !name.startsWith("__")) {
                this.privateUnusedMethods.put(new UnusedIdentifier(identifier.getName(), this.typeDeclaration), new ASTNodeColoring(identifier, coloring));
            } else {
                this.addOffsetRange(identifier, coloring);
            }
            if (!BodyDeclaration.Modifier.isAbstract(md.getModifier()) && (body = md.getFunction().getBody()) != null) {
                this.needToScan.add(body);
            }
        }

        @Override
        public void visit(TraitMethodAliasDeclaration node) {
            if (node.getNewMethodName() != null) {
                this.addOffsetRange(node.getNewMethodName(), ColoringAttributes.METHOD_SET);
            }
        }

        @Override
        public void visit(MethodInvocation node) {
            ASTNodeColoring item;
            Identifier identifier = null;
            if (node.getMethod().getFunctionName().getName() instanceof Variable) {
                Variable variable = (Variable)node.getMethod().getFunctionName().getName();
                if (variable.getName() instanceof Identifier) {
                    identifier = (Identifier)variable.getName();
                }
            } else if (node.getMethod().getFunctionName().getName() instanceof Identifier) {
                identifier = (Identifier)node.getMethod().getFunctionName().getName();
            }
            if (identifier != null && (item = this.privateUnusedMethods.remove(new UnusedIdentifier(identifier.getName(), this.typeDeclaration))) != null) {
                this.addOffsetRange(item.identifier, item.coloring);
            }
            super.visit(node);
        }

        @Override
        public void visit(InterfaceDeclaration node) {
            if (SemanticAnalysis.this.isCancelled()) {
                return;
            }
            this.typeDeclaration = node;
            Identifier name = node.getName();
            this.addOffsetRange(name, ColoringAttributes.CLASS_SET);
            super.visit(node);
        }

        @Override
        public void visit(TraitDeclaration node) {
            if (SemanticAnalysis.this.isCancelled()) {
                return;
            }
            this.typeDeclaration = node;
            Identifier name = node.getName();
            this.addOffsetRange(name, ColoringAttributes.CLASS_SET);
            this.needToScan = new ArrayList<Block>();
            if (node.getBody() != null) {
                node.getBody().accept(this);
                for (Block block : this.needToScan) {
                    block.accept(this);
                }
            }
            super.visit(node);
        }

        @Override
        public void visit(FieldsDeclaration node) {
            if (SemanticAnalysis.this.isCancelled()) {
                return;
            }
            boolean isPrivate = BodyDeclaration.Modifier.isPrivate(node.getModifier());
            EnumSet coloring = ColoringAttributes.FIELD_SET;
            if (BodyDeclaration.Modifier.isStatic(node.getModifier())) {
                coloring = ColoringAttributes.STATIC_FIELD_SET;
            }
            Variable[] variables = node.getVariableNames();
            for (int i = 0; i < variables.length; ++i) {
                Variable variable = variables[i];
                if (!isPrivate) {
                    this.addOffsetRange(variable.getName(), coloring);
                    continue;
                }
                if (!(variable.getName() instanceof Identifier)) continue;
                Identifier identifier = (Identifier)variable.getName();
                this.privateFieldsUnused.put(new UnusedIdentifier(identifier.getName(), this.typeDeclaration), new ASTNodeColoring(identifier, coloring));
            }
            super.visit(node);
        }

        @Override
        public void visit(FieldAccess node) {
            if (SemanticAnalysis.this.isCancelled()) {
                return;
            }
            if (!node.getField().isDollared()) {
                Expression expr = node.getField().getName();
                new FieldAccessVisitor(ColoringAttributes.FIELD_SET).scan(expr);
            }
            this.scan(node.getField());
            super.scan(node.getDispatcher());
        }

        @Override
        public void visit(StaticMethodInvocation node) {
            String name;
            ASTNodeColoring item;
            if (SemanticAnalysis.this.isCancelled()) {
                return;
            }
            FunctionName fnName = node.getMethod().getFunctionName();
            if (fnName.getName() instanceof Identifier && (item = this.privateUnusedMethods.remove(new UnusedIdentifier(name = ((Identifier)fnName.getName()).getName(), this.typeDeclaration))) != null) {
                this.addOffsetRange(item.identifier, item.coloring);
            }
            this.addOffsetRange(fnName, ColoringAttributes.STATIC_SET);
            super.visit(node);
        }

        @Override
        public void visit(PHPVarComment node) {
            int start = node.getVariable().getStartOffset();
            int end = start + 4;
            int startTranslated = this.snapshot.getOriginalOffset(start);
            if (startTranslated > -1) {
                int endTranslated = startTranslated + end - start;
                this.highlights.put(new OffsetRange(startTranslated, endTranslated), ColoringAttributes.CUSTOM1_SET);
            }
        }

        @Override
        public void visit(StaticFieldAccess node) {
            Expression expr = node.getField().getName();
            if (expr instanceof ArrayAccess) {
                ArrayAccess arrayAccess = (ArrayAccess)expr;
                expr = arrayAccess.getName();
            }
            new FieldAccessVisitor(ColoringAttributes.STATIC_FIELD_SET).scan(expr);
            super.visit(node);
        }

        @Override
        public void visit(ConstantDeclaration node) {
            List<Identifier> names;
            ASTNode parentNode = null;
            List<ASTNode> path = this.getPath();
            if (path != null && path.size() > 1) {
                parentNode = path.get(1);
            }
            if ((parentNode instanceof ClassDeclaration || parentNode instanceof InterfaceDeclaration || parentNode instanceof TraitDeclaration) && !(names = node.getNames()).isEmpty()) {
                for (Identifier identifier : names) {
                    this.addOffsetRange(identifier, ColoringAttributes.STATIC_FIELD_SET);
                }
            }
            super.visit(node);
        }

        @Override
        public void visit(StaticConstantAccess node) {
            Identifier constant = node.getConstant();
            if (constant != null) {
                this.addOffsetRange(constant, ColoringAttributes.STATIC_FIELD_SET);
            }
            super.visit(node);
        }

        @Override
        public void visit(PHPDocTypeNode node) {
            if (SemanticAnalysis.this.isCancelled()) {
                return;
            }
            QualifiedName typeName = QualifiedName.create(node.getValue());
            if (this.unusedUses.size() > 0 && !typeName.getKind().isFullyQualified()) {
                String firstSegmentName = typeName.getSegments().getFirst();
                this.processFirstSegmentName(firstSegmentName);
            }
        }

        @Override
        public void visit(NamespaceName node) {
            if (SemanticAnalysis.this.isCancelled()) {
                return;
            }
            if (this.unusedUses.size() > 0 && !node.isGlobal()) {
                Identifier firstSegment = node.getSegments().get(0);
                String firstSegmentName = firstSegment.getName();
                this.processFirstSegmentName(firstSegmentName);
            }
        }

        private void processFirstSegmentName(String firstSegmentName) {
            HashSet<String> namesToRemove = new HashSet<String>();
            for (String name : this.unusedUses.keySet()) {
                QualifiedName qualifiedUseName = QualifiedName.create(name);
                if (!qualifiedUseName.getSegments().getLast().equals(firstSegmentName)) continue;
                namesToRemove.add(name);
            }
            for (String nameToRemove : namesToRemove) {
                this.unusedUses.remove(nameToRemove);
                this.unusedUsesOffsetRanges.remove(nameToRemove);
            }
        }

        @Override
        public void visit(UseStatement node) {
            if (SemanticAnalysis.this.isCancelled()) {
                return;
            }
            List<UseStatementPart> parts = node.getParts();
            if (parts.size() == 1) {
                UseStatementPart useStatementPart = parts.get(0);
                String correctName = this.getCorrectName(useStatementPart);
                this.unusedUses.put(correctName, new ASTNodeColoring(node, UNUSED_USES_SET));
                OffsetRange offsetRange = new OffsetRange(node.getStartOffset(), node.getEndOffset());
                this.unusedUsesOffsetRanges.put(correctName, new UnusedOffsetRanges(offsetRange, offsetRange));
            } else {
                this.processUseStatementsParts(parts);
            }
        }

        private void processUseStatementsParts(List<UseStatementPart> parts) {
            int lastStartOffset = 0;
            for (int i = 0; i < parts.size(); ++i) {
                UseStatementPart useStatementPart = parts.get(i);
                int endOffset = useStatementPart.getEndOffset();
                if (i == 0) {
                    lastStartOffset = useStatementPart.getStartOffset();
                    assert (i + 1 < parts.size());
                    UseStatementPart nextPart = parts.get(i + 1);
                    endOffset = nextPart.getStartOffset();
                }
                String correctName = this.getCorrectName(useStatementPart);
                this.unusedUses.put(correctName, new ASTNodeColoring(useStatementPart, UNUSED_USES_SET));
                OffsetRange rangeToVisualise = new OffsetRange(useStatementPart.getStartOffset(), useStatementPart.getEndOffset());
                OffsetRange rangeToReplace = new OffsetRange(lastStartOffset, endOffset);
                this.unusedUsesOffsetRanges.put(correctName, new UnusedOffsetRanges(rangeToVisualise, rangeToReplace));
                lastStartOffset = useStatementPart.getEndOffset();
            }
        }

        private String getCorrectName(UseStatementPart useStatementPart) {
            String identifierName;
            Identifier alias = useStatementPart.getAlias();
            if (alias != null) {
                identifierName = alias.getName();
            } else {
                NamespaceName name = useStatementPart.getName();
                identifierName = CodeUtils.extractQualifiedName(name);
                if (name.isGlobal()) {
                    identifierName = SemanticAnalysis.NAMESPACE_SEPARATOR + identifierName;
                }
            }
            return identifierName;
        }

        private class UnusedIdentifier {
            private final String name;
            private final TypeDeclaration typeDeclaration;

            public UnusedIdentifier(String name, TypeDeclaration classDeclaration) {
                this.name = name;
                this.typeDeclaration = classDeclaration;
            }

            public int hashCode() {
                int hash = 5;
                hash = 29 * hash + (this.name != null ? this.name.hashCode() : 0);
                hash = 29 * hash + (this.typeDeclaration != null ? this.typeDeclaration.hashCode() : 0);
                return hash;
            }

            public boolean equals(Object obj) {
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                UnusedIdentifier other = (UnusedIdentifier)obj;
                if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                    return false;
                }
                return this.typeDeclaration == other.typeDeclaration || this.typeDeclaration != null && this.typeDeclaration.equals(other.typeDeclaration);
            }
        }

        private class FieldAccessVisitor
        extends DefaultVisitor {
            private final Set<ColoringAttributes> coloring;

            public FieldAccessVisitor(Set<ColoringAttributes> coloring) {
                this.coloring = coloring;
            }

            @Override
            public void visit(ArrayAccess node) {
                this.scan(node.getName());
            }

            @Override
            public void visit(Identifier identifier) {
                ASTNodeColoring removed = (ASTNodeColoring)SemanticHighlightVisitor.this.privateFieldsUnused.remove(new UnusedIdentifier(identifier.getName(), SemanticHighlightVisitor.this.typeDeclaration));
                if (removed != null) {
                    SemanticHighlightVisitor.this.addOffsetRange(removed.identifier, removed.coloring);
                }
                SemanticHighlightVisitor.this.addOffsetRange(identifier, this.coloring);
            }
        }

        private class ASTNodeColoring {
            public ASTNode identifier;
            public Set<ColoringAttributes> coloring;

            public ASTNodeColoring(ASTNode identifier, Set<ColoringAttributes> coloring) {
                this.identifier = identifier;
                this.coloring = coloring;
            }
        }
    }
}

