/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.php.api.annotation.PhpAnnotations;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.editor.parser.UnknownAnnotationLine;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocBlock;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocMethodTag;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocNode;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocStaticAccessType;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTag;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTypeNode;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTypeTag;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocVarTypeTag;
import org.netbeans.modules.php.spi.annotation.AnnotationLineParser;
import org.netbeans.modules.php.spi.annotation.AnnotationParsedLine;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public class PHPDocCommentParser {
    private static final Object LINE_PARSERS_LOCK = new Object();
    private static final List<AnnotationLineParser> LINE_PARSERS = new CopyOnWriteArrayList<AnnotationLineParser>(PhpAnnotations.getLineParsers());
    private static Pattern pattern;
    private static final List<AnnotationParsedLine> PHP_DOC_VAR_TYPE_TAGS;

    public PHPDocBlock parse(int startOffset, int endOffset, String comment) {
        PHPDocTag tag;
        AnnotationParsedLine tagType;
        String line;
        assert (startOffset <= endOffset);
        ArrayList<PHPDocTag> tags = new ArrayList<PHPDocTag>();
        String blockDescription = "";
        if (comment == null || comment.length() == 0) {
            return new PHPDocBlock(startOffset, endOffset, blockDescription, tags);
        }
        Matcher matcher = pattern.matcher(comment);
        int index = 0;
        String description = "";
        AnnotationParsedLine lastTag = null;
        int lastStartIndex = 0;
        int lastEndIndex = comment.length();
        while (matcher.find()) {
            line = comment.substring(index, matcher.start()).trim();
            if (index == 0) {
                line = this.removeStarAndTrim(line);
            }
            if ((tagType = this.findTagOnLine(line)) != null) {
                if (lastTag == null) {
                    blockDescription = description.length() > 0 && description.charAt(description.length() - 1) == '\n' ? description.substring(0, description.length() - 1) : description;
                } else {
                    tag = this.createTag(startOffset + 3 + lastStartIndex, startOffset + 3 + lastEndIndex, lastTag, description.substring(0, description.length() - 1), comment, startOffset + 3);
                    if (tag != null) {
                        tags.add(tag);
                    }
                }
                lastTag = tagType;
                lastStartIndex = index;
                description = "";
                line = line.substring(tagType.getName().length() + 1);
            }
            index = matcher.end();
            lastEndIndex = matcher.start();
            description = description + line + "\n";
        }
        line = index == 0 ? this.removeStarAndTrim(comment) : comment.substring(index, comment.length()).trim();
        tagType = this.findTagOnLine(line);
        if (tagType != null) {
            if (lastTag == null) {
                blockDescription = description.trim();
            } else {
                tag = this.createTag(startOffset + 3 + lastStartIndex, startOffset + 3 + lastEndIndex, lastTag, description.substring(0, description.length() - 1), comment, startOffset + 3);
                if (tag != null) {
                    tags.add(tag);
                }
            }
            line = line.substring(tagType.getName().length() + 1).trim();
            tag = this.createTag(startOffset + 3 + index, startOffset + 3 + comment.length(), tagType, line, comment, startOffset + 3);
            if (tag != null) {
                tags.add(tag);
            }
        } else if (lastTag == null) {
            blockDescription = description + line;
        } else {
            tag = this.createTag(startOffset + 3 + lastStartIndex, startOffset + 3 + lastEndIndex, lastTag, (description = description + line).substring(0, description.length() - 1), comment, startOffset + 3);
            if (tag != null) {
                tags.add(tag);
            }
        }
        return new PHPDocBlock(Math.min(startOffset + 3, endOffset), endOffset, blockDescription, tags);
    }

    private PHPDocTag createTag(int start, int end, AnnotationParsedLine type, String description, String originalComment, int originalCommentStart) {
        Map types = type.getTypes();
        if (types.isEmpty()) {
            List<PHPDocTypeNode> docTypes = this.findTypes(description, start, originalComment, originalCommentStart);
            if (PHP_DOC_VAR_TYPE_TAGS.contains(type)) {
                String variable = this.getVaribleName(description);
                PHPDocNode varibaleNode = null;
                if (variable != null) {
                    int startOfVariable = this.findStartOfDocNode(originalComment, originalCommentStart, variable, start);
                    varibaleNode = new PHPDocNode(startOfVariable, startOfVariable + variable.length(), variable);
                } else if (type.equals((Object)PHPDocTag.Type.PARAM)) {
                    varibaleNode = new PHPDocNode(start, start, "");
                }
                if (varibaleNode != null) {
                    return new PHPDocVarTypeTag(start, end, type, description, docTypes, varibaleNode);
                }
                return null;
            }
            if (type.equals((Object)PHPDocTag.Type.METHOD)) {
                String name = this.getMethodName(description);
                if (name != null) {
                    int startOfVariable = this.findStartOfDocNode(originalComment, originalCommentStart, name, start);
                    PHPDocNode methodNode = new PHPDocNode(startOfVariable, startOfVariable + name.length(), name);
                    List<PHPDocVarTypeTag> params = this.findMethodParams(description, this.findStartOfDocNode(originalComment, originalCommentStart, description, start));
                    return new PHPDocMethodTag(start, end, type, docTypes, methodNode, params, description);
                }
                return null;
            }
            if (type.equals((Object)PHPDocTag.Type.RETURN) || type.equals((Object)PHPDocTag.Type.VAR)) {
                return new PHPDocTypeTag(start, end, type, description, docTypes);
            }
            return new PHPDocTag(start, end, type, description);
        }
        return new PHPDocTypeTag(start, end, type, type.getDescription(), this.resolveTypes(types, start + (type.startsWithAnnotation() ? 1 : 0)));
    }

    private List<PHPDocTypeNode> resolveTypes(Map<OffsetRange, String> types, int lineStart) {
        ArrayList<PHPDocTypeNode> result = new ArrayList<PHPDocTypeNode>();
        for (Map.Entry<OffsetRange, String> entry : types.entrySet()) {
            result.add(new PHPDocTypeNode(lineStart + entry.getKey().getStart(), lineStart + entry.getKey().getEnd(), entry.getValue(), false));
        }
        return result;
    }

    private List<PHPDocTypeNode> findTypes(String description, int startDescription, String originalComment, int originalCommentStart) {
        ArrayList<PHPDocTypeNode> result = new ArrayList<PHPDocTypeNode>();
        for (String stype : this.getTypes(description)) {
            PHPDocTypeNode docType;
            boolean isArray;
            stype = this.removeHTMLTags(stype);
            int startDocNode = this.findStartOfDocNode(originalComment, originalCommentStart, stype, startDescription);
            int index = stype.indexOf("::");
            boolean bl = isArray = stype.indexOf(91) > 0 && stype.indexOf(93) > 0;
            if (isArray) {
                stype = stype.substring(0, stype.indexOf(91)).trim();
            }
            if (index == -1) {
                docType = new PHPDocTypeNode(startDocNode, startDocNode + stype.length(), stype, isArray);
            } else {
                String className = stype.substring(0, index);
                String constantName = stype.substring(index + 2, stype.length());
                PHPDocNode classNameNode = new PHPDocNode(startDocNode, startDocNode + className.length(), className);
                PHPDocNode constantNode = new PHPDocNode(startDocNode + className.length() + 2, startDocNode + stype.length(), constantName);
                docType = new PHPDocStaticAccessType(startDocNode, startDocNode + stype.length(), stype, classNameNode, constantNode);
            }
            result.add(docType);
        }
        return result;
    }

    private List<String> getTypes(String description) {
        String[] tokens = description.trim().split("[ ]+");
        ArrayList<String> types = new ArrayList<String>();
        if (tokens.length > 0 && !tokens[0].startsWith("$")) {
            if (tokens[0].indexOf(124) > -1) {
                String[] ttokens;
                for (String ttoken : ttokens = tokens[0].split("[|]")) {
                    types.add(ttoken.trim());
                }
            } else {
                types.add(tokens[0].trim());
            }
        }
        return types;
    }

    private String getVaribleName(String description) {
        String[] tokens = description.trim().split("[ \n\t]+");
        String variable = null;
        if (tokens.length > 0 && tokens[0].length() > 0 && tokens[0].charAt(0) == '$') {
            variable = tokens[0].trim();
        } else if (tokens.length > 1 && tokens[1].charAt(0) == '$') {
            variable = tokens[1].trim();
        }
        return variable;
    }

    private String getMethodName(String description) {
        String name = null;
        int index = description.indexOf(40);
        if (index > 0) {
            name = description.substring(0, index);
            if ((index = name.lastIndexOf(32)) > 0) {
                name = name.substring(index + 1);
            }
        } else {
            String[] tokens = description.trim().split("[ \n\t]+");
            if (tokens.length > 1) {
                name = tokens[1];
            }
        }
        return name;
    }

    private List<PHPDocVarTypeTag> findMethodParams(String description, int startOfDescription) {
        ArrayList<PHPDocVarTypeTag> result = new ArrayList<PHPDocVarTypeTag>();
        int position = startOfDescription;
        ParametersExtractor parametersExtractor = ParametersExtractorImpl.create();
        String parameters = parametersExtractor.extract(description);
        position += parametersExtractor.getPosition();
        if (parameters.length() > 0) {
            String[] tokens;
            for (String token : tokens = parameters.split("[,]+")) {
                String paramName = this.getVaribleName(token.trim());
                if (paramName != null) {
                    int startOfParamName = this.findStartOfDocNode(description, startOfDescription, paramName, position);
                    PHPDocNode paramNameNode = new PHPDocNode(startOfParamName, startOfParamName + paramName.length(), paramName);
                    List<PHPDocTypeNode> types = token.trim().indexOf(32) > -1 ? this.findTypes(token, position, description, startOfDescription) : Collections.EMPTY_LIST;
                    result.add(new PHPDocVarTypeTag(position, startOfParamName + paramName.length(), PHPDocTag.Type.PARAM, token, types, paramNameNode));
                }
                position = position + token.length() + 1;
            }
        }
        return result;
    }

    private String removeHTMLTags(String text) {
        String value = text;
        int index = value.indexOf(62);
        if (index > -1 && (index = (value = value.substring(index + 1)).indexOf(60)) > -1) {
            value = value.substring(0, index);
        }
        return value;
    }

    private int findStartOfDocNode(String originalComment, int originalStart, String what, int from) {
        int pos = originalComment.indexOf(what, from - originalStart);
        return originalStart + pos;
    }

    private String removeStarAndTrim(String text) {
        if ((text = text.trim()).length() > 0 && text.charAt(0) == '*') {
            text = text.substring(1).trim();
        }
        return text;
    }

    private AnnotationParsedLine findTagOnLine(String line) {
        AnnotationParsedLine result = null;
        if (line.length() > 0 && line.charAt(0) == '@') {
            String[] tokens = line.trim().split("[ \t]+");
            if (tokens.length > 0) {
                String name = tokens[0].substring(1);
                String tag = name.toUpperCase();
                if (tag.indexOf(45) > -1) {
                    tag = tag.replace('-', '_');
                }
                try {
                    result = PHPDocTag.Type.valueOf(tag);
                }
                catch (IllegalArgumentException iae) {
                    result = this.fetchCustomAnnotationLine(line.substring(1));
                    if (result == null) {
                        result = new UnknownAnnotationLine(name, PHPDocCommentParser.composeDescription(tokens));
                    }
                }
            }
        } else if (line.contains("@")) {
            result = this.fetchCustomAnnotationLine(line);
        }
        return result;
    }

    private static String composeDescription(String[] tokens) {
        assert (tokens.length > 0);
        ArrayList<String> tokenList = new ArrayList<String>(Arrays.asList(tokens));
        tokenList.remove(0);
        return StringUtils.implode(tokenList, (String)" ");
    }

    private AnnotationParsedLine fetchCustomAnnotationLine(String line) {
        AnnotationParsedLine result = null;
        for (AnnotationLineParser annotationLineParser : LINE_PARSERS) {
            AnnotationParsedLine parsedLine = annotationLineParser.parse(line);
            if (parsedLine == null) continue;
            result = parsedLine;
            break;
        }
        return result;
    }

    static {
        PhpAnnotations.addLineParsersListener((LookupListener)new LineParsersListener());
        pattern = Pattern.compile("[\r\n][ \\t]*[*]?[ \\t]*");
        PHP_DOC_VAR_TYPE_TAGS = new ArrayList<AnnotationParsedLine>();
        PHP_DOC_VAR_TYPE_TAGS.add(PHPDocTag.Type.PARAM);
        PHP_DOC_VAR_TYPE_TAGS.add(PHPDocTag.Type.PROPERTY);
        PHP_DOC_VAR_TYPE_TAGS.add(PHPDocTag.Type.GLOBAL);
        PHP_DOC_VAR_TYPE_TAGS.add(PHPDocTag.Type.PROPERTY_READ);
        PHP_DOC_VAR_TYPE_TAGS.add(PHPDocTag.Type.PROPERTY_WRITE);
    }

    private static interface ParametersExtractor {
        public String extract(String var1);

        public int getPosition();
    }

    private static final class ParametersExtractorImpl
    implements ParametersExtractor {
        private int position = 0;
        private String parameters = "";
        private String subDescription = "";
        private boolean hasParameters = false;
        private int bracketBalance = 0;
        private int paramsStart = 0;
        private int paramsEnd = 0;

        public static ParametersExtractor create() {
            return new ParametersExtractorImpl();
        }

        private ParametersExtractorImpl() {
        }

        @Override
        public String extract(String description) {
            int index = description.indexOf(40);
            int possibleParamIndex = description.indexOf(36);
            if (index > -1 && possibleParamIndex > -1) {
                this.position += index;
                this.subDescription = description.substring(index);
                this.processSubDescription();
            }
            return this.parameters;
        }

        private void processSubDescription() {
            for (int i = 0; i < this.subDescription.length(); ++i) {
                this.findMatchingBraces(i);
                if (!this.parameters.isEmpty()) break;
            }
        }

        private void findMatchingBraces(int i) {
            char ch = this.subDescription.charAt(i);
            if (ch == '(') {
                this.processLeftBrace(i);
            } else if (ch == ')') {
                this.processRightBrace(i);
            } else {
                if (Character.isWhitespace(ch)) {
                    return;
                }
                this.processNonWhiteCharacter();
            }
            this.checkParameters();
        }

        private void processLeftBrace(int i) {
            ++this.bracketBalance;
            if (this.bracketBalance == 1) {
                this.paramsStart = i + 1;
            }
        }

        private void processRightBrace(int i) {
            --this.bracketBalance;
            if (this.bracketBalance == 0) {
                this.paramsEnd = i;
            }
        }

        private void processNonWhiteCharacter() {
            this.hasParameters = this.bracketBalance != 0;
        }

        private void checkParameters() {
            if (this.hasParameters && this.bracketBalance == 0) {
                this.parameters = this.subDescription.substring(this.paramsStart, this.paramsEnd);
                this.position += this.paramsStart;
            }
        }

        @Override
        public int getPosition() {
            return this.position;
        }
    }

    private static class LineParsersListener
    implements LookupListener {
        private LineParsersListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resultChanged(LookupEvent ev) {
            Object object = LINE_PARSERS_LOCK;
            synchronized (object) {
                LINE_PARSERS.clear();
                LINE_PARSERS.addAll(PhpAnnotations.getLineParsers());
            }
        }
    }
}

