/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.options;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.php.editor.options.MarkOccurencesOptionsPanelController;
import org.netbeans.modules.php.editor.options.MarkOccurencesSettings;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class MarkOccurencesPanel
extends JPanel {
    private static final boolean DEFAULT_VALUE = true;
    private List<JCheckBox> boxes;
    private MarkOccurencesOptionsPanelController controller;
    private JCheckBox keepMarksCheckBox;
    private JCheckBox onOffCheckBox;

    public MarkOccurencesPanel(MarkOccurencesOptionsPanelController controller) {
        this.initComponents();
        this.fillBoxes();
        this.addListeners();
        this.load(controller);
    }

    public void load(MarkOccurencesOptionsPanelController controller) {
        this.controller = controller;
        Preferences node = MarkOccurencesSettings.getCurrentNode();
        for (JCheckBox box : this.boxes) {
            box.setSelected(node.getBoolean(box.getActionCommand(), true));
        }
        this.componentsSetEnabled();
    }

    public void store() {
        Preferences node = MarkOccurencesSettings.getCurrentNode();
        for (JCheckBox box : this.boxes) {
            boolean original;
            boolean value = box.isSelected();
            if (value == (original = node.getBoolean(box.getActionCommand(), true))) continue;
            node.putBoolean(box.getActionCommand(), value);
        }
        try {
            node.flush();
        }
        catch (BackingStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public boolean changed() {
        Preferences node = MarkOccurencesSettings.getCurrentNode();
        for (JCheckBox box : this.boxes) {
            boolean original;
            boolean value = box.isSelected();
            if (value == (original = node.getBoolean(box.getActionCommand(), true))) continue;
            return true;
        }
        return false;
    }

    private void initComponents() {
        this.onOffCheckBox = new JCheckBox();
        this.keepMarksCheckBox = new JCheckBox();
        this.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(new FocusTraversalPolicy(){

            @Override
            public Component getDefaultComponent(Container focusCycleRoot) {
                return MarkOccurencesPanel.this.onOffCheckBox;
            }

            @Override
            public Component getFirstComponent(Container focusCycleRoot) {
                return MarkOccurencesPanel.this.onOffCheckBox;
            }

            @Override
            public Component getLastComponent(Container focusCycleRoot) {
                return MarkOccurencesPanel.this.onOffCheckBox;
            }

            @Override
            public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
                return MarkOccurencesPanel.this.onOffCheckBox;
            }

            @Override
            public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
                return MarkOccurencesPanel.this.onOffCheckBox;
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.onOffCheckBox, (String)NbBundle.getMessage(MarkOccurencesPanel.class, (String)"CTL_OnOff_CheckBox"));
        this.onOffCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.keepMarksCheckBox.setMnemonic('s');
        Mnemonics.setLocalizedText((AbstractButton)this.keepMarksCheckBox, (String)NbBundle.getMessage(MarkOccurencesPanel.class, (String)"MarkOccurencesPanel.keepMarksCheckBox.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.onOffCheckBox)).addGroup(layout.createSequentialGroup().addGap(37, 37, 37).addComponent(this.keepMarksCheckBox))).addContainerGap(226, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.onOffCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.keepMarksCheckBox).addContainerGap(237, Short.MAX_VALUE)));
        this.onOffCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MarkOccurencesPanel.class, (String)"MarkOccurrencesPanel.onOffCheckBox.AccessibleContext.accessibleName"));
        this.onOffCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MarkOccurencesPanel.class, (String)"ACSD_OnOff_CB"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MarkOccurencesPanel.class, (String)"MarkOccurrencesPanel.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MarkOccurencesPanel.class, (String)"MarkOccurrencesPanel.AccessibleContext.accessibleDescription"));
    }

    private void fillBoxes() {
        this.boxes = new ArrayList<JCheckBox>();
        this.boxes.add(this.onOffCheckBox);
        this.boxes.add(this.keepMarksCheckBox);
        this.onOffCheckBox.setActionCommand("OnOff");
        this.keepMarksCheckBox.setActionCommand("KeepMarks");
    }

    private void addListeners() {
        CheckChangeListener cl = new CheckChangeListener();
        for (JCheckBox box : this.boxes) {
            box.addChangeListener(cl);
        }
    }

    private void componentsSetEnabled() {
        for (int i = 1; i < this.boxes.size(); ++i) {
            this.boxes.get(i).setEnabled(this.onOffCheckBox.isSelected());
        }
    }

    private class CheckChangeListener
    implements ChangeListener {
        private CheckChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent evt) {
            if (evt.getSource() == MarkOccurencesPanel.this.onOffCheckBox) {
                MarkOccurencesPanel.this.componentsSetEnabled();
            }
            MarkOccurencesPanel.this.controller.changed();
        }
    }
}

