/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.nav.hierarchy;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.modules.csl.api.UiUtils;
import org.netbeans.modules.php.editor.api.ElementQuery;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.elements.ClassElement;
import org.netbeans.modules.php.editor.api.elements.TreeElement;
import org.netbeans.modules.php.editor.api.elements.TypeElement;
import org.netbeans.modules.php.editor.model.FileScope;
import org.netbeans.modules.php.editor.model.Model;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.nav.hierarchy.Bundle;
import org.netbeans.modules.php.editor.nav.hierarchy.PhpHierarchyTopComponent;
import org.openide.filesystems.FileObject;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

@SuppressWarnings(value={"SE_BAD_FIELD_STORE"})
public class ClassHierarchyPanel
extends JPanel
implements HelpCtx.Provider {
    private static final int MAX_STACK_DEPTH = 250;
    private final JTree tree;
    private final DefaultTreeModel treeModel;
    private final MouseAdapter mouseListener = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent e) {
            TypeNode typeNode;
            FileObject fileObject;
            Object lastPathComponent;
            TreePath selPath = ClassHierarchyPanel.this.tree.getSelectionPath();
            if (selPath != null && e.getClickCount() == 2 && (lastPathComponent = selPath.getLastPathComponent()) instanceof TypeNode && (fileObject = (typeNode = (TypeNode)lastPathComponent).getFileObject()) != null && fileObject.isValid()) {
                UiUtils.open((FileObject)fileObject, (int)typeNode.getOffset());
            }
        }
    };
    private ButtonGroup directionGroup;
    private JScrollPane hierarchyPane;
    private JPanel jPanel2;
    private JToolBar.Separator jSeparator1;
    private JButton refreshButton;
    private JToggleButton subtypeButton;
    private JToggleButton supertypeButton;
    private JToolBar toolBar;

    public ClassHierarchyPanel(boolean isView) {
        this.initComponents();
        if (!isView) {
            this.toolBar.remove(0);
            this.toolBar.remove(0);
            this.subtypeButton.setFocusable(true);
            this.supertypeButton.setFocusable(true);
        }
        this.setName(NbBundle.getMessage(this.getClass(), (String)"CTL_ClassHierarchyTopComponent"));
        this.setToolTipText(NbBundle.getMessage(this.getClass(), (String)"HINT_ClassHierarchyTopComponent"));
        this.tree = new JTree();
        this.treeModel = new DefaultTreeModel(new DefaultMutableTreeNode());
        this.tree.setModel(this.treeModel);
        this.tree.setToggleClickCount(0);
        this.tree.setCellRenderer(new TreeRenderer());
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        this.tree.expandRow(0);
        this.tree.setShowsRootHandles(true);
        this.tree.setSelectionRow(0);
        this.tree.setRootVisible(false);
        this.hierarchyPane.add(this.tree);
        this.hierarchyPane.setViewportView(this.tree);
        this.tree.addMouseListener(this.mouseListener);
    }

    void setModel(Model model) {
        this.treeModel.setRoot(this.createRoot(model, this.subtypeButton.isSelected()));
        ClassHierarchyPanel.expandAll(this.tree);
    }

    private static void expandAll(JTree tree) {
        for (int row = 0; row < tree.getRowCount(); ++row) {
            tree.expandRow(row);
        }
    }

    private void initComponents() {
        this.directionGroup = new ButtonGroup();
        this.toolBar = new JToolBar();
        this.refreshButton = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.supertypeButton = new JToggleButton();
        this.subtypeButton = new JToggleButton();
        this.jPanel2 = new JPanel();
        this.hierarchyPane = new JScrollPane();
        this.setLayout(new GridBagLayout());
        this.toolBar.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.toolBar.setFloatable(false);
        this.toolBar.setBorderPainted(false);
        this.toolBar.setMaximumSize(new Dimension(74, 26));
        this.toolBar.setMinimumSize(new Dimension(74, 26));
        this.toolBar.setOpaque(false);
        this.refreshButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/php/editor/nav/resources/refresh.png")));
        this.refreshButton.setToolTipText(NbBundle.getMessage(ClassHierarchyPanel.class, (String)"ClassHierarchyPanel.refreshButton.toolTipText"));
        this.refreshButton.setFocusable(false);
        this.refreshButton.setHorizontalTextPosition(0);
        this.refreshButton.setMaximumSize(new Dimension(24, 24));
        this.refreshButton.setMinimumSize(new Dimension(24, 24));
        this.refreshButton.setPreferredSize(new Dimension(24, 24));
        this.refreshButton.setVerticalTextPosition(3);
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClassHierarchyPanel.this.refreshButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.refreshButton);
        this.toolBar.add(this.jSeparator1);
        this.directionGroup.add(this.supertypeButton);
        this.supertypeButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/php/editor/nav/resources/supertypehierarchy.gif")));
        this.supertypeButton.setSelected(true);
        this.supertypeButton.setToolTipText(NbBundle.getMessage(ClassHierarchyPanel.class, (String)"ClassHierarchyPanel.supertypeButton.toolTipText"));
        this.supertypeButton.setFocusable(false);
        this.supertypeButton.setHorizontalTextPosition(0);
        this.supertypeButton.setMaximumSize(new Dimension(24, 24));
        this.supertypeButton.setMinimumSize(new Dimension(24, 24));
        this.supertypeButton.setPreferredSize(new Dimension(24, 24));
        this.supertypeButton.setVerticalTextPosition(3);
        this.supertypeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClassHierarchyPanel.this.supertypeButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.supertypeButton);
        this.directionGroup.add(this.subtypeButton);
        this.subtypeButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/php/editor/nav/resources/subtypehierarchy.gif")));
        this.subtypeButton.setSelected(false);
        this.subtypeButton.setToolTipText(NbBundle.getMessage(ClassHierarchyPanel.class, (String)"ClassHierarchyPanel.subtypeButton.toolTipText"));
        this.subtypeButton.setFocusable(false);
        this.subtypeButton.setHorizontalTextPosition(0);
        this.subtypeButton.setMaximumSize(new Dimension(24, 24));
        this.subtypeButton.setMinimumSize(new Dimension(24, 24));
        this.subtypeButton.setPreferredSize(new Dimension(24, 24));
        this.subtypeButton.setVerticalTextPosition(3);
        this.subtypeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClassHierarchyPanel.this.subtypeButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.subtypeButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 0);
        this.add((Component)this.toolBar, gridBagConstraints);
        this.jPanel2.setFocusable(false);
        this.jPanel2.setMinimumSize(new Dimension(1, 1));
        this.jPanel2.setPreferredSize(new Dimension(1, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.add((Component)this.jPanel2, gridBagConstraints);
        this.hierarchyPane.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.hierarchyPane, gridBagConstraints);
    }

    private void refresh() {
        PhpHierarchyTopComponent view = PhpHierarchyTopComponent.findInstance();
        if (view != null) {
            view.refresh();
        }
    }

    private void refreshButtonActionPerformed(ActionEvent evt) {
        this.refresh();
    }

    private void subtypeButtonActionPerformed(ActionEvent evt) {
        this.refresh();
    }

    private void supertypeButtonActionPerformed(ActionEvent evt) {
        this.refresh();
    }

    @Override
    public boolean requestFocusInWindow() {
        super.requestFocusInWindow();
        return this.hierarchyPane.requestFocusInWindow();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("PhpTypeView");
    }

    private static TypeNode[] sortTypes(TypeNode[] types) {
        Arrays.sort(types, new Comparator<TypeNode>(){

            @Override
            public int compare(TypeNode o1, TypeNode o2) {
                int compareTo = Boolean.valueOf(o1.isClass).compareTo(o2.isClass);
                return compareTo == 0 ? o1.toString().compareToIgnoreCase(o2.toString()) : compareTo;
            }
        });
        return types;
    }

    protected TreeNode createRoot(Model model, boolean subDirection) {
        FileRootNode retval = new FileRootNode(model);
        FileScope fileScope = model.getFileScope();
        HashSet<TypeElement> types = new HashSet<TypeElement>();
        HashSet<TypeElement> recursionDetection = new HashSet<TypeElement>();
        types.addAll(ModelUtils.getDeclaredClasses(fileScope));
        types.addAll(ModelUtils.getDeclaredInterfaces(fileScope));
        TypeNode[] childernNodes = new TypeNode[types.size()];
        if (types.size() > 0) {
            ElementQuery.Index index = fileScope.getIndexScope().getIndex();
            Iterator iterator = types.iterator();
            int i = 0;
            while (iterator.hasNext()) {
                TypeElement type = (TypeElement)iterator.next();
                TreeElement<TypeElement> treeType = subDirection ? index.getInheritedByTypesAsTree(type, types) : index.getInheritedTypesAsTree(type, types);
                recursionDetection.add(type);
                childernNodes[i] = ClassHierarchyPanel.createTypeNode(retval, treeType, recursionDetection, 0);
                ++i;
            }
        }
        retval.setChildern(ClassHierarchyPanel.sortTypes(childernNodes));
        return retval;
    }

    @SuppressWarnings(value={"DLS_DEAD_LOCAL_STORE"})
    private static TypeNode createTypeNode(TreeNode parent, TreeElement<TypeElement> classElement, Set<TypeElement> recursionDetection, Integer stackDepth) {
        Integer n = stackDepth;
        Integer n2 = stackDepth = Integer.valueOf(stackDepth + 1);
        TypeNode retval = new TypeNode(parent, classElement);
        Set<TreeElement<TypeElement>> children = classElement.children();
        ArrayList<TypeNode> childernList = new ArrayList<TypeNode>();
        if (stackDepth <= 250) {
            for (TreeElement<TypeElement> child : children) {
                if (!recursionDetection.add(child.getElement())) continue;
                childernList.add(ClassHierarchyPanel.createTypeNode(retval, child, recursionDetection, stackDepth));
            }
        } else {
            childernList.add(new ErrTypeNode(parent, classElement));
        }
        Integer n3 = stackDepth;
        Integer n4 = stackDepth = Integer.valueOf(stackDepth - 1);
        retval.setChildern(ClassHierarchyPanel.sortTypes(childernList.toArray(new TypeNode[childernList.size()])));
        return retval;
    }

    public static class TreeRenderer
    extends JPanel
    implements TreeCellRenderer {
        private static final JList LIST_FOR_COLORS = new JList();
        protected JLabel label;

        public TreeRenderer() {
            this.setLayout(new BorderLayout());
            this.setOpaque(true);
            this.label = new JLabel();
            this.add((Component)this.label, "Center");
            this.label.setOpaque(false);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            String stringValue = tree.convertValueToText(value, isSelected, expanded, leaf, row, hasFocus);
            this.setEnabled(tree.isEnabled());
            if (value instanceof TypeNode) {
                TypeNode n = (TypeNode)value;
                stringValue = n.toStringAsHtml();
                this.label.setIcon(new ImageIcon(n.getIcon()));
            }
            if (isSelected) {
                this.label.setForeground(LIST_FOR_COLORS.getSelectionForeground());
                this.setOpaque(true);
                this.setBackground(LIST_FOR_COLORS.getSelectionBackground());
            } else {
                this.label.setForeground(tree.getForeground());
                this.setOpaque(false);
            }
            this.label.setText(stringValue);
            return this;
        }
    }

    private static class ErrTypeNode
    extends TypeNode {
        public ErrTypeNode(TreeNode parent, TreeElement<TypeElement> classElement) {
            super(parent, classElement);
        }

        @Override
        public String toString() {
            return Bundle.TooManyChilds(250);
        }

        @Override
        public String toStringAsHtml() {
            return "<html><span style='color: red; font-size: 0.9em;'>" + Bundle.TooManyChilds(250) + "</html>";
        }

        @Override
        public Image getIcon() {
            return ImageUtilities.loadImage((String)"org/netbeans/modules/php/editor/resources/error-glyph.gif");
        }
    }

    private static class TypeNode
    extends AbstractTypeNode {
        private static final String FONT_GRAY_COLOR = "<font color=\"#999999\">";
        private static final String CLOSE_FONT = "</font>";
        private final TreeNode parent;
        private final String name;
        private final List<String> superTypes;
        private final FileObject fileObject;
        private final int offset;
        private final boolean isClass;

        public TypeNode(TreeNode parent, TreeElement<TypeElement> classElement) {
            ClassElement clz;
            QualifiedName superClassName;
            this.parent = parent;
            TypeElement type = classElement.getElement();
            this.name = type.getName();
            this.superTypes = new ArrayList<String>();
            this.fileObject = type.getFileObject();
            this.offset = type.getOffset();
            this.isClass = type.isClass();
            if (type instanceof ClassElement && (superClassName = (clz = (ClassElement)type).getSuperClassName()) != null) {
                this.superTypes.add(superClassName.toString());
            }
            Set<QualifiedName> superInterfaces = type.getSuperInterfaces();
            for (QualifiedName supeIfaceName : superInterfaces) {
                if (supeIfaceName == null) continue;
                this.superTypes.add(supeIfaceName.toString());
            }
        }

        @Override
        public TreeNode getParent() {
            return this.parent;
        }

        public String toString() {
            return String.format("%s%s", this.name, this.superTypes);
        }

        @Override
        public Image getIcon() {
            return ImageUtilities.loadImage((String)("org/netbeans/modules/php/editor/resources/" + (this.isClass ? "class" : "interface") + ".png"));
        }

        @Override
        public String toStringAsHtml() {
            StringBuilder superTypeString = new StringBuilder();
            for (String superTypeName : this.superTypes) {
                if (superTypeString.length() != 0) {
                    superTypeString.append(", ");
                } else {
                    superTypeString.append("::");
                }
                superTypeString.append(superTypeName);
            }
            return String.format("<html>%s%s%s%s </html>", this.name, FONT_GRAY_COLOR, superTypeString.toString(), CLOSE_FONT);
        }

        public FileObject getFileObject() {
            return this.fileObject;
        }

        public int getOffset() {
            return this.offset;
        }
    }

    private static final class FileRootNode
    extends AbstractTypeNode {
        private final String filename;

        private FileRootNode(Model model) {
            FileObject fileObject = model.getFileScope().getFileObject();
            this.filename = fileObject == null ? "?" : fileObject.getNameExt();
        }

        @Override
        public TreeNode getParent() {
            return null;
        }

        public String toString() {
            return this.filename;
        }

        @Override
        public Image getIcon() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String toStringAsHtml() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    @SuppressWarnings(value={"EI_EXPOSE_REP2"})
    protected static abstract class AbstractTypeNode
    implements TreeNode {
        static final String ICON_BASE = "org/netbeans/modules/php/editor/resources/";
        static final String ICON_EXTENSION = ".png";
        private AbstractTypeNode[] childern = new AbstractTypeNode[0];

        protected AbstractTypeNode() {
        }

        public Enumeration children() {
            return new Enumeration(){
                int idx = 0;

                @Override
                public boolean hasMoreElements() {
                    return this.idx < AbstractTypeNode.this.getChildCount();
                }

                public Object nextElement() {
                    return AbstractTypeNode.this.getChildAt(this.idx++);
                }
            };
        }

        @Override
        public boolean getAllowsChildren() {
            return !this.isLeaf();
        }

        @Override
        public TreeNode getChildAt(int childIndex) {
            return this.childern[childIndex];
        }

        @Override
        public int getChildCount() {
            return this.childern.length;
        }

        @Override
        public int getIndex(TreeNode node) {
            for (int i = 0; i < this.childern.length; ++i) {
                AbstractTypeNode classNode = this.childern[i];
                if (classNode != node) continue;
                return i;
            }
            return -1;
        }

        @Override
        public boolean isLeaf() {
            return this.getChildCount() == 0;
        }

        public void setChildern(AbstractTypeNode[] childern) {
            this.childern = childern;
        }

        public abstract Image getIcon();

        public abstract String toStringAsHtml();
    }
}

