/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.nav;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.text.Document;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.php.editor.model.FileScope;
import org.netbeans.modules.php.editor.model.FunctionScope;
import org.netbeans.modules.php.editor.model.MethodScope;
import org.netbeans.modules.php.editor.model.Model;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.api.Utils;
import org.netbeans.modules.php.editor.parser.astnodes.ASTError;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.CatchClause;
import org.netbeans.modules.php.editor.parser.astnodes.Comment;
import org.netbeans.modules.php.editor.parser.astnodes.DoStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.ForEachStatement;
import org.netbeans.modules.php.editor.parser.astnodes.ForStatement;
import org.netbeans.modules.php.editor.parser.astnodes.IfStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.Statement;
import org.netbeans.modules.php.editor.parser.astnodes.SwitchCase;
import org.netbeans.modules.php.editor.parser.astnodes.SwitchStatement;
import org.netbeans.modules.php.editor.parser.astnodes.TryStatement;
import org.netbeans.modules.php.editor.parser.astnodes.UseTraitStatement;
import org.netbeans.modules.php.editor.parser.astnodes.WhileStatement;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;

public final class FoldingScanner {
    private static final String FOLD_CODE_BLOCKS = "codeblocks";
    private static final String FOLD_CLASS = "inner-classes";
    private static final String FOLD_PHPDOC = "comments";
    private static final String FOLD_COMMENT = "initial-comment";
    private static final String FOLD_OTHER_CODE_BLOCKS = "othercodeblocks";
    private static final String LAST_CORRECT_FOLDING_PROPERTY = "LAST_CORRECT_FOLDING_PROPERY";

    public static FoldingScanner create() {
        return new FoldingScanner();
    }

    private FoldingScanner() {
    }

    public Map<String, List<OffsetRange>> folds(ParserResult info) {
        HashMap<String, List<OffsetRange>> folds = new HashMap<String, List<OffsetRange>>();
        Program program = Utils.getRoot(info);
        if (program != null) {
            if (program.getStatements().size() == 1 && program.getStatements().get(0) instanceof ASTError) {
                Map lastCorrect;
                Document document = info.getSnapshot().getSource().getDocument(false);
                Map map = lastCorrect = document != null ? (Map)document.getProperty(LAST_CORRECT_FOLDING_PROPERTY) : null;
                if (lastCorrect != null) {
                    return lastCorrect;
                }
                return Collections.emptyMap();
            }
            List<Comment> comments = program.getComments();
            if (comments != null) {
                for (Comment comment : comments) {
                    if (comment.getCommentType() == Comment.Type.TYPE_PHPDOC) {
                        this.getRanges(folds, FOLD_PHPDOC).add(this.createOffsetRange(comment));
                        continue;
                    }
                    if (comment.getCommentType() != Comment.Type.TYPE_MULTILINE) continue;
                    this.getRanges(folds, FOLD_COMMENT).add(this.createOffsetRange(comment));
                }
            }
            PHPParseResult result = (PHPParseResult)info;
            Model model = result.getModel(Model.Type.COMMON);
            FileScope fileScope = model.getFileScope();
            List<Scope> scopes = this.getEmbededScopes(fileScope, null);
            for (Scope scope : scopes) {
                OffsetRange offsetRange = scope.getBlockRange();
                if (offsetRange == null) continue;
                if (scope instanceof TypeScope) {
                    this.getRanges(folds, FOLD_CLASS).add(offsetRange);
                    continue;
                }
                if (!(scope instanceof FunctionScope) && !(scope instanceof MethodScope)) continue;
                this.getRanges(folds, FOLD_CODE_BLOCKS).add(offsetRange);
            }
            program.accept(new FoldingVisitor(folds));
            Source source = info.getSnapshot().getSource();
            assert (source != null) : "source was null";
            Document doc = source.getDocument(false);
            if (doc != null) {
                doc.putProperty(LAST_CORRECT_FOLDING_PROPERTY, folds);
            }
            return folds;
        }
        return Collections.emptyMap();
    }

    private OffsetRange createOffsetRange(ASTNode node) {
        return new OffsetRange(node.getStartOffset(), node.getEndOffset());
    }

    private List<OffsetRange> getRanges(Map<String, List<OffsetRange>> folds, String kind) {
        List<OffsetRange> ranges = folds.get(kind);
        if (ranges == null) {
            ranges = new ArrayList<OffsetRange>();
            folds.put(kind, ranges);
        }
        return ranges;
    }

    private List<Scope> getEmbededScopes(Scope scope, List<Scope> collectedScopes) {
        if (collectedScopes == null) {
            collectedScopes = new ArrayList<Scope>();
        }
        List<? extends ModelElement> elements = scope.getElements();
        for (ModelElement modelElement : elements) {
            if (!(modelElement instanceof Scope)) continue;
            collectedScopes.add((Scope)modelElement);
            this.getEmbededScopes((Scope)modelElement, collectedScopes);
        }
        return collectedScopes;
    }

    private class FoldingVisitor
    extends DefaultVisitor {
        private final Map<String, List<OffsetRange>> folds;

        public FoldingVisitor(Map<String, List<OffsetRange>> folds) {
            this.folds = folds;
        }

        @Override
        public void visit(IfStatement node) {
            super.visit(node);
            if (node.getTrueStatement() != null) {
                this.addFold(node.getTrueStatement());
            }
            if (node.getFalseStatement() != null && !(node.getFalseStatement() instanceof IfStatement)) {
                this.addFold(node.getFalseStatement());
            }
        }

        @Override
        public void visit(UseTraitStatement node) {
            super.visit(node);
            if (node.getBody() != null) {
                this.addFold(node.getBody());
            }
        }

        @Override
        public void visit(ForEachStatement node) {
            super.visit(node);
            if (node.getStatement() != null) {
                this.addFold(node.getStatement());
            }
        }

        @Override
        public void visit(ForStatement node) {
            super.visit(node);
            if (node.getBody() != null) {
                this.addFold(node.getBody());
            }
        }

        @Override
        public void visit(WhileStatement node) {
            super.visit(node);
            if (node.getBody() != null) {
                this.addFold(node.getBody());
            }
        }

        @Override
        public void visit(DoStatement node) {
            super.visit(node);
            if (node.getBody() != null) {
                this.addFold(node.getBody());
            }
        }

        @Override
        public void visit(SwitchStatement node) {
            super.visit(node);
            if (node.getBody() != null) {
                this.addFold(node.getBody());
            }
        }

        @Override
        public void visit(SwitchCase node) {
            super.visit(node);
            List<Statement> actions2 = node.getActions();
            if (!actions2.isEmpty()) {
                OffsetRange offsetRange = null;
                if (node.isDefault()) {
                    offsetRange = new OffsetRange(node.getStartOffset() + "default:".length(), actions2.get(actions2.size() - 1).getEndOffset());
                } else {
                    Expression value = node.getValue();
                    if (value != null) {
                        offsetRange = new OffsetRange(value.getEndOffset() + ":".length(), actions2.get(actions2.size() - 1).getEndOffset());
                    }
                }
                this.addFold(offsetRange);
            }
        }

        @Override
        public void visit(TryStatement node) {
            super.visit(node);
            if (node.getBody() != null) {
                this.addFold(node.getBody());
            }
        }

        @Override
        public void visit(CatchClause node) {
            super.visit(node);
            if (node.getBody() != null) {
                this.addFold(node.getBody());
            }
        }

        private void addFold(ASTNode node) {
            this.addFold(FoldingScanner.this.createOffsetRange(node));
        }

        private void addFold(OffsetRange offsetRange) {
            FoldingScanner.this.getRanges(this.folds, FoldingScanner.FOLD_OTHER_CODE_BLOCKS).add(offsetRange);
        }
    }
}

