/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.nodes;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.elements.ParameterElement;
import org.netbeans.modules.php.editor.elements.ParameterElementImpl;
import org.netbeans.modules.php.editor.elements.TypeResolverImpl;
import org.netbeans.modules.php.editor.model.nodes.ASTNodeInfo;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.Reference;

public final class FormalParameterInfo
extends ASTNodeInfo<FormalParameter> {
    private ParameterElement parameter;

    private FormalParameterInfo(FormalParameter node, Map<String, List<QualifiedName>> paramDocTypes) {
        super(node);
        List<QualifiedName> types;
        FormalParameter formalParameter = (FormalParameter)this.getOriginalNode();
        boolean isReference = formalParameter.getParameterName() instanceof Reference;
        String name = this.getName();
        String defVal = CodeUtils.getParamDefaultValue(formalParameter);
        Expression parameterType = formalParameter.getParameterType();
        boolean isRawType = parameterType != null;
        List<QualifiedName> list = types = isRawType ? Collections.singletonList(QualifiedName.create(parameterType)) : paramDocTypes.get(name);
        if (types == null) {
            types = Collections.emptyList();
        }
        this.parameter = new ParameterElementImpl(name, defVal, this.getRange().getStart(), TypeResolverImpl.forNames(types), formalParameter.getDefaultValue() == null, isRawType, isReference);
    }

    public static FormalParameterInfo create(FormalParameter node, Map<String, List<QualifiedName>> paramDocTypes) {
        return new FormalParameterInfo(node, paramDocTypes);
    }

    @Override
    public ASTNodeInfo.Kind getKind() {
        return ASTNodeInfo.Kind.PARAMETER;
    }

    @Override
    public String getName() {
        FormalParameter formalParameter = (FormalParameter)this.getOriginalNode();
        return ASTNodeInfo.toName(formalParameter.getParameterName());
    }

    @Override
    public QualifiedName getQualifiedName() {
        QualifiedName qName = QualifiedName.create(((FormalParameter)this.getOriginalNode()).getParameterName());
        return qName != null ? qName : QualifiedName.createUnqualifiedName(this.getName());
    }

    @Override
    public OffsetRange getRange() {
        FormalParameter formalParameter = (FormalParameter)this.getOriginalNode();
        return ASTNodeInfo.toOffsetRange(formalParameter.getParameterName());
    }

    public ParameterElement toParameter() {
        return this.parameter;
    }
}

