/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.modules.php.editor.api.PhpElementKind;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.elements.TraitElement;
import org.netbeans.modules.php.editor.api.elements.TypeElement;
import org.netbeans.modules.php.editor.model.ClassConstantElement;
import org.netbeans.modules.php.editor.model.FieldElement;
import org.netbeans.modules.php.editor.model.IndexScope;
import org.netbeans.modules.php.editor.model.MethodScope;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.NamespaceScope;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.TraitScope;
import org.netbeans.modules.php.editor.model.TraitedScope;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.model.impl.IndexScopeImpl;
import org.netbeans.modules.php.editor.model.impl.ScopeImpl;
import org.netbeans.modules.php.editor.model.impl.TypeScopeImpl;
import org.netbeans.modules.php.editor.model.nodes.TraitDeclarationInfo;

public class TraitScopeImpl
extends TypeScopeImpl
implements TraitScope {
    private final Collection<QualifiedName> usedTraits;
    private Set<? super TypeScope> superRecursionDetection = new HashSet<TypeScope>();
    private Set<? super TypeScope> subRecursionDetection = new HashSet<TypeScope>();

    TraitScopeImpl(Scope inScope, TraitElement indexedTrait) {
        super(inScope, indexedTrait);
        this.usedTraits = indexedTrait.getUsedTraits();
    }

    TraitScopeImpl(Scope inScope, TraitDeclarationInfo nodeInfo) {
        super(inScope, nodeInfo);
        this.usedTraits = nodeInfo.getUsedTraits();
    }

    @Override
    public Collection<? extends MethodScope> getInheritedMethods() {
        return Collections.EMPTY_SET;
    }

    @Override
    public Collection<? extends MethodScope> getMethods() {
        return this.getDeclaredMethods();
    }

    @Override
    public Collection<? extends ClassConstantElement> getInheritedConstants() {
        return Collections.EMPTY_SET;
    }

    @Override
    public String asString(TypeElement.PrintAs as) {
        return this.getName();
    }

    @Override
    public String getIndexSignature() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName().toLowerCase()).append(';');
        sb.append(this.getName()).append(';');
        sb.append(this.getOffset()).append(';');
        NamespaceScope namespaceScope = ModelUtils.getNamespaceScope(this);
        assert (namespaceScope != null);
        QualifiedName qualifiedName = namespaceScope.getQualifiedName();
        sb.append(qualifiedName.toString()).append(';');
        if (!this.usedTraits.isEmpty()) {
            StringBuilder traitSb = new StringBuilder();
            for (QualifiedName usedTrait : this.usedTraits) {
                if (traitSb.length() > 0) {
                    traitSb.append(",");
                }
                traitSb.append(usedTrait.toString());
            }
            sb.append((CharSequence)traitSb);
        }
        sb.append(';');
        return sb.toString();
    }

    @Override
    public QualifiedName getNamespaceName() {
        if (this.indexedElement instanceof TraitElement) {
            TraitElement traitClass = (TraitElement)this.indexedElement;
            return traitClass.getNamespaceName();
        }
        return super.getNamespaceName();
    }

    @Override
    public Collection<? extends FieldElement> getDeclaredFields() {
        if (ModelUtils.getFileScope(this) == null) {
            IndexScope indexScopeImpl = ModelUtils.getIndexScope(this);
            return indexScopeImpl.findFields((TraitScope)this, new int[0]);
        }
        return TraitScopeImpl.filter(this.getElements(), new ScopeImpl.ElementFilter(){

            @Override
            public boolean isAccepted(ModelElement element) {
                return element.getPhpElementKind().equals((Object)PhpElementKind.FIELD);
            }
        });
    }

    @Override
    public Collection<QualifiedName> getUsedTraits() {
        return this.usedTraits;
    }

    @Override
    public Collection<? extends TraitScope> getTraits() {
        ArrayList<? extends TraitScope> result = new ArrayList<TraitScope>();
        for (QualifiedName qualifiedName : this.getUsedTraits()) {
            result.addAll(IndexScopeImpl.getTraits(qualifiedName, this));
        }
        return result;
    }

    @Override
    public boolean isSuperTypeOf(TypeScope subType) {
        boolean result = false;
        if (this.superRecursionDetection.add(subType) && subType.isTraited()) {
            TraitScope traitScope;
            assert (subType instanceof TraitedScope);
            Iterator<? extends TraitScope> i$ = ((TraitedScope)((Object)subType)).getTraits().iterator();
            while (i$.hasNext() && !(result = (traitScope = i$.next()).equals(this) ? true : this.isSuperTypeOf(traitScope))) {
            }
            if (!result && subType.isClass()) {
                result = subType.isSubTypeOf(this);
            }
        }
        return result;
    }

    @Override
    public boolean isSubTypeOf(TypeScope superType) {
        boolean result;
        block1: {
            TraitScope traitScope;
            result = false;
            if (!this.subRecursionDetection.add(superType) || !superType.isTrait()) break block1;
            Iterator<? extends TraitScope> i$ = this.getTraits().iterator();
            while (i$.hasNext() && !(result = (traitScope = i$.next()).equals(superType) ? true : traitScope.isSubTypeOf(superType))) {
            }
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        Collection<? extends TraitScope> traits = this.getTraits();
        if (traits.size() > 0) {
            sb.append(" uses ");
            for (TraitScope traitScope : traits) {
                sb.append(traitScope.getName()).append(" ");
            }
        }
        return sb.toString();
    }
}

