/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.netbeans.modules.php.editor.model.ClassScope;
import org.netbeans.modules.php.editor.model.InterfaceScope;
import org.netbeans.modules.php.editor.model.MethodScope;
import org.netbeans.modules.php.editor.model.NamespaceScope;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.TraitScope;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.model.impl.ClassScopeImpl;
import org.netbeans.modules.php.editor.model.impl.FieldElementImpl;
import org.netbeans.modules.php.editor.model.impl.FileScopeImpl;
import org.netbeans.modules.php.editor.model.impl.IncludeElementImpl;
import org.netbeans.modules.php.editor.model.impl.InterfaceScopeImpl;
import org.netbeans.modules.php.editor.model.impl.MethodScopeImpl;
import org.netbeans.modules.php.editor.model.impl.ModelElementFactory;
import org.netbeans.modules.php.editor.model.impl.ModelVisitor;
import org.netbeans.modules.php.editor.model.impl.NamespaceScopeImpl;
import org.netbeans.modules.php.editor.model.impl.OccurenceBuilder;
import org.netbeans.modules.php.editor.model.impl.ScopeImpl;
import org.netbeans.modules.php.editor.model.impl.TraitScopeImpl;
import org.netbeans.modules.php.editor.model.impl.VariableNameFactory;
import org.netbeans.modules.php.editor.model.impl.VariableNameImpl;
import org.netbeans.modules.php.editor.model.nodes.ClassDeclarationInfo;
import org.netbeans.modules.php.editor.model.nodes.IncludeInfo;
import org.netbeans.modules.php.editor.model.nodes.InterfaceDeclarationInfo;
import org.netbeans.modules.php.editor.model.nodes.MagicMethodDeclarationInfo;
import org.netbeans.modules.php.editor.model.nodes.MethodDeclarationInfo;
import org.netbeans.modules.php.editor.model.nodes.NamespaceDeclarationInfo;
import org.netbeans.modules.php.editor.model.nodes.SingleFieldDeclarationInfo;
import org.netbeans.modules.php.editor.model.nodes.TraitDeclarationInfo;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FieldsDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Include;
import org.netbeans.modules.php.editor.parser.astnodes.InterfaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocMethodTag;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.TraitDeclaration;

class ModelBuilder {
    private final FileScopeImpl fileScope;
    private NamespaceScopeImpl namespaceScope;
    private NamespaceScopeImpl defaultNamespaceScope;
    private Stack<ScopeImpl> currentScope;
    private Program program;
    private final Map<VariableNameFactory, Map<String, VariableNameImpl>> vars;

    ModelBuilder(FileScopeImpl fileScope) {
        this.fileScope = fileScope;
        this.currentScope = new Stack();
        this.vars = new HashMap<VariableNameFactory, Map<String, VariableNameImpl>>();
        this.setCurrentScope(fileScope);
        this.namespaceScope = this.defaultNamespaceScope = new NamespaceScopeImpl(fileScope);
        this.setCurrentScope(this.namespaceScope);
    }

    NamespaceScope build(NamespaceDeclaration node, OccurenceBuilder occurencesBuilder) {
        NamespaceScopeImpl nScope;
        NamespaceDeclarationInfo info = NamespaceDeclarationInfo.create(node);
        NamespaceScopeImpl namespaceScopeImpl = nScope = info.isDefaultNamespace() ? this.defaultNamespaceScope : ModelElementFactory.create(info, this);
        if (!nScope.isDefaultNamespace()) {
            this.setCurrentScope(nScope);
        }
        nScope.setBlockRange(node);
        return nScope;
    }

    ClassScope build(ClassDeclaration node, OccurenceBuilder occurencesBuilder) {
        ClassScopeImpl classScope = ModelElementFactory.create(ClassDeclarationInfo.create(node), this);
        this.setCurrentScope(classScope);
        occurencesBuilder.prepare(node, classScope);
        return classScope;
    }

    TraitScope build(TraitDeclaration node, OccurenceBuilder occurencesBuilder) {
        TraitScopeImpl traitScope = ModelElementFactory.create(TraitDeclarationInfo.create(node), this);
        this.setCurrentScope(traitScope);
        occurencesBuilder.prepare(node, traitScope);
        return traitScope;
    }

    void build(FieldsDeclaration node, OccurenceBuilder occurencesBuilder) {
        List<? extends SingleFieldDeclarationInfo> infos = SingleFieldDeclarationInfo.create(node);
        for (SingleFieldDeclarationInfo singleFieldDeclarationInfo : infos) {
            FieldElementImpl fei = ModelElementFactory.create(singleFieldDeclarationInfo, this);
            occurencesBuilder.prepare(singleFieldDeclarationInfo, fei);
        }
    }

    void build(Include node, OccurenceBuilder occurencesBuilder) {
        IncludeElementImpl inclImpl = ModelElementFactory.create(IncludeInfo.create(node), this);
        if (inclImpl != null) {
            occurencesBuilder.prepare(node, inclImpl);
        }
    }

    InterfaceScope build(InterfaceDeclaration node, OccurenceBuilder occurencesBuilder) {
        InterfaceScopeImpl classScope = ModelElementFactory.create(InterfaceDeclarationInfo.create(node), this);
        this.setCurrentScope(classScope);
        occurencesBuilder.prepare(node, classScope);
        return classScope;
    }

    void buildMagicMethod(PHPDocMethodTag node, OccurenceBuilder occurencesBuilder) {
        MagicMethodDeclarationInfo info = MagicMethodDeclarationInfo.create(node);
        if (info != null) {
            MethodScopeImpl methodScope = new MethodScopeImpl((Scope)this.getCurrentScope(), info);
            occurencesBuilder.prepare(info, (MethodScope)methodScope);
        }
    }

    MethodScope build(MethodDeclaration node, OccurenceBuilder occurencesBuilder, ModelVisitor visitor) {
        ScopeImpl scope = this.getCurrentScope();
        MethodScopeImpl methodScope = ModelElementFactory.create(MethodDeclarationInfo.create(this.getProgram(), node, (TypeScope)((Object)scope)), this, visitor);
        this.setCurrentScope(methodScope);
        occurencesBuilder.prepare(node, (MethodScope)methodScope);
        return methodScope;
    }

    void reset() {
        if (!this.currentScope.empty()) {
            ScopeImpl createdScope = this.currentScope.peek();
            if (createdScope instanceof NamespaceScopeImpl) {
                this.namespaceScope = this.defaultNamespaceScope;
                if (!((NamespaceScopeImpl)createdScope).isDefaultNamespace()) {
                    this.currentScope.pop();
                }
            } else {
                this.currentScope.pop();
            }
        }
    }

    void prepareForScope(Scope scope) {
        this.currentScope.clear();
        while (scope != null) {
            if (scope instanceof NamespaceScopeImpl) {
                this.namespaceScope = (NamespaceScopeImpl)scope;
            }
            this.currentScope.add(0, (ScopeImpl)scope);
            scope = scope.getInScope();
        }
    }

    FileScopeImpl getFileScope() {
        return this.fileScope;
    }

    NamespaceScopeImpl getCurrentNameSpace() {
        return this.namespaceScope;
    }

    ScopeImpl getCurrentScope() {
        return this.currentScope.isEmpty() ? null : this.currentScope.peek();
    }

    final void setCurrentScope(ScopeImpl scope) {
        if (scope instanceof NamespaceScopeImpl) {
            this.namespaceScope = (NamespaceScopeImpl)scope;
        }
        this.currentScope.push(scope);
    }

    Program getProgram() {
        assert (this.program != null);
        return this.program;
    }

    void setProgram(Program program) {
        this.program = program;
        this.defaultNamespaceScope.setBlockRange(program);
    }

    Map<VariableNameFactory, Map<String, VariableNameImpl>> getVars() {
        return this.vars;
    }
}

