/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.php.api.editor.EditorSupport;
import org.netbeans.modules.php.api.editor.PhpBaseElement;
import org.netbeans.modules.php.api.editor.PhpClass;
import org.netbeans.modules.php.api.editor.PhpFunction;
import org.netbeans.modules.php.api.editor.PhpVariable;
import org.netbeans.modules.php.api.util.Pair;
import org.netbeans.modules.php.editor.api.ElementQuery;
import org.netbeans.modules.php.editor.api.ElementQueryFactory;
import org.netbeans.modules.php.editor.api.NameKind;
import org.netbeans.modules.php.editor.api.QuerySupportFactory;
import org.netbeans.modules.php.editor.api.elements.ClassElement;
import org.netbeans.modules.php.editor.model.ClassScope;
import org.netbeans.modules.php.editor.model.FieldElement;
import org.netbeans.modules.php.editor.model.FileScope;
import org.netbeans.modules.php.editor.model.FunctionScope;
import org.netbeans.modules.php.editor.model.MethodScope;
import org.netbeans.modules.php.editor.model.Model;
import org.netbeans.modules.php.editor.model.ModelFactory;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.model.VariableScope;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class EditorSupportImpl
implements EditorSupport {
    public Collection<PhpClass> getClasses(FileObject fo) {
        final ArrayList<PhpClass> retval = new ArrayList<PhpClass>();
        Source source = Source.create((FileObject)fo);
        if (source != null) {
            try {
                ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

                    public void run(ResultIterator resultIterator) throws Exception {
                        Parser.Result pr = resultIterator.getParserResult();
                        if (pr != null && pr instanceof PHPParseResult) {
                            Model model = ModelFactory.getModel((PHPParseResult)pr);
                            FileScope fileScope = model.getFileScope();
                            Collection<? extends ClassScope> allClasses = ModelUtils.getDeclaredClasses(fileScope);
                            for (ClassScope classScope : allClasses) {
                                retval.add((PhpClass)EditorSupportImpl.this.getPhpBaseElement(classScope));
                            }
                        }
                    }
                });
            }
            catch (ParseException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return retval;
    }

    public Collection<Pair<FileObject, Integer>> filesForClass(FileObject sourceRoot, PhpClass phpClass) {
        if (sourceRoot.isData()) {
            throw new IllegalArgumentException("sourceRoot must be a folder");
        }
        ArrayList<Pair<FileObject, Integer>> retval = new ArrayList<Pair<FileObject, Integer>>();
        ElementQuery.Index indexQuery = ElementQueryFactory.createIndexQuery(QuerySupportFactory.get(sourceRoot));
        Set<ClassElement> classes = indexQuery.getClasses(NameKind.exact(phpClass.getFullyQualifiedName()));
        for (ClassElement indexedClass : classes) {
            FileObject fo = indexedClass.getFileObject();
            if (fo == null || !fo.isValid()) continue;
            retval.add((Pair<FileObject, Integer>)Pair.of((Object)fo, (Object)indexedClass.getOffset()));
        }
        return retval;
    }

    public PhpBaseElement getElement(FileObject fo, final int offset) {
        Source source = Source.create((FileObject)fo);
        final ArrayList retval = new ArrayList(1);
        if (source != null) {
            try {
                ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

                    public void run(ResultIterator resultIterator) throws Exception {
                        Parser.Result pr = resultIterator.getParserResult();
                        if (pr != null && pr instanceof PHPParseResult) {
                            Model model = ModelFactory.getModel((PHPParseResult)pr);
                            retval.add(EditorSupportImpl.this.getPhpBaseElement(model.getVariableScope(offset)));
                        }
                    }
                });
            }
            catch (ParseException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return retval.isEmpty() ? null : (PhpBaseElement)retval.get(0);
    }

    private PhpBaseElement getPhpBaseElement(Scope scope) {
        PhpVariable phpBaseElement = null;
        if (scope instanceof MethodScope) {
            PhpClass phpClass = (PhpClass)this.getPhpBaseElement((TypeScope)scope.getInScope());
            for (PhpClass.Method method : phpClass.getMethods()) {
                if (!method.getName().equals(scope.getName())) continue;
                phpBaseElement = method;
                break;
            }
        } else if (scope instanceof ClassScope) {
            ClassScope classScope = (ClassScope)scope;
            PhpClass phpClass = new PhpClass(classScope.getName(), classScope.getNamespaceName().append(classScope.getName()).toFullyQualified().toString(), classScope.getOffset());
            for (FieldElement fieldElement : classScope.getDeclaredFields()) {
                phpClass.addField(fieldElement.getName(), fieldElement.getName(), fieldElement.getOffset());
            }
            for (MethodScope methodScope : classScope.getDeclaredMethods()) {
                phpClass.addMethod(methodScope.getName(), methodScope.getName(), methodScope.getOffset());
            }
            phpBaseElement = phpClass;
        } else if (scope instanceof FunctionScope) {
            phpBaseElement = new PhpFunction(scope.getName(), scope.getNamespaceName().append(scope.getName()).toFullyQualified().toString(), scope.getOffset());
        } else if (scope instanceof VariableScope) {
            phpBaseElement = new PhpVariable(scope.getName(), scope.getName(), scope.getOffset());
        }
        return phpBaseElement;
    }
}

