/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.model.VariableScope;
import org.netbeans.modules.php.editor.model.impl.ModelElementImpl;
import org.netbeans.modules.php.editor.model.impl.ScopeImpl;
import org.netbeans.modules.php.editor.model.impl.VariousUtils;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayAccess;
import org.netbeans.modules.php.editor.parser.astnodes.Assignment;
import org.openide.util.Union2;

class AssignmentImpl<Container extends ModelElementImpl>
extends ScopeImpl {
    private Container container;
    private Union2<String, Collection<? extends TypeScope>> typeName;
    private OffsetRange scopeRange;
    private boolean arrayAccess;
    private boolean conditionalBlock;

    AssignmentImpl(Container container, Scope scope, OffsetRange scopeRange, OffsetRange nameRange, Assignment assignment, Map<String, AssignmentImpl> allAssignments) {
        this(container, scope, scopeRange, nameRange, VariousUtils.extractVariableTypeFromAssignment(assignment, allAssignments));
        if (assignment.getLeftHandSide() instanceof ArrayAccess) {
            this.arrayAccess = true;
        }
    }

    AssignmentImpl(Container container, Scope scope, OffsetRange scopeRange, OffsetRange nameRange, String typeName) {
        super(scope, ((ModelElementImpl)container).getName(), ((ModelElementImpl)container).getFile(), nameRange, ((ModelElementImpl)container).getPhpElementKind());
        this.container = container;
        String modifiedTypeName = typeName;
        if (typeName != null && !typeName.contains("@")) {
            QualifiedName qualifiedName = QualifiedName.create(typeName);
            QualifiedName fullyQualifiedName = VariousUtils.getFullyQualifiedName(qualifiedName, nameRange.getStart(), scope);
            if (qualifiedName.getSegments().size() != fullyQualifiedName.getSegments().size()) {
                modifiedTypeName = fullyQualifiedName.toString();
            }
        }
        this.typeName = Union2.createFirst((Object)modifiedTypeName);
        this.scopeRange = scopeRange;
    }

    @CheckForNull
    Union2<String, Collection<? extends TypeScope>> getTypeUnion() {
        return this.typeName;
    }

    boolean canBeProcessed(String tName) {
        return AssignmentImpl.canBeProcessed(tName, this.getName()) && AssignmentImpl.canBeProcessed(tName, this.getName().substring(1));
    }

    static boolean canBeProcessed(String tName, String name) {
        if (tName.length() > 0 && tName.indexOf(name) == -1) {
            return true;
        }
        String varThis = "var:$this";
        int indexOfVarThis = tName.indexOf(varThis);
        if (indexOfVarThis != -1 && !name.equals(varThis)) {
            return (tName = tName.substring(0, indexOfVarThis) + tName.substring(indexOfVarThis + varThis.length())).length() > 0 && tName.indexOf(name) == -1;
        }
        return false;
    }

    @CheckForNull
    private Collection<? extends TypeScope> typesFromUnion() {
        Union2<String, Collection<TypeScope>> typeUnion = this.getTypeUnion();
        if (typeUnion != null && typeUnion.hasSecond() && typeUnion.second() != null) {
            return (Collection)typeUnion.second();
        }
        return null;
    }

    String typeNameFromUnion() {
        Union2<String, Collection<TypeScope>> typeUnion = this.getTypeUnion();
        if (typeUnion != null) {
            if (typeUnion.hasFirst() && typeUnion.first() != null) {
                return (String)typeUnion.first();
            }
            if (typeUnion.hasSecond() && typeUnion.second() != null) {
                TypeScope type = (TypeScope)ModelUtils.getFirst((Collection)typeUnion.second());
                return type != null ? type.getName() : null;
            }
        }
        return null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName());
        sb.append(" == ").append(this.getTypeUnion());
        return sb.toString();
    }

    public Collection<? extends String> getTypeNames() {
        String tName = this.typeNameFromUnion();
        if (tName != null) {
            return Collections.singleton(tName);
        }
        return Collections.emptyList();
    }

    public Collection<? extends TypeScope> getTypes() {
        List empty = Collections.emptyList();
        Collection<TypeScope> types = this.typesFromUnion();
        if (types != null) {
            return types;
        }
        String tName = this.typeNameFromUnion();
        if (tName != null && this.canBeProcessed(tName)) {
            types = VariousUtils.getType((VariableScope)this.getInScope(), tName, this.getOffset(), false);
        }
        if (types != null) {
            if (types.isEmpty() && tName != null && !tName.contains("@")) {
                return empty;
            }
            this.typeName = Union2.createSecond(types);
            return types;
        }
        this.typeName = null;
        return empty;
    }

    Container getContainer() {
        return this.container;
    }

    @Override
    public OffsetRange getBlockRange() {
        return this.scopeRange;
    }

    @Override
    public String getNormalizedName() {
        return this.getClass().getName() + ":" + this.toString() + ":" + String.valueOf(this.getOffset());
    }

    public boolean isArrayAccess() {
        String tpName = this.typeNameFromUnion();
        return this.arrayAccess || tpName != null && tpName.equals("array");
    }

    public void setAsArrayAccess(boolean arrayAccess) {
        this.arrayAccess = arrayAccess;
    }

    public boolean isConditionalBlock() {
        return this.conditionalBlock;
    }

    public void setConditionalBlock(boolean conditionalBlock) {
        this.conditionalBlock = conditionalBlock;
    }
}

