/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.index;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

public final class PHPIndex {
    private static final Logger LOG = Logger.getLogger(PHPIndex.class.getName());
    public static final int ANY_ATTR = -1;
    private static String clusterUrl = null;
    private static final String CLUSTER_URL = "cluster:";

    private PHPIndex() {
    }

    public static void setClusterUrl(String url) {
        clusterUrl = url;
    }

    static String getPreindexUrl(String url) {
        String s = PHPIndex.getClusterUrl();
        if (url.startsWith(s)) {
            return CLUSTER_URL + url.substring(s.length());
        }
        return url;
    }

    public static FileObject getFileObject(String urlStr) {
        try {
            if (urlStr.startsWith(CLUSTER_URL)) {
                urlStr = PHPIndex.getClusterUrl() + urlStr.substring(CLUSTER_URL.length());
            }
            URL url = new URL(urlStr);
            return URLMapper.findFileObject((URL)url);
        }
        catch (MalformedURLException mue) {
            Exceptions.printStackTrace((Throwable)mue);
            return null;
        }
    }

    static String getClusterUrl() {
        if (clusterUrl == null) {
            File f = InstalledFileLocator.getDefault().locate("modules/org-netbeans-modules-php-editor.jar", null, false);
            if (f == null) {
                throw new RuntimeException("Can't find cluster");
            }
            f = new File(f.getParentFile().getParentFile().getAbsolutePath());
            try {
                f = f.getCanonicalFile();
                clusterUrl = Utilities.toURI((File)f).toURL().toExternalForm();
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
        }
        return clusterUrl;
    }
}

