/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.index;

import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.parsing.spi.indexing.support.IndexDocument;
import org.netbeans.modules.php.editor.index.IdentifierSignature;
import org.netbeans.modules.php.editor.index.Signature;
import org.netbeans.modules.php.editor.model.ClassConstantElement;
import org.netbeans.modules.php.editor.model.ClassScope;
import org.netbeans.modules.php.editor.model.FieldElement;
import org.netbeans.modules.php.editor.model.MethodScope;
import org.netbeans.modules.php.editor.parser.astnodes.BodyDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTypeNode;

public final class IdentifierSignatureFactory {
    private IdentifierSignatureFactory() {
    }

    public static IdentifierSignature createIdentifier(Identifier node) {
        String name = node.getName().toLowerCase();
        return new IdentifierSignatureImpl(name);
    }

    public static IdentifierSignature createDeclaration(Signature sign) {
        String name = sign.string(0);
        int mask = sign.integer(1);
        String typeName = (mask & 1) != 0 ? sign.string(2) : null;
        return new IdentifierSignatureImpl(name, typeName, mask);
    }

    public static IdentifierSignature createInvocation(Signature sign) {
        String name = sign.string(0);
        return new IdentifierSignatureImpl(name);
    }

    public static IdentifierSignature create(MethodScope method) {
        return new IdentifierSignatureImpl(method.getName(), method.getPhpModifiers().toFlags(), ElementKind.METHOD, method.getInScope().getName(), true, method.getInScope() instanceof ClassScope);
    }

    public static IdentifierSignature create(FieldElement fieldElement) {
        return new IdentifierSignatureImpl(fieldElement.getName(), fieldElement.getPhpModifiers().toFlags(), ElementKind.FIELD, fieldElement.getInScope().getName(), true, fieldElement.getInScope() instanceof ClassScope);
    }

    public static IdentifierSignature create(ClassConstantElement constantElement) {
        return new IdentifierSignatureImpl(constantElement.getName(), constantElement.getPhpModifiers().toFlags(), ElementKind.CONSTANT, constantElement.getInScope().getName(), true, constantElement.getInScope() instanceof ClassScope);
    }

    public static IdentifierSignature create(PHPDocTypeNode node) {
        IdentifierSignature result = IdentifierSignature.NONE;
        String type = node.getValue();
        String[] typeParts = type.split("\\\\");
        if (typeParts.length >= 1) {
            result = new IdentifierSignatureImpl(typeParts[typeParts.length - 1]);
        }
        return result;
    }

    private static final class IdentifierSignatureImpl
    implements IdentifierSignature {
        private static final int DECLARATION = 1;
        private static final int IFACE_MEMBER = 2;
        private static final int CLS_MEMBER = 4;
        private static final int MODIFIER_STATIC = 8;
        private static final int MODIFIER_ABSTRACT = 16;
        private static final int MODIFIER_PROTECTED = 32;
        private static final int MODIFIER_PUBLIC = 64;
        private static final int KIND_FNC = 128;
        private static final int KIND_VAR = 256;
        private static final int KIND_CONST = 512;
        private static final int KIND_CLASS = 1024;
        private String name;
        private int mask;
        private String typeName;

        private IdentifierSignatureImpl(String name) {
            this(name, null, 0);
        }

        private IdentifierSignatureImpl(String name, String typeName, int mask) {
            this.name = name.toLowerCase();
            while (name.startsWith("$")) {
                name = name.substring(1);
            }
            this.mask = mask;
            if (this.isDeclaration()) {
                this.typeName = typeName;
            }
        }

        private IdentifierSignatureImpl(String name, int modifier, ElementKind kind, String typeName, boolean declaration, Boolean clsmember) {
            this.name = name.toLowerCase();
            while (name.startsWith("$")) {
                name = name.substring(1);
            }
            if (declaration) {
                this.mask |= 1;
            }
            if (clsmember != null && clsmember.booleanValue()) {
                this.mask |= 4;
            }
            if (clsmember != null && !clsmember.booleanValue()) {
                this.mask |= 2;
            }
            switch (kind) {
                case METHOD: {
                    this.mask |= 0x80;
                    break;
                }
                case FIELD: {
                    this.mask |= 0x100;
                    break;
                }
                case CONSTANT: {
                    this.mask |= 0x200;
                    break;
                }
                case CLASS: {
                    this.mask |= 0x400;
                    break;
                }
                default: {
                    throw new IllegalStateException(kind.toString());
                }
            }
            if (BodyDeclaration.Modifier.isAbstract(modifier)) {
                this.mask |= 0x10;
            } else if (BodyDeclaration.Modifier.isStatic(modifier)) {
                this.mask |= 8;
            }
            if (BodyDeclaration.Modifier.isPublic(modifier)) {
                this.mask |= 0x40;
            } else if (BodyDeclaration.Modifier.isProtected(modifier)) {
                this.mask |= 0x20;
            }
            if (this.isDeclaration()) {
                this.typeName = typeName;
            }
        }

        private String getName() {
            return this.name;
        }

        private String getTypeName() {
            return this.typeName;
        }

        private boolean isDeclaration() {
            return (this.mask & 1) != 0;
        }

        private boolean isClassMember() {
            return (this.mask & 4) != 0;
        }

        private boolean isIfaceMember() {
            return (this.mask & 2) != 0;
        }

        private boolean isStatic() {
            return (this.mask & 8) != 0;
        }

        private boolean isAbstract() {
            return (this.mask & 0x10) != 0;
        }

        private boolean isPublic() {
            return (this.mask & 0x40) != 0;
        }

        private boolean isProtected() {
            return (this.mask & 0x20) != 0;
        }

        private boolean isPrivate() {
            return !this.isPublic() && !this.isProtected();
        }

        private boolean isFunction() {
            return (this.mask & 0x80) != 0 && !this.isClassMember() && !this.isIfaceMember();
        }

        private boolean isMethod() {
            return (this.mask & 0x80) != 0 && (this.isClassMember() || this.isIfaceMember());
        }

        private boolean isVariable() {
            return (this.mask & 0x100) != 0 && !this.isClassMember() && !this.isIfaceMember();
        }

        private boolean isField() {
            return (this.mask & 0x100) != 0 && (this.isClassMember() || this.isIfaceMember());
        }

        private boolean isClass() {
            return (this.mask & 0x400) != 0;
        }

        private boolean isConstant() {
            return (this.mask & 0x200) != 0 && !this.isClassMember() && !this.isIfaceMember();
        }

        private boolean isClassConstant() {
            return (this.mask & 0x200) != 0 && (this.isClassMember() || this.isIfaceMember());
        }

        private String getSignature() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.name).append(";");
            if (this.mask != 0) {
                sb.append(this.mask).append(";");
            } else assert (!this.isDeclaration());
            if (this.isDeclaration()) {
                sb.append(this.typeName).append(";");
            }
            return sb.toString();
        }

        @Override
        public void save(IndexDocument indexDocument, String key) {
            indexDocument.addPair(key, this.getSignature(), true, true);
        }
    }
}

