/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.indent;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.Formatter;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.editor.indent.spi.Context;
import org.netbeans.modules.php.editor.indent.CodeStyle;
import org.netbeans.modules.php.editor.indent.PHPNewLineIndenter;
import org.netbeans.modules.php.editor.indent.TokenFormatter;

public class PHPFormatter
implements Formatter {
    private static final Logger LOG = Logger.getLogger(PHPFormatter.class.getName());

    public PHPFormatter() {
        LOG.log(Level.FINE, "PHP Formatter: {0}", this.toString());
    }

    public boolean needsParserResult() {
        return true;
    }

    public void reindent(Context context) {
        String mimeType = PHPFormatter.getMimeTypeAtOffset(context.document(), context.startOffset());
        if (!"text/x-php5".equals(mimeType)) {
            return;
        }
        PHPNewLineIndenter indenter = new PHPNewLineIndenter(context);
        indenter.process();
    }

    public void reformat(Context context, ParserResult info) {
        long start = System.currentTimeMillis();
        new TokenFormatter().reformat(context, info);
        if (LOG.isLoggable(Level.FINE)) {
            long end = System.currentTimeMillis();
            LOG.log(Level.FINE, "Reformat took: {0} ms", end - start);
        }
    }

    public int indentSize() {
        return CodeStyle.get((Document)null).getIndentSize();
    }

    public int hangingIndentSize() {
        return CodeStyle.get((Document)null).getContinuationIndentSize();
    }

    private static String getMimeTypeAtOffset(Document doc, int offset) {
        TokenHierarchy th = TokenHierarchy.get((Document)doc);
        List tsl = th.embeddedTokenSequences(offset, false);
        if (tsl != null && tsl.size() > 0) {
            TokenSequence tokenSequence = (TokenSequence)tsl.get(tsl.size() - 1);
            return tokenSequence.language().mimeType();
        }
        return null;
    }
}

